/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class JDClipboard {
    private Vector objects = new Vector();
    Clipboard clipboard;
    private Vector clipboardListener = new Vector();
    static JDClipboard theClipboard = null;

    private JDClipboard() {
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    static JDClipboard getInstance() {
        if (theClipboard == null) {
            theClipboard = new JDClipboard();
        }
        return theClipboard;
    }

    public void addChangeListener(JDrawEditorListener l) {
        if (!this.clipboardListener.contains(l)) {
            this.clipboardListener.add(l);
        }
    }

    public void check() {
        this.load(false);
        for (int i = 0; i < this.clipboardListener.size(); ++i) {
            ((JDrawEditorListener)this.clipboardListener.get(i)).clipboardChanged();
        }
    }

    int size() {
        return this.objects.size();
    }

    void send(Vector objs) {
        StringBuffer to_save = new StringBuffer();
        to_save.append("JDFile v11 {\n");
        for (int i = 0; i < objs.size(); ++i) {
            ((JDObject)objs.get(i)).recordObject(to_save, 1);
        }
        to_save.append("}\n");
        StringSelection str = new StringSelection(to_save.toString());
        try {
            this.clipboard.setContents(str, null);
        }
        catch (IllegalStateException e1) {
            System.out.println("JDClipboard.send() : " + e1.getMessage());
            return;
        }
        this.check();
    }

    private void load(boolean showError) {
        block13: {
            String str;
            boolean hasTransferableText;
            Transferable contents;
            this.objects.clear();
            try {
                contents = this.clipboard.getContents(null);
            }
            catch (IllegalStateException e1) {
                if (showError) {
                    JOptionPane.showMessageDialog(null, "Clipboard not available.\n" + e1.getMessage());
                }
                System.out.println(e1.getMessage());
                return;
            }
            catch (Exception e2) {
                if (showError) {
                    JOptionPane.showMessageDialog(null, "Clipboard not available.\n" + e2.getMessage());
                }
                System.out.println(e2.getMessage());
                return;
            }
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!hasTransferableText) {
                return;
            }
            try {
                str = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e2) {
                if (showError) {
                    JOptionPane.showMessageDialog(null, "Invalid clipboard content.\n" + e2.getMessage());
                }
                System.out.println(e2.getMessage());
                return;
            }
            catch (IOException e3) {
                if (showError) {
                    JOptionPane.showMessageDialog(null, "Invalid clipboard content.\n" + e3.getMessage());
                }
                System.out.println(e3.getMessage());
                return;
            }
            try {
                JDFileLoader loader = new JDFileLoader(str.toString());
                this.objects = loader.parseFile();
            }
            catch (IOException e) {
                if (!showError) break block13;
                JOptionPane.showMessageDialog(null, "Invalid clipboard content.\n" + e.getMessage());
            }
        }
    }

    JDObject get(int idx) {
        return (JDObject)this.objects.get(idx);
    }

    Vector getObjects() {
        return this.objects;
    }
}

