/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class JDExtensionEditor
extends JDialog
implements ActionListener {
    private boolean modified = false;
    private JTextArea textArea;
    private JScrollPane textView;
    private JButton cancelBtn;
    private JButton applyBtn;

    JDExtensionEditor(Dialog parent) {
        super(parent, true);
        this.initComponents();
    }

    JDExtensionEditor() {
        super((Frame)null, true);
        this.initComponents();
    }

    private void initComponents() {
        JPanel innerPane = new JPanel();
        innerPane.setLayout(new BorderLayout());
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        this.applyBtn = new JButton("Apply change");
        this.applyBtn.setFont(JDUtils.labelFont);
        this.applyBtn.addActionListener(this);
        btnPanel.add(this.applyBtn);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setFont(JDUtils.labelFont);
        this.cancelBtn.addActionListener(this);
        btnPanel.add(this.cancelBtn);
        innerPane.add((Component)btnPanel, "South");
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textView = new JScrollPane(this.textArea);
        innerPane.add((Component)this.textView, "Center");
        this.textView.setPreferredSize(new Dimension(800, 600));
        this.setContentPane(innerPane);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.cancelBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (src == this.applyBtn) {
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    boolean getModified() {
        return this.modified;
    }

    String getValue() {
        return this.textArea.getText();
    }

    void setValue(String value) {
        this.textArea.setText(value);
    }

    static String showExtensionEditor(JComponent parent, String title, String defaultValue) {
        JDExtensionEditor dlg;
        Window peer = ATKGraphicsUtils.getWindowForComponent(parent);
        if (peer instanceof Dialog) {
            dlg = new JDExtensionEditor((Dialog)peer);
        } else {
            System.out.println("jdraw.JDExtensionEditor() : Warning null parent");
            dlg = new JDExtensionEditor();
        }
        dlg.setTitle(title);
        dlg.setValue(defaultValue);
        ATKGraphicsUtils.centerDialog(dlg);
        dlg.setVisible(true);
        if (dlg.getModified()) {
            return dlg.getValue();
        }
        return null;
    }
}

