/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDExtensionEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.MultiLineCellEditor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class JDExtensionPanel
extends JPanel
implements ActionListener {
    JDObject[] allObjects = null;
    JDrawEditor invoker;
    JTable theTable;
    JScrollPane tableView;
    DefaultTableModel theModel;
    JButton newExtensionBtn;
    JButton delExtensionBtn;
    JButton editExtensionBtn;
    JButton helpExtensionBtn;
    JButton applyBtn;
    MultiLineCellEditor cellEditor = null;
    static String[] colName = new String[]{"Name", "Value"};

    public JDExtensionPanel(JDObject[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel extPanel = new JPanel(null);
        extPanel.setBorder(JDUtils.createTitleBorder("Extensions"));
        extPanel.setBounds(5, 5, 370, 280);
        this.theModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    JDExtensionPanel.this.applyBtn.setEnabled(true);
                }
            }
        };
        this.theTable = new JTable(this.theModel);
        this.cellEditor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.cellEditor);
        this.tableView = new JScrollPane(this.theTable);
        this.tableView.setVerticalScrollBarPolicy(22);
        this.tableView.setBounds(10, 20, 350, 220);
        extPanel.add(this.tableView);
        this.newExtensionBtn = new JButton("New");
        this.newExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.newExtensionBtn.setFont(JDUtils.labelFont);
        this.newExtensionBtn.addActionListener(this);
        this.newExtensionBtn.setBounds(10, 245, 50, 24);
        extPanel.add(this.newExtensionBtn);
        this.delExtensionBtn = new JButton("Delete");
        this.delExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.delExtensionBtn.setFont(JDUtils.labelFont);
        this.delExtensionBtn.addActionListener(this);
        this.delExtensionBtn.setBounds(65, 245, 60, 24);
        extPanel.add(this.delExtensionBtn);
        this.editExtensionBtn = new JButton("Edit");
        this.editExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.editExtensionBtn.setFont(JDUtils.labelFont);
        this.editExtensionBtn.addActionListener(this);
        this.editExtensionBtn.setBounds(130, 245, 60, 24);
        extPanel.add(this.editExtensionBtn);
        this.helpExtensionBtn = new JButton("?");
        this.helpExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.helpExtensionBtn.setFont(JDUtils.labelFont);
        this.helpExtensionBtn.addActionListener(this);
        this.helpExtensionBtn.setBounds(195, 245, 30, 24);
        extPanel.add(this.helpExtensionBtn);
        this.applyBtn = new JButton("Apply");
        this.applyBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyBtn.setFont(JDUtils.labelFont);
        this.applyBtn.addActionListener(this);
        this.applyBtn.setBounds(270, 245, 90, 24);
        this.applyBtn.setEnabled(false);
        extPanel.add(this.applyBtn);
        this.add(extPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDObject[] objs) {
        this.allObjects = objs;
        this.refreshTable();
    }

    private void refreshTable() {
        if (this.allObjects == null || this.allObjects.length == 0) {
            this.theModel.setDataVector(null, colName);
            this.delExtensionBtn.setEnabled(false);
            this.editExtensionBtn.setEnabled(false);
            this.helpExtensionBtn.setEnabled(false);
        } else {
            int sz = this.allObjects[0].getExtendedParamNumber();
            Object[][] rows = new Object[sz][2];
            for (int i = 0; i < sz; ++i) {
                rows[i][0] = this.allObjects[0].getExtendedParamName(i);
                rows[i][1] = this.allObjects[0].getExtendedParam(i);
            }
            this.theModel.setDataVector(rows, colName);
            this.cellEditor.updateRows();
            this.delExtensionBtn.setEnabled(sz > 0);
            this.editExtensionBtn.setEnabled(sz > 0);
            this.helpExtensionBtn.setEnabled(sz > 0);
        }
        this.applyBtn.setEnabled(false);
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(230);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.newExtensionBtn) {
            String newExt = JOptionPane.showInputDialog("Enter extension name");
            if (newExt != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].addExtension(newExt);
                }
                this.refreshTable();
                this.invoker.setNeedToSave(true, "New extension");
            }
        } else if (src == this.delExtensionBtn) {
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].removeExtension(row);
                }
                this.refreshTable();
                this.invoker.setNeedToSave(true, "Remove extension");
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row first.", "Error", 0);
            }
        } else if (src == this.applyBtn) {
            if (this.theModel.getRowCount() > 0) {
                for (int row = 0; row < this.theModel.getRowCount(); ++row) {
                    String extName = (String)this.theModel.getValueAt(row, 0);
                    String value = (String)this.theModel.getValueAt(row, 1);
                    this.applyExtension(extName, value);
                }
                this.invoker.setNeedToSave(true, "Edit extension");
                this.refreshTable();
            }
        } else if (src == this.editExtensionBtn) {
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                String extName = (String)this.theModel.getValueAt(row, 0);
                String value = (String)this.theModel.getValueAt(row, 1);
                String newValue = JDExtensionEditor.showExtensionEditor(this, "Edit " + extName, value);
                if (newValue != null) {
                    this.applyExtension(extName, newValue);
                    this.invoker.setNeedToSave(true, "Edit extension");
                }
                this.refreshTable();
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row first.", "Error", 0);
            }
        } else if (src == this.helpExtensionBtn) {
            int row = this.theTable.getSelectedRow();
            if (row >= 0) {
                String extName = (String)this.theModel.getValueAt(row, 0);
                String helpStr = this.allObjects[0].getExtendedParamDesc(extName);
                if (helpStr != null && helpStr.length() > 0) {
                    JOptionPane.showMessageDialog(this, helpStr, "Help for " + extName, 1);
                } else {
                    JOptionPane.showMessageDialog(this, "No help for " + extName + ".", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row first.", "Error", 0);
            }
        }
    }

    private void applyExtension(String extName, String value) {
        JDObject obj = this.allObjects[0];
        obj.setExtendedParam(extName, value);
        if (obj instanceof JDSwingObject) {
            this.invoker.repaint(obj.getRepaintRect());
        }
        for (int i = 1; i < this.allObjects.length; ++i) {
            obj = this.allObjects[i];
            if (obj instanceof JDSwingObject) {
                ((JDSwingObject)obj).setExtendedParam(extName, value, true);
                this.invoker.repaint(obj.getRepaintRect());
                continue;
            }
            obj.setExtendedParam(extName, value);
        }
    }
}

