/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class JDFileFilter
extends FileFilter {
    private String description = null;
    private String[] extensions;

    public JDFileFilter(String desc, String[] ext) {
        this.extensions = ext;
        this.description = desc + "  (";
        for (int i = 0; i < ext.length; ++i) {
            this.description = this.description + "." + ext[i];
            if (i >= ext.length - 1) continue;
            this.description = this.description + ",";
        }
        this.description = this.description + ")";
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            return this.isWantedExtension(this.getExtension(f));
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    private boolean isWantedExtension(String ext) {
        boolean found = false;
        if (ext == null) {
            return false;
        }
        for (int i = 0; i < this.extensions.length && !found; ++i) {
            found = ext.equalsIgnoreCase(this.extensions[i]);
        }
        return found;
    }
}

