/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatableLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRect;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class JDFileLoader {
    static final int NUMBER = 1;
    static final int STRING = 2;
    static final int COMA = 3;
    static final int COLON = 4;
    static final int OPENBRACE = 5;
    static final int CLOSEBRACE = 6;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "COMA", "COLON", "'{'", "'}'"};
    static final String COMA_STR = ",";
    static final String COLON_STR = ":";
    static final String OPENBRACE_STR = "{";
    static final String CLOSEBRACE_STR = "}";
    static final int MAX_BUFFER_SIZE = 65536;
    static final int MAX_STRING_LENGTH = 4095;
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private char NextChar;
    private char[] loadingBuffer = null;
    private int bufferIdx;
    private int bufferSize;
    private String word;
    private String version;
    InputStreamReader f;
    private char[] tmpWord = new char[4096];
    Color globalBackground = JDrawEditor.defaultBackground;
    boolean autoZoomAsked = true;

    public JDFileLoader(FileReader fr) {
        this.f = fr;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
        this.NextChar = (char)32;
        this.loadingBuffer = new char[65536];
        this.bufferIdx = 0;
        this.bufferSize = 0;
    }

    public JDFileLoader(InputStreamReader insr) {
        this.f = insr;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
        this.NextChar = (char)32;
    }

    public JDFileLoader(String str) {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        this.f = new InputStreamReader(bis);
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
        this.NextChar = (char)32;
    }

    private void refill_buffer() throws IOException {
        if (this.bufferIdx >= this.bufferSize) {
            this.bufferSize = this.f.read(this.loadingBuffer);
            this.bufferIdx = 0;
        }
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.NextChar;
        if (this.loadingBuffer != null) {
            this.refill_buffer();
            if (this.bufferSize <= 0) {
                this.NextChar = '\u0000';
            } else {
                this.NextChar = this.loadingBuffer[this.bufferIdx];
                ++this.bufferIdx;
            }
        } else {
            this.NextChar = !this.f.ready() ? (char)'\u0000' : (char)this.f.read();
        }
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws IOException {
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ',') {
            this.read_char();
            return COMA_STR;
        }
        if (this.CurrentChar == ':') {
            this.read_char();
            return COLON_STR;
        }
        if (this.CurrentChar == '{') {
            this.read_char();
            return OPENBRACE_STR;
        }
        if (this.CurrentChar == '}') {
            this.read_char();
            return CLOSEBRACE_STR;
        }
        int wIdx = 0;
        if (this.CurrentChar == '\"') {
            boolean eos;
            this.tmpWord[wIdx++] = this.CurrentChar;
            this.read_char();
            boolean bl = eos = this.CurrentChar == '\"' || this.CurrentChar == '\u0000' || this.CurrentChar == '\n';
            while (!eos) {
                if (this.CurrentChar == '\\' && this.NextChar == '\"') {
                    this.tmpWord[wIdx++] = 34;
                    this.read_char();
                    this.read_char();
                } else if (this.CurrentChar == '\\' && this.NextChar == '\\') {
                    this.tmpWord[wIdx++] = 92;
                    this.read_char();
                    this.read_char();
                } else {
                    this.tmpWord[wIdx++] = this.CurrentChar;
                    this.read_char();
                }
                eos = this.CurrentChar == '\"' || this.CurrentChar == '\u0000' || this.CurrentChar == '\n' || wIdx >= 4095;
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n' || wIdx >= 4095) {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            this.tmpWord[wIdx++] = this.CurrentChar;
            this.read_char();
            return new String(this.tmpWord, 0, wIdx);
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != ':' && this.CurrentChar != '{' && this.CurrentChar != '}' && this.CurrentChar != ',' && wIdx < 4095) {
            this.tmpWord[wIdx++] = this.CurrentChar;
            this.read_char();
        }
        if (wIdx == 0) {
            return null;
        }
        return new String(this.tmpWord, 0, wIdx);
    }

    private boolean isNumber(String s) {
        char c;
        boolean ok = true;
        for (int i = 0; i < s.length() && ok; ok &= (c = s.charAt(i)) >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '-', ++i) {
        }
        return ok;
    }

    private int class_lex(String word) {
        if (word == null) {
            return 0;
        }
        if (word.length() == 0) {
            return 2;
        }
        if (word.charAt(0) == '\"') {
            return 2;
        }
        if (word.equals(COMA_STR)) {
            return 3;
        }
        if (word.equals(COLON_STR)) {
            return 4;
        }
        if (word.equals(OPENBRACE_STR)) {
            return 5;
        }
        if (word.equals(CLOSEBRACE_STR)) {
            return 6;
        }
        if (this.isNumber(word)) {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int lt, int le) throws IOException {
        if (lt != le) {
            throw new IOException("Invalid syntyax at line " + this.StartLine + ", " + this.lexical_word[le] + " expected");
        }
    }

    int getCurrentLine() {
        return this.StartLine;
    }

    void jumpPropertyValue() throws IOException {
        int lex = this.class_lex(this.word);
        if (lex == 5) {
            this.jumpBlock();
            return;
        }
        boolean ok = true;
        while (ok && this.word != null) {
            if (lex != 1 && lex != 2) {
                throw new IOException("Invalid syntyax at line " + this.StartLine + ": Number or String expected.");
            }
            this.word = this.read_word();
            lex = this.class_lex(this.word);
            ok = lex == 3;
            if (!ok) continue;
            this.word = this.read_word();
            lex = this.class_lex(this.word);
        }
    }

    void jumpBlock() throws IOException {
        int lex = this.class_lex(this.word);
        this.CHECK_LEX(lex, 5);
        int nb = 1;
        while (nb > 0 && this.word != null) {
            this.word = this.read_word();
            lex = this.class_lex(this.word);
            if (lex == 5) {
                ++nb;
            }
            if (lex != 6) continue;
            --nb;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        this.word = this.read_word();
    }

    void startBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 5);
        this.word = this.read_word();
    }

    void jumpLexem(int lexem) throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), lexem);
        this.word = this.read_word();
    }

    void endBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word();
    }

    boolean isEndBlock() {
        return this.class_lex(this.word) == 6;
    }

    double parseDouble() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        double ret = 0.0;
        try {
            ret = Double.parseDouble(this.word);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word();
        return ret;
    }

    private String extractQuote(String s) {
        if (s.charAt(0) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    String parseString() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String s = this.extractQuote(this.word);
        this.word = this.read_word();
        return s;
    }

    boolean parseBoolean() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String value = this.word;
        this.word = this.read_word();
        return value.equalsIgnoreCase("true");
    }

    Point2D.Double parsePoint() throws IOException {
        double x = this.parseDouble();
        this.jumpLexem(3);
        double y = this.parseDouble();
        return new Point2D.Double(x, y);
    }

    Point2D.Double[] parseSummitArray() throws IOException {
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        boolean end = false;
        this.CHECK_LEX(this.class_lex(this.word), 2);
        if (!this.word.equals("summit")) {
            throw new IOException("summit keyword missing at line " + this.StartLine);
        }
        this.word = this.read_word();
        this.jumpLexem(4);
        while (!end && this.word != null) {
            double x = this.parseDouble();
            this.jumpLexem(3);
            double y = this.parseDouble();
            v.add(new Point2D.Double(x, y));
            end = this.class_lex(this.word) != 3;
            if (end) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        Point2D.Double[] ret = new Point2D.Double[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = (Point2D.Double)v.get(i);
        }
        return ret;
    }

    Point2D.Double[] parseRectangularSummitArray() throws IOException {
        Point2D.Double[] ret;
        Point2D.Double[] pts = this.parseSummitArray();
        if (this.version.compareTo("v11") >= 0) {
            if (pts.length != 2) {
                throw new IOException("Invalid summit number for JDRectangular at line " + this.StartLine);
            }
            double x = pts[0].x;
            double y = pts[0].y;
            double w = pts[1].x - pts[0].x;
            double h = pts[1].y - pts[0].y;
            ret = new Point2D.Double[8];
            ret[0] = pts[0];
            ret[4] = pts[1];
            ret[1] = new Point2D.Double(x + w / 2.0, y);
            ret[2] = new Point2D.Double(x + w, y);
            ret[3] = new Point2D.Double(x + w, y + h / 2.0);
            ret[5] = new Point2D.Double(x + w / 2.0, y + h);
            ret[6] = new Point2D.Double(x, y + h);
            ret[7] = new Point2D.Double(x, y + h / 2.0);
        } else {
            ret = pts;
        }
        return ret;
    }

    String parseProperyName() throws IOException {
        String propName = this.parseString();
        this.jumpLexem(4);
        return propName;
    }

    Color parseColor() throws IOException {
        int alpha = 255;
        int red = (int)this.parseDouble();
        this.jumpLexem(3);
        int green = (int)this.parseDouble();
        this.jumpLexem(3);
        int blue = (int)this.parseDouble();
        if (this.class_lex(this.word) == 3) {
            this.jumpLexem(3);
            alpha = (int)this.parseDouble();
        }
        return new Color(red, green, blue, alpha);
    }

    String parseStringArray() throws IOException {
        Vector<String> v = new Vector<String>();
        boolean end = false;
        while (!end && this.word != null) {
            String s = this.parseString();
            v.add(s);
            end = this.class_lex(this.word) != 3;
            if (end) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        Object ret = "";
        for (int i = 0; i < v.size(); ++i) {
            ret = (String)ret + (String)v.get(i) + "\n";
        }
        return ret;
    }

    Font parseFont() throws IOException {
        String FontName = this.parseString();
        this.jumpLexem(3);
        int FontStyle = (int)this.parseDouble();
        this.jumpLexem(3);
        int FontSize = (int)this.parseDouble();
        return new Font(FontName, FontStyle, FontSize);
    }

    void parseGlobalSection() throws IOException {
        this.startBlock();
        while (!this.isEndBlock()) {
            String propName = this.parseProperyName();
            if (propName.equals("background")) {
                this.globalBackground = this.parseColor();
                continue;
            }
            if (propName.equals("autoZoom")) {
                this.autoZoomAsked = this.parseBoolean();
                continue;
            }
            System.out.println("Unknown global property found:" + propName);
            this.jumpPropertyValue();
        }
        this.endBlock();
    }

    JDObject parseObject() throws IOException {
        String className = this.parseString();
        if (className.equals("JDEllipse")) {
            return new JDEllipse(this);
        }
        if (className.equals("JDRectangle")) {
            return new JDRectangle(this);
        }
        if (className.equals("JDRoundRectangle")) {
            return new JDRoundRectangle(this);
        }
        if (className.equals("JDLabel")) {
            return new JDLabel(this);
        }
        if (className.equals("JDLine")) {
            return new JDLine(this);
        }
        if (className.equals("JDPolyline")) {
            return new JDPolyline(this);
        }
        if (className.equals("JDTitledRect")) {
            return new JDTitledRect(this);
        }
        if (className.equals("JDSpline")) {
            return new JDSpline(this);
        }
        if (className.equals("JDGroup")) {
            return new JDGroup(this);
        }
        if (className.equals("JDImage")) {
            return new JDImage(this);
        }
        if (className.equals("JDSwingObject")) {
            return new JDSwingObject(this);
        }
        if (className.equals("JDAxis")) {
            return new JDAxis(this);
        }
        if (className.equals("JDBar")) {
            return new JDBar(this);
        }
        if (className.equals("JDSlider")) {
            return new JDSlider(this);
        }
        if (className.equals("JDRotatableLabel")) {
            return new JDRotatableLabel(this);
        }
        if (className.equals("Global")) {
            this.parseGlobalSection();
            return null;
        }
        System.out.println("JDFileLoader.parseObject() Unknown class found:" + className + " at line " + this.StartLine);
        this.jumpBlock();
        return null;
    }

    String parseParamString() throws IOException {
        Vector<String> v = new Vector<String>();
        boolean end = false;
        while (!end && this.word != null) {
            int lex = this.class_lex(this.word);
            if (lex != 2 && lex != 1) {
                throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[1] + "' or '" + this.lexical_word[2] + "' expected");
            }
            v.add(this.extractQuote(this.word));
            this.word = this.read_word();
            end = this.class_lex(this.word) != 3;
            if (end) continue;
            this.word = this.read_word();
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file");
        }
        Object ret = "";
        for (int i = 0; i < v.size(); ++i) {
            ret = (String)ret + (String)v.get(i);
            if (i >= v.size() - 1) continue;
            ret = (String)ret + "\n";
        }
        return ret;
    }

    public Vector parseFile() throws IOException {
        boolean eof = false;
        Vector<JDObject> objects = new Vector<JDObject>();
        this.read_char();
        this.word = this.read_word();
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("jdfile")) {
            throw new IOException("Invalid header !");
        }
        this.jumpLexem(2);
        this.version = this.parseString();
        this.jumpLexem(5);
        int lex = this.class_lex(this.word);
        while (!eof) {
            switch (lex) {
                case 2: {
                    JDObject p = this.parseObject();
                    if (p == null) break;
                    objects.add(p);
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    throw new IOException("Invalid syntyax at line " + this.StartLine + ": Class name or '}' expected.");
                }
            }
            lex = this.class_lex(this.word);
            eof = this.word == null || lex == 6;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file at line " + this.StartLine + ".");
        }
        this.CHECK_LEX(this.class_lex(this.word), 6);
        return objects;
    }
}

