/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDGradientViewer;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDGradientDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private JDGradientViewer viewer;
    private JLabel color1Label;
    private JButton color1Button;
    private JLabel color2Label;
    private JButton color2Button;
    private JLabel ampLabel;
    private JSpinner ampSpinner;
    private JLabel offLabel;
    private JSpinner offSpinner;
    private JCheckBox cyclicCheckBox;
    private JDObject[] allObjects;
    private JComponent invoker;
    private JButton applyButton;
    private JButton dismissButton;
    private boolean modified = false;

    public JDGradientDialog(JDialog parent, JDObject[] p, JComponent jc) {
        super((Dialog)parent, true);
        this.allObjects = p;
        this.invoker = jc;
        this.initComponents();
    }

    public JDGradientDialog(JFrame parent, JDObject[] p, JComponent jc) {
        super((Frame)parent, true);
        this.allObjects = p;
        this.invoker = jc;
        this.initComponents();
    }

    private void initComponents() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(null);
        this.viewer = new JDGradientViewer();
        this.viewer.setGradient(this.allObjects[0].gradientX1, this.allObjects[0].gradientY1, this.allObjects[0].gradientC1, this.allObjects[0].gradientX2, this.allObjects[0].gradientY2, this.allObjects[0].gradientC2, this.allObjects[0].gradientCyclic);
        this.viewer.setBorder(BorderFactory.createEtchedBorder());
        this.viewer.setBounds(5, 5, 200, 200);
        innerPanel.add(this.viewer);
        this.color1Label = JDUtils.createLabel("Color 1");
        this.color1Label.setBounds(210, 5, 90, 24);
        innerPanel.add(this.color1Label);
        this.color1Button = new JButton("...");
        this.color1Button.setMargin(new Insets(0, 0, 0, 0));
        this.color1Button.setBackground(this.allObjects[0].gradientC1);
        this.color1Button.addActionListener(this);
        this.color1Button.setBounds(300, 5, 60, 24);
        innerPanel.add(this.color1Button);
        this.color2Label = JDUtils.createLabel("Color 2");
        this.color2Label.setBounds(210, 35, 90, 24);
        innerPanel.add(this.color2Label);
        this.color2Button = new JButton("...");
        this.color2Button.setMargin(new Insets(0, 0, 0, 0));
        this.color2Button.setBackground(this.allObjects[0].gradientC2);
        this.color2Button.addActionListener(this);
        this.color2Button.setBounds(300, 35, 60, 24);
        innerPanel.add(this.color2Button);
        this.ampLabel = new JLabel("Amplitude");
        this.ampLabel.setFont(JDUtils.labelFont);
        this.ampLabel.setForeground(JDUtils.labelColor);
        this.ampLabel.setBounds(210, 65, 90, 24);
        innerPanel.add(this.ampLabel);
        this.ampSpinner = new JSpinner();
        Integer value = new Integer(this.viewer.getAmplitupe());
        Integer min = new Integer(1);
        Integer max = new Integer(65535);
        Integer step = new Integer(1);
        SpinnerNumberModel spModel = new SpinnerNumberModel(value, min, max, step);
        this.ampSpinner.setModel(spModel);
        this.ampSpinner.addChangeListener(this);
        this.ampSpinner.setBounds(300, 65, 60, 26);
        innerPanel.add(this.ampSpinner);
        this.offLabel = new JLabel("Offset");
        this.offLabel.setFont(JDUtils.labelFont);
        this.offLabel.setForeground(JDUtils.labelColor);
        this.offLabel.setBounds(210, 95, 90, 24);
        innerPanel.add(this.offLabel);
        this.offSpinner = new JSpinner();
        value = new Integer(this.viewer.getOffset());
        min = new Integer(0);
        max = new Integer(65535);
        step = new Integer(1);
        spModel = new SpinnerNumberModel(value, min, max, step);
        this.offSpinner.setModel(spModel);
        this.offSpinner.addChangeListener(this);
        this.offSpinner.setBounds(300, 95, 60, 26);
        innerPanel.add(this.offSpinner);
        this.cyclicCheckBox = new JCheckBox("Cyclic");
        this.cyclicCheckBox.setFont(JDUtils.labelFont);
        this.cyclicCheckBox.setForeground(JDUtils.labelColor);
        this.cyclicCheckBox.setBounds(210, 125, 150, 25);
        this.cyclicCheckBox.setSelected(this.viewer.isCyclic());
        this.cyclicCheckBox.addActionListener(this);
        innerPanel.add(this.cyclicCheckBox);
        this.applyButton = new JButton("Apply");
        this.applyButton.setFont(JDUtils.labelFont);
        this.applyButton.addActionListener(this);
        this.applyButton.setBounds(5, 210, 100, 26);
        innerPanel.add(this.applyButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.setFont(JDUtils.labelFont);
        this.dismissButton.addActionListener(this);
        this.dismissButton.setBounds(260, 210, 100, 26);
        innerPanel.add(this.dismissButton);
        this.setTitle("Gradient properties");
        this.setContentPane(innerPanel);
    }

    private void repaintObjects() {
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect);
    }

    public boolean editGradient() {
        ATKGraphicsUtils.centerDialog(this, 367, 240);
        this.setVisible(true);
        return this.modified;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.color1Button) {
            Color c = JColorChooser.showDialog(this, "Choose 1st color", this.color1Button.getBackground());
            if (c != null) {
                this.viewer.setColor1(c);
                this.color1Button.setBackground(c);
            }
        } else if (src == this.color2Button) {
            Color c = JColorChooser.showDialog(this, "Choose 2nd color", this.color2Button.getBackground());
            if (c != null) {
                this.viewer.setColor2(c);
                this.color2Button.setBackground(c);
            }
        } else if (src == this.cyclicCheckBox) {
            this.viewer.setCyclic(this.cyclicCheckBox.isSelected());
        } else if (src == this.applyButton) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setGradientFillParam(this.viewer.getX1(), this.viewer.getY1(), this.viewer.getColor1(), this.viewer.getX2(), this.viewer.getY2(), this.viewer.getColor2(), this.viewer.isCyclic());
            }
            this.modified = true;
            this.repaintObjects();
        } else if (src == this.dismissButton) {
            this.dispose();
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.ampSpinner) {
            Integer v = (Integer)this.ampSpinner.getValue();
            this.viewer.setAmplitute(v);
        } else if (src == this.offSpinner) {
            Integer v = (Integer)this.offSpinner.getValue();
            this.viewer.setOffset(v);
        }
    }
}

