/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

class JDGradientViewer
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Cursor moveCursor = Cursor.getPredefinedCursor(13);
    private Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private static final double arrowLgth = 50.0;
    private static final Color transBlue = new Color(0, 255, 0, 196);
    private GradientPaint gradient = null;
    private double amp;
    private double vx;
    private double vy;
    private int xc = 0;
    private int yc = 0;
    private int dragMode = 0;
    private double offset;

    public JDGradientViewer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setGradient(float x1, float y1, Color color1, float x2, float y2, Color color2, boolean cyclic) {
        this.gradient = new GradientPaint(x1, y1, color1, x2, y2, color2, cyclic);
        this.vx = x2 - x1;
        this.vy = y2 - y1;
        this.amp = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        this.vx = this.vx * 50.0 / this.amp;
        this.vy = this.vy * 50.0 / this.amp;
        this.offset = Math.sqrt(x1 * x1 + y1 * y1);
        this.repaint();
    }

    public float getX1() {
        return (float)this.gradient.getPoint1().getX();
    }

    public float getY1() {
        return (float)this.gradient.getPoint1().getY();
    }

    public float getX2() {
        return (float)this.gradient.getPoint2().getX();
    }

    public float getY2() {
        return (float)this.gradient.getPoint2().getY();
    }

    public Color getColor1() {
        return this.gradient.getColor1();
    }

    public void setColor1(Color c1) {
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), c1, (float)this.gradient.getPoint2().getX(), (float)this.gradient.getPoint2().getY(), this.gradient.getColor2(), this.gradient.isCyclic());
    }

    public Color getColor2() {
        return this.gradient.getColor2();
    }

    public void setColor2(Color c2) {
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), this.gradient.getColor1(), (float)this.gradient.getPoint2().getX(), (float)this.gradient.getPoint2().getY(), c2, this.gradient.isCyclic());
    }

    public boolean isCyclic() {
        return this.gradient.isCyclic();
    }

    public void setCyclic(boolean b) {
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), this.gradient.getColor1(), (float)this.gradient.getPoint2().getX(), (float)this.gradient.getPoint2().getY(), this.gradient.getColor2(), b);
    }

    public int getAmplitupe() {
        return (int)(this.amp + 0.5);
    }

    public void setAmplitute(int a) {
        double r = (double)a / this.amp;
        double nx2 = this.gradient.getPoint2().getX() - this.gradient.getPoint1().getX();
        double ny2 = this.gradient.getPoint2().getY() - this.gradient.getPoint1().getY();
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), this.gradient.getColor1(), (float)(this.gradient.getPoint1().getX() + nx2 * r), (float)(this.gradient.getPoint1().getY() + ny2 * r), this.gradient.getColor2(), this.gradient.isCyclic());
    }

    public int getOffset() {
        return (int)(this.offset + 0.5);
    }

    public void setOffset(int a) {
        double nOffset = (double)a - this.offset;
        double r = nOffset / 50.0;
        float tx = (float)(this.vx * r);
        float ty = (float)(this.vy * r);
        this.setGradient((float)this.gradient.getPoint1().getX() + tx, (float)this.gradient.getPoint1().getY() + ty, this.gradient.getColor1(), (float)this.gradient.getPoint2().getX() + tx, (float)this.gradient.getPoint2().getY() + ty, this.gradient.getColor2(), this.gradient.isCyclic());
    }

    @Override
    public void paint(Graphics g) {
        if (this.gradient != null) {
            Dimension d = this.getSize();
            this.xc = d.width / 2;
            this.yc = d.height / 2;
            g.translate(this.xc, this.yc);
            ((Graphics2D)g).setPaint(this.gradient);
            g.fillRect(-this.xc, -this.yc, d.width, d.height);
            g.translate(-this.xc, -this.yc);
            g.setColor(transBlue);
            g.fillRect(this.xc - 2, this.yc - 2, 5, 5);
            g.drawLine(this.xc, this.yc, this.xc + (int)this.vx, this.yc + (int)this.vy);
            g.drawRect(this.xc + (int)this.vx - 3, this.yc + (int)this.vy - 3, 6, 6);
            g.drawOval(this.xc - 50, this.yc - 50, 100, 100);
        }
        this.paintBorder(g);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragMode = this.isInside(e) ? 1 : 0;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragMode = 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragMode == 1) {
            double nx = e.getX() - this.xc;
            double ny = e.getY() - this.yc;
            double nn = Math.sqrt(nx * nx + ny * ny);
            double x1 = this.gradient.getPoint1().getX();
            double y1 = this.gradient.getPoint1().getY();
            double n1 = Math.sqrt(x1 * x1 + y1 * y1) / nn;
            double x2 = this.gradient.getPoint2().getX();
            double y2 = this.gradient.getPoint2().getY();
            double n2 = Math.sqrt(x2 * x2 + y2 * y2) / nn;
            if (nn > 5.0) {
                this.setGradient((float)(nx * n1), (float)(ny * n1), this.gradient.getColor1(), (float)(nx * n2), (float)(ny * n2), this.gradient.getColor2(), this.gradient.isCyclic());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isInside(e)) {
            this.setCursor(this.moveCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    private boolean isInside(MouseEvent e) {
        int px = this.xc + (int)this.vx - e.getX();
        int py = this.yc + (int)this.vy - e.getY();
        return px > -5 && px < 5 && py > -5 && py < 5;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

