/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JDGroup
extends JDRectangular {
    private Vector children;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private boolean vFlat = false;
    private boolean hFlat = false;

    public JDGroup(String objectName, Vector o) {
        this.initDefault();
        this.children = new Vector();
        for (int i = 0; i < o.size(); ++i) {
            this.children.add(o.get(i));
        }
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    JDGroup(JDGroup e, int x, int y) {
        this.cloneObject(e, x, y);
        this.children = new Vector();
        for (int i = 0; i < e.children.size(); ++i) {
            this.children.add(((JDObject)e.children.get(i)).copy(x, y));
        }
        this.computeGroupBoundRect();
        this.updateShape();
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDGroup(this, x, y);
    }

    JDGroup(JLXObject jlxObj, Vector o) {
        this.initDefault();
        this.loadObject(jlxObj);
        this.children = o;
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    JDGroup(LXObject lxObj, Vector o) {
        this.initDefault();
        this.loadObject(lxObj);
        this.children = o;
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    private boolean canPaint() {
        if (!this.visible) {
            return false;
        }
        if (this.hFlat) {
            return this.boundRect.width > 1 || !(Math.abs(this.summit[4].x - this.summit[0].x) < 0.5);
        }
        if (this.vFlat) {
            return this.boundRect.height > 1 || !(Math.abs(this.summit[4].y - this.summit[0].y) < 0.5);
        }
        return this.boundRect.width > 1 && this.boundRect.height > 1 || !(Math.abs(this.summit[4].x - this.summit[0].x) < 0.5) && !(Math.abs(this.summit[4].y - this.summit[0].y) < 0.5);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (this.canPaint()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).paint(parent, g);
            }
        }
    }

    @Override
    void paintShadows(Graphics g) {
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        boolean found = false;
        for (int i = this.children.size() - 1; i >= 0 && !found; --i) {
            found = ((JDObject)this.children.get(i)).isInsideObject(x, y);
        }
        return found;
    }

    @Override
    void updateShape() {
        double sy;
        if (this.hFlat ? Math.abs(this.summit[4].x - this.summit[0].x) < 0.5 : (this.vFlat ? Math.abs(this.summit[4].y - this.summit[0].y) < 0.5 : Math.abs(this.summit[4].x - this.summit[0].x) < 0.5 || Math.abs(this.summit[4].y - this.summit[0].y) < 0.5)) {
            return;
        }
        double nx1 = this.summit[0].x;
        double ny1 = this.summit[0].y;
        double nx2 = this.summit[4].x;
        double ny2 = this.summit[4].y;
        double tx = nx1 - this.x1;
        double ty = ny1 - this.y1;
        double sx = this.vFlat ? 1.0 : (nx2 - nx1) / (this.x2 - this.x1);
        double d = sy = this.hFlat ? 1.0 : (ny2 - ny1) / (this.y2 - this.y1);
        if (sx == 1.0 && sy == 1.0) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).translate(tx, ty);
            }
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).scaleTranslate(this.x1, this.y1, sx, sy, tx, ty);
            }
        }
        this.computeGroupBoundRect();
        this.computeBoundRect();
    }

    @Override
    public void restoreTransform() {
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).restoreTransform();
        }
        this.computeGroupBoundRect();
        super.restoreTransform();
    }

    @Override
    public void saveTransform() {
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).saveTransform();
        }
        super.saveTransform();
    }

    @Override
    public void rotate90(double x, double y) {
        for (int i = 0; i < this.getChildrenNumber(); ++i) {
            this.getChildAt(i).rotate90(x, y);
        }
        this.computeSummitCoordinates();
        this.updateShape();
    }

    @Override
    int getSummitMotion(int id) {
        if (this.hFlat) {
            if (id == 1 || id == 5) {
                return 0;
            }
            return 1;
        }
        if (this.vFlat) {
            if (id == 7 || id == 3) {
                return 0;
            }
            return 2;
        }
        return super.getSummitMotion(id);
    }

    @Override
    public void moveSummit(int id, double x, double y) {
        if (this.hFlat) {
            switch (id) {
                case 0: 
                case 6: 
                case 7: {
                    super.moveSummit(7, x, y);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    super.moveSummit(3, x, y);
                }
            }
            return;
        }
        if (this.vFlat) {
            switch (id) {
                case 0: 
                case 1: 
                case 2: {
                    super.moveSummit(1, x, y);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    super.moveSummit(5, x, y);
                }
            }
            return;
        }
        super.moveSummit(id, x, y);
    }

    @Override
    void paintSummit(Graphics g, double summitWidth) {
        int sw = (int)(summitWidth / 2.0 + 1.0);
        if (this.hFlat) {
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            g.fillRect((int)(this.summit[0].x - (double)sw), (int)(this.summit[0].y - (double)sw), 2 * sw, 2 * sw);
            g.fillRect((int)(this.summit[2].x - (double)sw), (int)(this.summit[2].y - (double)sw), 2 * sw, 2 * sw);
            g.setPaintMode();
            return;
        }
        if (this.vFlat) {
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            g.fillRect((int)(this.summit[0].x - (double)sw), (int)(this.summit[0].y - (double)sw), 2 * sw, 2 * sw);
            g.fillRect((int)(this.summit[6].x - (double)sw), (int)(this.summit[6].y - (double)sw), 2 * sw, 2 * sw);
            g.setPaintMode();
            return;
        }
        super.paintSummit(g, summitWidth);
    }

    @Override
    void setParent(JDrawEditor p) {
        super.setParent(p);
        for (int i = 0; i < this.getChildrenNumber(); ++i) {
            this.getChildAt(i).setParent(p);
        }
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle r = null;
        for (int i = 0; i < this.children.size(); ++i) {
            r = i == 0 ? ((JDObject)this.children.get(i)).getRepaintRect() : r.union(((JDObject)this.children.get(i)).getRepaintRect());
        }
        if (r == null) {
            int sw = this.lineWidth + 1;
            return new Rectangle(this.boundRect.x - sw, this.boundRect.y - sw, this.boundRect.width + sw * 2, this.boundRect.height + sw * 2);
        }
        return r;
    }

    @Override
    public void setBackground(Color c) {
        this.background = c;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        this.foreground = c;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setForeground(c);
        }
    }

    @Override
    public void setFillStyle(int s) {
        this.fillStyle = s;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setFillStyle(s);
        }
    }

    @Override
    public void setLineStyle(int s) {
        this.lineStyle = s;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setLineStyle(s);
        }
    }

    @Override
    public void setAntiAlias(boolean alias) {
        this.antiAlias = alias;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setAntiAlias(alias);
        }
    }

    @Override
    public void setLineWidth(int w) {
        this.lineWidth = w;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setLineWidth(w);
        }
    }

    @Override
    public void setShadow(boolean b) {
        this.isShadowed = b;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setShadow(b);
        }
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setVisible(b);
        }
    }

    @Override
    public void setInverseShadow(boolean b) {
        this.invertShadow = b;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setInverseShadow(b);
        }
    }

    @Override
    public void setShadowWidth(int w) {
        this.shadowThickness = w;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setShadowWidth(w);
        }
    }

    @Override
    void setVal(int v, JDObject master) {
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setVal(v, master);
        }
        super.setVal(v, master);
    }

    @Override
    void initVal(JDObject master) {
        JDObject m = this.isInteractive() ? this : master;
        super.initVal(m);
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).initVal(m);
        }
    }

    @Override
    public void setMinValue(int v) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).setMinValue(v);
        }
        super.setMinValue(v);
    }

    @Override
    public void setMaxValue(int v) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).setMaxValue(v);
        }
        super.setMaxValue(v);
    }

    @Override
    public void setInitValue(int v) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).setInitValue(v);
        }
        super.setInitValue(v);
    }

    @Override
    void findObjectsAt(int x, int y, Vector result) {
        if (this.isInteractive()) {
            super.findObjectsAt(x, y, result);
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).findObjectsAt(x, y, result);
        }
    }

    @Override
    void getUserValueList(Vector result) {
        if (this.isInteractive()) {
            result.add(this);
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                this.getChildAt(i).getUserValueList(result);
            }
        }
    }

    @Override
    void getObjectsByClassList(Vector result, Class theClass) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).getObjectsByClassList(result, theClass);
        }
    }

    @Override
    public void getObjectsByName(Vector result, String name, boolean recurseGroup) {
        super.getObjectsByName(result, name, recurseGroup);
        for (int i = 0; i < this.children.size() && recurseGroup; ++i) {
            this.getChildAt(i).getObjectsByName(result, name, recurseGroup);
        }
    }

    @Override
    public boolean isProgrammed() {
        boolean ret = super.isProgrammed();
        for (int i = 0; i < this.children.size(); ++i) {
            ret |= this.getChildAt(i).isProgrammed();
        }
        return ret;
    }

    public JDObject getChildAt(int idx) {
        return (JDObject)this.children.get(idx);
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public void setChildrenList(Vector o) {
        this.children = new Vector();
        for (int i = 0; i < o.size(); ++i) {
            this.children.add(o.get(i));
        }
        this.computeSummitCoordinates();
        this.updateShape();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void generateJavaClass(FileWriter f) throws IOException {
        int j;
        int i;
        int xOrg = this.boundRect.x + this.boundRect.width / 2;
        int yOrg = this.boundRect.y + this.boundRect.height / 2;
        class ObjInfo {
            int type;
            boolean closed;
            int[] xPolys;
            int[] yPolys;
            int backgroundId;
            int foregroundId;

            ObjInfo() {
            }

            void setValue(JDPolyline p, int xOrg, int yOrg, ColorManager c) {
                this.type = 1;
                this.xPolys = new int[p.getSummitNumber()];
                this.yPolys = new int[p.getSummitNumber()];
                for (int j = 0; j < p.getSummitNumber(); ++j) {
                    this.xPolys[j] = (int)p.getSummit((int)j).x - xOrg;
                    this.yPolys[j] = (int)p.getSummit((int)j).y - yOrg;
                }
                if (p.getName().equalsIgnoreCase("body")) {
                    this.backgroundId = -3;
                    this.foregroundId = -1;
                } else {
                    class ColorManager {
                        Vector colors = new Vector();

                        ColorManager() {
                        }

                        int addColor(Color c) {
                            if (c.equals(Color.black)) {
                                return -1;
                            }
                            if (c.equals(Color.white)) {
                                return -2;
                            }
                            int i = 0;
                            boolean found = false;
                            while (i < this.colors.size() && !found) {
                                found = ((Color)this.colors.get(i)).getRGB() == c.getRGB();
                                if (found) continue;
                                ++i;
                            }
                            if (!found) {
                                this.colors.add(c);
                            }
                            return i;
                        }

                        Color get(int i) {
                            return (Color)this.colors.get(i);
                        }

                        String getName(int i) {
                            if (i == -1) {
                                return "Color.black";
                            }
                            if (i == -2) {
                                return "Color.white";
                            }
                            if (i == -3) {
                                return "backColor";
                            }
                            return "sColor" + i;
                        }
                    }
                    this.backgroundId = c.addColor(p.getBackground());
                    this.foregroundId = c.addColor(p.getForeground());
                }
                this.closed = p.isClosed();
            }
        }
        ObjInfo[] objInfo = new ObjInfo[this.getChildrenNumber()];
        ColorManager colorManager = new ColorManager();
        for (i = 0; i < this.getChildrenNumber(); ++i) {
            JDObject p;
            objInfo[i] = new ObjInfo();
            if (this.getChildAt(i) instanceof JDPolyConvert) {
                p = ((JDPolyConvert)((Object)this.getChildAt(i))).convertToPolyline();
                objInfo[i].setValue((JDPolyline)p, xOrg, yOrg, colorManager);
                continue;
            }
            if (this.getChildAt(i) instanceof JDPolyline) {
                p = (JDPolyline)this.getChildAt(i);
                objInfo[i].setValue((JDPolyline)p, xOrg, yOrg, colorManager);
                continue;
            }
            if (this.getChildAt(i) instanceof JDLine) {
                p = (JDLine)this.getChildAt(i);
                objInfo[i].type = 2;
                objInfo[i].xPolys = new int[2];
                objInfo[i].yPolys = new int[2];
                objInfo[i].xPolys[0] = (int)p.getSummit((int)0).x - xOrg;
                objInfo[i].yPolys[0] = (int)p.getSummit((int)0).y - yOrg;
                objInfo[i].xPolys[1] = (int)p.getSummit((int)1).x - xOrg;
                objInfo[i].yPolys[1] = (int)p.getSummit((int)1).y - yOrg;
                objInfo[i].foregroundId = colorManager.addColor(p.getForeground());
                continue;
            }
            throw new IOException("generateJavaClass() supports only Line or Polyline");
        }
        f.write("/** ---------- " + this.getName() + " class ---------- */\n");
        f.write("public class " + this.getName() + " {\n\n");
        f.write("  private static int[][] xPolys = null;\n");
        f.write("  private static int[][] yPolys = null;\n\n");
        for (i = 0; i < colorManager.colors.size(); ++i) {
            Color c = colorManager.get(i);
            f.write("  private static Color sColor" + i + " = new Color(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");\n");
        }
        f.write("\n");
        f.write("  private static int[][] xOrgPolys = {\n");
        for (i = 0; i < this.getChildrenNumber(); ++i) {
            if (objInfo[i].type != 1) continue;
            f.write("    {");
            for (j = 0; j < objInfo[i].xPolys.length; ++j) {
                f.write(Integer.toString(objInfo[i].xPolys[j]));
                if (j >= objInfo[i].xPolys.length - 1) continue;
                f.write(",");
            }
            f.write("},\n");
        }
        f.write("  };\n\n");
        f.write("  private static int[][] yOrgPolys = {\n");
        for (i = 0; i < this.getChildrenNumber(); ++i) {
            if (objInfo[i].type != 1) continue;
            f.write("    {");
            for (j = 0; j < objInfo[i].yPolys.length; ++j) {
                f.write(Integer.toString(objInfo[i].yPolys[j]));
                if (j >= objInfo[i].yPolys.length - 1) continue;
                f.write(",");
            }
            f.write("},\n");
        }
        f.write("  };\n\n");
        f.write("  static public void paint(Graphics g,Color backColor,int x,int y,double size) {\n\n");
        f.write("    // Allocate array once\n");
        f.write("    if( xPolys == null ) {\n");
        f.write("      xPolys = new int [xOrgPolys.length][];\n");
        f.write("      yPolys = new int [yOrgPolys.length][];\n");
        f.write("      for( int i=0 ; i<xOrgPolys.length ; i++ ) {\n");
        f.write("        xPolys[i] = new int [xOrgPolys[i].length];\n");
        f.write("        yPolys[i] = new int [yOrgPolys[i].length];\n");
        f.write("      }\n");
        f.write("    }\n\n");
        f.write("    // Scale and translate poly\n");
        f.write("    for( int i=0 ; i<xOrgPolys.length ; i++ ) {\n");
        f.write("      for( int j=0 ; j<xOrgPolys[i].length ; j++ ) {\n");
        f.write("        xPolys[i][j] = (int)((double)xOrgPolys[i][j]*size+0.5) + x;\n");
        f.write("        yPolys[i][j] = (int)((double)yOrgPolys[i][j]*size+0.5) + y;\n");
        f.write("      }\n");
        f.write("    }\n\n");
        f.write("    // Paint object\n");
        int k = 0;
        for (i = 0; i < this.getChildrenNumber(); ++i) {
            if (objInfo[i].type == 1) {
                if (this.getChildAt(i).getFillStyle() != 0) {
                    f.write("    g.setColor(" + colorManager.getName(objInfo[i].backgroundId) + ");g.fillPolygon(xPolys[" + k + "],yPolys[" + k + "],xPolys[" + k + "].length);\n");
                }
                if (objInfo[i].closed) {
                    f.write("    g.setColor(" + colorManager.getName(objInfo[i].foregroundId) + ");g.drawPolygon(xPolys[" + k + "],yPolys[" + k + "],xPolys[" + k + "].length);\n");
                } else {
                    f.write("    g.setColor(" + colorManager.getName(objInfo[i].foregroundId) + ");g.drawPolyline(xPolys[" + k + "],yPolys[" + k + "],xPolys[" + k + "].length);\n");
                }
                ++k;
                continue;
            }
            f.write("    g.setColor(" + colorManager.getName(objInfo[i].foregroundId) + ");\n");
            f.write("    g.drawLine((int)(" + objInfo[i].xPolys[0] + ".0*size+0.5)+x, (int)(" + objInfo[i].yPolys[0] + ".0*size+0.5)+y, (int)(" + objInfo[i].xPolys[1] + ".0*size+0.5)+x, (int)(" + objInfo[i].yPolys[1] + ".0*size+0.5)+y);\n");
        }
        f.write("\n  }\n\n");
        f.write("  static public void setBoundRect(int x,int y,double size,Rectangle bound) {\n");
        f.write("    bound.setRect((int)(" + (this.boundRect.x - xOrg) + ".0*size+0.5)+x,(int)(" + (this.boundRect.y - yOrg) + ".0*size+0.5)+y,(int)(" + this.boundRect.width + ".0*size+0.5),(int)(" + this.boundRect.height + ".0*size+0.5));");
        f.write("\n  }\n\n");
        f.write("}\n\n");
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        if (this.children.size() > 0) {
            StringBuffer decal = this.recordObjectHeader(to_write, level);
            to_write.append(decal).append("children: {\n");
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).recordObject(to_write, level + 2);
            }
            to_write.append(decal).append("}\n");
            this.closeObjectHeader(to_write, level);
        }
    }

    JDGroup(JDFileLoader f) throws IOException {
        this.children = new Vector();
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("children")) {
                f.startBlock();
                while (!f.isEndBlock()) {
                    this.children.add(f.parseObject());
                }
                f.endBlock();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.computeGroupBoundRect();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(2);
        this.fillUndoPattern(u);
        u.gChildren = new Vector();
        for (int i = 0; i < this.children.size(); ++i) {
            u.gChildren.add(((JDObject)this.children.get(i)).getUndoPattern());
        }
        return u;
    }

    JDGroup(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.children = new Vector();
        for (int i = 0; i < e.gChildren.size(); ++i) {
            UndoPattern u = (UndoPattern)e.gChildren.get(i);
            UndoBuffer.rebuildObject(u, this.children);
        }
        this.computeGroupBoundRect();
        this.updateShape();
    }

    private void computeGroupBoundRect() {
        double t;
        this.x1 = 65536.0;
        this.y1 = 65536.0;
        this.x2 = -65536.0;
        this.y2 = -65536.0;
        for (int i = 0; i < this.children.size(); ++i) {
            JDObject p = (JDObject)this.children.get(i);
            for (int j = 0; j < p.summit.length; ++j) {
                if (p.summit[j].x < this.x1) {
                    this.x1 = p.summit[j].x;
                }
                if (p.summit[j].y < this.y1) {
                    this.y1 = p.summit[j].y;
                }
                if (p.summit[j].x > this.x2) {
                    this.x2 = p.summit[j].x;
                }
                if (!(p.summit[j].y > this.y2)) continue;
                this.y2 = p.summit[j].y;
            }
        }
        this.hFlat = this.y2 == this.y1;
        boolean bl = this.vFlat = this.x2 == this.x1;
        if (this.summit[0].x > this.summit[4].x) {
            t = this.x1;
            this.x1 = this.x2;
            this.x2 = t;
        }
        if (this.summit[0].y > this.summit[4].y) {
            t = this.y1;
            this.y1 = this.y2;
            this.y2 = t;
        }
    }

    private void computeSummitCoordinates() {
        this.computeGroupBoundRect();
        if (this.children.size() >= 0) {
            this.summit[0].x = this.x1;
            this.summit[0].y = this.y1;
            this.summit[2].x = this.x2;
            this.summit[2].y = this.y1;
            this.summit[4].x = this.x2;
            this.summit[4].y = this.y2;
            this.summit[6].x = this.x1;
            this.summit[6].y = this.y2;
            this.centerSummit();
        }
        this.setOrigin(new Point2D.Double((this.x2 - this.x1) / 2.0, (this.y2 - this.y1) / 2.0));
    }
}

