/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class JDImage
extends JDRectangular {
    private static ImageIcon defaultImage = new ImageIcon(JDImage.class.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/not_found.gif"));
    private Image theImage = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private String fileName;

    public JDImage(String objectName, String fileName, int x, int y) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.fileName = fileName;
        this.lineWidth = 0;
        this.createSummit();
        this.loadImage();
        this.computeSummitCoordinates(x, y, this.imgWidth, this.imgHeight);
        this.updateShape();
        this.centerOrigin();
    }

    JDImage(JDImage e, int x, int y) {
        this.cloneObject(e, x, y);
        this.fileName = new String(e.fileName);
        this.invalidateImage();
        this.updateShape();
    }

    JDImage(JLXObject jlxObj, String fileName) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        if (fileName.startsWith("file:/")) {
            fileName = fileName.substring(6);
        }
        this.fileName = fileName;
        this.lineWidth = 0;
        this.fillStyle = 0;
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.loadImage();
        this.updateShape();
    }

    JDImage(LXObject lxObj, String fileName) {
        this.initDefault();
        this.loadObject(lxObj);
        double x = lxObj.boundRect.getX();
        double y = lxObj.boundRect.getY();
        double w = lxObj.boundRect.getWidth() - 1.0;
        double h = lxObj.boundRect.getHeight() - 1.0;
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        if (fileName.startsWith("file:/")) {
            fileName = fileName.substring(6);
        }
        this.fileName = fileName;
        this.lineWidth = 0;
        this.fillStyle = 0;
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.loadImage();
        this.updateShape();
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDImage(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        this.prepareRendering((Graphics2D)g);
        super.paint(parent, g);
        this.loadImage();
        g.drawImage(this.theImage, this.boundRect.x, this.boundRect.y, this.boundRect.width, this.boundRect.height, null);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.invalidateImage();
        this.loadImage();
        this.computeSummitCoordinates((int)this.summit[0].x, (int)this.summit[0].y, this.imgWidth, this.imgHeight);
        this.updateShape();
        this.centerOrigin();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void resetToOriginalSize() {
        this.computeSummitCoordinates((int)this.summit[0].x, (int)this.summit[0].y, this.imgWidth, this.imgHeight);
        this.updateShape();
        this.centerOrigin();
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        to_write.append(decal).append("file_name:\"").append(this.fileName).append("\"\n");
        this.closeObjectHeader(to_write, level);
    }

    JDImage(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("file_name")) {
                this.fileName = f.parseString();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.invalidateImage();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(9);
        this.fillUndoPattern(u);
        u.fileName = new String(this.fileName);
        return u;
    }

    JDImage(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.fileName = e.fileName;
        this.invalidateImage();
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width - 1;
        this.summit[2].y = y;
        this.summit[4].x = x + width - 1;
        this.summit[4].y = y + height - 1;
        this.summit[6].x = x;
        this.summit[6].y = y + height - 1;
        this.centerSummit();
    }

    private void invalidateImage() {
        this.theImage = null;
    }

    private void loadImage() {
        if (this.theImage == null) {
            try {
                if (this.fileName.startsWith("jar:")) {
                    InputStream stream = this.getClass().getResourceAsStream(this.fileName.substring(4));
                    if (stream == null) {
                        if (this.getParent() == null) {
                            this.theImage = defaultImage.getImage();
                            this.imgWidth = defaultImage.getIconWidth();
                            this.imgHeight = defaultImage.getIconHeight();
                            System.out.println("JDImage.setParent() Warning " + this.fileName + " load failed : parent is null");
                            return;
                        }
                        boolean loaded = false;
                        String[] paths = this.getParent().getRootPaths();
                        if (paths != null) {
                            String relPath = this.fileName.substring(4);
                            if (relPath.startsWith("/")) {
                                relPath = relPath.substring(1);
                            }
                            for (int i = 0; !loaded && i < paths.length; ++i) {
                                File in = new File(paths[i] + relPath);
                                if (!in.exists()) continue;
                                try {
                                    this.theImage = ImageIO.read(in);
                                    this.imgWidth = ((BufferedImage)this.theImage).getWidth();
                                    this.imgHeight = ((BufferedImage)this.theImage).getHeight();
                                    this.updateShape();
                                    loaded = true;
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!loaded) {
                            this.theImage = defaultImage.getImage();
                            this.imgWidth = defaultImage.getIconWidth();
                            this.imgHeight = defaultImage.getIconHeight();
                            System.out.println("JDImage.setParent() Warning " + this.fileName + " load failed : resource not found");
                        }
                    } else {
                        this.theImage = ImageIO.read(stream);
                        this.imgWidth = ((BufferedImage)this.theImage).getWidth();
                        this.imgHeight = ((BufferedImage)this.theImage).getHeight();
                    }
                } else {
                    File in = new File(this.fileName);
                    this.theImage = ImageIO.read(in);
                    this.imgWidth = ((BufferedImage)this.theImage).getWidth();
                    this.imgHeight = ((BufferedImage)this.theImage).getHeight();
                }
            }
            catch (IOException e) {
                System.out.println("JDImage.loadImage() Warning " + this.fileName + " load failed : " + e.getMessage());
                this.theImage = defaultImage.getImage();
                this.imgWidth = defaultImage.getIconWidth();
                this.imgHeight = defaultImage.getIconHeight();
            }
        }
    }
}

