/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDImagePanel
extends JPanel
implements ActionListener {
    private JTextField filenameLabel;
    private JButton filenameBtn;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JButton resetBtn;
    private JDImage[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDImagePanel(JDImage[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel imgPanel = new JPanel(null);
        imgPanel.setBorder(JDUtils.createTitleBorder("Filename"));
        imgPanel.setBounds(5, 5, 370, 60);
        this.filenameLabel = new JTextField();
        this.filenameLabel.setMargin(JDUtils.zMargin);
        this.filenameLabel.setFont(JDUtils.labelFont);
        this.filenameLabel.setEditable(false);
        this.filenameLabel.setBorder(null);
        this.filenameLabel.setForeground(JDUtils.labelColor);
        this.filenameLabel.setBounds(10, 20, 310, 25);
        imgPanel.add(this.filenameLabel);
        this.filenameBtn = new JButton();
        this.filenameBtn.setText("...");
        this.filenameBtn.setMargin(new Insets(0, 0, 0, 0));
        this.filenameBtn.setFont(JDUtils.labelFont);
        this.filenameBtn.setBounds(325, 20, 30, 24);
        this.filenameBtn.addActionListener(this);
        imgPanel.add(this.filenameBtn);
        this.add(imgPanel);
        JPanel dimPanel = new JPanel(null);
        dimPanel.setBorder(JDUtils.createTitleBorder("Dimension"));
        dimPanel.setBounds(5, 75, 370, 115);
        this.widthLabel = new JLabel();
        this.widthLabel.setBounds(10, 20, 240, 25);
        this.widthLabel.setFont(JDUtils.labelFont);
        dimPanel.add(this.widthLabel);
        this.heightLabel = new JLabel();
        this.heightLabel.setBounds(10, 50, 240, 25);
        this.heightLabel.setFont(JDUtils.labelFont);
        dimPanel.add(this.heightLabel);
        this.resetBtn = new JButton();
        this.resetBtn.setText("Reset to original size");
        this.resetBtn.setMargin(new Insets(0, 0, 0, 0));
        this.resetBtn.setFont(JDUtils.labelFont);
        this.resetBtn.setBounds(10, 80, 180, 24);
        this.resetBtn.addActionListener(this);
        dimPanel.add(this.resetBtn);
        this.add(dimPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDImage[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.filenameLabel.setText("");
            this.widthLabel.setText("Width: ");
            this.heightLabel.setText("Height: ");
        } else {
            JDImage p = objs[0];
            this.filenameLabel.setText(p.getFileName());
            this.filenameLabel.setCaretPosition(p.getFileName().length());
            this.widthLabel.setText("Width: " + p.getImageWidth());
            this.heightLabel.setText("Height: " + p.getImageHeight());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.filenameBtn) {
            JFileChooser chooser = new JFileChooser(".");
            String[] exts = new String[]{"gif", "png", "jpg"};
            chooser.addChoosableFileFilter(new JDFileFilter("Image file", exts));
            if (chooser.showOpenDialog(this) == 0) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setFileName(chooser.getSelectedFile().getAbsolutePath());
                }
                this.invoker.setNeedToSave(true, "New image");
            }
        } else if (src == this.resetBtn) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].resetToOriginalSize();
            }
            this.invoker.setNeedToSave(true, "Reset size");
        }
        this.repaintObjects();
    }
}

