/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class JDLabel
extends JDRectangular {
    public static final int CENTER_ALIGNMENT = 0;
    public static final int LEFT_ALIGNMENT = 1;
    public static final int RIGHT_ALIGNMENT = 2;
    public static final int UP_ALIGNMENT = 1;
    public static final int DOWN_ALIGNMENT = 2;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int BOTTOM_TO_TOP = 1;
    public static final int RIGHT_TO_LEFT = 2;
    public static final int TOP_TO_BOTTOM = 3;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final String textDefault = "";
    static final Font fontDefault = new Font("Dialog", 0, 14);
    static final int hAlignmentDefault = 0;
    static final int vAlignmentDefault = 0;
    static final int textOrientationDefault = 0;
    static BufferedImage img = new BufferedImage(10, 10, 1);
    private String theText;
    private Font theFont;
    private int hAlignment;
    private int vAlignment;
    private Dimension preferredSize = null;
    private int textOrientation;
    private int sTextOrientation;

    public JDLabel(String objectName, String text, int x, int y) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.theText = text;
        this.lineWidth = 0;
        Dimension d = this.getMinSize();
        this.createSummit();
        this.computeSummitCoordinates(x, y, d.width, d.height);
        this.updateShape();
        this.centerOrigin();
    }

    JDLabel(JDLabel e, int x, int y) {
        this.cloneObject(e, x, y);
        this.theText = new String(e.theText);
        this.theFont = new Font(e.theFont.getName(), e.theFont.getStyle(), e.theFont.getSize());
        this.textOrientation = e.textOrientation;
        this.hAlignment = e.hAlignment;
        this.vAlignment = e.vAlignment;
        this.updateShape();
    }

    JDLabel(JLXObject jlxObj, Font f, String text, int align, boolean resize) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.theFont = f;
        this.theText = text;
        this.hAlignment = align;
        this.vAlignment = 1;
        if (resize) {
            Dimension d = this.getMinSize();
            this.computeSummitCoordinates((int)(x + (w - (double)d.width) / 2.0), (int)(y + (h - (double)d.height) / 2.0), d.width, d.height);
        } else {
            this.computeSummitCoordinates((int)x, (int)y, (int)w, (int)h);
        }
        this.updateShape();
    }

    JDLabel(LXObject lxObj, String text) {
        this.initDefault();
        this.loadObject(lxObj);
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.theFont = lxObj.font;
        this.theText = text;
        this.hAlignment = 1;
        this.vAlignment = 1;
        this.lineWidth = 0;
        Dimension d = this.getMinSize();
        this.computeSummitCoordinates((int)lxObj.px, (int)lxObj.py, d.width, d.height);
        this.updateShape();
        double bx = this.boundRect.getX();
        double by = this.boundRect.getY();
        double bw = this.boundRect.getWidth();
        double bh = this.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(bx + bw / 2.0, by + bh / 2.0));
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.theText = textDefault;
        this.theFont = fontDefault;
        this.hAlignment = 0;
        this.vAlignment = 0;
        this.textOrientation = 0;
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDLabel(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        int bh;
        int i;
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        super.paint(parent, g);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setFont(this.theFont);
        FontRenderContext frc = g2.getFontRenderContext();
        int fa = (int)Math.ceil(g.getFont().getLineMetrics("ABC", frc).getAscent());
        double angRot = 0.0;
        int w = this.boundRect.width;
        int h = this.boundRect.height;
        int ypos = 0;
        Dimension d = new Dimension(this.getMinSize());
        String[] nLines = this.theText.split("\n");
        String[] lines = null;
        int hmax = 0;
        int xpos = 0;
        Rectangle2D bounds = null;
        int nb = nLines.length;
        if (w < d.width || h < d.height) {
            boolean found = false;
            hmax = 0;
            i = 0;
            while (i < nb && !found) {
                bounds = g.getFont().getStringBounds(nLines[i], frc);
                bh = (int)Math.ceil(bounds.getHeight());
                if (this.textOrientation == 0 || this.textOrientation == 2) {
                    found = hmax + bh > h;
                } else {
                    boolean bl = found = hmax + bh > w;
                }
                if (found) continue;
                ++i;
                hmax += bh;
            }
            if (i > 0) {
                lines = new String[i];
                for (i = 0; i < lines.length; ++i) {
                    lines[i] = nLines[i];
                }
                if (this.textOrientation == 0 || this.textOrientation == 2) {
                    d.height = hmax;
                    for (i = 0; i < lines.length; ++i) {
                        lines[i] = this.getSegmentString(this.theFont, frc, lines[i], w);
                    }
                } else {
                    d.width = hmax;
                    for (i = 0; i < lines.length; ++i) {
                        lines[i] = this.getSegmentString(this.theFont, frc, lines[i], h);
                    }
                }
            }
        } else {
            lines = nLines;
        }
        if (lines == null) {
            return;
        }
        nb = lines.length;
        hmax = 0;
        block0 : switch (this.textOrientation) {
            case 0: 
            case 2: {
                switch (this.vAlignment) {
                    case 0: {
                        ypos = (h - d.height) / 2;
                        break;
                    }
                    case 1: {
                        ypos = 2;
                        break;
                    }
                    case 2: {
                        ypos = h - d.height - 2;
                    }
                }
                break;
            }
            case 1: {
                angRot = -NINETY_DEGREES;
                switch (this.vAlignment) {
                    case 0: {
                        xpos = (w - d.width) / 2;
                        break;
                    }
                    case 1: {
                        xpos = 2;
                        break;
                    }
                    case 2: {
                        xpos = w - d.width - 2;
                    }
                }
                break;
            }
            case 3: {
                angRot = NINETY_DEGREES;
                switch (this.vAlignment) {
                    case 0: {
                        xpos = (w - d.width) / 2;
                        break block0;
                    }
                    case 1: {
                        xpos = 2;
                        break block0;
                    }
                    case 2: {
                        xpos = w - d.width - 2;
                    }
                }
            }
        }
        if (angRot != 0.0) {
            g2.rotate(angRot);
        }
        g2.setColor(this.foreground);
        block44: for (i = 0; i < nb; ++i) {
            switch (this.textOrientation) {
                case 0: 
                case 2: {
                    bounds = g.getFont().getStringBounds(lines[i], frc);
                    int bw = (int)Math.ceil(bounds.getWidth());
                    bh = (int)Math.ceil(bounds.getHeight());
                    switch (this.hAlignment) {
                        case 0: {
                            xpos = this.ptsx[0] + (w - bw) / 2;
                            break;
                        }
                        case 1: {
                            xpos = this.ptsx[0] + 3;
                            break;
                        }
                        case 2: {
                            xpos = this.ptsx[0] + w - bw - 3;
                        }
                    }
                    g2.drawString(lines[i], xpos, this.ptsy[0] + ypos + hmax + fa);
                    hmax += bh;
                    continue block44;
                }
                case 1: {
                    bounds = g.getFont().getStringBounds(lines[i], frc);
                    int bw = (int)Math.ceil(bounds.getWidth());
                    bh = (int)Math.ceil(bounds.getHeight());
                    switch (this.hAlignment) {
                        case 0: {
                            ypos = -this.ptsy[3] + (h - bw) / 2;
                            break;
                        }
                        case 1: {
                            ypos = -this.ptsy[3] + 3;
                            break;
                        }
                        case 2: {
                            ypos = -this.ptsy[3] + h - bw - 3;
                        }
                    }
                    g2.drawString(lines[i], ypos, this.ptsx[0] + xpos + hmax + fa);
                    hmax += bh;
                    continue block44;
                }
                case 3: {
                    bounds = g.getFont().getStringBounds(lines[i], frc);
                    int bw = (int)Math.ceil(bounds.getWidth());
                    bh = (int)Math.ceil(bounds.getHeight());
                    switch (this.hAlignment) {
                        case 0: {
                            ypos = this.ptsy[0] + (h - bw) / 2;
                            break;
                        }
                        case 1: {
                            ypos = this.ptsy[0] + 3;
                            break;
                        }
                        case 2: {
                            ypos = this.ptsy[0] + h - bw - 3;
                        }
                    }
                    g2.drawString(lines[i], ypos, -this.ptsx[1] + xpos + hmax + fa);
                    hmax += bh;
                }
            }
        }
        if (angRot != 0.0) {
            g2.rotate(-angRot);
        }
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    @Override
    public void rotate90(double x, double y) {
        super.rotate90(x, y);
        ++this.textOrientation;
        if (this.textOrientation > 3) {
            this.textOrientation = 0;
        }
    }

    @Override
    public void restoreTransform() {
        this.textOrientation = this.sTextOrientation;
        super.restoreTransform();
    }

    @Override
    public void saveTransform() {
        this.sTextOrientation = this.textOrientation;
        super.saveTransform();
    }

    public void setFont(Font f) {
        this.setFont(f, false);
    }

    public void setFont(Font f, boolean resize) {
        this.theFont = f;
        this.updateLabel(resize);
    }

    public Font getFont() {
        return this.theFont;
    }

    public void setHorizontalAlignment(int a) {
        this.hAlignment = a;
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setVerticalAlignment(int a) {
        this.vAlignment = a;
    }

    public int setVerticalAlignment() {
        return this.vAlignment;
    }

    public void setOrientation(int a) {
        this.textOrientation = a;
        this.updateLabel(true);
    }

    public int getOrientation() {
        return this.textOrientation;
    }

    public void setText(String s) {
        this.setText(s, false);
    }

    public void setText(String s, boolean resize) {
        this.theText = s;
        this.updateLabel(resize);
    }

    public String getText() {
        return this.theText;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.theFont.getName() != fontDefault.getName() || this.theFont.getStyle() != fontDefault.getStyle() || this.theFont.getSize() != fontDefault.getSize()) {
            to_write.append(decal).append("font:\"");
            to_write.append(this.theFont.getName()).append("\",");
            to_write.append(this.theFont.getStyle()).append(",");
            to_write.append(this.theFont.getSize()).append("\n");
        }
        if (!this.theText.equals(textDefault)) {
            String[] lines = this.theText.split("\n");
            to_write.append(decal).append("text:");
            for (int i = 0; i < lines.length; ++i) {
                if (i == 0) {
                    this.appendQuotedString(to_write, lines[i]);
                } else {
                    to_write.append(decal).append("     ");
                    this.appendQuotedString(to_write, lines[i]);
                }
                if (i == lines.length - 1) {
                    to_write.append("\n");
                    continue;
                }
                to_write.append(",\n");
            }
        }
        if (this.hAlignment != 0) {
            to_write.append(decal).append("hAlignment:").append(this.hAlignment).append("\n");
        }
        if (this.vAlignment != 0) {
            to_write.append(decal).append("vAlignment:").append(this.vAlignment).append("\n");
        }
        if (this.textOrientation != 0) {
            to_write.append(decal).append("textOrientation:").append(this.textOrientation).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDLabel(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("text")) {
                this.theText = f.parseStringArray();
                continue;
            }
            if (propName.equals("hAlignment")) {
                this.hAlignment = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("vAlignment")) {
                this.vAlignment = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("textOrientation")) {
                this.textOrientation = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("font")) {
                this.theFont = f.parseFont();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(3);
        this.fillUndoPattern(u);
        u.fName = this.theFont.getName();
        u.fStyle = this.theFont.getStyle();
        u.fSize = this.theFont.getSize();
        u.textOrientation = this.textOrientation;
        u.vAlignment = this.vAlignment;
        u.hAlignment = this.hAlignment;
        u.text = new String(this.theText);
        return u;
    }

    JDLabel(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.theFont = new Font(e.fName, e.fStyle, e.fSize);
        this.textOrientation = e.textOrientation;
        this.vAlignment = e.vAlignment;
        this.hAlignment = e.hAlignment;
        this.theText = e.text;
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }

    private void updateLabel(boolean resize) {
        this.preferredSize = null;
        Dimension d = this.getMinSize();
        if (resize && (this.summit[2].x - this.summit[0].x <= (double)d.width || this.summit[6].y - this.summit[0].y <= (double)d.height)) {
            double x = this.summit[0].x + (double)d.width;
            double y = this.summit[0].y + (double)d.height;
            this.summit[2].x = x;
            this.summit[4].x = x;
            this.summit[4].y = y;
            this.summit[6].y = y;
            this.centerSummit();
            this.updateShape();
        }
    }

    private String getSegmentString(Font f, FontRenderContext frc, String str, int wmax) {
        boolean found = false;
        String s = textDefault;
        for (int j = str.length(); j > 0 && !found; --j) {
            s = str.substring(0, j);
            Rectangle2D bounds = f.getStringBounds(s, frc);
            int bw = (int)Math.ceil(bounds.getWidth());
            found = bw < wmax;
        }
        if (!found) {
            return textDefault;
        }
        return s;
    }

    private Dimension getMinSize() {
        if (this.preferredSize == null) {
            Graphics g = img.getGraphics();
            g.setFont(this.theFont);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontRenderContext frc = g2.getFontRenderContext();
            String[] lines = this.theText.split("\n");
            int wmax = 0;
            int hmax = 0;
            for (int i = 0; i < lines.length; ++i) {
                Rectangle2D bounds = g.getFont().getStringBounds(lines[i], frc);
                int w = (int)Math.ceil(bounds.getWidth());
                int h = (int)Math.ceil(bounds.getHeight());
                if (w > wmax) {
                    wmax = w;
                }
                hmax += h;
            }
            g.dispose();
            this.preferredSize = this.textOrientation == 0 || this.textOrientation == 2 ? new Dimension(wmax + 6, hmax + 4) : new Dimension(hmax + 4, wmax + 6);
        }
        return this.preferredSize;
    }
}

