/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKFontChooser;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class JDLabelPanel
extends JPanel
implements ActionListener {
    private JScrollPane textView;
    private JTextArea textText;
    private JButton applyTextBtn;
    private JLabel fontLabel;
    private JButton fontBtn;
    private JLabel alignmentLabel;
    private JComboBox alignmentCombo;
    private JLabel alignment2Label;
    private JComboBox alignment2Combo;
    private JLabel orientationLabel;
    private JComboBox orientationCombo;
    private JDLabel[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDLabelPanel(JDLabel[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel namePanel = new JPanel(null);
        namePanel.setBorder(JDUtils.createTitleBorder("Text"));
        namePanel.setBounds(5, 5, 370, 130);
        this.textText = new JTextArea();
        this.textText.setEditable(true);
        this.textText.setFont(JDUtils.labelFont);
        this.textView = new JScrollPane(this.textText);
        this.textView.setBounds(10, 20, 350, 70);
        namePanel.add(this.textView);
        this.applyTextBtn = new JButton("Apply");
        this.applyTextBtn.setFont(JDUtils.labelFont);
        this.applyTextBtn.addActionListener(this);
        this.applyTextBtn.setBounds(260, 95, 100, 25);
        namePanel.add(this.applyTextBtn);
        this.add(namePanel);
        JPanel stylePanel = new JPanel(null);
        stylePanel.setBorder(JDUtils.createTitleBorder("Text styles"));
        stylePanel.setBounds(5, 140, 370, 145);
        this.fontLabel = new JLabel("Font");
        this.fontLabel.setFont(JDUtils.labelFont);
        this.fontLabel.setForeground(JDUtils.labelColor);
        this.fontLabel.setBounds(10, 20, 135, 24);
        stylePanel.add(this.fontLabel);
        this.fontBtn = new JButton();
        this.fontBtn.setText("Choose");
        this.fontBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fontBtn.setFont(JDUtils.labelFont);
        this.fontBtn.setBounds(220, 20, 140, 24);
        this.fontBtn.addActionListener(this);
        stylePanel.add(this.fontBtn);
        this.alignmentLabel = new JLabel("Horizontal alignment");
        this.alignmentLabel.setFont(JDUtils.labelFont);
        this.alignmentLabel.setForeground(JDUtils.labelColor);
        this.alignmentLabel.setBounds(10, 50, 125, 25);
        stylePanel.add(this.alignmentLabel);
        this.alignmentCombo = new JComboBox();
        this.alignmentCombo.setFont(JDUtils.labelFont);
        this.alignmentCombo.addItem("Center");
        this.alignmentCombo.addItem("Left");
        this.alignmentCombo.addItem("Right");
        this.alignmentCombo.addActionListener(this);
        this.alignmentCombo.setBounds(220, 50, 140, 25);
        stylePanel.add(this.alignmentCombo);
        this.alignment2Label = new JLabel("Vertical alignment");
        this.alignment2Label.setFont(JDUtils.labelFont);
        this.alignment2Label.setForeground(JDUtils.labelColor);
        this.alignment2Label.setBounds(10, 80, 125, 25);
        stylePanel.add(this.alignment2Label);
        this.alignment2Combo = new JComboBox();
        this.alignment2Combo.setFont(JDUtils.labelFont);
        this.alignment2Combo.addItem("Center");
        this.alignment2Combo.addItem("Up");
        this.alignment2Combo.addItem("Down");
        this.alignment2Combo.addActionListener(this);
        this.alignment2Combo.setBounds(220, 80, 140, 25);
        stylePanel.add(this.alignment2Combo);
        this.orientationLabel = new JLabel("Text orientation");
        this.orientationLabel.setFont(JDUtils.labelFont);
        this.orientationLabel.setForeground(JDUtils.labelColor);
        this.orientationLabel.setBounds(10, 110, 100, 25);
        stylePanel.add(this.orientationLabel);
        this.orientationCombo = new JComboBox();
        this.orientationCombo.setFont(JDUtils.labelFont);
        this.orientationCombo.addItem("Left to right");
        this.orientationCombo.addItem("Bottom to top");
        this.orientationCombo.addItem("Left to right");
        this.orientationCombo.addItem("Top to bottom");
        this.orientationCombo.addActionListener(this);
        this.orientationCombo.setBounds(220, 110, 140, 25);
        stylePanel.add(this.orientationCombo);
        this.add(stylePanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDLabel[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.textText.setText("");
            this.fontLabel.setText("Font: ");
            this.alignmentCombo.setSelectedIndex(-1);
            this.alignment2Combo.setSelectedIndex(-1);
            this.orientationCombo.setSelectedIndex(-1);
        } else {
            JDLabel p = objs[0];
            this.fontLabel.setText("Font: [" + JDUtils.buildFontName(p.getFont()) + "]");
            this.textText.setText(p.getText());
            this.alignmentCombo.setSelectedIndex(p.getHorizontalAlignment());
            this.alignment2Combo.setSelectedIndex(p.getHorizontalAlignment());
            this.orientationCombo.setSelectedIndex(p.getOrientation());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.fontBtn) {
            Font newFont = ATKFontChooser.getNewFont(this, "Choose label font", this.allObjects[0].getFont());
            if (newFont != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setFont(newFont, this.invoker.resizeLabelOnFontChange);
                }
                this.fontLabel.setText("Font: [" + JDUtils.buildFontName(newFont) + "]");
                this.invoker.setNeedToSave(true, "Change font");
            }
        } else if (src == this.alignmentCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setHorizontalAlignment(this.alignmentCombo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change H. alignment");
        } else if (src == this.alignment2Combo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVerticalAlignment(this.alignment2Combo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change V. alignment");
        } else if (src == this.orientationCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setOrientation(this.orientationCombo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change orientation");
        } else if (src == this.applyTextBtn) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setText(this.textText.getText(), this.invoker.resizeLabelOnTextChange);
            }
            this.invoker.setNeedToSave(true, "Change text");
        }
        this.repaintObjects();
    }
}

