/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatable;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDLine
extends JDObject
implements JDRotatable {
    public static final int ARROW_NONE = 0;
    public static final int ARROW1_LEFT = 1;
    public static final int ARROW1_RIGHT = 2;
    public static final int ARROW1_BOTH = 3;
    public static final int ARROW1_CENTER = 4;
    public static final int ARROW2_LEFT = 5;
    public static final int ARROW2_RIGHT = 6;
    public static final int ARROW2_BOTH = 7;
    public static final int ARROW2_CENTER = 8;
    static final int arrowModeDefault = 0;
    static final int arrowWidthDefault = 7;
    private int arrowMode = 0;
    Polygon[] arrows = null;
    int arrowWidth;
    int[] ashx;
    int[] ashy;

    public JDLine(String objectName, int x1, int y1, int x2, int y2) {
        this.initDefault();
        this.summit = new Point2D.Double[2];
        this.summit[0] = new Point2D.Double(x1, y1);
        this.summit[1] = new Point2D.Double(x2, y2);
        this.name = objectName;
        this.updateShape();
        Point2D.Double org = new Point2D.Double((x1 + x2) / 2, (y1 + y2) / 2);
        this.setOrigin(org);
    }

    JDLine(JDLine e, int x, int y) {
        this.cloneObject(e, x, y);
        this.arrowMode = e.arrowMode;
        this.arrowWidth = e.arrowWidth;
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.updateShape();
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDLine(this, x, y);
    }

    JDLine(JLXObject jlxObj, JLXPath p) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[2];
        this.createSummit();
        for (int i = 0; i < 2; ++i) {
            double[] pts = (double[])p.path.get(i);
            this.summit[i].x = this.origin.x + pts[0];
            this.summit[i].y = this.origin.y + pts[1];
        }
        this.arrowMode = p.arrow;
        this.updateShape();
    }

    JDLine(LXObject lxObj, double x1, double y1, double x2, double y2, int arrow) {
        this.initDefault();
        this.loadObject(lxObj);
        double x = lxObj.boundRect.getX();
        double y = lxObj.boundRect.getY();
        double w = lxObj.boundRect.getWidth();
        double h = lxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[2];
        this.createSummit();
        this.summit[0].x = x1;
        this.summit[0].y = y1;
        this.summit[1].x = x2;
        this.summit[1].y = y2;
        this.arrowMode = arrow;
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.arrowMode = 0;
        this.arrowWidth = 7;
    }

    public void setArrow(int arrow) {
        this.arrowMode = arrow;
        this.updateShape();
    }

    public int getArrow() {
        return this.arrowMode;
    }

    public void setArrowSize(int s) {
        this.arrowWidth = s;
        this.updateShape();
    }

    public int getArrowSize() {
        return this.arrowWidth;
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        if (this.lineWidth > 0) {
            g.setColor(this.foreground);
            BasicStroke bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            if (bs != null) {
                Stroke old = g2.getStroke();
                g2.setStroke(bs);
                if (this.antiAlias) {
                    g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    Line2D.Double l = new Line2D.Double(this.summit[0].x, this.summit[0].y, this.summit[1].x, this.summit[1].y);
                    g2.draw(l);
                } else {
                    g2.drawLine(this.ptsx[0], this.ptsy[0], this.ptsx[1], this.ptsy[1]);
                }
                g2.setStroke(old);
            } else if (this.antiAlias) {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                Line2D.Double l = new Line2D.Double(this.summit[0].x, this.summit[0].y, this.summit[1].x, this.summit[1].y);
                g2.draw(l);
            } else {
                g2.drawLine(this.ptsx[0], this.ptsy[0], this.ptsx[1], this.ptsy[1]);
            }
        }
        if (this.arrows != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this.arrows.length; ++i) {
                g2.setColor(this.foreground);
                g2.fillPolygon(this.arrows[i]);
            }
        }
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    @Override
    Rectangle getShadowBoundRect() {
        return null;
    }

    @Override
    int getSummitMotion(int id) {
        return 3;
    }

    @Override
    public void moveSummit(int id, double x, double y) {
        this.summit[id].x = x;
        this.summit[id].y = y;
        this.updateShape();
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        return this.isPointOnLine(x, y, (int)this.summit[0].x, (int)this.summit[0].y, (int)this.summit[1].x, (int)this.summit[1].y);
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle r = super.getRepaintRect();
        if (this.arrowMode != 0) {
            r.x -= this.arrowWidth;
            r.y -= this.arrowWidth;
            r.width += 2 * this.arrowWidth;
            r.height += 2 * this.arrowWidth;
        }
        return r;
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.updateShape();
    }

    @Override
    public void rotate(double angle, double xCenter, double yCenter) {
        double sn = Math.sin(angle);
        double cs = Math.cos(angle);
        for (int i = 0; i < this.summit.length; ++i) {
            double vx = this.summit[i].x - xCenter;
            double vy = this.summit[i].y - yCenter;
            this.summit[i].x = vx * cs + vy * sn + xCenter;
            this.summit[i].y = -vx * sn + vy * cs + yCenter;
        }
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.arrowWidth != 7) {
            to_write.append(decal).append("arrowWidth:").append(this.arrowWidth).append("\n");
        }
        if (this.arrowMode != 0) {
            to_write.append(decal).append("arrowMode:").append(this.arrowMode).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDLine(JDFileLoader f) throws IOException {
        this.initDefault();
        int l = f.getCurrentLine();
        f.startBlock();
        this.summit = f.parseSummitArray();
        if (this.summit.length != 2) {
            throw new IOException("Invalid summit number for JDLine at line " + l);
        }
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("arrowMode")) {
                this.arrowMode = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("arrowWidth")) {
                this.arrowWidth = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(4);
        this.fillUndoPattern(u);
        u.arrowMode = this.arrowMode;
        u.arrowWidth = this.arrowWidth;
        return u;
    }

    JDLine(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.arrowMode = e.arrowMode;
        this.arrowWidth = e.arrowWidth;
        this.updateShape();
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[this.summit.length];
        this.ptsy = new int[this.summit.length];
        for (int i = 0; i < this.summit.length; ++i) {
            this.ptsx[i] = (int)this.summit[i].x;
            this.ptsy[i] = (int)this.summit[i].y;
        }
        if (this.arrowMode != 0) {
            double nx = -(this.ptsy[1] - this.ptsy[0]);
            double ny = this.ptsx[1] - this.ptsx[0];
            double n = Math.sqrt(nx * nx + ny * ny);
            double aw = this.arrowWidth;
            double lw = this.lineWidth;
            if (n < 1.0) {
                this.arrows = null;
            } else {
                int i = 0;
                double dx = (double)(this.ptsx[1] - this.ptsx[0]) * aw / n;
                double dy = (double)(this.ptsy[1] - this.ptsy[0]) * aw / n;
                double dpx = 0.0;
                double dpy = 0.0;
                if (this.lineWidth > 1) {
                    dpx = (double)(this.ptsx[1] - this.ptsx[0]) * (lw + 1.0) / n;
                    dpy = (double)(this.ptsy[1] - this.ptsy[0]) * (lw + 1.0) / n;
                }
                this.arrows = this.arrowMode == 3 || this.arrowMode == 7 ? new Polygon[2] : new Polygon[1];
                if (this.arrowMode == 3 || this.arrowMode == 1) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[0] + dx + -nx / n * aw);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[0] + dy + -ny / n * aw);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[0] + dx + nx / n * aw);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[0] + dy + ny / n * aw);
                    this.ashx[2] = this.ptsx[0];
                    this.ashy[2] = this.ptsy[0];
                    this.ptsx[0] = this.ptsx[0] + (int)Math.round(dpx);
                    this.ptsy[0] = this.ptsy[0] + (int)Math.round(dpy);
                    this.arrows[i] = new Polygon(this.ashx, this.ashy, 3);
                    ++i;
                }
                if (this.arrowMode == 3 || this.arrowMode == 2) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[1] - dx + -nx / n * aw);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[1] - dy + -ny / n * aw);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[1] - dx + nx / n * aw);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[1] - dy + ny / n * aw);
                    this.ashx[2] = this.ptsx[1];
                    this.ashy[2] = this.ptsy[1];
                    this.ptsx[1] = this.ptsx[1] - (int)Math.round(dpx);
                    this.ptsy[1] = this.ptsy[1] - (int)Math.round(dpy);
                    this.arrows[i] = new Polygon(this.ashx, this.ashy, 3);
                }
                if (this.arrowMode == 4) {
                    double xc = (double)(this.ptsx[1] + this.ptsx[0]) / 2.0;
                    double yc = (double)(this.ptsy[1] + this.ptsy[0]) / 2.0;
                    this.ashx[0] = (int)Math.round(xc + -nx / n * aw);
                    this.ashy[0] = (int)Math.round(yc + -ny / n * aw);
                    this.ashx[1] = (int)Math.round(xc + nx / n * aw);
                    this.ashy[1] = (int)Math.round(yc + ny / n * aw);
                    this.ashx[2] = (int)Math.round(xc + dx);
                    this.ashy[2] = (int)Math.round(yc + dy);
                    this.arrows[i] = new Polygon(this.ashx, this.ashy, 3);
                }
                if (this.arrowMode == 7 || this.arrowMode == 5) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[0] + dx + -nx / n * aw + dx / 2.0);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[0] + dy + -ny / n * aw + dy / 2.0);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[0] + dx);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[0] + dy);
                    this.ashx[2] = (int)Math.round((double)this.ptsx[0] + dx + nx / n * aw + dx / 2.0);
                    this.ashy[2] = (int)Math.round((double)this.ptsy[0] + dy + ny / n * aw + dy / 2.0);
                    this.ashx[3] = this.ptsx[0];
                    this.ashy[3] = this.ptsy[0];
                    this.arrows[i] = new Polygon(this.ashx, this.ashy, 4);
                    ++i;
                    this.ptsx[0] = this.ptsx[0] + (int)Math.round(dpx);
                    this.ptsy[0] = this.ptsy[0] + (int)Math.round(dpy);
                }
                if (this.arrowMode == 7 || this.arrowMode == 6) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[1] - dx + -nx / n * aw - dx / 2.0);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[1] - dy + -ny / n * aw - dy / 2.0);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[1] - dx);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[1] - dy);
                    this.ashx[2] = (int)Math.round((double)this.ptsx[1] - dx + nx / n * aw - dx / 2.0);
                    this.ashy[2] = (int)Math.round((double)this.ptsy[1] - dy + ny / n * aw - dy / 2.0);
                    this.ashx[3] = this.ptsx[1];
                    this.ashy[3] = this.ptsy[1];
                    this.ptsx[1] = this.ptsx[1] - (int)Math.round(dpx);
                    this.ptsy[1] = this.ptsy[1] - (int)Math.round(dpy);
                    this.arrows[i] = new Polygon(this.ashx, this.ashy, 4);
                }
                if (this.arrowMode == 8) {
                    int xc = (this.ptsx[1] + this.ptsx[0]) / 2;
                    int yc = (this.ptsy[1] + this.ptsy[0]) / 2;
                    this.ashx[0] = xc + (int)(-nx / n * aw) - (int)(dx / 2.0);
                    this.ashy[0] = yc + (int)(-ny / n * aw) - (int)(dy / 2.0);
                    this.ashx[1] = xc;
                    this.ashy[1] = yc;
                    this.ashx[2] = xc + (int)(nx / n * aw) - (int)(dx / 2.0);
                    this.ashy[2] = yc + (int)(ny / n * aw) - (int)(dy / 2.0);
                    this.ashx[3] = xc + (int)dx;
                    this.ashy[3] = yc + (int)dy;
                    this.arrows[i] = new Polygon(this.ashx, this.ashy, 4);
                }
            }
        } else {
            this.arrows = null;
        }
    }
}

