/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;

public abstract class JDObject {
    public static final int LINE_STYLE_SOLID = 0;
    public static final int LINE_STYLE_DOT = 1;
    public static final int LINE_STYLE_DASH = 2;
    public static final int LINE_STYLE_LONG_DASH = 3;
    public static final int LINE_STYLE_DASH_DOT = 4;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_SOLID = 1;
    public static final int FILL_STYLE_LARGE_RIGHT_HATCH = 2;
    public static final int FILL_STYLE_LARGE_LEFT_HATCH = 3;
    public static final int FILL_STYLE_LARGE_CROSS_HATCH = 4;
    public static final int FILL_STYLE_SMALL_RIGHT_HATCH = 5;
    public static final int FILL_STYLE_SMALL_LEFT_HATCH = 6;
    public static final int FILL_STYLE_SMALL_CROSS_HATCH = 7;
    public static final int FILL_STYLE_DOT_PATTERN_1 = 8;
    public static final int FILL_STYLE_DOT_PATTERN_2 = 9;
    public static final int FILL_STYLE_DOT_PATTERN_3 = 10;
    public static final int FILL_STYLE_GRADIENT = 11;
    public static final int VALUE_INC_ON_CLICK = 0;
    public static final int VALUE_INC_ON_PRESSRELEASE = 1;
    public static final int VALUE_CHANGE_ON_XDRAG_LEFT = 2;
    public static final int VALUE_CHANGE_ON_XDRAG_RIGHT = 3;
    public static final int VALUE_CHANGE_ON_YDRAG_TOP = 4;
    public static final int VALUE_CHANGE_ON_YDRAG_BOTTOM = 5;
    static final int NONE_SM = 0;
    static final int HORIZONTAL_SM = 1;
    static final int VERTICAL_SM = 2;
    static final int BOTH_SM = 3;
    static final int MPRESSED = 1;
    static final int MRELEASED = 2;
    static final int MDRAGGED = 3;
    private static final Color foregroundDefault = Color.black;
    private static final Color backgroundDefault = Color.white;
    private static final int fillStyleDefault = 0;
    private static final int lineWidthDefault = 1;
    private static final int lineStyleDefault = 0;
    private static final boolean isShadowedDefault = false;
    private static final boolean invertShadowDefault = false;
    private static final int shadowThicknessDefault = 5;
    private static final boolean visibleDefault = true;
    private static final String nameDefault = "JDObject";
    private static final int minValueDefault = 0;
    private static final int maxValueDefault = 1;
    private static final int initValueDefault = 0;
    private static final boolean userValueDefault = false;
    private static final int valueChangeModeDefault = 0;
    private static final float gradientX1default = 0.0f;
    private static final float gradientY1default = 0.0f;
    private static final float gradientX2default = 70.7f;
    private static final float gradientY2default = 70.7f;
    private static final Color gradientC1default = Color.BLACK;
    private static final Color gradientC2default = Color.WHITE;
    private static final boolean gradientCyclicdefault = false;
    private static final boolean antiAliasDefault = false;
    Rectangle boundRect = new Rectangle(0, 0, 0, 0);
    Point2D.Double origin = new Point2D.Double(0.0, 0.0);
    Point2D.Double[] summit;
    Color foreground;
    int lineStyle;
    int lineWidth;
    Color background;
    int fillStyle;
    boolean visible;
    String name;
    boolean userValue;
    int valueChangeMode;
    boolean antiAlias;
    private int value;
    int minValue;
    int maxValue;
    int initValue;
    private boolean hasMapper;
    JDValueProgram backgroundMapper;
    JDValueProgram foregroundMapper;
    JDValueProgram visibilityMapper;
    JDValueProgram invertShadowMapper;
    JDValueProgram hTranslationMapper;
    JDValueProgram vTranslationMapper;
    private Vector valueListener = null;
    private Vector mouseListener = null;
    private JDrawEditor parent = null;
    int[] ptsx;
    int[] ptsy;
    double[] normes;
    Polygon[] shadows;
    Color[] shadowColors;
    int shadowThickness;
    Rectangle sBoundRect;
    boolean isShadowed;
    boolean invertShadow;
    double lightx = 1.0;
    double lighty = 1.0;
    private double[] sSummit = null;
    private double sXOrg;
    private double sYOrg;
    private Rectangle preRefreshRect = null;
    float gradientX1;
    float gradientX2;
    float gradientY1;
    float gradientY2;
    float sGradientX1;
    float sGradientX2;
    float sGradientY1;
    float sGradientY2;
    Color gradientC1;
    Color gradientC2;
    boolean gradientCyclic;
    String[] extParamValue = null;
    String[] extParamName = null;
    boolean isDisabled = false;

    void initDefault() {
        this.lightx = 0.707106781186;
        this.lighty = 0.707106781186;
        this.sBoundRect = new Rectangle();
        this.foreground = foregroundDefault;
        this.background = backgroundDefault;
        this.fillStyle = 0;
        this.lineWidth = 1;
        this.lineStyle = 0;
        this.isShadowed = false;
        this.invertShadow = false;
        this.shadowThickness = 5;
        this.visible = true;
        this.name = nameDefault;
        this.antiAlias = false;
        this.minValue = 0;
        this.maxValue = 1;
        this.initValue = 0;
        this.userValue = false;
        this.valueChangeMode = 0;
        this.initDefaultMapper();
        this.gradientX1 = 0.0f;
        this.gradientX2 = 70.7f;
        this.gradientY1 = 0.0f;
        this.gradientY2 = 70.7f;
        this.gradientC1 = gradientC1default;
        this.gradientC2 = gradientC2default;
        this.gradientCyclic = false;
    }

    void initDefaultMapper() {
        this.backgroundMapper = null;
        this.foregroundMapper = null;
        this.visibilityMapper = null;
        this.invertShadowMapper = null;
        this.hTranslationMapper = null;
        this.vTranslationMapper = null;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.restoreTransform();
        this.setVal(v, this);
    }

    void setVal(int v, JDObject master) {
        this.value = v;
        this.manageMappers(master);
    }

    void initValue() {
        this.initVal(this);
    }

    void initVal(JDObject master) {
        this.hasMapper = this.hasValueProgram();
        this.value = this.initValue;
        this.manageMappers(master);
    }

    void incValue() {
        if (this.value + 1 > this.maxValue) {
            this.setValue(this.minValue);
            this.fireValueExceed();
        } else {
            this.setValue(this.value + 1);
        }
    }

    boolean hasValueProgram() {
        return this.backgroundMapper != null || this.foregroundMapper != null || this.visibilityMapper != null || this.invertShadowMapper != null || this.hTranslationMapper != null || this.vTranslationMapper != null;
    }

    int saturateValue(int v) {
        if (v > this.getMaxValue()) {
            v = this.getMaxValue();
        }
        if (v < this.getMinValue()) {
            v = this.getMinValue();
        }
        return v;
    }

    void processValue(int type, int ex, int ey) {
        int oldValue = this.value;
        switch (this.getValueChangeMode()) {
            case 0: {
                if (type != 1) break;
                this.incValue();
                this.fireValueChange();
                break;
            }
            case 1: {
                if (type != 1 && type != 2) break;
                this.incValue();
                this.fireValueChange();
                break;
            }
            case 2: {
                Rectangle b = this.getBoundRect();
                double r = this.getMaxValue() + 1 - this.getMinValue();
                int v = this.getMinValue() + (int)((double)(ex - b.x) / (double)b.width * r);
                this.setValue(this.saturateValue(v));
                if (this.value == oldValue) break;
                this.fireValueChange();
                break;
            }
            case 3: {
                Rectangle b = this.getBoundRect();
                double r = this.getMaxValue() + 1 - this.getMinValue();
                int v = this.getMinValue() + (int)((double)(b.width + b.x - ex) / (double)b.width * r);
                this.setValue(this.saturateValue(v));
                if (this.value == oldValue) break;
                this.fireValueChange();
                break;
            }
            case 4: {
                Rectangle b = this.getBoundRect();
                double r = this.getMaxValue() + 1 - this.getMinValue();
                int v = this.getMinValue() + (int)((double)(ey - b.y) / (double)b.height * r);
                this.setValue(this.saturateValue(v));
                if (this.value == oldValue) break;
                this.fireValueChange();
                break;
            }
            case 5: {
                Rectangle b = this.getBoundRect();
                double r = this.getMaxValue() + 1 - this.getMinValue();
                int v = this.getMinValue() + (int)((double)(b.height + b.y - ey) / (double)b.height * r);
                this.setValue(this.saturateValue(v));
                if (this.value == oldValue) break;
                this.fireValueChange();
            }
        }
    }

    void findObjectsAt(int x, int y, Vector result) {
        boolean oldVisible = this.visible;
        this.visible = true;
        if (this.isInteractive() && this.isInsideObject(x, y)) {
            result.add(this);
        }
        this.visible = oldVisible;
    }

    void getUserValueList(Vector result) {
        if (this.isInteractive()) {
            result.add(this);
        }
    }

    private void manageMappers(JDObject master) {
        if (this.hasMapper) {
            this.manageBackgroundMapper();
            this.manageForegroundMapper();
            this.manageVisibilityMapper();
            this.manageInvertShadowMapper();
            this.manageTranslationMapper(master);
        }
    }

    private void manageBackgroundMapper() {
        if (this.backgroundMapper != null) {
            Color nC = this.backgroundMapper.getColorMappingFor(this);
            this.setBackground(nC);
        }
    }

    private void manageForegroundMapper() {
        if (this.foregroundMapper != null) {
            Color nC = this.foregroundMapper.getColorMappingFor(this);
            this.setForeground(nC);
        }
    }

    private void manageInvertShadowMapper() {
        if (this.invertShadowMapper != null) {
            boolean nS = this.invertShadowMapper.getBooleanMappingFor(this);
            this.setInverseShadow(nS);
        }
    }

    private void manageVisibilityMapper() {
        if (this.visibilityMapper != null) {
            boolean nS = this.visibilityMapper.getBooleanMappingFor(this);
            this.setVisible(nS);
        }
    }

    private void manageTranslationMapper(JDObject master) {
        int x = 0;
        int y = 0;
        if (this.hTranslationMapper != null) {
            x = this.hTranslationMapper.getIntegerMappingFor(this, master);
        }
        if (this.vTranslationMapper != null) {
            y = this.vTranslationMapper.getIntegerMappingFor(this, master);
        }
        this.translate(x, y);
    }

    public void addValueListener(JDValueListener l) {
        if (this.valueListener == null) {
            this.valueListener = new Vector();
        }
        this.valueListener.add(l);
    }

    public void addMouseListener(JDMouseListener l) {
        if (this.mouseListener == null) {
            this.mouseListener = new Vector();
        }
        this.mouseListener.add(l);
    }

    public void removeValueListener(JDValueListener l) {
        if (this.valueListener != null) {
            this.valueListener.remove(l);
        }
    }

    public void removeMouseListener(JDMouseListener l) {
        if (this.mouseListener != null) {
            this.mouseListener.remove(l);
        }
    }

    public void clearValueListener() {
        if (this.valueListener != null) {
            this.valueListener.clear();
        }
        this.valueListener = null;
    }

    public void clearMouseListener() {
        if (this.mouseListener != null) {
            this.mouseListener.clear();
        }
        this.mouseListener = null;
    }

    boolean hasMouseListener() {
        if (this.mouseListener != null) {
            return this.mouseListener.size() > 0;
        }
        return false;
    }

    void fireValueChange() {
        if (this.valueListener != null) {
            for (int i = 0; i < this.valueListener.size(); ++i) {
                ((JDValueListener)this.valueListener.get(i)).valueChanged(this);
            }
        }
    }

    void fireValueExceed() {
        if (this.valueListener != null) {
            for (int i = 0; i < this.valueListener.size(); ++i) {
                ((JDValueListener)this.valueListener.get(i)).valueExceedBounds(this);
            }
        }
    }

    void fireMouseEvent(int type, MouseEvent e0) {
        if (this.mouseListener != null) {
            JDMouseEvent e = new JDMouseEvent(this, e0);
            switch (type) {
                case 501: {
                    for (int i = 0; i < this.mouseListener.size(); ++i) {
                        ((JDMouseListener)this.mouseListener.get(i)).mousePressed(e);
                    }
                    break;
                }
                case 502: {
                    for (int i = 0; i < this.mouseListener.size(); ++i) {
                        ((JDMouseListener)this.mouseListener.get(i)).mouseReleased(e);
                    }
                    break;
                }
                case 500: {
                    for (int i = 0; i < this.mouseListener.size(); ++i) {
                        ((JDMouseListener)this.mouseListener.get(i)).mouseClicked(e);
                    }
                    break;
                }
                case 504: {
                    for (int i = 0; i < this.mouseListener.size(); ++i) {
                        ((JDMouseListener)this.mouseListener.get(i)).mouseEntered(e);
                    }
                    break;
                }
                case 505: {
                    for (int i = 0; i < this.mouseListener.size(); ++i) {
                        ((JDMouseListener)this.mouseListener.get(i)).mouseExited(e);
                    }
                    break;
                }
            }
        }
    }

    public abstract void paint(JDrawEditor var1, Graphics var2);

    void getObjectsByClassList(Vector result, Class theClass) {
        if (this.getClass() == theClass) {
            result.add(this);
        }
    }

    public void getObjectsByName(Vector result, String name, boolean recurseGroup) {
        if (this.getName().equals(name)) {
            result.add(this);
        }
    }

    Rectangle getRepaintRect() {
        int sw = this.lineWidth + 1;
        if (!this.hasShadow()) {
            return new Rectangle(this.boundRect.x - sw, this.boundRect.y - sw, this.boundRect.width + sw * 2, this.boundRect.height + sw * 2);
        }
        Rectangle r = this.getShadowBoundRect();
        return new Rectangle(r.x - sw, r.y - sw, r.width + sw * 2, r.height + sw * 2);
    }

    public Rectangle getBoundRect() {
        return this.boundRect;
    }

    void paintShadows(Graphics g) {
        if (this.hasShadow()) {
            for (int i = 0; i < this.shadows.length; ++i) {
                g.setColor(this.shadowColors[i]);
                g.fillPolygon(this.shadows[i]);
            }
        }
    }

    void createSummit() {
        for (int i = 0; i < this.summit.length; ++i) {
            this.summit[i] = new Point2D.Double(0.0, 0.0);
        }
    }

    public boolean isInsideObject(int x, int y) {
        if (!this.visible) {
            return false;
        }
        int lw = (this.lineWidth + 1) * 2;
        Rectangle r = new Rectangle(this.boundRect.x - lw / 2, this.boundRect.y - lw / 2, this.boundRect.width + lw, this.boundRect.height + lw);
        return r.contains(x, y);
    }

    public int getSummitNumber() {
        return this.summit.length;
    }

    int getSummit(int x, int y, double summitWidth) {
        int i = 0;
        boolean found = false;
        int sw = (int)(summitWidth / 2.0 + 1.0);
        while (i < this.summit.length && !found) {
            found = (double)x >= this.summit[i].x - (double)sw && (double)x <= this.summit[i].x + (double)sw && (double)y >= this.summit[i].y - (double)sw && (double)y <= this.summit[i].y + (double)sw;
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public Point2D.Double getSummit(int id) {
        return this.summit[id];
    }

    void computeBoundRect() {
        double maxx = -65536.0;
        double maxy = -65536.0;
        double minx = 65536.0;
        double miny = 65536.0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (this.summit[i].x < minx) {
                minx = this.summit[i].x;
            }
            if (this.summit[i].x > maxx) {
                maxx = this.summit[i].x;
            }
            if (this.summit[i].y < miny) {
                miny = this.summit[i].y;
            }
            if (!(this.summit[i].y > maxy)) continue;
            maxy = this.summit[i].y;
        }
        this.boundRect.setRect((int)minx, (int)miny, (int)(maxx - minx) + 1, (int)(maxy - miny) + 1);
    }

    void paintSummit(Graphics g, double summitWidth) {
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        int sw = (int)(summitWidth / 2.0 + 1.0);
        for (int i = 0; i < this.summit.length; ++i) {
            g.fillRect((int)(this.summit[i].x + 0.5) - sw, (int)(this.summit[i].y + 0.5) - sw, 2 * sw, 2 * sw);
        }
        g.setPaintMode();
    }

    void paintOrigin(Graphics g) {
        g.setColor(Color.RED);
        g.drawLine((int)(this.origin.x - 10.0), (int)this.origin.y, (int)(this.origin.x + 10.0), (int)this.origin.y);
        g.drawLine((int)this.origin.x, (int)(this.origin.y - 10.0), (int)this.origin.x, (int)(this.origin.y + 10.0));
    }

    public abstract void moveSummit(int var1, double var2, double var4);

    public void moveSummitH(int id, double x) {
        double y = this.summit[id].y;
        this.moveSummit(id, x, y);
    }

    public void moveSummitV(int id, double y) {
        double x = this.summit[id].x;
        this.moveSummit(id, x, y);
    }

    abstract int getSummitMotion(int var1);

    boolean isPointOnLine(int x, int y, int x1, int y1, int x2, int y2) {
        Line2D.Double l = new Line2D.Double(x1, y1, x2, y2);
        return l.intersects(x - 2, y - 2, 4.0, 4.0);
    }

    public abstract JDObject copy(int var1, int var2);

    JDPolyline buildDefaultPolyline() {
        this.updateShape();
        Point[] pts = new Point[this.ptsx.length];
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new Point(this.ptsx[i], this.ptsy[i]);
        }
        JDPolyline ret = new JDPolyline(this.name, pts);
        ret.copyObjectProperty(this);
        return ret;
    }

    void copyObjectProperty(JDObject e) {
        this.foreground = new Color(e.getForeground().getRGB());
        this.background = new Color(e.getBackground().getRGB());
        this.fillStyle = e.fillStyle;
        this.lineWidth = e.lineWidth;
        this.lineStyle = e.lineStyle;
        this.antiAlias = e.antiAlias;
        this.isShadowed = e.isShadowed;
        this.invertShadow = e.invertShadow;
        this.shadowThickness = e.shadowThickness;
        this.name = new String(e.name);
        this.visible = e.visible;
        this.sBoundRect = new Rectangle();
        this.minValue = e.minValue;
        this.maxValue = e.maxValue;
        this.initValue = e.initValue;
        this.userValue = e.userValue;
        this.valueChangeMode = e.valueChangeMode;
        this.initDefaultMapper();
        if (e.backgroundMapper != null) {
            this.backgroundMapper = e.backgroundMapper.copy();
        }
        if (e.foregroundMapper != null) {
            this.foregroundMapper = e.foregroundMapper.copy();
        }
        if (e.visibilityMapper != null) {
            this.visibilityMapper = e.visibilityMapper.copy();
        }
        if (e.invertShadowMapper != null) {
            this.invertShadowMapper = e.invertShadowMapper.copy();
        }
        if (e.hTranslationMapper != null) {
            this.hTranslationMapper = e.hTranslationMapper.copy();
        }
        if (e.vTranslationMapper != null) {
            this.vTranslationMapper = e.vTranslationMapper.copy();
        }
        this.gradientX1 = e.gradientX1;
        this.gradientX2 = e.gradientX2;
        this.gradientY1 = e.gradientY1;
        this.gradientY2 = e.gradientY2;
        this.gradientC1 = e.gradientC1;
        this.gradientC2 = e.gradientC2;
        this.gradientCyclic = e.gradientCyclic;
        if (e.extParamName != null) {
            this.extParamName = e.extParamName;
            this.extParamValue = new String[e.extParamValue.length];
            for (int i = 0; i < e.extParamValue.length; ++i) {
                this.extParamValue[i] = new String(e.extParamValue[i]);
            }
        } else {
            this.extParamValue = null;
        }
    }

    void cloneObject(JDObject e, int x, int y) {
        this.summit = new Point2D.Double[e.summit.length];
        for (int i = 0; i < e.summit.length; ++i) {
            this.summit[i] = new Point2D.Double(e.summit[i].x + (double)x, e.summit[i].y + (double)y);
        }
        this.origin = new Point2D.Double(e.origin.x + (double)x, e.origin.y + (double)y);
        this.copyObjectProperty(e);
    }

    public void translate(double x, double y) {
        for (int i = 0; i < this.summit.length; ++i) {
            this.summit[i].x += x;
            this.summit[i].y += y;
        }
        this.origin.x += x;
        this.origin.y += y;
        this.updateShape();
    }

    public void scaleTranslate(double scaleX, double scaleY, double ratioX, double ratioY, double transX, double transY) {
        int i;
        for (i = 0; i < this.summit.length; ++i) {
            this.summit[i].x = scaleX + ratioX * (this.summit[i].x - scaleX);
            this.summit[i].y = scaleY + ratioY * (this.summit[i].y - scaleY);
        }
        this.origin.x = scaleX + ratioX * (this.origin.x - scaleX);
        this.origin.y = scaleY + ratioY * (this.origin.y - scaleY);
        for (i = 0; i < this.summit.length; ++i) {
            this.summit[i].x += transX;
            this.summit[i].y += transY;
        }
        this.origin.x += transX;
        this.origin.y += transY;
        this.updateShape();
    }

    public void scale(double x, double y, double rx, double ry) {
        for (int i = 0; i < this.summit.length; ++i) {
            this.summit[i].x = x + rx * (this.summit[i].x - x);
            this.summit[i].y = y + ry * (this.summit[i].y - y);
        }
        this.origin.x = x + rx * (this.origin.x - x);
        this.origin.y = y + ry * (this.origin.y - y);
        this.updateShape();
    }

    public void rotate90(double x, double y) {
        double py;
        double px;
        int lgth = this.summit.length;
        for (int i = 0; i < lgth; ++i) {
            px = this.summit[i].x;
            py = this.summit[i].y;
            this.summit[i].x = x + (py - y);
            this.summit[i].y = y - (px - x);
        }
        px = this.origin.x;
        py = this.origin.y;
        this.origin.x = x + (py - y);
        this.origin.y = y - (px - x);
        px = this.gradientX1;
        py = this.gradientY1;
        this.gradientX1 = (float)py;
        this.gradientY1 = (float)(-px);
        px = this.gradientX2;
        py = this.gradientY2;
        this.gradientX2 = (float)py;
        this.gradientY2 = (float)(-px);
        this.updateShape();
    }

    void appendQuotedString(StringBuffer buff, String s) {
        buff.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                buff.append("\\\\");
                continue;
            }
            if (s.charAt(i) == '\"') {
                buff.append("\\\"");
                continue;
            }
            buff.append(s.charAt(i));
        }
        buff.append("\"");
    }

    abstract void recordObject(StringBuffer var1, int var2);

    void loadDefaultPropery(JDFileLoader f, String propName) throws IOException {
        if (propName.equals("origin")) {
            this.origin = f.parsePoint();
        } else if (propName.equals("foreground")) {
            this.foreground = f.parseColor();
        } else if (propName.equals("background")) {
            this.background = f.parseColor();
        } else if (propName.equals("fillStyle")) {
            this.fillStyle = (int)f.parseDouble();
        } else if (propName.equals("lineWidth")) {
            this.lineWidth = (int)f.parseDouble();
        } else if (propName.equals("lineStyle")) {
            this.lineStyle = (int)f.parseDouble();
        } else if (propName.equals("antiAlias")) {
            this.antiAlias = f.parseBoolean();
        } else if (propName.equals("isShadowed")) {
            this.isShadowed = f.parseBoolean();
        } else if (propName.equals("invertShadow")) {
            this.invertShadow = f.parseBoolean();
        } else if (propName.equals("name")) {
            this.name = f.parseString();
        } else if (propName.equals("shadowThickness")) {
            this.shadowThickness = (int)f.parseDouble();
        } else if (propName.equals("visible")) {
            this.visible = f.parseBoolean();
        } else if (propName.equals("minvalue")) {
            this.minValue = (int)f.parseDouble();
        } else if (propName.equals("maxvalue")) {
            this.maxValue = (int)f.parseDouble();
        } else if (propName.equals("initvalue")) {
            this.initValue = (int)f.parseDouble();
        } else if (propName.equals("uservalue")) {
            this.userValue = f.parseBoolean();
        } else if (propName.equals("valuechangemode")) {
            this.valueChangeMode = (int)f.parseDouble();
        } else if (propName.equals("gradX1")) {
            this.gradientX1 = (int)f.parseDouble();
        } else if (propName.equals("gradY1")) {
            this.gradientY1 = (int)f.parseDouble();
        } else if (propName.equals("gradX2")) {
            this.gradientX2 = (int)f.parseDouble();
        } else if (propName.equals("gradY2")) {
            this.gradientY2 = (int)f.parseDouble();
        } else if (propName.equals("gradCyclic")) {
            this.gradientCyclic = f.parseBoolean();
        } else if (propName.equals("gradC1")) {
            this.gradientC1 = f.parseColor();
        } else if (propName.equals("gradC2")) {
            this.gradientC2 = f.parseColor();
        } else if (propName.equals("backgroundmapper")) {
            this.backgroundMapper = new JDValueProgram(f);
        } else if (propName.equals("foregroundmapper")) {
            this.foregroundMapper = new JDValueProgram(f);
        } else if (propName.equals("visibilitymapper")) {
            this.visibilityMapper = new JDValueProgram(f);
        } else if (propName.equals("htranslationmapper")) {
            this.hTranslationMapper = new JDValueProgram(f);
        } else if (propName.equals("vtranslationmapper")) {
            this.vTranslationMapper = new JDValueProgram(f);
        } else if (propName.equals("invertshadowmapper")) {
            this.invertShadowMapper = new JDValueProgram(f);
        } else if (propName.equals("extensions")) {
            this.loadObjectExtension(f);
        } else {
            System.out.println("Unknown property found:" + propName);
            f.jumpPropertyValue();
        }
    }

    private void loadObjectExtension(JDFileLoader f) throws IOException {
        Vector<String> extN = new Vector<String>();
        Vector<String> extV = new Vector<String>();
        f.startBlock();
        while (!f.isEndBlock()) {
            extN.add(f.parseProperyName());
            extV.add(f.parseParamString());
        }
        f.endBlock();
        int sz = extN.size();
        if (sz > 0) {
            int i;
            String[] strs = new String[sz];
            for (i = 0; i < sz; ++i) {
                strs[i] = (String)extN.get(i);
            }
            this.setExtensionList(strs);
            for (i = 0; i < sz; ++i) {
                this.setExtendedParam(i, (String)extV.get(i));
            }
        }
    }

    void loadObject(JDFileLoader f) throws IOException {
        f.startBlock();
        this.summit = f.parseSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
    }

    void loadObject(JLXObject o) {
        this.foreground = o.style.lineColor;
        this.background = o.style.fillColor;
        this.fillStyle = o.style.fillStyle;
        this.lineWidth = o.style.lineWidth;
        this.lineStyle = o.style.lineStyle;
        this.isShadowed = o.shadowWidth != 0;
        this.invertShadow = o.shadowWidth < 0;
        this.name = o.name;
        int n = this.shadowThickness = o.shadowWidth < 0 ? -o.shadowWidth : o.shadowWidth;
        if (this.shadowThickness == 0) {
            this.shadowThickness = 1;
        }
        this.visible = o.visible;
        this.gradientX1 = o.style.gradientX1;
        this.gradientY1 = o.style.gradientY1;
        this.gradientX2 = o.style.gradientX2;
        this.gradientY2 = o.style.gradientY2;
        this.gradientC1 = o.style.gradientC1;
        this.gradientC2 = o.style.gradientC2;
        this.gradientCyclic = o.style.gradientCyclic;
    }

    void loadObject(LXObject o) {
        this.foreground = o.foreground;
        this.background = o.background;
        this.fillStyle = o.fillStyle;
        this.lineWidth = o.lineWidth;
        this.lineStyle = o.lineStyle;
        this.isShadowed = o.shadowWidth != 0;
        this.invertShadow = o.invertShadow;
        this.name = o.name;
        int n = this.shadowThickness = o.shadowWidth < 0 ? -o.shadowWidth : o.shadowWidth;
        if (this.shadowThickness == 0) {
            this.shadowThickness = 1;
        }
        this.visible = o.visible;
        if (o.userClass != 0) {
            this.addExtension("UserClass");
            this.setExtendedParam("UserClass", Integer.toString(o.userClass));
        }
    }

    String roundDouble(double d) {
        Object ret = null;
        boolean checkZero = false;
        boolean sign = false;
        if (d < 0.0) {
            d = -d;
            sign = true;
        }
        int i = (int)(d * 10000.0 + 0.5);
        int ipart = i / 10000;
        int fpart = i % 10000;
        if (fpart == 0) {
            ret = Integer.toString(ipart);
        } else if (fpart > 0 && fpart < 10) {
            ret = Integer.toString(ipart) + ".000" + Integer.toString(fpart);
        } else if (fpart >= 10 && fpart < 100) {
            checkZero = true;
            ret = Integer.toString(ipart) + ".00" + Integer.toString(fpart);
        } else if (fpart >= 100 && fpart < 1000) {
            checkZero = true;
            ret = Integer.toString(ipart) + ".0" + Integer.toString(fpart);
        } else {
            checkZero = true;
            ret = Integer.toString(ipart) + "." + Integer.toString(fpart);
        }
        if (checkZero) {
            i = ((String)ret).length() - 1;
            while (checkZero && i >= 0) {
                checkZero = ((String)ret).charAt(i) == '0';
                if (!checkZero) continue;
                --i;
            }
            ret = ((String)ret).substring(0, i + 1);
        }
        if (sign) {
            ret = "-" + (String)ret;
        }
        return ret;
    }

    private void recordMapper(StringBuffer to_write, String name, JDValueProgram vm, StringBuffer decal) {
        to_write.append(decal).append(name).append(":{\n");
        vm.recordObject(to_write, decal);
        to_write.append(decal).append("}\n");
    }

    private void recordExtensions(StringBuffer to_write, StringBuffer decal) {
        int sz = this.getExtendedParamNumber();
        if (sz > 0) {
            to_write.append(decal).append("extensions:{\n");
            for (int i = 0; i < sz; ++i) {
                int j;
                String extName = this.extParamName[i].indexOf(32) > 0 ? decal + "  \"" + this.extParamName[i] + "\":" : decal + "  " + this.extParamName[i] + ":";
                to_write.append(extName);
                StringBuffer decal2 = new StringBuffer();
                String[] vals = JDUtils.makeStringArray(this.extParamValue[i]);
                for (j = 0; j < extName.length(); ++j) {
                    decal2.append(" ");
                }
                for (j = 0; j < vals.length; ++j) {
                    if (j > 0) {
                        to_write.append(decal2);
                    }
                    this.appendQuotedString(to_write, vals[j]);
                    if (j < vals.length - 1) {
                        to_write.append(",");
                    }
                    to_write.append("\n");
                }
            }
            to_write.append(decal).append("}\n");
        }
    }

    void recordSummit(StringBuffer to_write, StringBuffer decal) {
        to_write.append(decal).append("summit:");
        for (int i = 0; i < this.summit.length; ++i) {
            if (i != this.summit.length - 1) {
                to_write.append(this.roundDouble(this.summit[i].x)).append(",").append(this.roundDouble(this.summit[i].y)).append(",");
                continue;
            }
            to_write.append(this.roundDouble(this.summit[i].x)).append(",").append(this.roundDouble(this.summit[i].y)).append("\n");
        }
    }

    StringBuffer recordObjectHeader(StringBuffer to_write, int level) {
        StringBuffer decal = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            decal.append("  ");
        }
        to_write.append(decal).append(this.toString()).append(" {\n");
        decal.append("  ");
        this.recordSummit(to_write, decal);
        to_write.append(decal).append("origin:");
        to_write.append(this.roundDouble(this.origin.x)).append(",");
        to_write.append(this.roundDouble(this.origin.y)).append("\n");
        if (this.foreground.getRGB() != foregroundDefault.getRGB()) {
            to_write.append(decal).append("foreground:");
            to_write.append(this.foreground.getRed()).append(",");
            to_write.append(this.foreground.getGreen()).append(",");
            to_write.append(this.foreground.getBlue());
            if (this.foreground.getAlpha() != 255) {
                to_write.append(",").append(this.foreground.getAlpha());
            }
            to_write.append("\n");
        }
        if (this.background.getRGB() != backgroundDefault.getRGB()) {
            to_write.append(decal).append("background:");
            to_write.append(this.background.getRed()).append(",");
            to_write.append(this.background.getGreen()).append(",");
            to_write.append(this.background.getBlue());
            if (this.background.getAlpha() != 255) {
                to_write.append(",").append(this.background.getAlpha());
            }
            to_write.append("\n");
        }
        if (this.fillStyle != 0) {
            to_write.append(decal).append("fillStyle:").append(this.fillStyle).append("\n");
        }
        if (this.lineWidth != 1) {
            to_write.append(decal).append("lineWidth:").append(this.lineWidth).append("\n");
        }
        if (this.antiAlias) {
            to_write.append(decal).append("antiAlias:").append(this.antiAlias).append("\n");
        }
        if (this.lineStyle != 0) {
            to_write.append(decal).append("lineStyle:").append(this.lineStyle).append("\n");
        }
        if (this.isShadowed) {
            to_write.append(decal).append("isShadowed:").append(this.isShadowed).append("\n");
        }
        if (this.invertShadow) {
            to_write.append(decal).append("invertShadow:").append(this.invertShadow).append("\n");
        }
        if (this.shadowThickness != 5) {
            to_write.append(decal).append("shadowThickness:").append(this.shadowThickness).append("\n");
        }
        if (!this.visible) {
            to_write.append(decal).append("visible:").append(this.visible).append("\n");
        }
        if (this.minValue != 0) {
            to_write.append(decal).append("minvalue:").append(this.minValue).append("\n");
        }
        if (this.maxValue != 1) {
            to_write.append(decal).append("maxvalue:").append(this.maxValue).append("\n");
        }
        if (this.initValue != 0) {
            to_write.append(decal).append("initvalue:").append(this.initValue).append("\n");
        }
        if (this.userValue) {
            to_write.append(decal).append("uservalue:").append(this.userValue).append("\n");
        }
        if (this.valueChangeMode != 0) {
            to_write.append(decal).append("valuechangemode:").append(this.valueChangeMode).append("\n");
        }
        if (!this.name.equals(nameDefault)) {
            to_write.append(decal).append("name:");
            this.appendQuotedString(to_write, this.name);
            to_write.append("\n");
        }
        if (this.gradientX1 != 0.0f) {
            to_write.append(decal).append("gradX1:").append(this.gradientX1).append("\n");
        }
        if (this.gradientX2 != 70.7f) {
            to_write.append(decal).append("gradX2:").append(this.gradientX2).append("\n");
        }
        if (this.gradientY1 != 0.0f) {
            to_write.append(decal).append("gradY1:").append(this.gradientY1).append("\n");
        }
        if (this.gradientY2 != 70.7f) {
            to_write.append(decal).append("gradY2:").append(this.gradientY2).append("\n");
        }
        if (this.gradientCyclic) {
            to_write.append(decal).append("gradCyclic:").append(this.gradientCyclic).append("\n");
        }
        if (this.gradientC1.getRGB() != gradientC1default.getRGB()) {
            to_write.append(decal).append("gradC1:");
            to_write.append(this.gradientC1.getRed()).append(",");
            to_write.append(this.gradientC1.getGreen()).append(",");
            to_write.append(this.gradientC1.getBlue()).append("\n");
        }
        if (this.gradientC2.getRGB() != gradientC2default.getRGB()) {
            to_write.append(decal).append("gradC2:");
            to_write.append(this.gradientC2.getRed()).append(",");
            to_write.append(this.gradientC2.getGreen()).append(",");
            to_write.append(this.gradientC2.getBlue()).append("\n");
        }
        this.recordExtensions(to_write, decal);
        if (this.hasBackgroundMapper()) {
            this.recordMapper(to_write, "backgroundmapper", this.backgroundMapper, decal);
        }
        if (this.hasForegroundMapper()) {
            this.recordMapper(to_write, "foregroundmapper", this.foregroundMapper, decal);
        }
        if (this.hasVisibilityMapper()) {
            this.recordMapper(to_write, "visibilitymapper", this.visibilityMapper, decal);
        }
        if (this.hasInvertShadowMapper()) {
            this.recordMapper(to_write, "invertshadowmapper", this.invertShadowMapper, decal);
        }
        if (this.hasHTranslationMapper()) {
            this.recordMapper(to_write, "htranslationmapper", this.hTranslationMapper, decal);
        }
        if (this.hasVTranslationMapper()) {
            this.recordMapper(to_write, "vtranslationmapper", this.vTranslationMapper, decal);
        }
        return decal;
    }

    void closeObjectHeader(StringBuffer to_write, int level) {
        StringBuffer decal = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            decal.append("  ");
        }
        to_write.append(decal).append("}\n");
    }

    abstract UndoPattern getUndoPattern();

    void fillUndoPattern(UndoPattern e) {
        int i;
        e.xOrigin = this.origin.x;
        e.yOrigin = this.origin.y;
        e.summit = new double[this.summit.length * 2];
        for (i = 0; i < this.summit.length; ++i) {
            e.summit[2 * i + 0] = this.summit[i].x;
            e.summit[2 * i + 1] = this.summit[i].y;
        }
        e.rgbForeground = this.foreground.getRGB();
        e.rgbBackground = this.background.getRGB();
        e.fillStyle = this.fillStyle;
        e.lineWidth = this.lineWidth;
        e.lineStyle = this.lineStyle;
        e.antiAlias = this.antiAlias;
        e.isShadowed = this.isShadowed;
        e.invertShadow = this.invertShadow;
        e.name = new String(this.name);
        e.shadowThickness = this.shadowThickness;
        e.visible = this.visible;
        e.minValue = this.minValue;
        e.maxValue = this.maxValue;
        e.initValue = this.initValue;
        e.userValue = this.userValue;
        e.valueChangeMode = this.valueChangeMode;
        if (this.hasBackgroundMapper()) {
            e.backgroundMapper = this.backgroundMapper.copy();
        }
        if (this.hasForegroundMapper()) {
            e.foregroundMapper = this.foregroundMapper.copy();
        }
        if (this.hasVisibilityMapper()) {
            e.visibilityMapper = this.visibilityMapper.copy();
        }
        if (this.hasInvertShadowMapper()) {
            e.invertShadowMapper = this.invertShadowMapper.copy();
        }
        if (this.hasHTranslationMapper()) {
            e.hTranslationMapper = this.hTranslationMapper.copy();
        }
        if (this.hasVTranslationMapper()) {
            e.vTranslationMapper = this.vTranslationMapper.copy();
        }
        e.gradientX1 = this.gradientX1;
        e.gradientX2 = this.gradientX2;
        e.gradientY1 = this.gradientY1;
        e.gradientY2 = this.gradientY2;
        e.gradientC1 = this.gradientC1;
        e.gradientC2 = this.gradientC2;
        e.gradientCyclic = this.gradientCyclic;
        e.extsN = this.extParamName;
        if (e.extsN != null) {
            e.extsV = new String[e.extsN.length];
            for (i = 0; i < e.extsN.length; ++i) {
                e.extsV[i] = new String(this.extParamValue[i]);
            }
        }
    }

    void applyUndoPattern(UndoPattern e) {
        int i;
        int nbS = e.summit.length / 2;
        this.origin = new Point2D.Double(e.xOrigin, e.yOrigin);
        this.summit = new Point2D.Double[nbS];
        for (i = 0; i < nbS; ++i) {
            this.summit[i] = new Point2D.Double(e.summit[2 * i], e.summit[2 * i + 1]);
        }
        this.foreground = new Color(e.rgbForeground);
        this.background = new Color(e.rgbBackground);
        this.fillStyle = e.fillStyle;
        this.lineWidth = e.lineWidth;
        this.lineStyle = e.lineStyle;
        this.antiAlias = e.antiAlias;
        this.isShadowed = e.isShadowed;
        this.invertShadow = e.invertShadow;
        this.name = e.name;
        this.shadowThickness = e.shadowThickness;
        this.visible = e.visible;
        this.minValue = e.minValue;
        this.maxValue = e.maxValue;
        this.initValue = e.initValue;
        this.userValue = e.userValue;
        this.valueChangeMode = e.valueChangeMode;
        if (e.backgroundMapper != null) {
            this.backgroundMapper = e.backgroundMapper.copy();
        }
        if (e.foregroundMapper != null) {
            this.foregroundMapper = e.foregroundMapper.copy();
        }
        if (e.visibilityMapper != null) {
            this.visibilityMapper = e.visibilityMapper.copy();
        }
        if (e.invertShadowMapper != null) {
            this.invertShadowMapper = e.invertShadowMapper.copy();
        }
        if (e.hTranslationMapper != null) {
            this.hTranslationMapper = e.hTranslationMapper.copy();
        }
        if (e.vTranslationMapper != null) {
            this.vTranslationMapper = e.vTranslationMapper.copy();
        }
        this.gradientX1 = e.gradientX1;
        this.gradientX2 = e.gradientX2;
        this.gradientY1 = e.gradientY1;
        this.gradientY2 = e.gradientY2;
        this.gradientC1 = e.gradientC1;
        this.gradientC2 = e.gradientC2;
        this.gradientCyclic = e.gradientCyclic;
        this.extParamName = e.extsN;
        if (e.extsN != null) {
            this.extParamValue = new String[e.extsN.length];
            for (i = 0; i < e.extsN.length; ++i) {
                this.extParamValue[i] = new String(e.extsV[i]);
            }
        }
    }

    public void restoreTransform() {
        this.origin.x = this.sXOrg;
        this.origin.y = this.sYOrg;
        for (int i = 0; i < this.sSummit.length / 2; ++i) {
            this.summit[i].x = this.sSummit[2 * i];
            this.summit[i].y = this.sSummit[2 * i + 1];
        }
        this.gradientX1 = this.sGradientX1;
        this.gradientX2 = this.sGradientX2;
        this.gradientY1 = this.sGradientY1;
        this.gradientY2 = this.sGradientY2;
        this.updateShape();
    }

    public void saveTransform() {
        this.sSummit = new double[this.summit.length * 2];
        for (int i = 0; i < this.summit.length; ++i) {
            this.sSummit[2 * i] = this.summit[i].x;
            this.sSummit[2 * i + 1] = this.summit[i].y;
        }
        this.sXOrg = this.origin.x;
        this.sYOrg = this.origin.y;
        this.sGradientX1 = this.gradientX1;
        this.sGradientX2 = this.gradientX2;
        this.sGradientY1 = this.gradientY1;
        this.sGradientY2 = this.gradientY2;
    }

    abstract void updateShape();

    Rectangle getShadowBoundRect() {
        return this.sBoundRect;
    }

    void getMinMax(int[] p, int[] m) {
        int min = 65536;
        int max = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] <= min) {
                min = p[i];
            }
            if (p[i] < max) continue;
            max = p[i];
        }
        if (min < 0) {
            min = 0;
        }
        if (max > 65536) {
            max = 65536;
        }
        m[0] = min;
        m[1] = max;
    }

    void computeNextShadowSegment(int i, Polygon p, double[] ret) {
        double cy;
        double cx;
        int icur;
        int inext = i + 2;
        int nb = this.ptsx.length;
        if (inext >= nb) {
            inext -= nb;
        }
        if ((icur = i + 1) >= nb) {
            icur -= nb;
        }
        if (this.normes[i] < 1.0 || this.normes[icur] < 1.0) {
            cx = 0.0;
            cy = 0.0;
        } else {
            double ux = (double)(this.ptsx[inext] - this.ptsx[icur]) / this.normes[icur];
            double vx = (double)(this.ptsx[i] - this.ptsx[icur]) / this.normes[i];
            cx = ux + vx;
            double uy = (double)(this.ptsy[inext] - this.ptsy[icur]) / this.normes[icur];
            double vy = (double)(this.ptsy[i] - this.ptsy[icur]) / this.normes[i];
            cy = uy + vy;
            double n = Math.sqrt(cx * cx + cy * cy);
            if (n <= 1.0E-5) {
                cx = -(this.ptsy[icur] - this.ptsy[i]);
                cy = this.ptsx[icur] - this.ptsx[i];
                n = Math.sqrt(cx * cx + cy * cy);
                if (n < 1.0) {
                    cx = 0.0;
                    cy = 0.0;
                } else {
                    cx /= n;
                    cy /= n;
                }
            } else {
                double s = (cx /= n) * ux + (cy /= n) * uy;
                s = Math.sqrt(1.0 - s * s);
                cx /= s;
                cy /= s;
            }
            if (!p.contains(this.ptsx[icur] + (int)(cx * 4.0), this.ptsy[icur] + (int)(cy * 4.0))) {
                cx = -cx;
                cy = -cy;
            }
        }
        ret[0] = cx;
        ret[1] = cy;
    }

    Color computeShadowColor(int i, int inext, Polygon p, double[] yuv) {
        double Y;
        double l;
        double delta;
        double nx = -(this.ptsy[inext] - this.ptsy[i]);
        double ny = this.ptsx[inext] - this.ptsx[i];
        double n = Math.sqrt(nx * nx + ny * ny);
        if (n < 1.0) {
            nx = 0.0;
            ny = 0.0;
        } else {
            nx /= n;
            ny /= n;
        }
        int vx = (int)(nx * 4.0);
        int vy = (int)(ny * 4.0);
        if (!p.contains((this.ptsx[inext] + this.ptsx[i]) / 2 + vx, (this.ptsy[inext] + this.ptsy[i]) / 2 + vy)) {
            nx = -nx;
            ny = -ny;
        }
        if ((delta = (l = !this.invertShadow ? this.lightx * nx + this.lighty * ny : this.lightx * -nx + this.lighty * -ny) * 128.0) > 0.0 && delta < 80.0) {
            delta = 80.0;
        }
        if (delta <= 0.0 && delta > -20.0) {
            delta = -20.0;
        }
        if ((Y = yuv[0] + delta) < 0.0) {
            Y = 0.0;
        }
        if (Y > 255.0) {
            Y = 255.0;
        }
        return this.createColorFromYUV(Y, yuv[1], yuv[2]);
    }

    void RGBtoYUV(Color c, double[] yuv) {
        double R = c.getRed();
        double G = c.getGreen();
        double B = c.getBlue();
        yuv[0] = 0.299 * R + 0.587 * G + 0.114 * B;
        yuv[1] = -0.169 * R - 0.331 * G + 0.5 * B + 128.0;
        yuv[2] = 0.5 * R - 0.419 * G - 0.081 * B + 128.0;
    }

    Color createColorFromYUV(double Y, double U, double V) {
        int r = (int)(Y + 1.4075 * (V - 128.0));
        int g = (int)(Y - 0.7169 * (V - 128.0) - 0.3455 * (U - 128.0));
        int b = (int)(Y + 1.779 * (U - 128.0));
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        return new Color(r, g, b);
    }

    void computeShadow(boolean isClosed) {
        double cy;
        double cx;
        int i;
        int minx = 65536;
        int miny = 65536;
        int maxx = 0;
        int maxy = 0;
        int nb = isClosed ? this.ptsx.length : this.ptsx.length - 1;
        Polygon poly = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
        double[] c = new double[2];
        this.normes = new double[this.ptsx.length];
        Polygon[] nShadows = new Polygon[nb];
        int[] shx = new int[4];
        int[] shy = new int[4];
        double st = this.shadowThickness;
        int[] m = new int[2];
        for (i = 0; i < this.ptsx.length - 1; ++i) {
            cx = (this.ptsx[i + 1] - this.ptsx[i]) * (this.ptsx[i + 1] - this.ptsx[i]);
            cy = (this.ptsy[i + 1] - this.ptsy[i]) * (this.ptsy[i + 1] - this.ptsy[i]);
            this.normes[i] = Math.sqrt(cx + cy);
        }
        cx = (this.ptsx[0] - this.ptsx[i]) * (this.ptsx[0] - this.ptsx[i]);
        cy = (this.ptsy[0] - this.ptsy[i]) * (this.ptsy[0] - this.ptsy[i]);
        this.normes[i] = Math.sqrt(cx + cy);
        this.computeNextShadowSegment(this.ptsx.length - 1, poly, c);
        for (i = 0; i < nb; ++i) {
            shx[0] = this.ptsx[i];
            shy[0] = this.ptsy[i];
            shx[1] = this.ptsx[i] + (int)Math.round(st * c[0]);
            shy[1] = this.ptsy[i] + (int)Math.round(st * c[1]);
            this.computeNextShadowSegment(i, poly, c);
            int inext = i + 1;
            if (inext >= this.ptsx.length) {
                inext = 0;
            }
            shx[2] = this.ptsx[inext] + (int)Math.round(st * c[0]);
            shy[2] = this.ptsy[inext] + (int)Math.round(st * c[1]);
            shx[3] = this.ptsx[inext];
            shy[3] = this.ptsy[inext];
            this.getMinMax(shx, m);
            if (m[0] <= minx) {
                minx = m[0];
            }
            if (m[1] >= maxx) {
                maxx = m[1];
            }
            this.getMinMax(shy, m);
            if (m[0] <= miny) {
                miny = m[0];
            }
            if (m[1] >= maxy) {
                maxy = m[1];
            }
            nShadows[i] = new Polygon(shx, shy, 4);
        }
        this.shadows = nShadows;
        this.sBoundRect.setBounds(minx, miny, maxx - minx + 1, maxy - miny + 1);
        this.sBoundRect = this.sBoundRect.union(this.boundRect);
    }

    void computeShadowColors() {
        int nb = this.ptsx.length;
        double[] yuv = new double[3];
        if (this.foreground != null) {
            this.RGBtoYUV(this.foreground, yuv);
        } else {
            yuv[0] = 0.0;
            yuv[1] = 128.0;
            yuv[2] = 128.0;
        }
        Polygon poly = new Polygon(this.ptsx, this.ptsy, nb);
        this.shadowColors = new Color[nb];
        for (int i = 0; i < nb; ++i) {
            int inext = i + 1;
            if (inext >= nb) {
                inext = 0;
            }
            this.shadowColors[i] = this.computeShadowColor(i, inext, poly, yuv);
        }
    }

    String getNodeName() {
        Object treeName;
        String className = this.getClass().toString();
        int idx = className.lastIndexOf(46);
        if (idx > 0) {
            className = className.substring(idx + 1);
        }
        Object object = treeName = this.name.length() >= 0 ? this.name : className;
        if (this.isInteractive()) {
            treeName = (String)treeName + "*";
        }
        return treeName;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setForeground(Color c) {
        this.foreground = c;
        if (this.hasShadow()) {
            this.computeShadowColors();
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setOrigin(Point2D.Double p) {
        this.origin = p;
    }

    public void centerOrigin() {
        this.origin.x = this.boundRect.x + this.boundRect.width / 2;
        this.origin.y = this.boundRect.y + this.boundRect.height / 2;
    }

    public Point2D.Double getOrigin() {
        return this.origin;
    }

    public String toString() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            className = className.substring(pos + 1);
        }
        return className;
    }

    public void setFillStyle(int style) {
        this.fillStyle = style;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setAntiAlias(boolean aliasing) {
        this.antiAlias = aliasing;
    }

    public boolean isAntiAliased() {
        return this.antiAlias;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean hasShadow() {
        return this.isShadowed;
    }

    public void setShadow(boolean b) {
        this.isShadowed = b;
        this.updateShape();
    }

    public void setShadowWidth(int w) {
        this.shadowThickness = w;
        this.updateShape();
    }

    public int getShadowWidth() {
        return this.shadowThickness;
    }

    public boolean hasInverseShadow() {
        return this.invertShadow;
    }

    public void setInverseShadow(boolean b) {
        this.invertShadow = b;
        if (this.hasShadow()) {
            this.computeShadowColors();
        }
    }

    public void setMinValue(int min) {
        this.minValue = min;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int max) {
        this.maxValue = max;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setInitValue(int i) {
        this.initValue = i;
    }

    public int getInitValue() {
        return this.initValue;
    }

    public boolean isInteractive() {
        return this.userValue;
    }

    public void setInteractive(boolean b) {
        this.userValue = b;
    }

    public int getValueChangeMode() {
        return this.valueChangeMode;
    }

    public void setValueChangeMode(int m) {
        this.valueChangeMode = m;
    }

    public boolean hasBackgroundMapper() {
        return this.backgroundMapper != null;
    }

    public void setBackgroundMapper(JDValueProgram m) {
        this.backgroundMapper = m;
    }

    public JDValueProgram getBackgroundMapper() {
        return this.backgroundMapper;
    }

    public boolean hasForegroundMapper() {
        return this.foregroundMapper != null;
    }

    public void setForegroundMapper(JDValueProgram m) {
        this.foregroundMapper = m;
    }

    public JDValueProgram getForegroundMapper() {
        return this.foregroundMapper;
    }

    public boolean hasVisibilityMapper() {
        return this.visibilityMapper != null;
    }

    public void setVisibilityMapper(JDValueProgram m) {
        this.visibilityMapper = m;
    }

    public JDValueProgram getVisibilityMapper() {
        return this.visibilityMapper;
    }

    public boolean hasInvertShadowMapper() {
        return this.invertShadowMapper != null;
    }

    public void setInvertShadowMapper(JDValueProgram m) {
        this.invertShadowMapper = m;
    }

    public JDValueProgram getInvertShadowMapper() {
        return this.invertShadowMapper;
    }

    public boolean hasHTranslationMapper() {
        return this.hTranslationMapper != null;
    }

    public void setHTranslationMapper(JDValueProgram m) {
        this.hTranslationMapper = m;
    }

    public JDValueProgram getHTranslationMapper() {
        return this.hTranslationMapper;
    }

    public boolean hasVTranslationMapper() {
        return this.vTranslationMapper != null;
    }

    public void setVTranslationMapper(JDValueProgram m) {
        this.vTranslationMapper = m;
    }

    public JDValueProgram getVTranslationMapper() {
        return this.vTranslationMapper;
    }

    void prepareRendering(Graphics2D g2) {
        if (this.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void setGradientFillParam(float x1, float y1, Color color1, float x2, float y2, Color color2, boolean cyclic) {
        this.gradientX1 = x1;
        this.gradientX2 = x2;
        this.gradientY1 = y1;
        this.gradientY2 = y2;
        this.gradientC1 = color1;
        this.gradientC2 = color2;
        this.gradientCyclic = cyclic;
    }

    void setParent(JDrawEditor p) {
        this.parent = p;
    }

    JDrawEditor getParent() {
        return this.parent;
    }

    public boolean isProgrammed() {
        return this.hasValueProgram();
    }

    public void refresh() {
        if (this.parent != null) {
            if (this.preRefreshRect != null) {
                this.parent.repaint(this.preRefreshRect.union(this.getRepaintRect()));
            } else {
                this.parent.repaint(this.getRepaintRect());
            }
        }
        this.preRefreshRect = null;
    }

    public void preRefresh() {
        this.preRefreshRect = this.getRepaintRect();
    }

    public void setExtensionList(String[] names) {
        this.extParamName = names;
        this.extParamValue = new String[names.length];
        for (int i = 0; i < this.extParamValue.length; ++i) {
            this.extParamValue[i] = "";
        }
    }

    public void addExtension(String name) {
        int i = this.getExtendedParamIndex(name);
        if (i != -1) {
            return;
        }
        int nbExt = this.getExtendedParamNumber();
        String[] newExts = new String[nbExt + 1];
        String[] newValues = new String[nbExt + 1];
        for (i = 0; i < nbExt; ++i) {
            newExts[i] = this.extParamName[i];
            newValues[i] = this.extParamValue[i];
        }
        newExts[i] = name;
        newValues[i] = "";
        this.extParamName = newExts;
        this.extParamValue = newValues;
    }

    public void setExtendedParam(String name, String value) {
        int i = this.getExtendedParamIndex(name);
        if (i != -1) {
            this.extParamValue[i] = value;
        } else {
            System.out.println("JDObject.setExtendedParam() : " + name + " does not exist for " + this.getName() + ".");
        }
    }

    public void removeExtension(int extIdx) {
        int i;
        int nbExt = this.getExtendedParamNumber();
        if (extIdx >= nbExt || extIdx < 0) {
            System.out.println("JDObject.removeExtension() : " + extIdx + " index out of bounds.");
            return;
        }
        String[] newExts = new String[nbExt - 1];
        String[] newValues = new String[nbExt - 1];
        for (i = 0; i < extIdx; ++i) {
            newExts[i] = this.extParamName[i];
            newValues[i] = this.extParamValue[i];
        }
        for (i = extIdx + 1; i < nbExt; ++i) {
            newExts[i - 1] = this.extParamName[i];
            newValues[i - 1] = this.extParamValue[i];
        }
        this.extParamName = newExts;
        this.extParamValue = newValues;
    }

    public void setExtendedParam(int extIdx, String value) {
        int n = this.getExtendedParamNumber();
        if (extIdx < 0 || extIdx >= n) {
            System.out.println("JDObject.setExtendedParam() : index of of bounds.");
            return;
        }
        this.extParamValue[extIdx] = value;
    }

    public String getExtendedParam(String name) {
        int i = this.getExtendedParamIndex(name);
        if (i != -1) {
            return this.extParamValue[i];
        }
        System.out.println("JDObject.getExtendedParam() : " + name + " does not exist.");
        return "";
    }

    public String getExtendedParam(int extIdx) {
        int n = this.getExtendedParamNumber();
        if (extIdx < 0 || extIdx >= n) {
            System.out.println("JDObject.getExtendedParam() : index of of bounds.");
            return "";
        }
        return this.extParamValue[extIdx];
    }

    public String getExtendedParamName(int extIdx) {
        int n = this.getExtendedParamNumber();
        if (extIdx < 0 || extIdx >= n) {
            System.out.println("JDObject.getExtendedParamName() : index of of bounds.");
            return "";
        }
        return this.extParamName[extIdx];
    }

    public String getExtendedParamDesc(String extName) {
        return "";
    }

    public int getExtendedParamNumber() {
        if (this.extParamValue == null) {
            return 0;
        }
        return this.extParamValue.length;
    }

    public int getExtendedParamIndex(String name) {
        if (this.extParamName == null) {
            return -1;
        }
        boolean found = false;
        int i = 0;
        while (i < this.extParamName.length && !found) {
            found = name.equalsIgnoreCase(this.extParamName[i]);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public boolean hasExtendedParam(String name) {
        return this.getExtendedParamIndex(name) >= 0;
    }

    public boolean isFixedExtendedParam(String name) {
        return false;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }
}

