/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDBrowserPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDGradientDialog;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDObjectPanel
extends JPanel
implements ActionListener,
ChangeListener,
KeyListener {
    private JTextField nameText;
    private JButton applyNameBtn;
    private JLabel backgroundLabel;
    private JButton backgroundButton;
    private JLabel foregroundLabel;
    private JButton foregroundButton;
    private JLabel lineWidthLabel;
    private JSpinner lineWidthSpinner;
    private JLabel lineDashLabel;
    private JComboBox lineDashCombo;
    private JLabel fillDashLabel;
    private JComboBox fillDashCombo;
    private JButton fillCustomButton;
    private JCheckBox visibleCheckBox;
    private JCheckBox antiAliasCheckBox;
    private JCheckBox shadowCheckBox;
    private JCheckBox invertShadowCheckBox;
    private JLabel shadowWidthLabel;
    private JSpinner shadowWidthSpinner;
    private JDObject[] allObjects = null;
    private JDrawEditor invoker;
    private JDBrowserPanel invoker2;
    private Rectangle oldRect;
    private boolean isUpdating = false;
    private boolean nameHasChanged;

    public JDObjectPanel() {
        this(null, null, null);
    }

    public JDObjectPanel(JDObject[] p, JDrawEditor jc, JDBrowserPanel jb) {
        this.invoker = jc;
        this.invoker2 = jb;
        this.setForeground(JDUtils.labelColor);
        this.setFont(JDUtils.labelFont);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel namePanel = new JPanel(null);
        namePanel.setBorder(JDUtils.createTitleBorder("Object name"));
        namePanel.setBounds(5, 5, 370, 55);
        this.nameText = new JTextField();
        this.nameText.setMargin(JDUtils.zMargin);
        this.nameText.setEditable(true);
        this.nameText.setFont(JDUtils.labelFont);
        this.nameText.setBounds(10, 20, 260, 24);
        this.nameText.addActionListener(this);
        this.nameText.addKeyListener(this);
        namePanel.add(this.nameText);
        this.nameHasChanged = false;
        this.applyNameBtn = new JButton("Apply");
        this.applyNameBtn.setFont(JDUtils.labelFont);
        this.applyNameBtn.setBounds(270, 20, 90, 24);
        this.applyNameBtn.addActionListener(this);
        namePanel.add(this.applyNameBtn);
        this.add(namePanel);
        JPanel colorPanel = new JPanel(null);
        colorPanel.setBorder(JDUtils.createTitleBorder("Colors"));
        colorPanel.setBounds(5, 60, 370, 55);
        this.foregroundLabel = JDUtils.createLabel("Foreground");
        this.foregroundLabel.setBounds(10, 20, 100, 24);
        colorPanel.add(this.foregroundLabel);
        this.foregroundButton = new JButton("...");
        this.foregroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.foregroundButton.setForeground(Color.BLACK);
        this.foregroundButton.addActionListener(this);
        this.foregroundButton.setBounds(120, 20, 60, 24);
        colorPanel.add(this.foregroundButton);
        this.add(colorPanel);
        this.backgroundLabel = JDUtils.createLabel("Background");
        this.backgroundLabel.setBounds(190, 20, 100, 24);
        colorPanel.add(this.backgroundLabel);
        this.backgroundButton = new JButton("");
        this.backgroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundButton.setForeground(Color.BLACK);
        this.backgroundButton.addActionListener(this);
        this.backgroundButton.setBounds(300, 20, 60, 24);
        colorPanel.add(this.backgroundButton);
        JPanel stylePanel = new JPanel(null);
        stylePanel.setBorder(JDUtils.createTitleBorder("Styles"));
        stylePanel.setBounds(5, 115, 370, 115);
        this.lineDashLabel = JDUtils.createLabel("Line style");
        this.lineDashLabel.setBounds(10, 20, 70, 25);
        stylePanel.add(this.lineDashLabel);
        this.lineDashCombo = new JComboBox();
        this.lineDashCombo.setFont(JDUtils.labelFont);
        this.lineDashCombo.addItem("Solid");
        this.lineDashCombo.addItem("Point dash");
        this.lineDashCombo.addItem("Short dash");
        this.lineDashCombo.addItem("Long dash");
        this.lineDashCombo.addItem("Dot dash");
        this.lineDashCombo.addActionListener(this);
        this.lineDashCombo.setBounds(80, 20, 140, 25);
        stylePanel.add(this.lineDashCombo);
        this.lineWidthLabel = JDUtils.createLabel("Line width");
        this.lineWidthLabel.setHorizontalAlignment(4);
        this.lineWidthLabel.setBounds(220, 20, 90, 25);
        stylePanel.add(this.lineWidthLabel);
        this.lineWidthSpinner = new JSpinner();
        this.lineWidthSpinner.addChangeListener(this);
        this.lineWidthSpinner.setBounds(315, 20, 45, 25);
        stylePanel.add(this.lineWidthSpinner);
        this.add(stylePanel);
        this.fillDashLabel = JDUtils.createLabel("Fill style");
        this.fillDashLabel.setBounds(10, 50, 70, 25);
        stylePanel.add(this.fillDashLabel);
        this.fillDashCombo = new JComboBox();
        this.fillDashCombo.setFont(JDUtils.labelFont);
        this.fillDashCombo.addItem("No fill");
        this.fillDashCombo.addItem("Solid");
        this.fillDashCombo.addItem("Large leff hatch");
        this.fillDashCombo.addItem("Large right hatch");
        this.fillDashCombo.addItem("Large cross hatch");
        this.fillDashCombo.addItem("Small leff hatch");
        this.fillDashCombo.addItem("Small right hatch");
        this.fillDashCombo.addItem("Small cross hatch");
        this.fillDashCombo.addItem("Dot pattern 1");
        this.fillDashCombo.addItem("Dot pattern 2");
        this.fillDashCombo.addItem("Dot pattern 3");
        this.fillDashCombo.addItem("Gradient fill");
        this.fillDashCombo.addActionListener(this);
        this.fillDashCombo.setBounds(80, 50, 140, 25);
        stylePanel.add(this.fillDashCombo);
        this.fillCustomButton = new JButton("Gradient settings");
        this.fillCustomButton.setFont(JDUtils.labelFont);
        this.fillCustomButton.setMargin(new Insets(0, 0, 0, 0));
        this.fillCustomButton.setForeground(Color.BLACK);
        this.fillCustomButton.addActionListener(this);
        this.fillCustomButton.setBounds(230, 50, 130, 25);
        stylePanel.add(this.fillCustomButton);
        this.visibleCheckBox = new JCheckBox("Visible");
        this.visibleCheckBox.setFont(JDUtils.labelFont);
        this.visibleCheckBox.setForeground(JDUtils.labelColor);
        this.visibleCheckBox.setBounds(5, 80, 90, 25);
        this.visibleCheckBox.addActionListener(this);
        stylePanel.add(this.visibleCheckBox);
        this.antiAliasCheckBox = new JCheckBox("Anti alias");
        this.antiAliasCheckBox.setFont(JDUtils.labelFont);
        this.antiAliasCheckBox.setForeground(JDUtils.labelColor);
        this.antiAliasCheckBox.setBounds(110, 80, 90, 25);
        this.antiAliasCheckBox.addActionListener(this);
        stylePanel.add(this.antiAliasCheckBox);
        JPanel shadowPanel = new JPanel(null);
        shadowPanel.setBorder(JDUtils.createTitleBorder("Shadows"));
        shadowPanel.setBounds(5, 230, 370, 55);
        this.shadowCheckBox = new JCheckBox("Shadow");
        this.shadowCheckBox.setFont(JDUtils.labelFont);
        this.shadowCheckBox.setForeground(JDUtils.labelColor);
        this.shadowCheckBox.setBounds(5, 20, 90, 25);
        this.shadowCheckBox.addActionListener(this);
        shadowPanel.add(this.shadowCheckBox);
        this.invertShadowCheckBox = new JCheckBox("Invert");
        this.invertShadowCheckBox.setFont(JDUtils.labelFont);
        this.invertShadowCheckBox.setForeground(JDUtils.labelColor);
        this.invertShadowCheckBox.setBounds(110, 20, 90, 25);
        this.invertShadowCheckBox.addActionListener(this);
        shadowPanel.add(this.invertShadowCheckBox);
        this.shadowWidthLabel = JDUtils.createLabel("Thickness");
        this.shadowWidthLabel.setHorizontalAlignment(4);
        this.shadowWidthLabel.setBounds(200, 20, 90, 25);
        shadowPanel.add(this.shadowWidthLabel);
        this.shadowWidthSpinner = new JSpinner();
        this.shadowWidthSpinner.addChangeListener(this);
        this.shadowWidthSpinner.setBounds(295, 20, 65, 25);
        shadowPanel.add(this.shadowWidthSpinner);
        this.add(shadowPanel);
        this.updatePanel(p);
    }

    public boolean nameHasChanged() {
        return this.nameHasChanged;
    }

    public void applyName() {
        for (int i = 0; i < this.allObjects.length; ++i) {
            this.allObjects[i].setName(this.nameText.getText());
        }
        this.invoker.setNeedToSave(true, "Change name");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.nameText.setCaretPosition(0);
        this.nameHasChanged = false;
    }

    public void cancelNameChanged() {
        this.nameHasChanged = false;
    }

    public void updatePanel(JDObject[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        this.nameHasChanged = false;
        if (objs == null || objs.length <= 0) {
            this.nameText.setText("");
            this.foregroundButton.setBackground(Color.LIGHT_GRAY);
            this.backgroundButton.setBackground(Color.LIGHT_GRAY);
            this.lineDashCombo.setSelectedIndex(-1);
            this.lineWidthSpinner.setModel(new SpinnerNumberModel(0, 0, 0, 0));
            this.shadowWidthSpinner.setModel(new SpinnerNumberModel(0, 0, 0, 0));
            this.fillDashCombo.setSelectedIndex(-1);
            this.fillCustomButton.setEnabled(false);
            this.visibleCheckBox.setSelected(false);
            this.antiAliasCheckBox.setSelected(false);
            this.shadowCheckBox.setSelected(false);
            this.invertShadowCheckBox.setSelected(false);
        } else {
            JDObject p = objs[0];
            this.nameText.setText(p.getName());
            this.foregroundButton.setBackground(p.getForeground());
            this.backgroundButton.setBackground(p.getBackground());
            this.lineDashCombo.setSelectedIndex(p.getLineStyle());
            Integer value = new Integer(p.getLineWidth());
            Integer min = new Integer(0);
            Integer max = new Integer(10);
            Integer step = new Integer(1);
            SpinnerNumberModel spModel = new SpinnerNumberModel(value, min, max, step);
            this.lineWidthSpinner.setModel(spModel);
            min = new Integer(1);
            max = new Integer(20);
            step = new Integer(1);
            value = new Integer(p.getShadowWidth());
            SpinnerNumberModel sp2Model = new SpinnerNumberModel(value, min, max, step);
            this.shadowWidthSpinner.setModel(sp2Model);
            this.fillDashCombo.setSelectedIndex(p.getFillStyle());
            this.fillCustomButton.setEnabled(p.getFillStyle() == 11);
            this.visibleCheckBox.setSelected(p.isVisible());
            this.antiAliasCheckBox.setSelected(p.isAntiAliased());
            this.shadowCheckBox.setSelected(p.hasShadow());
            this.invertShadowCheckBox.setSelected(p.hasInverseShadow());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        Object src = e.getSource();
        this.initRepaint();
        if (src == this.backgroundButton) {
            Color c = JColorChooser.showDialog(this, "Choose background color", this.allObjects[0].getBackground());
            if (c != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setBackground(c);
                }
                this.backgroundButton.setBackground(c);
                this.invoker.setNeedToSave(true, "Change background");
            }
        } else if (src == this.foregroundButton) {
            Color c = JColorChooser.showDialog(this, "Choose foreground color", this.allObjects[0].getForeground());
            if (c != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setForeground(c);
                }
                this.foregroundButton.setBackground(c);
                this.invoker.setNeedToSave(true, "Change foreground");
            }
        } else if (src == this.lineDashCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setLineStyle(this.lineDashCombo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change line style");
        } else if (src == this.fillDashCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setFillStyle(this.fillDashCombo.getSelectedIndex());
            }
            this.fillCustomButton.setEnabled(this.fillDashCombo.getSelectedIndex() == 11);
            this.invoker.setNeedToSave(true, "Change fill style");
        } else if (src == this.shadowCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setShadow(this.shadowCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change shadow");
        } else if (src == this.invertShadowCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInverseShadow(this.invertShadowCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change invert shadow");
        } else if (src == this.nameText || src == this.applyNameBtn) {
            this.applyName();
        } else if (src == this.visibleCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVisible(this.visibleCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change visible");
        } else if (src == this.fillCustomButton) {
            JDialog d = (JDialog)this.getRootPane().getRootPane().getParent();
            JDGradientDialog dlg = new JDGradientDialog(d, this.allObjects, (JComponent)this.invoker);
            if (dlg.editGradient()) {
                this.invoker.setNeedToSave(true, "Change gradient fill");
            }
        } else if (src == this.antiAliasCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setAntiAlias(this.antiAliasCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change anti alias");
        }
        this.repaintObjects();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object src = e.getSource();
        if (src == this.nameText) {
            this.nameHasChanged = true;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        Object src = e.getSource();
        this.initRepaint();
        if (src == this.lineWidthSpinner) {
            Integer v = (Integer)this.lineWidthSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setLineWidth(v);
            }
            this.invoker.setNeedToSave(true, "Change line width");
        } else if (src == this.shadowWidthSpinner) {
            Integer v = (Integer)this.shadowWidthSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setShadowWidth(v);
            }
            this.invoker.setNeedToSave(true, "Change shadow width");
        }
        this.repaintObjects();
    }
}

