/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatable;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDPolyline
extends JDObject
implements JDRotatable {
    static final boolean isClosedDefault = true;
    static final int stepDefault = 1;
    boolean isClosed;
    int step;
    int breakId = -1;
    int breakX;
    int breakY;

    JDPolyline() {
    }

    public JDPolyline(String objectName, Point[] p) {
        this.initDefault();
        this.summit = new Point2D.Double[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.summit[i] = new Point2D.Double(p[i].x, p[i].y);
        }
        this.name = objectName;
        this.updateShape();
        Point2D.Double org = new Point2D.Double(this.boundRect.x + this.boundRect.width / 2, this.boundRect.y + this.boundRect.height / 2);
        this.setOrigin(org);
    }

    JDPolyline(JDPolyline e, int x, int y) {
        this.cloneObject(e, x, y);
        this.isClosed = e.isClosed;
        this.step = e.step;
        this.updateShape();
    }

    JDPolyline(JLXObject jlxObj, JLXPath p) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        int nbp = p.path.size();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[nbp];
        this.createSummit();
        for (int i = 0; i < nbp; ++i) {
            double[] pts = (double[])p.path.get(i);
            this.summit[i].x = this.origin.x + pts[0];
            this.summit[i].y = this.origin.y + pts[1];
        }
        this.isClosed = p.closed;
        this.step = 1;
        this.updateShape();
    }

    JDPolyline(LXObject lxObj, double[] ptsx, double[] ptsy, boolean closed) {
        this.initDefault();
        this.loadObject(lxObj);
        int nbp = ptsx.length;
        this.summit = new Point2D.Double[nbp];
        this.createSummit();
        for (int i = 0; i < nbp; ++i) {
            this.summit[i].x = ptsx[i];
            this.summit[i].y = ptsy[i];
        }
        this.isClosed = closed;
        this.step = 1;
        this.updateShape();
        double x = this.boundRect.getX();
        double y = this.boundRect.getY();
        double w = this.boundRect.getWidth();
        double h = this.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.step = 1;
        this.isClosed = true;
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDPolyline(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        if (this.fillStyle != 0) {
            Paint p = GraphicsUtils.createPatternForFilling(this);
            if (p != null) {
                g2.setPaint(p);
            }
            g.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
        }
        if (!this.isClosed) {
            if (this.lineWidth > 0) {
                g.setColor(this.foreground);
                bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
                if (bs != null) {
                    Stroke old = g2.getStroke();
                    g2.setStroke(bs);
                    g.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
                    g2.setStroke(old);
                } else {
                    g.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
                }
            }
        } else if (this.lineWidth > 0) {
            g.setColor(this.foreground);
            bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            if (bs != null) {
                Stroke old = g2.getStroke();
                g2.setStroke(bs);
                g.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                g2.setStroke(old);
            } else {
                g.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        this.paintShadows(g);
    }

    void paintSelectedSummit(Graphics g, int[] ids, double summitWidth) {
        g.setColor(Color.MAGENTA);
        g.setXORMode(Color.white);
        int sw = (int)(summitWidth / 2.0 + 1.0);
        for (int i = 0; i < ids.length; ++i) {
            g.fillRect((int)(this.summit[ids[i]].x + 0.5) - sw, (int)(this.summit[ids[i]].y + 0.5) - sw, 2 * sw, 2 * sw);
        }
        g.setPaintMode();
    }

    @Override
    int getSummitMotion(int id) {
        return 3;
    }

    void translateSummits(int[] ids, double tx, double ty) {
        for (int i = 0; i < ids.length; ++i) {
            this.summit[ids[i]].x += tx;
            this.summit[ids[i]].y += ty;
        }
        this.updateShape();
    }

    int[] getSummitsInsideRectangle(Rectangle r) {
        int[] tmp = new int[this.summit.length];
        int nb = 0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (!r.contains((int)(this.summit[i].x + 0.5), (int)(this.summit[i].y + 0.5))) continue;
            tmp[nb] = i;
            ++nb;
        }
        int[] ret = new int[nb];
        for (int i = 0; i < nb; ++i) {
            ret[i] = tmp[i];
        }
        return ret;
    }

    @Override
    public void moveSummit(int id, double x, double y) {
        this.summit[id].x = x;
        this.summit[id].y = y;
        this.updateShape();
    }

    void deleteSummit() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] nSummit = new Point2D.Double[this.summit.length - 1];
        int nb = 0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (i == this.breakId) continue;
            nSummit[nb++] = this.summit[i];
        }
        this.summit = nSummit;
        this.updateShape();
    }

    boolean canDeleteSummit(int id) {
        if (!this.visible) {
            return false;
        }
        this.breakId = -1;
        if (id < 0 || id >= this.summit.length || this.summit.length <= 2) {
            return false;
        }
        this.breakId = id;
        return true;
    }

    boolean canBreakShape(int x, int y) {
        if (!this.visible) {
            return false;
        }
        Line2D.Double l = new Line2D.Double();
        this.breakId = -1;
        for (int i = 0; i < this.ptsx.length; ++i) {
            int inext = i + 1;
            if (inext >= this.ptsx.length) {
                inext -= this.ptsx.length;
            }
            l.setLine(this.ptsx[i], this.ptsy[i], this.ptsx[inext], this.ptsy[inext]);
            if (!l.intersects(x - 3, y - 3, 6.0, 6.0)) continue;
            this.breakId = i;
            this.breakX = x;
            this.breakY = y;
            return true;
        }
        return false;
    }

    void breakShape() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] nSummit = new Point2D.Double[this.summit.length + 1];
        int nb = 0;
        for (int i = 0; i < this.summit.length; ++i) {
            nSummit[nb++] = this.summit[i];
            if (i != this.breakId) continue;
            nSummit[nb++] = new Point2D.Double(this.breakX, this.breakY);
        }
        this.summit = nSummit;
        this.updateShape();
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        boolean found = false;
        int i = 0;
        if (this.fillStyle != 0 && this.isClosed) {
            Polygon p = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            found = p.contains(x, y);
        } else {
            while (i < this.ptsx.length - 1 && !found) {
                found = this.isPointOnLine(x, y, this.ptsx[i], this.ptsy[i], this.ptsx[i + 1], this.ptsy[i + 1]);
                if (found) continue;
                ++i;
            }
            if (!found && this.isClosed) {
                found = this.isPointOnLine(x, y, this.ptsx[i], this.ptsy[i], this.ptsx[0], this.ptsy[0]);
            }
        }
        return found;
    }

    @Override
    public void rotate(double angle, double xCenter, double yCenter) {
        double sn = Math.sin(angle);
        double cs = Math.cos(angle);
        for (int i = 0; i < this.summit.length; ++i) {
            double vx = this.summit[i].x - xCenter;
            double vy = this.summit[i].y - yCenter;
            this.summit[i].x = vx * cs + vy * sn + xCenter;
            this.summit[i].y = -vx * sn + vy * cs + yCenter;
        }
        this.updateShape();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean b) {
        this.isClosed = b;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int s) {
        this.step = 1;
    }

    public void setStartingPoint(int idx) {
        int i;
        Point2D.Double[] nSummit = new Point2D.Double[this.summit.length];
        for (i = idx %= this.summit.length; i < this.summit.length; ++i) {
            nSummit[i - idx] = this.summit[i];
        }
        for (i = 0; i < idx; ++i) {
            nSummit[i + this.summit.length - idx] = this.summit[i];
        }
        this.summit = nSummit;
        this.updateShape();
    }

    public void connect(JDPolyline pline) {
        int i;
        JDPolyline p = pline instanceof JDSpline ? ((JDSpline)pline).convertToPolyline() : pline;
        Point2D.Double[] nSummit = new Point2D.Double[this.summit.length + p.getSummitNumber()];
        for (i = 0; i < this.summit.length; ++i) {
            nSummit[i] = this.summit[i];
        }
        for (i = 0; i < p.getSummitNumber(); ++i) {
            nSummit[i + this.summit.length] = new Point2D.Double(p.getSummit((int)i).x, p.getSummit((int)i).y);
        }
        this.summit = nSummit;
        this.updateShape();
    }

    public void invertSummitOrder() {
        Point2D.Double[] nSummit = new Point2D.Double[this.summit.length];
        for (int i = 0; i < this.summit.length; ++i) {
            nSummit[this.summit.length - i - 1] = this.summit[i];
        }
        this.summit = nSummit;
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.step != 1) {
            to_write.append(decal).append("step:").append(this.step).append("\n");
        }
        if (!this.isClosed) {
            to_write.append(decal).append("isClosed:").append(this.isClosed).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDPolyline(JDFileLoader f) throws IOException {
        this.initDefault();
        int l = f.getCurrentLine();
        f.startBlock();
        this.summit = f.parseSummitArray();
        if (this.summit.length < 2) {
            throw new IOException("Invalid summit number for JDPolyline at line " + l);
        }
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("isClosed")) {
                this.isClosed = f.parseBoolean();
                continue;
            }
            if (propName.equals("step")) {
                this.step = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(5);
        this.fillUndoPattern(u);
        u.step = this.step;
        u.isClosed = this.isClosed;
        return u;
    }

    JDPolyline(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.step = e.step;
        this.isClosed = e.isClosed;
        this.updateShape();
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[this.summit.length];
        this.ptsy = new int[this.summit.length];
        for (int i = 0; i < this.summit.length; ++i) {
            this.ptsx[i] = (int)(this.summit[i].x + 0.5);
            this.ptsy[i] = (int)(this.summit[i].y + 0.5);
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }
}

