/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDPolylinePanel
extends JPanel
implements ActionListener,
ChangeListener {
    JCheckBox closedCheckBox;
    private JLabel stepLabel;
    private JSpinner stepSpinner;
    private JDPolyline[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDPolylinePanel(JDPolyline[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel polyPanel = new JPanel(null);
        polyPanel.setBorder(JDUtils.createTitleBorder("Polyline"));
        polyPanel.setBounds(5, 5, 370, 85);
        this.closedCheckBox = new JCheckBox("Closed");
        this.closedCheckBox.setFont(JDUtils.labelFont);
        this.closedCheckBox.setBounds(5, 20, 100, 24);
        this.closedCheckBox.addActionListener(this);
        polyPanel.add(this.closedCheckBox);
        this.stepLabel = new JLabel("Interpolation step");
        this.stepLabel.setFont(JDUtils.labelFont);
        this.stepLabel.setForeground(JDUtils.labelColor);
        this.stepLabel.setBounds(10, 50, 100, 25);
        polyPanel.add(this.stepLabel);
        this.stepSpinner = new JSpinner();
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(115, 50, 60, 25);
        polyPanel.add(this.stepSpinner);
        this.add(polyPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDPolyline[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.closedCheckBox.setSelected(false);
            this.stepSpinner.setModel(new SpinnerNumberModel(0, 0, 0, 0));
        } else {
            JDPolyline p = objs[0];
            this.closedCheckBox.setSelected(p.isClosed());
            Integer value = new Integer(p.getStep());
            Integer min = new Integer(1);
            Integer max = new Integer(256);
            Integer step = new Integer(1);
            SpinnerNumberModel spModel = new SpinnerNumberModel(value, min, max, step);
            this.stepSpinner.setModel(spModel);
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.closedCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setClosed(this.closedCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change closed");
        }
        this.repaintObjects();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.stepSpinner) {
            Integer v = (Integer)this.stepSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setStep(v);
            }
            this.invoker.setNeedToSave(true, "Change step");
        }
        this.repaintObjects();
    }
}

