/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class JDRotatableLabel
extends JDRectangular {
    static final Font fontDefault = new Font("Dialog", 0, 14);
    static BufferedImage img = new BufferedImage(10, 10, 1);
    private String theText;
    private Font theFont;
    private double angle;
    private double sAngle;
    private double sn;
    private double cs;
    private int tx;
    private int ty;
    private double minWidth;
    private double minHeight;
    private double minX;
    private double minY;
    private Polygon boundPolygon;
    private int[] px;
    private int[] py;

    public JDRotatableLabel(String objectName, String text, int x, int y) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.theText = this.keepFirstLine(text);
        this.lineWidth = 0;
        this.angle = 0.0;
        this.createSummit();
        this.computeSummitCoordinates(x, y);
        this.updateShape();
        this.centerOrigin();
    }

    JDRotatableLabel(JDRotatableLabel e, int x, int y) {
        this.cloneObject(e, x, y);
        this.theText = new String(e.theText);
        this.theFont = new Font(e.theFont.getName(), e.theFont.getStyle(), e.theFont.getSize());
        this.angle = e.angle;
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.theText = "";
        this.theFont = fontDefault;
        this.angle = 0.0;
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        if (this.boundPolygon == null) {
            return true;
        }
        return this.boundPolygon.contains(x, y);
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDRotatableLabel(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        super.paint(parent, g);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setFont(this.theFont);
        g2.setColor(this.foreground);
        FontRenderContext frc = g2.getFontRenderContext();
        int fa = (int)Math.ceil(g.getFont().getLineMetrics("ABC", frc).getAscent());
        Shape oldClip = g2.getClip();
        g2.setClip(this.ptsx[0], this.ptsy[0], this.getWidth(), this.getHeight());
        g2.translate(this.ptsx[0] + this.tx, this.ptsy[0] + this.ty);
        g2.rotate(this.angle);
        g2.drawString(this.theText, 1, 1 + fa);
        g2.rotate(-this.angle);
        g2.translate(-this.ptsx[0] - this.tx, -this.ptsy[0] - this.ty);
        g2.setClip(oldClip);
    }

    @Override
    void updateShape() {
        this.computeMinBounds();
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
        this.tx = (int)(-this.minX + ((double)this.getWidth() - this.minWidth) / 2.0);
        this.ty = (int)(-this.minY + ((double)this.getHeight() - this.minHeight) / 2.0);
        int[] bx = new int[4];
        int[] by = new int[4];
        for (int i = 0; i < 4; ++i) {
            bx[i] = this.px[i] + this.ptsx[0] + this.tx;
            by[i] = this.py[i] + this.ptsy[0] + this.ty;
        }
        this.boundPolygon = new Polygon(bx, by, 4);
    }

    public void setFont(Font f) {
        this.setFont(f, false);
    }

    public void setFont(Font f, boolean resize) {
        this.theFont = f;
        this.updateLabel(resize);
    }

    public Font getFont() {
        return this.theFont;
    }

    public void setAngle(double a) {
        this.angle = a;
        this.updateLabel(true);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setText(String s) {
        this.setText(s, false);
    }

    public void setText(String s, boolean resize) {
        this.theText = s;
        this.updateLabel(resize);
    }

    public String getText() {
        return this.theText;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.theFont.getName() != fontDefault.getName() || this.theFont.getStyle() != fontDefault.getStyle() || this.theFont.getSize() != fontDefault.getSize()) {
            to_write.append(decal).append("font:\"");
            to_write.append(this.theFont.getName()).append("\",");
            to_write.append(this.theFont.getStyle()).append(",");
            to_write.append(this.theFont.getSize()).append("\n");
        }
        if (!this.theText.equals("")) {
            String[] lines = this.theText.split("\n");
            to_write.append(decal).append("text:");
            for (int i = 0; i < lines.length; ++i) {
                if (i == 0) {
                    to_write.append("\"").append(lines[i]).append("\"");
                } else {
                    to_write.append(decal).append("     \"").append(lines[i]).append("\"");
                }
                if (i == lines.length - 1) {
                    to_write.append("\n");
                    continue;
                }
                to_write.append(",\n");
            }
        }
        if (this.angle != 0.0) {
            to_write.append(decal).append("textAngle:").append(this.angle).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDRotatableLabel(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("text")) {
                this.theText = f.parseStringArray();
                continue;
            }
            if (propName.equals("textAngle")) {
                this.angle = f.parseDouble();
                continue;
            }
            if (propName.equals("font")) {
                this.theFont = f.parseFont();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(15);
        this.fillUndoPattern(u);
        u.fName = this.theFont.getName();
        u.fStyle = this.theFont.getStyle();
        u.fSize = this.theFont.getSize();
        u.angle = this.angle;
        u.text = new String(this.theText);
        return u;
    }

    JDRotatableLabel(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.theFont = new Font(e.fName, e.fStyle, e.fSize);
        this.angle = e.angle;
        this.theText = e.text;
        this.updateShape();
    }

    private String keepFirstLine(String text) {
        int i = text.indexOf(10);
        if (i != -1) {
            return text.substring(0, i);
        }
        return text;
    }

    private void computeSummitCoordinates(int x, int y) {
        this.computeMinBounds();
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = (double)x + this.minWidth;
        this.summit[2].y = y;
        this.summit[4].x = (double)x + this.minWidth;
        this.summit[4].y = (double)y + this.minHeight;
        this.summit[6].x = x;
        this.summit[6].y = (double)y + this.minHeight;
        this.centerSummit();
    }

    private void computeMinBounds() {
        Graphics g = img.getGraphics();
        g.setFont(this.theFont);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = g.getFont().getStringBounds(this.theText, frc);
        double textWidth = (int)Math.ceil(bounds.getWidth()) + 2;
        double textHeight = (int)Math.ceil(bounds.getHeight()) + 2;
        this.sn = Math.sin(this.angle);
        this.cs = Math.cos(this.angle);
        this.minX = 0.0;
        this.minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        Point2D.Double p1 = this.rotate(textWidth, 0.0);
        this.minX = Math.min(this.minX, p1.x);
        maxX = Math.max(maxX, p1.x);
        this.minY = Math.min(this.minY, p1.y);
        maxY = Math.max(maxY, p1.y);
        Point2D.Double p2 = this.rotate(textWidth, textHeight);
        this.minX = Math.min(this.minX, p2.x);
        maxX = Math.max(maxX, p2.x);
        this.minY = Math.min(this.minY, p2.y);
        maxY = Math.max(maxY, p2.y);
        Point2D.Double p3 = this.rotate(0.0, textHeight);
        this.minX = Math.min(this.minX, p3.x);
        maxX = Math.max(maxX, p3.x);
        this.minY = Math.min(this.minY, p3.y);
        maxY = Math.max(maxY, p3.y);
        this.px = new int[4];
        this.py = new int[4];
        this.px[0] = 0;
        this.px[1] = (int)p1.x;
        this.px[2] = (int)p2.x;
        this.px[3] = (int)p3.x;
        this.py[0] = 0;
        this.py[1] = (int)p1.y;
        this.py[2] = (int)p2.y;
        this.py[3] = (int)p3.y;
        this.minWidth = maxX - this.minX;
        this.minHeight = maxY - this.minY;
    }

    private Point2D.Double rotate(double x, double y) {
        Point2D.Double r = new Point2D.Double();
        r.x = this.cs * x - this.sn * y;
        r.y = this.sn * x + this.cs * y;
        return r;
    }

    private void updateLabel(boolean resize) {
        if (resize && ((double)this.getWidth() <= this.minWidth || (double)this.getHeight() <= this.minHeight)) {
            double x = this.summit[0].x + this.minWidth;
            double y = this.summit[0].y + this.minHeight;
            this.summit[2].x = x;
            this.summit[4].x = x;
            this.summit[4].y = y;
            this.summit[6].y = y;
            this.centerSummit();
        }
        this.updateShape();
    }

    @Override
    public void rotate90(double x, double y) {
        super.rotate90(x, y);
        this.angle += Math.toRadians(90.0);
        this.updateShape();
    }

    @Override
    public void restoreTransform() {
        this.angle = this.sAngle;
        this.updateShape();
        super.restoreTransform();
    }

    @Override
    public void saveTransform() {
        this.sAngle = this.angle;
        this.updateShape();
        super.saveTransform();
    }
}

