/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKFontChooser;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatableLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class JDRotatableLabelPanel
extends JPanel
implements ActionListener {
    private JScrollPane textView;
    private JTextArea textText;
    private JButton applyTextBtn;
    private JLabel fontLabel;
    private JButton fontBtn;
    private JLabel angleLabel;
    private JTextField angleText;
    private JDRotatableLabel[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDRotatableLabelPanel(JDRotatableLabel[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel namePanel = new JPanel(null);
        namePanel.setBorder(JDUtils.createTitleBorder("Text"));
        namePanel.setBounds(5, 5, 370, 130);
        this.textText = new JTextArea();
        this.textText.setEditable(true);
        this.textText.setFont(JDUtils.labelFont);
        this.textView = new JScrollPane(this.textText);
        this.textView.setBounds(10, 20, 350, 70);
        namePanel.add(this.textView);
        this.applyTextBtn = new JButton("Apply");
        this.applyTextBtn.setFont(JDUtils.labelFont);
        this.applyTextBtn.addActionListener(this);
        this.applyTextBtn.setBounds(260, 95, 100, 25);
        namePanel.add(this.applyTextBtn);
        this.add(namePanel);
        JPanel stylePanel = new JPanel(null);
        stylePanel.setBorder(JDUtils.createTitleBorder("Text styles"));
        stylePanel.setBounds(5, 140, 370, 145);
        this.fontLabel = new JLabel("Font");
        this.fontLabel.setFont(JDUtils.labelFont);
        this.fontLabel.setForeground(JDUtils.labelColor);
        this.fontLabel.setBounds(10, 20, 135, 24);
        stylePanel.add(this.fontLabel);
        this.fontBtn = new JButton();
        this.fontBtn.setText("Choose");
        this.fontBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fontBtn.setFont(JDUtils.labelFont);
        this.fontBtn.setBounds(220, 20, 140, 24);
        this.fontBtn.addActionListener(this);
        stylePanel.add(this.fontBtn);
        this.angleLabel = new JLabel("Text rotation");
        this.angleLabel.setFont(JDUtils.labelFont);
        this.angleLabel.setForeground(JDUtils.labelColor);
        this.angleLabel.setBounds(10, 50, 100, 25);
        stylePanel.add(this.angleLabel);
        this.angleText = new JTextField("");
        this.angleText.setFont(JDUtils.labelFont);
        this.angleText.setEditable(true);
        this.angleText.addActionListener(this);
        this.angleText.setBounds(110, 50, 100, 25);
        stylePanel.add(this.angleText);
        this.add(stylePanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDRotatableLabel[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.textText.setText("");
            this.fontLabel.setText("Font: ");
            this.angleText.setText("");
        } else {
            JDRotatableLabel p = objs[0];
            this.fontLabel.setText("Font: [" + JDUtils.buildFontName(p.getFont()) + "]");
            this.textText.setText(p.getText());
            this.angleText.setText(String.format("%.2f", Math.toDegrees(p.getAngle())));
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.fontBtn) {
            Font newFont = ATKFontChooser.getNewFont(this, "Choose label font", this.allObjects[0].getFont());
            if (newFont != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setFont(newFont, this.invoker.resizeLabelOnFontChange);
                }
                this.fontLabel.setText("Font: [" + JDUtils.buildFontName(newFont) + "]");
                this.invoker.setNeedToSave(true, "Change font");
            }
        } else if (src == this.angleText) {
            double angle = Math.toRadians(Double.parseDouble(this.angleText.getText()));
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setAngle(angle);
            }
            this.invoker.setNeedToSave(true, "Change angle");
        } else if (src == this.applyTextBtn) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setText(this.textText.getText(), this.invoker.resizeLabelOnTextChange);
            }
            this.invoker.setNeedToSave(true, "Change text");
        }
        this.repaintObjects();
    }
}

