/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDRoundRectanglePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JLabel stepLabel;
    private JSpinner stepSpinner;
    private JLabel cornerWidthLabel;
    private JSpinner cornerWidthSpinner;
    private JDRoundRectangle[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDRoundRectanglePanel(JDRoundRectangle[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel polyPanel = new JPanel(null);
        polyPanel.setBorder(JDUtils.createTitleBorder("Corner"));
        polyPanel.setBounds(5, 5, 370, 85);
        this.cornerWidthLabel = new JLabel("Corner width");
        this.cornerWidthLabel.setFont(JDUtils.labelFont);
        this.cornerWidthLabel.setForeground(JDUtils.labelColor);
        this.cornerWidthLabel.setBounds(10, 20, 100, 25);
        polyPanel.add(this.cornerWidthLabel);
        this.cornerWidthSpinner = new JSpinner();
        this.cornerWidthSpinner.addChangeListener(this);
        this.cornerWidthSpinner.setBounds(115, 20, 60, 25);
        polyPanel.add(this.cornerWidthSpinner);
        this.stepLabel = new JLabel("Interpolation step");
        this.stepLabel.setFont(JDUtils.labelFont);
        this.stepLabel.setForeground(JDUtils.labelColor);
        this.stepLabel.setBounds(10, 50, 100, 25);
        polyPanel.add(this.stepLabel);
        this.stepSpinner = new JSpinner();
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(115, 50, 60, 25);
        polyPanel.add(this.stepSpinner);
        this.add(polyPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDRoundRectangle[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            SpinnerNumberModel nullModel = new SpinnerNumberModel(0, 0, 0, 0);
            this.cornerWidthSpinner.setModel(nullModel);
            this.stepSpinner.setModel(nullModel);
        } else {
            JDRoundRectangle p = objs[0];
            Integer value = new Integer(p.getCornerWidth());
            Integer min = new Integer(1);
            Integer max = new Integer(256);
            Integer step = new Integer(1);
            SpinnerNumberModel spModel = new SpinnerNumberModel(value, min, max, step);
            this.cornerWidthSpinner.setModel(spModel);
            Integer value2 = new Integer(p.getStep());
            Integer min2 = new Integer(1);
            Integer max2 = new Integer(256);
            Integer step2 = new Integer(1);
            SpinnerNumberModel spModel2 = new SpinnerNumberModel(value2, min2, max2, step2);
            this.stepSpinner.setModel(spModel2);
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i;
        Integer v;
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.stepSpinner) {
            v = (Integer)this.stepSpinner.getValue();
            for (i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setStep(v);
            }
            this.invoker.setNeedToSave(true, "Change step");
        }
        if (src == this.cornerWidthSpinner) {
            v = (Integer)this.cornerWidthSpinner.getValue();
            for (i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setCornerWidth(v);
            }
            this.invoker.setNeedToSave(true, "Change corner width");
        }
        this.repaintObjects();
    }
}

