/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JDSwingObject
extends JDRectangular
implements MouseListener {
    public static Border lowerBevelBorder = BorderFactory.createLoweredBevelBorder();
    public static Border raiseBevelBorder = BorderFactory.createRaisedBevelBorder();
    public static Border etchedBevelBorder = BorderFactory.createEtchedBorder();
    public static final int NO_BORDER = 0;
    public static final int LOWERED_BORDER = 1;
    public static final int RAISED_BORDER = 2;
    public static final int ETCHED_BORDER = 3;
    static final int borderDefault = 0;
    private String className = "";
    private JDrawable swingComp = null;
    private Font theFont;
    private int border;

    public JDSwingObject(String objectName, String className, int x, int y) {
        Dimension d;
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.className = className;
        this.lineWidth = 0;
        this.fillStyle = 1;
        this.createSummit();
        this.constructComponent(true);
        if (this.swingComp != null) {
            d = this.swingComp.getComponent().getPreferredSize();
            if (d.width < 16) {
                d.width = 16;
            }
            if (d.height < 16) {
                d.height = 16;
            }
        } else {
            d = new Dimension(16, 16);
        }
        this.computeSummitCoordinates(x, y, d.width, d.height);
        this.updateShape();
        this.centerOrigin();
    }

    JDSwingObject(JDSwingObject e, int x, int y) {
        this.cloneObject(e, x, y);
        this.className = e.className;
        this.theFont = new Font(e.theFont.getName(), e.theFont.getStyle(), e.theFont.getSize());
        this.border = e.border;
        this.constructComponent(false);
        this.mapExtensions();
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.theFont = JDLabel.fontDefault;
        this.border = 0;
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDSwingObject(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.swingComp == null) {
            return;
        }
        if (parent.getMode() == 3) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.antiAlias = false;
        this.prepareRendering(g2);
        this.swingComp.getComponent().validate();
        SwingUtilities.paintComponent(g, this.swingComp.getComponent(), parent, this.boundRect);
        this.swingComp.getComponent().setBounds(this.boundRect);
    }

    void setExtendedParam(String name, String value, boolean ignoreError) {
        if (this.isFixedExtendedParam(name)) {
            this.swingComp.setExtendedParam(name, value, !ignoreError);
            super.setExtendedParam(name, this.swingComp.getExtendedParam(name));
        } else {
            super.setExtendedParam(name, value);
        }
    }

    @Override
    public boolean isFixedExtendedParam(String name) {
        return this.getSwingExtensionIdx(name) >= 0;
    }

    private int getSwingExtensionIdx(String name) {
        int ret = -1;
        if (this.swingComp != null) {
            String[] lst = this.swingComp.getExtensionList();
            boolean found = false;
            int i = 0;
            while (i < lst.length && !found) {
                found = lst[i].equalsIgnoreCase(name);
                if (found) continue;
                ++i;
            }
            if (found) {
                return i;
            }
        }
        return ret;
    }

    @Override
    public void addMouseListener(JDMouseListener l) {
        super.addMouseListener(l);
        this.swingComp.getComponent().addMouseListener(this);
    }

    @Override
    public void removeMouseListener(JDMouseListener l) {
        super.removeMouseListener(l);
        this.swingComp.getComponent().removeMouseListener(this);
    }

    @Override
    public void setExtendedParam(String name, String value) {
        this.setExtendedParam(name, value, false);
    }

    @Override
    public void removeExtension(int idx) {
        String extName;
        if (this.swingComp != null && this.isFixedExtendedParam(extName = this.getExtendedParamName(idx))) {
            System.out.println("JDSwingObject.removeExtension() : Warning, trying to remove JDrawable extension '" + extName + "'.");
            return;
        }
        super.removeExtension(idx);
    }

    @Override
    public String getExtendedParamDesc(String extName) {
        if (this.swingComp != null) {
            return this.swingComp.getDescription(extName);
        }
        return "";
    }

    @Override
    void updateShape() {
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
        this.computeBoundRect();
        if (this.swingComp != null) {
            if (this.fillStyle == 1) {
                this.swingComp.getComponent().setBackground(this.background);
            }
            this.swingComp.getComponent().setForeground(this.foreground);
            this.swingComp.getComponent().setVisible(this.visible);
            this.swingComp.getComponent().setOpaque(this.fillStyle != 0);
            this.swingComp.getComponent().setFont(this.theFont);
            switch (this.border) {
                case 0: {
                    this.swingComp.getComponent().setBorder(null);
                    break;
                }
                case 1: {
                    this.swingComp.getComponent().setBorder(lowerBevelBorder);
                    break;
                }
                case 2: {
                    this.swingComp.getComponent().setBorder(raiseBevelBorder);
                    break;
                }
                case 3: {
                    this.swingComp.getComponent().setBorder(etchedBevelBorder);
                }
            }
            this.swingComp.getComponent().setBounds(this.boundRect);
        }
    }

    @Override
    public void setBackground(Color b) {
        super.setBackground(b);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setBackground(b);
        }
    }

    @Override
    public void setForeground(Color b) {
        super.setForeground(b);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setForeground(b);
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setVisible(v);
        }
    }

    @Override
    public void setFillStyle(int style) {
        super.setFillStyle(style);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setOpaque(this.fillStyle != 0);
        }
    }

    public void setFont(Font f) {
        this.setFont(f, false);
    }

    public void setFont(Font f, boolean resize) {
        this.theFont = f;
        this.updateComp(resize);
    }

    public void setBorder(int border) {
        this.border = border;
        this.updateShape();
    }

    public int getBorder() {
        return this.border;
    }

    public Font getFont() {
        return this.theFont;
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public JComponent getComponent() {
        if (this.swingComp != null) {
            return this.swingComp.getComponent();
        }
        return null;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        to_write.append(decal).append("className:\"").append(this.className).append("\"\n");
        if (this.theFont.getName() != JDLabel.fontDefault.getName() || this.theFont.getStyle() != JDLabel.fontDefault.getStyle() || this.theFont.getSize() != JDLabel.fontDefault.getSize()) {
            to_write.append(decal).append("font:\"");
            to_write.append(this.theFont.getName()).append("\",");
            to_write.append(this.theFont.getStyle()).append(",");
            to_write.append(this.theFont.getSize()).append("\n");
        }
        if (this.border != 0) {
            to_write.append(decal).append("border:").append(this.border).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDSwingObject(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("className")) {
                this.className = f.parseString();
                continue;
            }
            if (propName.equals("font")) {
                this.theFont = f.parseFont();
                continue;
            }
            if (propName.equals("border")) {
                this.border = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.constructComponent(false);
        this.mapExtensions();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(10);
        this.fillUndoPattern(u);
        u.className = this.className;
        u.swingComp = this.swingComp;
        u.fName = this.theFont.getName();
        u.fStyle = this.theFont.getStyle();
        u.fSize = this.theFont.getSize();
        u.border = this.border;
        return u;
    }

    JDSwingObject(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.className = e.className;
        this.swingComp = e.swingComp;
        this.theFont = new Font(e.fName, e.fStyle, e.fSize);
        this.border = e.border;
        this.mapExtensions();
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width - 1;
        this.summit[2].y = y;
        this.summit[4].x = x + width - 1;
        this.summit[4].y = y + height - 1;
        this.summit[6].x = x;
        this.summit[6].y = y + height - 1;
        this.centerSummit();
    }

    private void updateComp(boolean resize) {
        if (this.swingComp != null) {
            this.swingComp.getComponent().setFont(this.theFont);
            if (resize) {
                Dimension d = this.swingComp.getComponent().getPreferredSize();
                if (d.width < 8) {
                    d.width = 8;
                }
                if (d.height < 8) {
                    d.height = 8;
                }
                if (this.summit[2].x - this.summit[0].x <= (double)d.width || this.summit[6].y - this.summit[0].y <= (double)d.height) {
                    double x = this.summit[0].x + (double)d.width;
                    double y = this.summit[0].y + (double)d.height;
                    this.summit[2].x = x;
                    this.summit[4].x = x;
                    this.summit[4].y = y;
                    this.summit[6].y = y;
                    this.centerSummit();
                    this.updateShape();
                }
            }
        }
    }

    private void mapExtensions() {
        if (this.swingComp != null) {
            int nbExt = this.getExtendedParamNumber();
            for (int i = 0; i < nbExt; ++i) {
                this.swingComp.setExtendedParam(this.getExtendedParamName(i), this.getExtendedParam(i), false);
            }
        }
    }

    private void constructComponent(boolean loadExtension) {
        try {
            Class[] types = new Class[]{};
            Object[] params = new Object[]{};
            Class<?> swingClass = Class.forName(this.className);
            Constructor<?> swingNew = swingClass.getConstructor(types);
            this.swingComp = (JDrawable)swingNew.newInstance(params);
            this.swingComp.initForEditing();
            String[] extList = this.swingComp.getExtensionList();
            if (loadExtension) {
                this.setExtensionList(extList);
                for (int i = 0; i < extList.length; ++i) {
                    super.setExtendedParam(i, this.swingComp.getExtendedParam(extList[i]));
                }
                this.theFont = this.swingComp.getComponent().getFont();
                if (this.theFont == null) {
                    this.theFont = JDLabel.fontDefault;
                    this.swingComp.getComponent().setFont(this.theFont);
                }
                this.foreground = this.swingComp.getComponent().getForeground();
                this.background = this.swingComp.getComponent().getBackground();
                Border b = this.swingComp.getComponent().getBorder();
                if (b == lowerBevelBorder) {
                    this.border = 1;
                } else if (b == raiseBevelBorder) {
                    this.border = 2;
                } else if (b == etchedBevelBorder) {
                    this.border = 3;
                }
            } else {
                for (int i = 0; i < extList.length; ++i) {
                    if (this.hasExtendedParam(extList[i])) continue;
                    this.addExtension(extList[i]);
                    super.setExtendedParam(extList[i], this.swingComp.getExtendedParam(extList[i]));
                }
            }
        }
        catch (Exception e) {
            System.out.println("JDSwingObject.constructComponent() : " + e.getClass() + " while trying to construct " + this.className);
            e.printStackTrace();
            this.swingComp = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.fireMouseEvent(500, e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.fireMouseEvent(501, e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.fireMouseEvent(502, e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.fireMouseEvent(504, e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.fireMouseEvent(505, e);
    }
}

