/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class JDTitledRect
extends JDRectangular {
    static final String textDefault = "Title";
    static final Font fontDefault = new Font("Dialog", 1, 14);
    static final int rMargin = 10;
    static final Color color1Default = Color.BLACK;
    static final Color color2Default = Color.WHITE;
    static final boolean etchedBorderDefault = true;
    static BufferedImage img = new BufferedImage(10, 10, 1);
    private String theTitle;
    private Font theFont;
    private Color c1;
    private Color c2;
    private Dimension preferredSize = null;
    private boolean etchedBorder;
    private int wTitle = 0;
    private int hTitle = 0;

    public JDTitledRect(String objectName, String title, int x, int y) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.theTitle = title;
        Dimension d = this.getMinSize();
        this.createSummit();
        this.computeSummitCoordinates(x, y, d.width, d.height);
        this.updateShape();
        this.centerOrigin();
    }

    JDTitledRect(JDTitledRect e, int x, int y) {
        this.cloneObject(e, x, y);
        this.theTitle = new String(e.theTitle);
        this.theFont = new Font(e.theFont.getName(), e.theFont.getStyle(), e.theFont.getSize());
        this.c1 = new Color(e.c1.getRGB());
        this.c2 = new Color(e.c2.getRGB());
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.theTitle = textDefault;
        this.theFont = fontDefault;
        this.c1 = color1Default;
        this.c2 = color2Default;
        this.etchedBorder = true;
    }

    @Override
    public JDTitledRect copy(int x, int y) {
        return new JDTitledRect(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setFont(this.theFont);
        FontRenderContext frc = g2.getFontRenderContext();
        int fa = (int)Math.ceil(g.getFont().getLineMetrics("ABC", frc).getAscent());
        Rectangle2D bounds = g.getFont().getStringBounds(this.theTitle, frc);
        this.wTitle = (int)Math.ceil(bounds.getWidth());
        this.hTitle = (int)Math.ceil(bounds.getHeight());
        g2.setColor(this.foreground);
        int x1 = this.boundRect.x;
        int y1 = this.boundRect.y + this.hTitle / 2;
        int x2 = this.boundRect.x + this.boundRect.width - this.lineWidth;
        int y2 = this.boundRect.y + this.boundRect.height - this.lineWidth;
        int h1 = x1 + 10;
        int h2 = x1 + 20 + this.wTitle;
        if (this.boundRect.height > this.hTitle / 2) {
            Paint p;
            if (this.fillStyle != 0) {
                p = GraphicsUtils.createPatternForFilling(this);
                if (p != null) {
                    g2.setPaint(p);
                }
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
            }
            if (this.boundRect.width > 20 + this.wTitle && this.boundRect.height > this.hTitle + 2) {
                if (this.fillStyle != 0) {
                    p = GraphicsUtils.createPatternForFilling(this);
                    if (p != null) {
                        g2.setPaint(p);
                    }
                    g.fillRect(this.boundRect.x + 10, this.boundRect.y, this.wTitle + 10, this.hTitle);
                    this.paintRect(g2, this.foreground, this.boundRect.x + 10, this.boundRect.y, this.wTitle + 10, this.hTitle);
                }
                int xpos = this.boundRect.x + 10 + 5;
                int ypos = this.boundRect.y + fa;
                g2.setColor(this.foreground);
                g2.drawString(this.theTitle, xpos, ypos);
            }
            this.paintRect(g2, this.c1, x1, y1, x2, y2, h1, h2);
            if (this.etchedBorder) {
                this.paintRect(g2, this.c2, x1 + this.lineWidth, y1 + this.lineWidth, x2 + this.lineWidth, y2 + this.lineWidth, h1, h2);
            }
        }
    }

    private void paintRect(Graphics2D g2, Color c, int x, int y, int w, int h) {
        if (this.lineWidth > 0) {
            BasicStroke bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            Stroke old = null;
            if (bs != null) {
                old = g2.getStroke();
                g2.setStroke(bs);
            }
            g2.setColor(this.foreground);
            g2.drawLine(x, y, x + w, y);
            g2.drawLine(x + w, y, x + w, y + h);
            g2.drawLine(x + w, y + h, x, y + h);
            g2.drawLine(x, y + h, x, y);
            if (old != null) {
                g2.setStroke(old);
            }
        }
    }

    private void paintRect(Graphics2D g2, Color c, int x1, int y1, int x2, int y2, int h1, int h2) {
        if (this.lineWidth < 1) {
            return;
        }
        g2.setColor(c);
        BasicStroke bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
        Stroke old = null;
        if (bs != null) {
            old = g2.getStroke();
            g2.setStroke(bs);
        }
        if (h1 < x2) {
            g2.drawLine(x1, y1, h1, y1);
            if (h2 < x2) {
                g2.drawLine(h2, y1, x2, y1);
            }
        }
        g2.drawLine(x2, y1, x2, y2);
        g2.drawLine(x2, y2, x1, y2);
        g2.drawLine(x1, y2, x1, y1);
        if (old != null) {
            g2.setStroke(old);
        }
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(x, y);
        }
        int x1 = this.boundRect.x;
        int x2 = this.boundRect.x + this.boundRect.width;
        int y1 = this.boundRect.y + this.hTitle / 2;
        int y2 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(x, y, x1, y1, x2, y1) || this.isPointOnLine(x, y, x2, y1, x2, y2) || this.isPointOnLine(x, y, x2, y2, x1, y2) || this.isPointOnLine(x, y, x1, y2, x1, y1);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
    }

    public void setFont(Font f) {
        this.theFont = f;
    }

    public Font getFont() {
        return this.theFont;
    }

    public void setTitle(String s) {
        this.theTitle = s;
    }

    public String getTitle() {
        return this.theTitle;
    }

    public void setColor1(Color c) {
        this.c1 = c;
    }

    public Color getColor1() {
        return this.c1;
    }

    public void setColor2(Color c) {
        this.c2 = c;
    }

    public Color getColor2() {
        return this.c2;
    }

    public boolean hasEtchedBorder() {
        return this.etchedBorder;
    }

    public void setEtchedBorder(boolean b) {
        this.etchedBorder = b;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.theFont.getName() != fontDefault.getName() || this.theFont.getStyle() != fontDefault.getStyle() || this.theFont.getSize() != fontDefault.getSize()) {
            to_write.append(decal).append("font:\"");
            to_write.append(this.theFont.getName()).append("\",");
            to_write.append(this.theFont.getStyle()).append(",");
            to_write.append(this.theFont.getSize()).append("\n");
        }
        if (!this.theTitle.equals(textDefault)) {
            to_write.append(decal).append("title:");
            to_write.append("\"").append(this.theTitle).append("\"\n");
        }
        if (this.c1.getRGB() != color1Default.getRGB()) {
            to_write.append(decal).append("color1:");
            to_write.append(this.c1.getRed()).append(",");
            to_write.append(this.c1.getGreen()).append(",");
            to_write.append(this.c1.getBlue());
            if (this.c1.getAlpha() != 255) {
                to_write.append(",").append(this.foreground.getAlpha());
            }
            to_write.append("\n");
        }
        if (this.c2.getRGB() != color2Default.getRGB()) {
            to_write.append(decal).append("color2:");
            to_write.append(this.c2.getRed()).append(",");
            to_write.append(this.c2.getGreen()).append(",");
            to_write.append(this.c2.getBlue());
            if (this.c2.getAlpha() != 255) {
                to_write.append(",").append(this.foreground.getAlpha());
            }
            to_write.append("\n");
        }
        if (!this.etchedBorder) {
            to_write.append(decal).append("etchedBorder:").append(this.etchedBorder).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDTitledRect(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("title")) {
                this.theTitle = f.parseString();
                continue;
            }
            if (propName.equals("font")) {
                this.theFont = f.parseFont();
                continue;
            }
            if (propName.equals("color1")) {
                this.c1 = f.parseColor();
                continue;
            }
            if (propName.equals("color2")) {
                this.c2 = f.parseColor();
                continue;
            }
            if (propName.equals("etchedBorder")) {
                this.etchedBorder = f.parseBoolean();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(14);
        this.fillUndoPattern(u);
        u.fName = this.theFont.getName();
        u.fStyle = this.theFont.getStyle();
        u.fSize = this.theFont.getSize();
        u.text = new String(this.theTitle);
        u.etched = this.etchedBorder;
        u.c1 = this.c1.getRGB();
        u.c2 = this.c2.getRGB();
        return u;
    }

    JDTitledRect(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.theFont = new Font(e.fName, e.fStyle, e.fSize);
        this.theTitle = e.text;
        this.c1 = new Color(e.c1);
        this.c2 = new Color(e.c2);
        this.etchedBorder = e.etched;
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }

    private Dimension getMinSize() {
        if (this.preferredSize == null) {
            Graphics g = img.getGraphics();
            g.setFont(this.theFont);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D bounds = g.getFont().getStringBounds(this.theTitle, frc);
            int w = (int)Math.ceil(bounds.getWidth());
            int h = (int)Math.ceil(bounds.getHeight());
            g.dispose();
            this.preferredSize = new Dimension(w + 20, h + 2);
        }
        return this.preferredSize;
    }
}

