/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKFontChooser;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRect;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDTitledRectPanel
extends JPanel
implements ActionListener {
    private JTextField titleText;
    private JButton applyTitleBtn;
    private JLabel fontLabel;
    private JButton fontBtn;
    private JLabel c1Label;
    private JButton c1Button;
    private JLabel c2Label;
    private JButton c2Button;
    private JCheckBox etchedCheckBox;
    private JDTitledRect[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDTitledRectPanel(JDTitledRect[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel namePanel = new JPanel(null);
        namePanel.setBorder(JDUtils.createTitleBorder("Title"));
        namePanel.setBounds(5, 5, 370, 55);
        this.titleText = new JTextField();
        this.titleText.setMargin(JDUtils.zMargin);
        this.titleText.setEditable(true);
        this.titleText.setFont(JDUtils.labelFont);
        this.titleText.setBounds(10, 20, 260, 24);
        this.titleText.addActionListener(this);
        namePanel.add(this.titleText);
        this.applyTitleBtn = new JButton("Apply");
        this.applyTitleBtn.setFont(JDUtils.labelFont);
        this.applyTitleBtn.setBounds(270, 20, 90, 24);
        this.applyTitleBtn.addActionListener(this);
        namePanel.add(this.applyTitleBtn);
        this.add(namePanel);
        JPanel stylePanel = new JPanel(null);
        stylePanel.setBorder(JDUtils.createTitleBorder("Text styles"));
        stylePanel.setBounds(5, 60, 370, 55);
        this.fontLabel = new JLabel("Font");
        this.fontLabel.setFont(JDUtils.labelFont);
        this.fontLabel.setForeground(JDUtils.labelColor);
        this.fontLabel.setBounds(10, 20, 135, 24);
        stylePanel.add(this.fontLabel);
        this.fontBtn = new JButton();
        this.fontBtn.setText("Choose");
        this.fontBtn.setMargin(new Insets(0, 0, 0, 0));
        this.fontBtn.setFont(JDUtils.labelFont);
        this.fontBtn.setBounds(220, 20, 140, 24);
        this.fontBtn.addActionListener(this);
        stylePanel.add(this.fontBtn);
        this.add(stylePanel);
        JPanel borderPanel = new JPanel(null);
        borderPanel.setBorder(JDUtils.createTitleBorder("Border"));
        borderPanel.setBounds(5, 120, 370, 85);
        this.c1Label = JDUtils.createLabel("Color #1");
        this.c1Label.setBounds(10, 20, 100, 24);
        borderPanel.add(this.c1Label);
        this.c1Button = new JButton("...");
        this.c1Button.setMargin(new Insets(0, 0, 0, 0));
        this.c1Button.setForeground(Color.BLACK);
        this.c1Button.addActionListener(this);
        this.c1Button.setBounds(120, 20, 60, 24);
        borderPanel.add(this.c1Button);
        this.add(borderPanel);
        this.c2Label = JDUtils.createLabel("Color #2");
        this.c2Label.setBounds(190, 20, 100, 24);
        borderPanel.add(this.c2Label);
        this.c2Button = new JButton("");
        this.c2Button.setMargin(new Insets(0, 0, 0, 0));
        this.c2Button.setForeground(Color.BLACK);
        this.c2Button.addActionListener(this);
        this.c2Button.setBounds(300, 20, 60, 24);
        borderPanel.add(this.c2Button);
        this.etchedCheckBox = JDUtils.createCheckBox("Etched", this);
        this.etchedCheckBox.setBounds(10, 50, 150, 25);
        borderPanel.add(this.etchedCheckBox);
        this.updatePanel(p);
    }

    public void updatePanel(JDTitledRect[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.titleText.setText("");
            this.fontLabel.setText("Font: ");
            this.c1Button.setBackground(JDTitledRect.color1Default);
            this.c2Button.setBackground(JDTitledRect.color2Default);
            this.etchedCheckBox.setSelected(true);
        } else {
            JDTitledRect p = objs[0];
            this.fontLabel.setText("Font: [" + JDUtils.buildFontName(p.getFont()) + "]");
            this.titleText.setText(p.getTitle());
            this.c1Button.setBackground(p.getColor1());
            this.c2Button.setBackground(p.getColor2());
            this.etchedCheckBox.setSelected(p.hasEtchedBorder());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.fontBtn) {
            Font newFont = ATKFontChooser.getNewFont(this, "Choose label font", this.allObjects[0].getFont());
            if (newFont != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setFont(newFont);
                }
                this.fontLabel.setText("Font: [" + JDUtils.buildFontName(newFont) + "]");
                this.invoker.setNeedToSave(true, "Change font");
            }
        } else if (src == this.applyTitleBtn || src == this.titleText) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setTitle(this.titleText.getText());
            }
            this.invoker.setNeedToSave(true, "Change title");
        } else if (src == this.c1Button) {
            Color c = JColorChooser.showDialog(this, "Choose color #1", this.allObjects[0].getColor1());
            if (c != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setColor1(c);
                }
                this.c1Button.setBackground(c);
                this.invoker.setNeedToSave(true, "Change color #1");
            }
        } else if (src == this.c2Button) {
            Color c = JColorChooser.showDialog(this, "Choose color #2", this.allObjects[0].getColor2());
            if (c != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setColor2(c);
                }
                this.c2Button.setBackground(c);
                this.invoker.setNeedToSave(true, "Change color #2");
            }
        } else if (src == this.etchedCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setEtchedBorder(this.etchedCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change etched");
        }
        this.repaintObjects();
    }
}

