/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDBrowserPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDValuePanel
extends JPanel
implements ActionListener {
    private JCheckBox userValueCheckBox;
    private JLabel initValueLabel;
    private JTextField initValueText;
    private JLabel minValueLabel;
    private JTextField minValueText;
    private JLabel maxValueLabel;
    private JTextField maxValueText;
    private JButton applyValueBtn;
    private JLabel userBehaviorLabel;
    private JComboBox userBehaviorCombo;
    private JCheckBox affectBackgroundCheckBox;
    private JButton affectBackgroundBtn;
    private JCheckBox affectForegroundCheckBox;
    private JButton affectForegroundBtn;
    private JCheckBox affectVisibleCheckBox;
    private JButton affectVisibleBtn;
    private JCheckBox affectInvertShadowCheckBox;
    private JButton affectInvertShadowBtn;
    private JCheckBox affectXPosCheckBox;
    private JButton affectXPosBtn;
    private JCheckBox affectYPosCheckBox;
    private JButton affectYPosBtn;
    private JCheckBox affectXScaleCheckBox;
    private JButton affectXScaleBtn;
    private JCheckBox affectYScaleCheckBox;
    private JButton affectYScaleBtn;
    private JDObject[] allObjects = null;
    private JDrawEditor invoker;
    private JDBrowserPanel invoker2;
    private boolean isUpdating = false;

    public JDValuePanel(JDObject[] p, JDrawEditor jc, JDBrowserPanel jb) {
        this.invoker = jc;
        this.invoker2 = jb;
        this.setForeground(JDUtils.labelColor);
        this.setFont(JDUtils.labelFont);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel userPanel = new JPanel(null);
        userPanel.setBorder(JDUtils.createTitleBorder("Object value"));
        userPanel.setBounds(5, 5, 370, 145);
        this.userValueCheckBox = JDUtils.createCheckBox("Enable user interaction (Play mode)", this);
        this.userValueCheckBox.setBounds(5, 20, 330, 25);
        userPanel.add(this.userValueCheckBox);
        this.initValueLabel = JDUtils.createLabel("Init");
        this.initValueLabel.setBounds(10, 50, 30, 25);
        userPanel.add(this.initValueLabel);
        this.initValueText = new JTextField();
        this.initValueText.setMargin(JDUtils.zMargin);
        this.initValueText.setEditable(true);
        this.initValueText.setFont(JDUtils.labelFont);
        this.initValueText.setBounds(45, 50, 40, 24);
        this.initValueText.addActionListener(this);
        userPanel.add(this.initValueText);
        this.minValueLabel = JDUtils.createLabel("Min");
        this.minValueLabel.setBounds(90, 50, 30, 25);
        userPanel.add(this.minValueLabel);
        this.minValueText = new JTextField();
        this.minValueText.setMargin(JDUtils.zMargin);
        this.minValueText.setEditable(true);
        this.minValueText.setFont(JDUtils.labelFont);
        this.minValueText.setBounds(125, 50, 40, 24);
        this.minValueText.addActionListener(this);
        userPanel.add(this.minValueText);
        this.maxValueLabel = JDUtils.createLabel("Max");
        this.maxValueLabel.setBounds(170, 50, 30, 25);
        userPanel.add(this.maxValueLabel);
        this.maxValueText = new JTextField();
        this.maxValueText.setMargin(JDUtils.zMargin);
        this.maxValueText.setEditable(true);
        this.maxValueText.setFont(JDUtils.labelFont);
        this.maxValueText.setBounds(205, 50, 40, 24);
        this.maxValueText.addActionListener(this);
        userPanel.add(this.maxValueText);
        this.applyValueBtn = new JButton("Apply values");
        this.applyValueBtn.setFont(JDUtils.labelFont);
        this.applyValueBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyValueBtn.setForeground(Color.BLACK);
        this.applyValueBtn.addActionListener(this);
        this.applyValueBtn.setBounds(255, 50, 105, 25);
        userPanel.add(this.applyValueBtn);
        this.userBehaviorLabel = JDUtils.createLabel("Object value change when nouse");
        this.userBehaviorLabel.setBounds(10, 83, 300, 20);
        userPanel.add(this.userBehaviorLabel);
        this.userBehaviorCombo = new JComboBox();
        this.userBehaviorCombo.setFont(JDUtils.labelFont);
        this.userBehaviorCombo.addItem("Clicked (value=value+1)");
        this.userBehaviorCombo.addItem("Pressed,Released (value=value+1)");
        this.userBehaviorCombo.addItem("XDragged (value=vMin,X=0 to vMax,X=W)");
        this.userBehaviorCombo.addItem("XDragged (value=vMax,X=0 to vMin,X=W)");
        this.userBehaviorCombo.addItem("YDragged (value=vMin,Y=0 to vMax,Y=H)");
        this.userBehaviorCombo.addItem("YDragged (value=vMax,Y=0 to vMin,Y=H)");
        this.userBehaviorCombo.addActionListener(this);
        this.userBehaviorCombo.setBounds(10, 105, 350, 25);
        userPanel.add(this.userBehaviorCombo);
        this.add(userPanel);
        JPanel dynaPanel = new JPanel(null);
        dynaPanel.setBorder(JDUtils.createTitleBorder("Object value affetcs"));
        int curY = 20;
        this.affectBackgroundCheckBox = JDUtils.createCheckBox("Backgound color", this);
        this.affectBackgroundCheckBox.setBounds(5, curY, 140, 25);
        dynaPanel.add(this.affectBackgroundCheckBox);
        this.affectBackgroundBtn = JDUtils.createSetButton(this);
        this.affectBackgroundBtn.setBounds(150, curY, 25, 25);
        dynaPanel.add(this.affectBackgroundBtn);
        this.affectForegroundCheckBox = JDUtils.createCheckBox("Foregound color", this);
        this.affectForegroundCheckBox.setBounds(5, curY += 25, 140, 25);
        dynaPanel.add(this.affectForegroundCheckBox);
        this.affectForegroundBtn = JDUtils.createSetButton(this);
        this.affectForegroundBtn.setBounds(150, curY, 25, 25);
        dynaPanel.add(this.affectForegroundBtn);
        this.affectVisibleCheckBox = JDUtils.createCheckBox("Visibilty", this);
        this.affectVisibleCheckBox.setBounds(5, curY += 25, 140, 25);
        dynaPanel.add(this.affectVisibleCheckBox);
        this.affectVisibleBtn = JDUtils.createSetButton(this);
        this.affectVisibleBtn.setBounds(150, curY, 25, 25);
        dynaPanel.add(this.affectVisibleBtn);
        this.affectInvertShadowCheckBox = JDUtils.createCheckBox("Inverse shadow", this);
        this.affectInvertShadowCheckBox.setBounds(5, curY += 25, 140, 25);
        dynaPanel.add(this.affectInvertShadowCheckBox);
        this.affectInvertShadowBtn = JDUtils.createSetButton(this);
        this.affectInvertShadowBtn.setBounds(150, curY, 25, 25);
        dynaPanel.add(this.affectInvertShadowBtn);
        curY = 20;
        this.affectXPosCheckBox = JDUtils.createCheckBox("Horizontal position", this);
        this.affectXPosCheckBox.setBounds(190, curY, 140, 25);
        dynaPanel.add(this.affectXPosCheckBox);
        this.affectXPosBtn = JDUtils.createSetButton(this);
        this.affectXPosBtn.setBounds(335, curY, 25, 25);
        dynaPanel.add(this.affectXPosBtn);
        this.affectYPosCheckBox = JDUtils.createCheckBox("Vertical position", this);
        this.affectYPosCheckBox.setBounds(190, curY += 25, 140, 25);
        dynaPanel.add(this.affectYPosCheckBox);
        this.affectYPosBtn = JDUtils.createSetButton(this);
        this.affectYPosBtn.setBounds(335, curY, 25, 25);
        dynaPanel.add(this.affectYPosBtn);
        this.affectXScaleCheckBox = JDUtils.createCheckBox("Horizontal scale", this);
        this.affectXScaleCheckBox.setBounds(190, curY += 25, 140, 25);
        dynaPanel.add(this.affectXScaleCheckBox);
        this.affectXScaleBtn = JDUtils.createSetButton(this);
        this.affectXScaleBtn.setBounds(335, curY, 25, 25);
        dynaPanel.add(this.affectXScaleBtn);
        this.affectYScaleCheckBox = JDUtils.createCheckBox("Vertical scale", this);
        this.affectYScaleCheckBox.setBounds(190, curY += 25, 140, 25);
        dynaPanel.add(this.affectYScaleCheckBox);
        this.affectYScaleBtn = JDUtils.createSetButton(this);
        this.affectYScaleBtn.setBounds(335, curY, 25, 25);
        dynaPanel.add(this.affectYScaleBtn);
        this.add(dynaPanel);
        dynaPanel.setBounds(5, 155, 370, (curY += 25) + 10);
        this.updatePanel(p);
    }

    public void updatePanel(JDObject[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            this.minValueText.setText("");
            this.maxValueText.setText("");
            this.initValueText.setText("");
            this.userValueCheckBox.setSelected(false);
            this.userBehaviorCombo.setSelectedIndex(-1);
            this.userBehaviorCombo.setEnabled(false);
            this.affectBackgroundCheckBox.setSelected(false);
            this.affectBackgroundBtn.setEnabled(false);
            this.affectForegroundCheckBox.setSelected(false);
            this.affectForegroundBtn.setEnabled(false);
            this.affectVisibleCheckBox.setSelected(false);
            this.affectVisibleBtn.setEnabled(false);
            this.affectInvertShadowCheckBox.setSelected(false);
            this.affectInvertShadowBtn.setEnabled(false);
            this.affectInvertShadowCheckBox.setSelected(false);
            this.affectInvertShadowBtn.setEnabled(false);
            this.affectXPosCheckBox.setSelected(false);
            this.affectXPosBtn.setEnabled(false);
            this.affectYPosCheckBox.setSelected(false);
            this.affectYPosBtn.setEnabled(false);
            this.affectXScaleCheckBox.setEnabled(false);
            this.affectXScaleBtn.setEnabled(false);
            this.affectYScaleCheckBox.setEnabled(false);
            this.affectYScaleBtn.setEnabled(false);
        } else {
            this.refreshControls();
        }
        this.isUpdating = false;
    }

    private void refreshControls() {
        if (this.allObjects == null) {
            return;
        }
        this.isUpdating = true;
        this.minValueText.setText(Integer.toString(this.allObjects[0].getMinValue()));
        this.minValueText.setCaretPosition(0);
        this.maxValueText.setText(Integer.toString(this.allObjects[0].getMaxValue()));
        this.maxValueText.setCaretPosition(0);
        this.initValueText.setText(Integer.toString(this.allObjects[0].getInitValue()));
        this.initValueText.setCaretPosition(0);
        boolean isEnabled = this.allObjects[0].isInteractive();
        this.userValueCheckBox.setSelected(isEnabled);
        this.userBehaviorCombo.setSelectedIndex(this.allObjects[0].getValueChangeMode());
        this.userBehaviorCombo.setEnabled(isEnabled);
        this.affectBackgroundCheckBox.setSelected(this.allObjects[0].hasBackgroundMapper());
        this.affectBackgroundBtn.setEnabled(this.allObjects[0].hasBackgroundMapper());
        this.affectForegroundCheckBox.setSelected(this.allObjects[0].hasForegroundMapper());
        this.affectForegroundBtn.setEnabled(this.allObjects[0].hasForegroundMapper());
        this.affectVisibleCheckBox.setSelected(this.allObjects[0].hasVisibilityMapper());
        this.affectVisibleBtn.setEnabled(this.allObjects[0].hasVisibilityMapper());
        this.affectInvertShadowCheckBox.setSelected(this.allObjects[0].hasInvertShadowMapper());
        this.affectInvertShadowBtn.setEnabled(this.allObjects[0].hasInvertShadowMapper());
        this.affectInvertShadowCheckBox.setSelected(this.allObjects[0].hasInvertShadowMapper());
        this.affectInvertShadowBtn.setEnabled(this.allObjects[0].hasInvertShadowMapper());
        this.affectXPosCheckBox.setSelected(this.allObjects[0].hasHTranslationMapper());
        this.affectXPosBtn.setEnabled(this.allObjects[0].hasHTranslationMapper());
        this.affectYPosCheckBox.setSelected(this.allObjects[0].hasVTranslationMapper());
        this.affectYPosBtn.setEnabled(this.allObjects[0].hasVTranslationMapper());
        this.affectXScaleCheckBox.setEnabled(false);
        this.affectXScaleBtn.setEnabled(false);
        this.affectYScaleCheckBox.setEnabled(false);
        this.affectYScaleBtn.setEnabled(false);
        this.isUpdating = false;
    }

    private void editBackgroundMapper() {
        JDValueProgram bm = JDUtils.showValueMappingDialog(this, this.allObjects, "Background color", 2, this.allObjects[0].getBackgroundMapper());
        if (bm != null) {
            this.setBackgroundMapper(bm);
        } else {
            this.refreshControls();
        }
    }

    private void setBackgroundMapper(JDValueProgram bm) {
        if (bm == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setBackgroundMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setBackgroundMapper(bm.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change background program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editForegroundMapper() {
        JDValueProgram bm = JDUtils.showValueMappingDialog(this, this.allObjects, "Foreground color", 2, this.allObjects[0].getForegroundMapper());
        if (bm != null) {
            this.setForegroundMapper(bm);
        } else {
            this.refreshControls();
        }
    }

    private void setForegroundMapper(JDValueProgram bm) {
        if (bm == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setForegroundMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setForegroundMapper(bm.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change foreground program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editVisibilityMapper() {
        JDValueProgram bm = JDUtils.showValueMappingDialog(this, this.allObjects, "Visibility", 3, this.allObjects[0].getVisibilityMapper());
        if (bm != null) {
            this.setVisibilityMapper(bm);
        } else {
            this.refreshControls();
        }
    }

    private void setVisibilityMapper(JDValueProgram bm) {
        if (bm == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVisibilityMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVisibilityMapper(bm.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change visibility program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editInvertShadowMapper() {
        JDValueProgram bm = JDUtils.showValueMappingDialog(this, this.allObjects, "Invert shadow", 3, this.allObjects[0].getInvertShadowMapper());
        if (bm != null) {
            this.setInvertShadowMapper(bm);
        } else {
            this.refreshControls();
        }
    }

    private void setInvertShadowMapper(JDValueProgram bm) {
        if (bm == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInvertShadowMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInvertShadowMapper(bm.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change shadow program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editHTranslationMapper() {
        JDValueProgram bm = JDUtils.showValueMappingDialog(this, this.allObjects, "Horizontal Translation", 1, this.allObjects[0].getHTranslationMapper());
        if (bm != null) {
            this.setHTranslationMapper(bm);
        } else {
            this.refreshControls();
        }
    }

    private void setHTranslationMapper(JDValueProgram bm) {
        if (bm == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setHTranslationMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setHTranslationMapper(bm.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change htranslation program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    private void editVTranslationMapper() {
        JDValueProgram bm = JDUtils.showValueMappingDialog(this, this.allObjects, "Vertical Translation", 1, this.allObjects[0].getVTranslationMapper());
        if (bm != null) {
            this.setVTranslationMapper(bm);
        } else {
            this.refreshControls();
        }
    }

    private void setVTranslationMapper(JDValueProgram bm) {
        if (bm == null) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVTranslationMapper(null);
            }
        } else {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setVTranslationMapper(bm.copy());
            }
        }
        this.invoker.setNeedToSave(true, "Change vtranslation program");
        if (this.invoker2 != null) {
            this.invoker2.updateNode();
        }
        this.refreshControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        Object src = e.getSource();
        if (src == this.minValueText) {
            try {
                int m = Integer.parseInt(this.minValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMinValue(m);
                }
                this.invoker.setNeedToSave(true, "Change min value");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for min value");
            }
            this.refreshControls();
        } else if (src == this.maxValueText) {
            try {
                int m = Integer.parseInt(this.maxValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMaxValue(m);
                }
                this.invoker.setNeedToSave(true, "Change max value");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for max value");
            }
            this.refreshControls();
        } else if (src == this.initValueText) {
            try {
                int m = Integer.parseInt(this.initValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setInitValue(m);
                }
                this.invoker.setNeedToSave(true, "Change init value");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for init value");
            }
            this.refreshControls();
        } else if (src == this.applyValueBtn) {
            try {
                int min = Integer.parseInt(this.minValueText.getText());
                int max = Integer.parseInt(this.maxValueText.getText());
                int init = Integer.parseInt(this.initValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMinValue(min);
                    this.allObjects[i].setMaxValue(max);
                    this.allObjects[i].setInitValue(init);
                }
                this.invoker.setNeedToSave(true, "Change value range");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "One or more value are incorrect");
            }
            this.refreshControls();
        } else if (src == this.userValueCheckBox) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setInteractive(this.userValueCheckBox.isSelected());
            }
            this.invoker.setNeedToSave(true, "Change interactive flag");
            if (this.invoker2 != null) {
                this.invoker2.updateNode();
            }
            this.refreshControls();
        } else if (src == this.userBehaviorCombo) {
            int s = this.userBehaviorCombo.getSelectedIndex();
            if (s >= 0) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setValueChangeMode(s);
                }
                this.invoker.setNeedToSave(true, "Change interactive behavior");
            }
        } else if (src == this.affectBackgroundBtn) {
            this.editBackgroundMapper();
        } else if (src == this.affectBackgroundCheckBox) {
            if (this.allObjects[0].hasBackgroundMapper()) {
                this.setBackgroundMapper(null);
            } else {
                this.editBackgroundMapper();
            }
        } else if (src == this.affectForegroundBtn) {
            this.editForegroundMapper();
        } else if (src == this.affectForegroundCheckBox) {
            if (this.allObjects[0].hasForegroundMapper()) {
                this.setForegroundMapper(null);
            } else {
                this.editForegroundMapper();
            }
        } else if (src == this.affectVisibleBtn) {
            this.editVisibilityMapper();
        } else if (src == this.affectVisibleCheckBox) {
            if (this.allObjects[0].hasVisibilityMapper()) {
                this.setVisibilityMapper(null);
            } else {
                this.editVisibilityMapper();
            }
        } else if (src == this.affectInvertShadowBtn) {
            this.editInvertShadowMapper();
        } else if (src == this.affectInvertShadowCheckBox) {
            if (this.allObjects[0].hasInvertShadowMapper()) {
                this.setInvertShadowMapper(null);
            } else {
                this.editInvertShadowMapper();
            }
        } else if (src == this.affectXPosBtn) {
            this.editHTranslationMapper();
        } else if (src == this.affectXPosCheckBox) {
            if (this.allObjects[0].hasHTranslationMapper()) {
                this.setHTranslationMapper(null);
            } else {
                this.editHTranslationMapper();
            }
        } else if (src == this.affectYPosBtn) {
            this.editVTranslationMapper();
        } else if (src == this.affectYPosCheckBox) {
            if (this.allObjects[0].hasVTranslationMapper()) {
                this.setVTranslationMapper(null);
            } else {
                this.editVTranslationMapper();
            }
        }
    }
}

