/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDClipboard;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDEntityNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatableLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRect;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import fr.esrf.tangoatk.widget.util.jdraw.JLXFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.LXFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class JDrawEditor
extends JComponent
implements MouseMotionListener,
MouseListener,
ActionListener,
KeyListener,
ComponentListener,
DropTargetListener {
    public static final int MODE_EDIT = 1;
    public static final int MODE_EDIT_GROUP = 2;
    public static final int MODE_PLAY = 3;
    public static final int MODE_LIB = 4;
    public static final int CREATE_RECTANGLE = 1;
    public static final int CREATE_LINE = 2;
    public static final int CREATE_ELLIPSE = 3;
    public static final int CREATE_POLYLINE = 4;
    public static final int CREATE_LABEL = 5;
    public static final int CREATE_SPLINE = 6;
    public static final int CREATE_CLIPBOARD = 7;
    public static final int CREATE_RRECTANGLE = 8;
    public static final int CREATE_IMAGE = 9;
    public static final int CREATE_SWINGOBJECT = 10;
    public static final int CREATE_AXIS = 11;
    public static final int CREATE_BAR = 12;
    public static final int CREATE_SLIDER = 13;
    static final int CREATE_SLIDER_CURSOR = 14;
    static final int CREATE_CONNECT_POLY = 15;
    static final int CREATE_TITLEDRECT = 16;
    public static final int CREATE_ROTATABLELABEL = 17;
    private static final int undoLength = 20;
    private Vector objects;
    private JDClipboard clipboard;
    private Vector undo;
    private int undoPos;
    private int curObject;
    private Vector selObjects;
    private boolean isDraggingSummits;
    private int[] selSummits;
    private boolean isDraggingSummit;
    private int selSummit;
    private boolean isDraggingObject;
    private boolean isDraggingSelection;
    private boolean hasMoved;
    private int lastX;
    private int lastY;
    private int selX1;
    private int selY1;
    private int selX2;
    private int selY2;
    private int creationMode;
    private JDObject lastCreatedObject = null;
    private Vector tmpPoints;
    private JPopupMenu objMenu;
    private JPopupMenu polyMenu;
    private JDPolyline editedPolyline;
    private int zoomFactor = 0;
    private double autoZoomFactor = 1.0;
    private boolean autoZoom = false;
    private int sizeX;
    private int sizeY;
    private String lastFileName = "";
    private boolean needToSave = false;
    Vector listeners;
    private int mode;
    private int transx;
    private int transy;
    private JDObject pressedObject = null;
    private JDObject motionObject = null;
    private boolean alignToGrid = false;
    private int GRID_SIZE = 16;
    private boolean gridVisible = false;
    private String creationParam = null;
    boolean resizeLabelOnFontChange = true;
    boolean resizeLabelOnTextChange = true;
    boolean autoZoomAsked = true;
    private JDSlider sliderRef;
    private JDPolyline connectPolyline;
    private JLabel statusLabel = null;
    private String currentStatus = "";
    private DropTarget dropTarget;
    private String[] rootPaths = null;
    private JSeparator sep1;
    private JSeparator sep2;
    private JSeparator sep3;
    private JSeparator sep4;
    private JSeparator sep5;
    private JSeparator sep6;
    private JMenuItem infoMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;
    private JMenuItem createATKPExtension;
    private JMenuItem groupMenuItem;
    private JMenuItem ungroupMenuItem;
    private JMenuItem editGroupMenuItem;
    private JMenuItem editShapeMenuItem;
    private JMenuItem connectShapeMenuItem;
    private JMenuItem raiseMenuItem;
    private JMenuItem lowerMenuItem;
    private JMenuItem frontMenuItem;
    private JMenuItem backMenuItem;
    private JMenuItem infoPolyMenuItem;
    private JMenuItem delSummitMenuItem;
    private JMenuItem brkShapeMenuItem;
    private JMenuItem set0ShapeMenuItem;
    private JMenuItem reorderShapeMenuItem;
    private JMenuItem cancelShapeMenuItem;
    private static Cursor hCursor = Cursor.getPredefinedCursor(10);
    private static Cursor vCursor = Cursor.getPredefinedCursor(8);
    private static Cursor nwCursor = Cursor.getPredefinedCursor(6);
    private static Cursor neCursor = Cursor.getPredefinedCursor(7);
    private static Cursor seCursor = Cursor.getPredefinedCursor(5);
    private static Cursor swCursor = Cursor.getPredefinedCursor(4);
    private static Cursor bCursor = Cursor.getPredefinedCursor(13);
    private static Cursor dCursor = Cursor.getPredefinedCursor(0);
    static final Color defaultBackground = new Color(230, 230, 230);

    public JDrawEditor(int mode) {
        this.setLayout(null);
        this.mode = mode;
        this.initComponents();
    }

    private void initComponents() {
        this.objects = new Vector();
        this.selObjects = new Vector();
        this.sizeX = 800;
        this.sizeY = 600;
        this.setBackground(defaultBackground);
        this.setOpaque(true);
        this.isDraggingSummit = false;
        this.isDraggingSummits = false;
        this.isDraggingObject = false;
        this.isDraggingSelection = false;
        this.hasMoved = false;
        this.selY2 = 0;
        this.selY1 = 0;
        this.selX2 = 0;
        this.selX1 = 0;
        this.creationMode = 0;
        this.transy = 0;
        this.transx = 0;
        this.listeners = new Vector();
        this.needToSave = false;
        this.editedPolyline = null;
        this.selSummits = new int[0];
        switch (this.mode) {
            case 1: {
                this.clipboard = JDClipboard.getInstance();
                this.tmpPoints = new Vector();
                this.undo = new Vector();
                this.clearUndo();
                this.createContextualMenu();
                break;
            }
            case 2: {
                this.tmpPoints = new Vector();
                this.clipboard = JDClipboard.getInstance();
                this.createContextualMenu();
                break;
            }
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.mode == 1) {
            this.dropTarget = new DropTarget(this, this);
        }
    }

    public void setGridVisible(boolean b) {
        this.gridVisible = b;
        this.repaint();
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridSize(int size) {
        if (size > 1) {
            this.GRID_SIZE = size;
            this.repaint();
        }
    }

    public int getGridSize() {
        return this.GRID_SIZE;
    }

    public void setAlignToGrid(boolean b) {
        this.alignToGrid = b;
    }

    public boolean isAlignToGrid() {
        return this.alignToGrid;
    }

    public int getMode() {
        return this.mode;
    }

    public void selectObject(JDObject obj) {
        if (obj != null && this.mode != 3) {
            if (!this.isSelected(obj)) {
                this.selObjects.add(obj);
            }
            this.repaint(obj.getRepaintRect());
        }
    }

    public void unselectObject(JDObject obj) {
        if (obj != null && this.mode != 3) {
            this.selObjects.remove(obj);
            this.repaint(obj.getRepaintRect());
        }
    }

    public boolean isSelected(JDObject obj) {
        if (this.mode == 3) {
            return false;
        }
        return this.selObjects.contains(obj);
    }

    public void selectObjects(JDObject[] objs) {
        if (objs.length > 0 && this.mode != 3 && this.selObjects.size() == 0) {
            for (int i = 0; i < objs.length; ++i) {
                this.selObjects.add(objs[i]);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
        }
    }

    public int getObjectNumber() {
        return this.objects.size();
    }

    public JDObject getObjectAt(int idx) {
        return (JDObject)this.objects.get(idx);
    }

    public Vector getObjects() {
        return this.objects;
    }

    public Vector getSelectedObjects() {
        return this.selObjects;
    }

    public void unselectAll() {
        this.unselectAll(true);
    }

    private void unselectAll(boolean fireSelChanged) {
        if (this.mode == 3) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        this.selObjects.clear();
        this.editedPolyline = null;
        if (fireSelChanged) {
            this.fireSelectionChange();
        }
    }

    public void selectAll() {
        this.selectAll(true);
    }

    public void selectNotVisible() {
        if (this.mode == 3) {
            return;
        }
        this.selObjects.clear();
        int nbObj = this.objects.size();
        for (int i = 0; i < nbObj; ++i) {
            JDObject obj = (JDObject)this.objects.get(i);
            if (obj.isVisible()) continue;
            this.selObjects.add(obj);
        }
        this.editedPolyline = null;
        this.repaint();
        this.fireSelectionChange();
    }

    private void selectAll(boolean fireSelChanged) {
        if (this.mode == 3) {
            return;
        }
        this.selObjects.clear();
        this.selObjects.addAll(this.objects);
        this.editedPolyline = null;
        this.repaint(this.buildRepaintRect(this.objects));
        if (fireSelChanged) {
            this.fireSelectionChange();
        }
    }

    public void create(int what) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        this.initCreate(what);
    }

    public void create(int what, String param) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        this.initCreate(what);
        this.creationParam = param;
    }

    void pickCursor(JDSlider parent) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (parent == null) {
            return;
        }
        this.initCreate(14);
        this.sliderRef = parent;
    }

    void pickPolyline() {
        JDObject s;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() > 0 && (s = (JDObject)this.selObjects.get(0)) instanceof JDPolyline) {
            this.initCreate(15);
            this.connectPolyline = (JDPolyline)s;
        }
    }

    public int getSelectionLength() {
        if (this.mode == 3) {
            return 0;
        }
        return this.selObjects.size();
    }

    public void showPropertyWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        JDUtils.showPropertyDialog(this, this.selObjects);
    }

    public void showTransformWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        boolean m = JDUtils.showTransformDialog(this, this.selObjects);
        if (m) {
            this.setNeedToSave(true, "transform");
        }
    }

    public void showBrowserWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        boolean m = JDUtils.showBrowserDialog(this, this.selObjects);
        if (m) {
            this.setNeedToSave(true, "Property change");
        }
    }

    public void showGroupEditorWindow() {
        JDObject p;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 1 && (p = (JDObject)this.selObjects.get(0)) instanceof JDGroup) {
            boolean m;
            if (this.mode == 1) {
                JDUtils.modified = false;
            }
            if (m = JDUtils.showGroupEditorDialog(this, (JDGroup)p)) {
                this.setNeedToSave(true, "Group edit");
            }
        }
    }

    public void generateJavaClasses(String dirName) throws IOException {
        String msgInfo = "Destination directory: " + dirName + "\n\n";
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject p = (JDObject)this.selObjects.get(i);
            String fileName = dirName + "\\" + p.getName() + ".java";
            FileWriter f = new FileWriter(fileName);
            f.write("/* Class generated by JDraw */\n\n");
            f.write("import java.awt.*;\n\n");
            if (p instanceof JDGroup) {
                ((JDGroup)p).generateJavaClass(f);
                msgInfo = msgInfo + "   " + p.getName() + ".java : OK\n";
            } else {
                msgInfo = msgInfo + "   " + p.getName() + ".java : generation failed (Invalid object type)\n";
            }
            f.close();
        }
        JOptionPane.showMessageDialog(this, msgInfo, "Message", 1);
    }

    public void showGroupJavaWindow() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() >= 1) {
            JFileChooser jf = new JFileChooser(".");
            jf.setFileSelectionMode(1);
            jf.setDialogTitle("Choose directory for java classes generation");
            if (jf.showSaveDialog(this) == 0) {
                try {
                    this.generateJavaClasses(jf.getSelectedFile().getAbsolutePath());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error during java code generation.\n" + e.getMessage());
                }
            }
        }
    }

    void addObjectToClipboard(Vector objs) {
        this.clipboard.send(objs);
    }

    public void copySelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.addObjectToClipboard(this.selObjects);
    }

    public void pasteClipboard(int x, int y, boolean fromOrigin) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.clipboard.size() == 0) {
            return;
        }
        this.unselectAll(false);
        int tx = x;
        int ty = y;
        if (fromOrigin) {
            Point org = JDUtils.getTopLeftCorner(this.clipboard.getObjects());
            tx -= org.x;
            ty -= org.y;
        }
        if (this.alignToGrid) {
            tx = (tx + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            ty = (ty + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
        }
        boolean hasSwing = false;
        for (int i = 0; i < this.clipboard.size(); ++i) {
            JDObject n = this.clipboard.get(i).copy(tx, ty);
            n.setParent(this);
            hasSwing = n instanceof JDSwingObject || hasSwing;
            this.objects.add(n);
            this.selObjects.add(n);
        }
        this.setNeedToSave(true, "Paste");
        if (!hasSwing) {
            this.repaint(this.buildRepaintRect(this.selObjects));
        } else {
            this.repaintLater();
        }
        this.fireSelectionChange();
    }

    public void scaleSelection(double rx, double ry) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        Point org = JDUtils.getCenter(this.selObjects);
        for (int i = 0; i < this.selObjects.size(); ++i) {
            ((JDObject)this.selObjects.get(i)).scale(org.x, org.y, rx, ry);
        }
        this.setNeedToSave(true, "Scale");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void cutSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.objects.removeAll(this.selObjects);
        this.clipboard.send(this.selObjects);
        this.repaint(this.buildRepaintRect(this.selObjects));
        this.selObjects.clear();
        this.editedPolyline = null;
        this.setNeedToSave(true, "Cut");
        this.fireSelectionChange();
    }

    public void deleteSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.objects.removeAll(this.selObjects);
        this.repaint(this.buildRepaintRect(this.selObjects));
        this.selObjects.clear();
        this.editedPolyline = null;
        this.setNeedToSave(true, "Delete");
        this.fireSelectionChange();
    }

    public void showSaveDialog(String defaultDir) {
        File f;
        int returnVal;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(defaultDir);
        if (this.lastFileName.length() > 0) {
            chooser.setSelectedFile(new File(this.lastFileName));
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0 && (f = chooser.getSelectedFile()) != null) {
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                try {
                    this.saveFile(f.getAbsolutePath());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Error during saving file.\n" + e.getMessage());
                }
            }
        }
    }

    public void saveFile(String fileName) throws IOException {
        String fName;
        if (((String)fileName).endsWith(".jlx")) {
            fName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46));
            if (JOptionPane.showConfirmDialog(this, "Cannot save to JLoox (.jlx) format , save to jdw format ?\n" + fName + ".jdw", "Save confirmation", 0) == 1) {
                return;
            }
            fileName = fName + ".jdw";
        }
        if (((String)fileName).endsWith(".g")) {
            fName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46));
            if (JOptionPane.showConfirmDialog(this, "Cannot save to Loox (.g) format , save to jdw format ?\n" + fName + ".jdw", "Save confirmation", 0) == 1) {
                return;
            }
            fileName = fName + ".jdw";
        }
        StringBuffer to_save = this.getSaveString();
        FileWriter fw = new FileWriter((String)fileName);
        try {
            fw.write(to_save.toString(), 0, to_save.length());
            fw.close();
        }
        catch (IOException e) {
            fw.close();
            throw e;
        }
        this.lastFileName = fileName;
        this.setNeedToSave(false, "Save");
    }

    public StringBuffer getSaveString() {
        StringBuffer to_save = new StringBuffer();
        to_save.append("JDFile v11 {\n");
        to_save.append("  Global {\n");
        if (this.getBackground().getRGB() != defaultBackground.getRGB()) {
            to_save.append("    background:");
            to_save.append(this.getBackground().getRed()).append(",");
            to_save.append(this.getBackground().getGreen()).append(",");
            to_save.append(this.getBackground().getBlue());
            to_save.append("\n");
        }
        if (!this.autoZoomAsked) {
            to_save.append("    autoZoom:false\n");
        }
        to_save.append("  }\n");
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).recordObject(to_save, 1);
        }
        to_save.append("}\n");
        return to_save;
    }

    public void instantSave(String defaultDir) {
        if (this.lastFileName.length() > 0) {
            try {
                this.saveFile(this.lastFileName);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error during saving file.\n" + e.getMessage());
            }
        } else if (defaultDir != null) {
            this.showSaveDialog(defaultDir);
        }
    }

    protected void loadFromStream(InputStreamReader inp) throws IOException {
        Vector objs;
        Object jdFile = null;
        if (this.mode != 3) {
            return;
        }
        JDFileLoader fl = new JDFileLoader(inp);
        try {
            objs = fl.parseFile();
            inp.close();
        }
        catch (IOException e) {
            inp.close();
            throw e;
        }
        this.applyGlobalOption(fl);
        this.clearObjects();
        this.editedPolyline = null;
        this.objects = objs;
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).setParent(this);
        }
        this.initPlayer();
        this.computePreferredSize();
        this.repaintLater();
    }

    public void setRootPaths(String[] paths) {
        this.rootPaths = paths;
    }

    public String[] getRootPaths() {
        return this.rootPaths;
    }

    public void loadFile(String fileName) throws IOException {
        this.loadFile(fileName, true);
    }

    public void loadFile(String fileName, boolean clearUndoBuffer) throws IOException {
        Vector objs;
        Object fl;
        FileReader fr = new FileReader(fileName);
        if (fileName.endsWith(".jlx")) {
            fl = new JLXFileLoader(fr);
            try {
                objs = ((JLXFileLoader)fl).parseFile();
                fr.close();
            }
            catch (IOException e) {
                fr.close();
                throw e;
            }
        }
        if (fileName.endsWith(".g")) {
            fl = new LXFileLoader(fr);
            try {
                objs = ((LXFileLoader)fl).parseFile();
                fr.close();
            }
            catch (IOException e) {
                fr.close();
                throw e;
            }
        }
        fl = new JDFileLoader(fr);
        try {
            objs = ((JDFileLoader)fl).parseFile();
            fr.close();
        }
        catch (IOException e) {
            fr.close();
            throw e;
        }
        this.applyGlobalOption((JDFileLoader)fl);
        this.clearObjects();
        this.editedPolyline = null;
        this.objects = objs;
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).setParent(this);
        }
        this.lastFileName = fileName;
        if (this.mode != 3) {
            if (clearUndoBuffer) {
                this.clearUndo();
            }
            this.setNeedToSave(false, "Load");
            this.fireSelectionChange();
        } else {
            this.initPlayer();
        }
        this.computePreferredSize();
        this.repaintLater();
    }

    public void showOpenDialog(String defaultDir) {
        int ok = 1;
        if (this.needToSave) {
            ok = JOptionPane.showConfirmDialog(this, "Your changes will be lost , save before opening a new file ?", "Open confirmation", 1);
        }
        if (ok == 0) {
            this.instantSave(".");
        }
        if (ok == 0 || ok == 1) {
            JFileChooser chooser = new JFileChooser(defaultDir);
            if (this.lastFileName.length() > 0) {
                chooser.setSelectedFile(new File(this.lastFileName));
            }
            JDFileFilter jlxFilter = new JDFileFilter("JLoox vectorial draw", new String[]{"jlx"});
            chooser.addChoosableFileFilter(jlxFilter);
            JDFileFilter lxFilter = new JDFileFilter("Loox vectorial draw", new String[]{"g"});
            chooser.addChoosableFileFilter(lxFilter);
            JDFileFilter jdwFilter = new JDFileFilter("JDraw graphics program", new String[]{"jdw"});
            chooser.addChoosableFileFilter(jdwFilter);
            int returnVal = chooser.showOpenDialog(this);
            File f = chooser.getSelectedFile();
            if (returnVal == 0) {
                try {
                    this.loadFile(f.getAbsolutePath());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Error during reading file: " + f.getName() + "\n" + ex.getMessage());
                }
            }
        }
    }

    public void frontSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Vector<JDObject> nObjects = new Vector<JDObject>();
        for (int i = 0; i < this.objects.size(); ++i) {
            JDObject p = (JDObject)this.objects.get(i);
            if (!this.isSelected(p)) continue;
            nObjects.add(p);
        }
        this.objects.removeAll(nObjects);
        this.objects.addAll(nObjects);
        this.setNeedToSave(true, "Bring to front");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void backSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Vector<JDObject> nObjects = new Vector<JDObject>();
        for (int i = 0; i < this.objects.size(); ++i) {
            JDObject p = (JDObject)this.objects.get(i);
            if (!this.isSelected(p)) continue;
            nObjects.add(p);
        }
        this.objects.removeAll(nObjects);
        this.objects.addAll(0, nObjects);
        this.setNeedToSave(true, "Send to back");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void groupSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Vector<JDObject> nObjects = new Vector<JDObject>();
        for (int i = 0; i < this.objects.size(); ++i) {
            JDObject p = (JDObject)this.objects.get(i);
            if (!this.isSelected(p)) continue;
            nObjects.add(p);
        }
        if (nObjects.size() > 0) {
            this.selObjects.clear();
            this.objects.removeAll(nObjects);
            JDGroup g = new JDGroup("JDGroup", nObjects);
            this.selObjects.add(g);
            this.objects.add(g);
            this.editedPolyline = null;
            this.fireSelectionChange();
            this.setNeedToSave(true, "Group");
            this.repaint(g.getRepaintRect());
        }
    }

    public void ungroupSelection() {
        JDObject p;
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 1 && (p = (JDObject)this.selObjects.get(0)) instanceof JDGroup) {
            JDGroup g = (JDGroup)p;
            this.repaint(g.getRepaintRect());
            int id = this.objects.indexOf(g);
            this.objects.remove(g);
            this.selObjects.clear();
            this.selObjects.addAll(g.getChildren());
            this.objects.addAll(id, g.getChildren());
            this.editedPolyline = null;
            this.fireSelectionChange();
            this.setNeedToSave(true, "Ungroup");
        }
    }

    public void zoomIn() {
        ++this.zoomFactor;
        this.invalidate();
        this.fireSizeChanged();
        this.focusZoomSelection();
    }

    public void zoomOut() {
        --this.zoomFactor;
        this.invalidate();
        this.fireSizeChanged();
        this.focusZoomSelection();
    }

    private void focusZoomSelection() {
        Container p;
        if (this.selObjects.size() > 0 && (p = this.getParent()) instanceof JViewport) {
            JViewport vp = (JViewport)p;
            Rectangle r = this.buildRepaintRect(this.selObjects);
            Rectangle zr = new Rectangle(this.zbconvert(r.x, this.transx), this.zbconvert(r.y, this.transy), this.zbconvert(r.width, 0), this.zbconvert(r.height, 0));
            vp.validate();
            Dimension vr = vp.getSize();
            Rectangle nr = new Rectangle(zr.x - (vr.width - zr.width) / 2, zr.y - (vr.height - zr.height) / 2, vr.width, vr.height);
            vp.setViewPosition(new Point(0, 0));
            vp.scrollRectToVisible(nr);
        }
    }

    public int getZoomFactorPercent() {
        return this.zbconvert(100, 0);
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int z) {
        this.zoomFactor = z;
        this.invalidate();
        this.fireSizeChanged();
    }

    public void setAutoZoom(boolean b) {
        this.autoZoom = b;
        if (this.autoZoom) {
            this.addComponentListener(this);
        } else {
            this.removeComponentListener(this);
        }
    }

    public void setAutoZoomFactor(double ratio) {
        this.autoZoomFactor = ratio;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public boolean isAutoZoomAsked() {
        return this.autoZoomAsked;
    }

    public void translateSelection(int x, int y) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() > 0 && (x != 0 || y != 0)) {
            Rectangle oldRect = this.buildRepaintRect(this.selObjects);
            this.repaint(oldRect);
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).translate(x, y);
            }
            oldRect.translate(x, y);
            this.repaint(oldRect);
            if (this.isDraggingObject) {
                this.hasMoved = true;
            }
        }
    }

    public boolean canUndo() {
        return this.mode == 1 && this.undoPos >= 2;
    }

    public boolean canRedo() {
        return this.mode == 1 && this.undoPos < this.undo.size();
    }

    public String getLastActionName() {
        if (this.canUndo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos - 1)).getName();
        }
        return "";
    }

    public String getNextActionName() {
        if (this.canRedo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos)).getName();
        }
        return "";
    }

    public void undo() {
        if (this.canUndo()) {
            --this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void redo() {
        if (this.canRedo()) {
            ++this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void clearUndo() {
        if (this.mode == 1) {
            this.undo.clear();
            this.undo.add(new UndoBuffer(this.objects, "Init"));
            this.undoPos = 1;
        }
    }

    public void aligntopSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject first = (JDObject)this.selObjects.get(0);
        int orgy = first.getBoundRect().y;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject n = (JDObject)this.selObjects.get(i);
            double y = n.boundRect.y;
            n.translate(0.0, (double)orgy - y);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void alignleftSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject first = (JDObject)this.selObjects.get(0);
        int orgx = first.getBoundRect().x;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject n = (JDObject)this.selObjects.get(i);
            double x = n.boundRect.x;
            n.translate((double)orgx - x, 0.0);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void alignbottomSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject first = (JDObject)this.selObjects.get(0);
        int orgy = first.getBoundRect().y + first.getBoundRect().height;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject n = (JDObject)this.selObjects.get(i);
            double y = n.boundRect.y + n.boundRect.height;
            n.translate(0.0, (double)orgy - y);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void alignrightSelection() {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.selObjects.size() == 0) {
            return;
        }
        this.repaint(this.buildRepaintRect(this.selObjects));
        JDObject first = (JDObject)this.selObjects.get(0);
        int orgx = first.getBoundRect().x + first.getBoundRect().width;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject n = (JDObject)this.selObjects.get(i);
            double x = n.boundRect.x + n.boundRect.width;
            n.translate((double)orgx - x, 0.0);
        }
        this.setNeedToSave(true, "Align");
        this.repaint(this.buildRepaintRect(this.selObjects));
    }

    public void addEditorListener(JDrawEditorListener l) {
        this.listeners.add(l);
    }

    public void removeEditorListener(JDrawEditorListener l) {
        this.listeners.remove(l);
    }

    public void clearEditorListener() {
        this.listeners.clear();
    }

    public boolean getNeedToSaveState() {
        return this.needToSave;
    }

    public String getFileName() {
        return this.lastFileName;
    }

    public void addObject(JDObject o) {
        this.objects.add(o);
        o.setParent(this);
    }

    public void clearObjects() {
        this.objects.clear();
        if (this.mode == 3) {
            return;
        }
        this.selObjects.clear();
    }

    public void setTranslation(int x, int y) {
        this.transx = x;
        this.transy = y;
    }

    public void computePreferredSize() {
        Dimension d = new Dimension();
        Rectangle old = null;
        for (int i = 0; i < this.objects.size(); ++i) {
            old = old == null ? this.getObjectAt(i).getBoundRect() : old.union(this.getObjectAt(i).getBoundRect());
        }
        if (old == null) {
            d.width = 320;
            d.height = 200;
        } else {
            d.width = old.x + old.width + 1;
            d.height = old.y + old.height + 1;
        }
        this.setPreferredSize(d);
        this.fireSizeChanged();
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.sizeX = d.width;
        this.sizeY = d.height;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int bW = insets.right + insets.left;
        int bH = insets.bottom + insets.top;
        Dimension d = new Dimension(this.zbconvert(this.sizeX, 0) + bW, this.zbconvert(this.sizeY, 0) + bH);
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Container p = this.getParent();
        if (p instanceof JSplitPane) {
            return new Dimension(16, 16);
        }
        return this.getPreferredSize();
    }

    public void initPlayer() {
        if (this.mode != 3) {
            return;
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            this.getObjectAt(i).saveTransform();
            this.getObjectAt(i).initValue();
        }
        this.removeAll();
        Vector v = this.getObjectsOfClass(JDSwingObject.class);
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            this.add(((JDSwingObject)v.get(sz - i - 1)).getComponent());
        }
    }

    public Vector getObjectsOfClass(Class theClass) {
        Vector ret = new Vector();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).getObjectsByClassList(ret, theClass);
        }
        return ret;
    }

    public Vector getObjectsByName(String name, boolean recurseGroup) {
        Vector ret = new Vector();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).getObjectsByName(ret, name, recurseGroup);
        }
        return ret;
    }

    public void convertToPolyline() {
        for (int i = 0; i < this.selObjects.size(); ++i) {
            JDObject o = (JDObject)this.selObjects.get(i);
            if (o instanceof JDPolyConvert) {
                JDPolyline n = ((JDPolyConvert)((Object)o)).convertToPolyline();
                int pos = this.objects.indexOf(o);
                this.objects.remove(pos);
                this.selObjects.clear();
                this.objects.add(pos, n);
                this.selObjects.add(n);
                this.repaint(o.getRepaintRect());
                this.repaint(n.getRepaintRect());
            }
            this.setNeedToSave(true, "Convert to polyline");
        }
    }

    boolean canConvertToPolyline() {
        boolean ret = this.selObjects.size() > 0;
        for (int i = 0; i < this.selObjects.size(); ++i) {
            ret = ret && this.selObjects.get(i) instanceof JDPolyConvert;
        }
        return ret;
    }

    boolean canEditGroup() {
        return this.selObjects.size() == 1 && this.selObjects.get(0) instanceof JDGroup;
    }

    public void raiseObject() {
        JDObject n;
        int pos;
        if (this.selObjects.size() == 1 && (pos = this.objects.indexOf(n = (JDObject)this.selObjects.get(0))) < this.objects.size() - 1) {
            this.objects.remove(pos);
            this.objects.add(pos + 1, n);
            this.setNeedToSave(true, "Raise");
            this.repaint(n.getRepaintRect());
        }
    }

    public void lowerObject() {
        JDObject n;
        int pos;
        if (this.selObjects.size() == 1 && (pos = this.objects.indexOf(n = (JDObject)this.selObjects.get(0))) > 0) {
            this.objects.remove(pos);
            this.objects.add(pos - 1, n);
            this.setNeedToSave(true, "Lower");
            this.repaint(n.getRepaintRect());
        }
    }

    public Vector getInteractiveObjects() {
        Vector ret = new Vector();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).getUserValueList(ret);
        }
        return ret;
    }

    public void setStatusLabel(JLabel label) {
        this.statusLabel = label;
    }

    public boolean canPaste() {
        return this.clipboard.size() > 0;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        int t = this.alignToGrid ? this.GRID_SIZE : 1;
        switch (e.getKeyCode()) {
            case 38: {
                if (this.editedPolyline != null) {
                    Rectangle old = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, 0.0, -t);
                    this.repaint(old.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(0, -t);
                    this.setNeedToSave(true, "Translate");
                }
                e.consume();
                break;
            }
            case 40: {
                if (this.editedPolyline != null) {
                    Rectangle old = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, 0.0, t);
                    this.repaint(old.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(0, t);
                    this.setNeedToSave(true, "Translate");
                }
                e.consume();
                break;
            }
            case 37: {
                if (this.editedPolyline != null) {
                    Rectangle old = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, -t, 0.0);
                    this.repaint(old.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(-t, 0);
                    this.setNeedToSave(true, "Translate");
                }
                e.consume();
                break;
            }
            case 39: {
                if (this.editedPolyline != null) {
                    Rectangle old = this.editedPolyline.getRepaintRect();
                    this.editedPolyline.translateSummits(this.selSummits, t, 0.0);
                    this.repaint(old.union(this.editedPolyline.getRepaintRect()));
                    this.setNeedToSave(true, "Shape edit");
                } else {
                    this.translateSelection(t, 0);
                    this.setNeedToSave(true, "Translate");
                }
                e.consume();
                break;
            }
            case 127: {
                this.deleteSelection();
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mode == 3) {
            this.relayPlayerMouseMoveEvent(e);
            this.mouseDraggedPlayer(e);
        } else {
            this.mouseDraggedEditor(e);
        }
    }

    private void mouseDraggedPlayer(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if (this.selObjects.size() > 0) {
            this.repaint(this.buildRepaintRect(this.selObjects));
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).processValue(3, ex, ey);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
        }
    }

    private void mouseDraggedEditor(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if (this.isDraggingSelection) {
            Rectangle old = this.buildSelectionRect();
            this.selX2 = ex;
            this.selY2 = ey;
            this.repaint(old.union(this.buildSelectionRect()));
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.isDraggingSummits) {
            if (this.alignToGrid) {
                ex = (ex + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                ey = (ey + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            Rectangle old = this.editedPolyline.getRepaintRect();
            this.editedPolyline.translateSummits(this.selSummits, ex - this.lastX, ey - this.lastY);
            this.repaint(old.union(this.editedPolyline.getRepaintRect()));
            this.hasMoved = true;
            this.lastX = ex;
            this.lastY = ey;
        }
        if (this.isDraggingSummit) {
            if (this.alignToGrid) {
                ex = (ex + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                ey = (ey + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            JDObject p = (JDObject)this.selObjects.get(this.curObject);
            Rectangle old = p.getRepaintRect();
            switch (p.getSummitMotion(this.selSummit)) {
                case 3: {
                    p.moveSummit(this.selSummit, ex, ey);
                    break;
                }
                case 1: {
                    p.moveSummit(this.selSummit, ex, p.getSummit((int)this.selSummit).y);
                    break;
                }
                case 2: {
                    p.moveSummit(this.selSummit, p.getSummit((int)this.selSummit).x, ey);
                }
            }
            this.addStatus("[" + Integer.toString(this.selSummit) + " @" + Integer.toString(ex) + "," + Integer.toString(ey) + "  (" + Integer.toString(p.getBoundRect().width - 1) + "," + Integer.toString(p.getBoundRect().height - 1) + ")]");
            this.hasMoved = true;
            this.repaint(old.union(p.getRepaintRect()));
        }
        if (this.isDraggingObject) {
            if (this.alignToGrid) {
                ex = (ex + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                ey = (ey + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            this.translateSelection(ex - this.lastX, ey - this.lastY);
            this.lastX = ex;
            this.lastY = ey;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mode == 4) {
            return;
        }
        if (this.mode == 3) {
            this.relayPlayerMouseMoveEvent(e);
            return;
        }
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if ((this.creationMode == 4 || this.creationMode == 6) && this.tmpPoints.size() > 0) {
            if (this.alignToGrid) {
                ex = (ex + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                ey = (ey + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            }
            int s = this.tmpPoints.size();
            Rectangle old = this.buildRectFromLine((Point)this.tmpPoints.get(s - 2), (Point)this.tmpPoints.get(s - 1));
            ((Point)this.tmpPoints.get((int)(s - 1))).x = ex;
            ((Point)this.tmpPoints.get((int)(s - 1))).y = ey;
            this.repaint(old.union(this.buildRectFromLine((Point)this.tmpPoints.get(s - 2), (Point)this.tmpPoints.get(s - 1))));
            return;
        }
        if (!(this.isDraggingSummit || this.isDraggingObject || this.isDraggingSelection || this.isDraggingSummits)) {
            this.findSummit(ex, ey);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mode == 3 && this.motionObject != null) {
            this.motionObject.fireMouseEvent(505, e);
            this.motionObject = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            boolean found = false;
            int i = this.selObjects.size() - 1;
            while (!found && i >= 0) {
                found = ((JDObject)this.selObjects.get(i)).isInsideObject(ex, ey);
                if (found) continue;
                --i;
            }
            if (found) {
                this.showPropertyWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mode == 3) {
            this.relayPlayerMouseReleasedEvent(e);
            this.mouseReleasedPlayer(e);
        } else {
            this.mouseReleasedEditor(e);
        }
    }

    private void mouseReleasedPlayer(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if (this.selObjects.size() > 0) {
            this.repaint(this.buildRepaintRect(this.selObjects));
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).processValue(2, ex, ey);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
            this.selObjects.clear();
        }
    }

    private void mouseReleasedEditor(MouseEvent e) {
        if ((this.isDraggingSummits || this.isDraggingSummit || this.isDraggingObject) && this.hasMoved) {
            if (this.isDraggingSummit) {
                if (this.lastCreatedObject == null) {
                    this.setNeedToSave(true, "Shape edit");
                    this.setStatus("");
                } else {
                    this.setNeedToSave(true, "Object creation");
                    this.fireCreationDone();
                    this.lastCreatedObject.centerOrigin();
                    this.lastCreatedObject = null;
                }
            }
            if (this.isDraggingObject) {
                this.setNeedToSave(true, "Translate");
                this.repaint(this.buildRepaintRect(this.selObjects));
            }
            if (this.isDraggingSummits) {
                this.setNeedToSave(true, "Shape edit");
                this.repaint(this.buildRepaintRect(this.selObjects));
            }
        }
        this.isDraggingSummit = false;
        this.isDraggingSummits = false;
        this.isDraggingObject = false;
        this.hasMoved = false;
        if (this.isDraggingSelection) {
            this.isDraggingSelection = false;
            Rectangle sr = this.buildSelectionRect();
            Rectangle rep = null;
            this.selY2 = 0;
            this.selY1 = 0;
            this.selX2 = 0;
            this.selX1 = 0;
            if (this.editedPolyline != null) {
                int[] nSummit = this.editedPolyline.getSummitsInsideRectangle(sr);
                for (int i = 0; i < nSummit.length; ++i) {
                    this.selectSummit(nSummit[i]);
                }
            } else {
                for (int i = 0; i < this.objects.size(); ++i) {
                    JDObject p = (JDObject)this.objects.get(i);
                    if (!p.isVisible() || !sr.contains(p.getBoundRect())) continue;
                    if (!this.isSelected(p)) {
                        this.selObjects.add(p);
                    } else if (e.isControlDown()) {
                        this.selObjects.remove(p);
                    }
                    rep = rep == null ? p.getRepaintRect() : rep.union(p.getRepaintRect());
                }
                this.fireSelectionChange();
            }
            if (rep != null) {
                this.repaint(sr.union(rep));
            } else {
                this.repaint(sr);
            }
        }
        this.setCursor(dCursor);
    }

    public void mousePressedEditorB1(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if (this.editedPolyline != null) {
            this.findSummit(ex, ey);
            if (this.selSummit == -1) {
                if (!e.isControlDown()) {
                    this.selSummits = new int[0];
                    this.repaint(this.editedPolyline.getRepaintRect());
                }
                this.selX1 = ex;
                this.selY1 = ey;
                this.selX2 = ex;
                this.selY2 = ey;
                this.isDraggingSelection = true;
            } else {
                if (this.alignToGrid) {
                    ex = (ex + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                    ey = (ey + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                }
                this.lastX = ex;
                this.lastY = ey;
                if (this.isSelectedSummit(this.selSummit)) {
                    this.isDraggingSummits = true;
                } else {
                    if (e.isControlDown()) {
                        this.selectSummit(this.selSummit);
                    } else {
                        this.selSummits = new int[1];
                        this.selSummits[0] = this.selSummit;
                        this.isDraggingSummits = true;
                    }
                    this.repaint(this.editedPolyline.getRepaintRect());
                }
            }
            return;
        }
        if (this.createObject(ex, ey)) {
            return;
        }
        if (this.mode != 4 && this.findSummit(ex, ey)) {
            this.isDraggingSummit = true;
            return;
        }
        JDObject p = this.findObject(ex, ey);
        if (p != null) {
            if (!this.isSelected(p)) {
                if (!e.isControlDown()) {
                    this.unselectAll(false);
                }
                this.selObjects.add(p);
                this.repaint(p.getRepaintRect());
                this.fireSelectionChange();
            } else if (e.isControlDown()) {
                this.selObjects.remove(p);
                this.repaint(p.getRepaintRect());
                this.fireSelectionChange();
                return;
            }
            if (this.mode != 4) {
                this.curObject = this.selObjects.indexOf(p);
                this.isDraggingObject = true;
                if (this.alignToGrid) {
                    ex = (ex + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                    ey = (ey + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
                }
                this.lastX = ex;
                this.lastY = ey;
                this.setCursor(bCursor);
            }
        } else {
            if (!e.isControlDown()) {
                this.unselectAll();
            }
            this.selX1 = ex;
            this.selY1 = ey;
            this.selX2 = ex;
            this.selY2 = ey;
            this.isDraggingSelection = true;
        }
    }

    public void mousePressedEditorB3(MouseEvent e) {
        if (this.creationMode == 0) {
            this.showMenu(e);
        }
        if (this.creationMode == 4) {
            if (this.tmpPoints.size() != 0) {
                int s = this.tmpPoints.size();
                Point[] pts = new Point[s];
                for (int i = 0; i < s; ++i) {
                    pts[i] = (Point)this.tmpPoints.get(i);
                }
                JDPolyline p = new JDPolyline("Polyline", pts);
                this.selObjects.add(p);
                this.objects.add(p);
                this.repaint(p.getRepaintRect());
                this.fireCreationDone();
                this.fireSelectionChange();
                this.setNeedToSave(true, "Object creation");
            } else {
                this.fireCreationDone();
            }
            this.tmpPoints.clear();
            this.creationMode = 0;
            return;
        }
        if (this.creationMode == 6) {
            int s = this.tmpPoints.size();
            if ((s = (s - 1) / 3 * 3 + 1) >= 4) {
                Point[] pts = new Point[s];
                for (int i = 0; i < s; ++i) {
                    pts[i] = (Point)this.tmpPoints.get(i);
                }
                JDSpline p = new JDSpline("Spline", pts);
                this.selObjects.add(p);
                this.objects.add(p);
                this.repaint(p.getRepaintRect());
                this.fireCreationDone();
                this.fireSelectionChange();
                this.setNeedToSave(true, "Object creation");
            } else {
                this.fireCreationDone();
                this.repaint();
            }
            this.tmpPoints.clear();
            this.creationMode = 0;
            return;
        }
        if (this.creationMode != 0) {
            this.tmpPoints.clear();
            this.creationMode = 0;
            this.fireCreationDone();
            this.repaint();
            return;
        }
        this.showMenu(e);
    }

    public void mousePressedPlayerB1(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        this.selObjects.clear();
        this.selectObjects(ex, ey, this.selObjects);
        if (this.selObjects.size() > 0) {
            this.repaint(this.buildRepaintRect(this.selObjects));
            for (int i = 0; i < this.selObjects.size(); ++i) {
                ((JDObject)this.selObjects.get(i)).processValue(1, ex, ey);
            }
            this.repaint(this.buildRepaintRect(this.selObjects));
        }
    }

    public void mousePressedPlayerB3(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.grabFocus();
        if (this.mode == 3) {
            this.relayPlayerMousePressedEvent(e);
            if (e.getButton() == 1) {
                this.mousePressedPlayerB1(e);
            }
            if (e.getButton() == 3) {
                this.mousePressedPlayerB3(e);
            }
        } else {
            if (e.getButton() == 1) {
                this.mousePressedEditorB1(e);
            }
            if (e.getButton() == 3) {
                this.mousePressedEditorB3(e);
            }
        }
    }

    private void relayPlayerMouseReleasedEvent(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        if (this.pressedObject != null) {
            if (this.pressedObject.isInsideObject(ex, ey)) {
                this.pressedObject.fireMouseEvent(502, e);
                this.pressedObject.fireMouseEvent(500, e);
            }
            this.pressedObject = null;
        }
    }

    private void relayPlayerMousePressedEvent(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        this.pressedObject = this.findMouseListenerObject(ex, ey);
        if (this.pressedObject != null) {
            this.pressedObject.fireMouseEvent(501, e);
        }
    }

    private void relayPlayerMouseMoveEvent(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        JDObject p = this.findMouseListenerObject(ex, ey);
        if (this.motionObject == null) {
            if (p != null) {
                this.motionObject = p;
                this.motionObject.fireMouseEvent(504, e);
            }
        } else if (p == null) {
            this.motionObject.fireMouseEvent(505, e);
            this.motionObject = null;
        } else if (p != this.motionObject) {
            this.motionObject.fireMouseEvent(505, e);
            this.motionObject = p;
            this.motionObject.fireMouseEvent(504, e);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.autoZoom && this.mode == 3) {
            Dimension d = this.getSize();
            double ratioX = (double)d.width / (double)this.sizeX;
            double ratioY = (double)d.height / (double)this.sizeY;
            this.autoZoomFactor = ratioX > ratioY ? ratioY : ratioX;
            if (this.autoZoomFactor < 0.1) {
                this.autoZoomFactor = 0.1;
            }
            Vector v = this.getObjectsOfClass(JDSwingObject.class);
            int sz = v.size();
            for (int i = 0; i < sz; ++i) {
                JDSwingObject jdw = (JDSwingObject)v.get(i);
                Rectangle r = new Rectangle(jdw.getBoundRect());
                r.x = (int)Math.rint((double)r.x * this.autoZoomFactor);
                r.y = (int)Math.rint((double)r.y * this.autoZoomFactor);
                r.width = (int)Math.rint((double)r.width * this.autoZoomFactor);
                r.height = (int)Math.rint((double)r.height * this.autoZoomFactor);
                jdw.getComponent().setBounds(r);
                jdw.getComponent().validate();
            }
            this.repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Transferable trans = dtde.getTransferable();
        if (trans.isDataFlavorSupported(JDEntityNode.JDENTITY_NODE_FLAVOR)) {
            dtde.acceptDrop(3);
            try {
                JDEntityNode jde = (JDEntityNode)trans.getTransferData(JDEntityNode.JDENTITY_NODE_FLAVOR);
                Point location = dtde.getLocation();
                int ex = this.zconvert(location.x, this.transx);
                int ey = this.zconvert(location.y, this.transy);
                boolean found = false;
                int i = this.objects.size() - 1;
                while (!found && i >= 0) {
                    found = ((JDObject)this.objects.get(i)).isInsideObject(ex, ey);
                    if (found) continue;
                    --i;
                }
                if (found) {
                    JDObject p = (JDObject)this.objects.get(i);
                    p.setName(jde.getName());
                    this.setNeedToSave(true, "Change name");
                    this.unselectAll(false);
                    this.selObjects.add(p);
                    this.repaint(p.getRepaintRect());
                    this.fireSelectionChange();
                } else {
                    JOptionPane.showMessageDialog(this, "No object found here");
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, "Drag operation not allowed");
            }
            catch (UnsupportedFlavorException e2) {
                JOptionPane.showMessageDialog(this, "Drag operation not allowed");
            }
            dtde.dropComplete(true);
        } else {
            JOptionPane.showMessageDialog(this, "Drag operation not allowed");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        Object src = e.getSource();
        Rectangle rep = null;
        if (src == this.delSummitMenuItem) {
            rep = this.editedPolyline.getRepaintRect();
            this.editedPolyline.deleteSummit();
            this.selSummits = new int[0];
            this.setNeedToSave(true, "Delete polyline point");
            this.repaint(rep.union(this.editedPolyline.getRepaintRect()));
        } else if (src == this.brkShapeMenuItem) {
            rep = this.editedPolyline.getRepaintRect();
            this.setNeedToSave(true, "Add polyline point");
            this.editedPolyline.breakShape();
            this.selSummits = new int[0];
            this.repaint(rep.union(this.editedPolyline.getRepaintRect()));
        } else if (src == this.set0ShapeMenuItem) {
            rep = this.editedPolyline.getRepaintRect();
            this.setNeedToSave(true, "Set starting point");
            this.editedPolyline.setStartingPoint(this.selSummit);
            this.selSummits = new int[0];
            this.repaint(rep.union(this.editedPolyline.getRepaintRect()));
        } else if (src == this.reorderShapeMenuItem) {
            rep = this.editedPolyline.getRepaintRect();
            this.setNeedToSave(true, "Reorder polyline");
            this.editedPolyline.invertSummitOrder();
            this.selSummits = new int[0];
            this.repaint(rep.union(this.editedPolyline.getRepaintRect()));
        } else if (src == this.copyMenuItem) {
            this.copySelection();
        } else if (src == this.pasteMenuItem) {
            this.pasteClipboard(this.lastX, this.lastY, true);
        } else if (src == this.cutMenuItem) {
            this.cutSelection();
        } else if (src == this.deleteMenuItem) {
            this.deleteSelection();
        } else if (src == this.raiseMenuItem) {
            this.raiseObject();
        } else if (src == this.lowerMenuItem) {
            this.lowerObject();
        } else if (src == this.frontMenuItem) {
            this.frontSelection();
        } else if (src == this.backMenuItem) {
            this.backSelection();
        } else if (src == this.groupMenuItem) {
            this.groupSelection();
        } else if (src == this.ungroupMenuItem) {
            this.ungroupSelection();
        } else if (src == this.editGroupMenuItem) {
            this.showGroupEditorWindow();
        } else if (src == this.zoomInMenuItem) {
            this.zoomIn();
        } else if (src == this.zoomOutMenuItem) {
            this.zoomOut();
        } else if (src == this.createATKPExtension) {
            for (int i = 0; i < this.selObjects.size(); ++i) {
                JDObject o = (JDObject)this.selObjects.get(i);
                if (o.getExtendedParamIndex("className") != -1) continue;
                o.addExtension("className");
                o.setExtendedParam("className", "atkpanel.MainPanel");
            }
        } else if (src == this.editShapeMenuItem) {
            if (this.selObjects.size() > 0) {
                this.selSummits = new int[0];
                this.editedPolyline = (JDPolyline)this.selObjects.get(0);
                this.repaint(this.editedPolyline.getRepaintRect());
            }
        } else if (src == this.connectShapeMenuItem) {
            this.pickPolyline();
        } else if (src == this.cancelShapeMenuItem) {
            rep = this.editedPolyline.getRepaintRect();
            this.editedPolyline = null;
            this.repaint(rep);
        }
    }

    public void paintObjects(Graphics g) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).paint(this, g);
        }
    }

    public void paintSelection(Graphics g) {
        if (this.mode != 3) {
            int i;
            if (!this.isDraggingObject || !this.hasMoved) {
                for (i = 0; i < this.selObjects.size(); ++i) {
                    ((JDObject)this.selObjects.get(i)).paintSummit(g, this.zdconvert(6.0, 0.0));
                }
            }
            if (this.editedPolyline != null) {
                this.editedPolyline.paintSelectedSummit(g, this.selSummits, this.zdconvert(6.0, 0.0));
            }
            if (this.selX1 != this.selX2 && this.selY1 != this.selY2) {
                g.setColor(Color.darkGray);
                g.drawLine(this.selX1, this.selY1, this.selX2, this.selY1);
                g.drawLine(this.selX2, this.selY1, this.selX2, this.selY2);
                g.drawLine(this.selX2, this.selY2, this.selX1, this.selY2);
                g.drawLine(this.selX1, this.selY2, this.selX1, this.selY1);
            }
            if (this.mode != 4) {
                for (i = 1; i < this.tmpPoints.size(); ++i) {
                    g.setColor(Color.darkGray);
                    Point p1 = (Point)this.tmpPoints.get(i - 1);
                    Point p2 = (Point)this.tmpPoints.get(i);
                    g.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }
        }
    }

    private void paintGrid(Graphics gr) {
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 4) {
            return;
        }
        if (this.gridVisible) {
            Dimension d = this.getSize();
            double gs = this.zbdconvert(this.GRID_SIZE, 0.0);
            int r = this.getBackground().getRed() < 128 ? this.getBackground().getRed() + 64 : this.getBackground().getRed() - 64;
            int g = this.getBackground().getGreen() < 128 ? this.getBackground().getGreen() + 64 : this.getBackground().getGreen() - 64;
            int b = this.getBackground().getBlue() < 128 ? this.getBackground().getBlue() + 64 : this.getBackground().getBlue() - 64;
            Color gColor = new Color(r, g, b);
            gr.setColor(gColor);
            for (double i = 0.0; i <= (double)d.width; i += gs) {
                for (double j = 0.0; j <= (double)d.height; j += gs) {
                    int x = (int)(i + 0.5);
                    int y = (int)(j + 0.5);
                    gr.drawLine(x, y, x, y);
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        this.paintGrid(g);
        AffineTransform oldT = g2.getTransform();
        Object oldTextAA = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        Object oldTextFM = g2.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        AffineTransform nT = new AffineTransform(oldT);
        double r = this.getZoomScaleRatio();
        nT.scale(r, r);
        nT.translate(this.transx, this.transy);
        g2.setTransform(nT);
        this.paintObjects(g);
        this.paintSelection(g);
        g2.setTransform(oldT);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAA);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldTextFM);
        boolean oldOpaque = this.isOpaque();
        this.setOpaque(false);
        super.paint(g);
        this.setOpaque(oldOpaque);
    }

    @Override
    public void repaint(Rectangle r) {
        if (r != null) {
            int m = (int)(this.zdconvert(3.0, 0.0) + 0.5) + 1;
            Rectangle zr = new Rectangle(this.zbconvert(r.x, this.transx) - m, this.zbconvert(r.y, this.transy) - m, this.zbconvert(r.width, 0) + 2 * m, this.zbconvert(r.height, 0) + 2 * m);
            super.repaint(zr);
        }
    }

    public void resetNeedToSave() {
        this.setNeedToSave(false, "");
    }

    void setNeedToSave(boolean b, String s) {
        this.needToSave = b;
        if (this.needToSave && this.mode == 1) {
            for (int i = this.undo.size() - 1; i >= this.undoPos; --i) {
                this.undo.removeElementAt(i);
            }
            this.undo.add(new UndoBuffer(this.objects, s));
            if (this.undo.size() >= 20) {
                this.undo.removeElementAt(0);
            }
            this.undoPos = this.undo.size();
        }
        this.fireValueChanged();
    }

    private double getZoomScaleRatio() {
        if (this.autoZoom) {
            return this.autoZoomFactor;
        }
        double r = 1.0;
        if (this.zoomFactor != 0) {
            r = this.zoomFactor >= 0 ? (double)(this.zoomFactor + 1) : 1.0 / (double)(-this.zoomFactor + 1);
        }
        return r;
    }

    private int zconvert(int x, int t) {
        if (this.autoZoom) {
            return (int)((double)x / this.autoZoomFactor + 0.5) - t;
        }
        if (this.zoomFactor == 0) {
            return x - t;
        }
        if (this.zoomFactor > 0) {
            return (int)((double)x / (double)(this.zoomFactor + 1)) - t;
        }
        return x * (-this.zoomFactor + 1) - t;
    }

    private int zbconvert(int x, int t) {
        if (this.autoZoom) {
            return (int)((double)(x + t) * this.autoZoomFactor + 0.5);
        }
        if (this.zoomFactor == 0) {
            return x + t;
        }
        if (this.zoomFactor > 0) {
            return (x + t) * (this.zoomFactor + 1);
        }
        return (int)((double)(x + t) / (double)(-this.zoomFactor + 1));
    }

    private double zdconvert(double x, double tx) {
        if (this.autoZoom) {
            return (x - tx) / this.autoZoomFactor;
        }
        if (this.zoomFactor == 0) {
            return x - tx;
        }
        if (this.zoomFactor > 0) {
            return (x - tx) / (double)(this.zoomFactor + 1);
        }
        return (x - tx) * (double)(-this.zoomFactor + 1);
    }

    private double zbdconvert(double x, double tx) {
        if (this.autoZoom) {
            return (x + tx) * this.autoZoomFactor;
        }
        if (this.zoomFactor == 0) {
            return x + tx;
        }
        if (this.zoomFactor > 0) {
            return (x + tx) * (double)(this.zoomFactor + 1);
        }
        return (x + tx) / (double)(-this.zoomFactor + 1);
    }

    public void addToMenu(JMenuItem newItem) {
        if (this.objMenu == null) {
            this.objMenu = new JPopupMenu();
            this.infoMenuItem = new JMenuItem();
            this.infoMenuItem.setEnabled(false);
            this.objMenu.add(this.infoMenuItem);
            this.sep1 = new JSeparator();
            this.objMenu.add(this.sep1);
        }
        if (newItem != null) {
            this.objMenu.add(newItem);
        }
    }

    private void showMenu(MouseEvent e) {
        int ex = this.zconvert(e.getX(), this.transx);
        int ey = this.zconvert(e.getY(), this.transy);
        this.findSummit(ex, ey);
        if (this.editedPolyline != null && this.mode != 4) {
            this.infoPolyMenuItem.setText("Polyline edition");
            this.delSummitMenuItem.setEnabled(false);
            this.brkShapeMenuItem.setEnabled(false);
            this.set0ShapeMenuItem.setEnabled(this.selSummit != -1);
            if (this.selSummit != -1) {
                this.delSummitMenuItem.setEnabled(this.editedPolyline.canDeleteSummit(this.selSummit));
                Object s = this.infoPolyMenuItem.getText();
                s = (String)s + " [Summit: " + this.selSummit + " ]";
                this.infoPolyMenuItem.setText((String)s);
            } else {
                this.brkShapeMenuItem.setEnabled(this.editedPolyline.canBreakShape(ex, ey));
            }
            this.lastX = ex;
            this.lastY = ey;
            this.polyMenu.show(this, e.getX(), e.getY());
        } else {
            JDObject p = this.findObject(ex, ey);
            if (p != null && !this.isSelected(p)) {
                this.unselectAll(false);
                this.selObjects.add(p);
                this.repaint(p.getRepaintRect());
                this.fireSelectionChange();
            }
            int sz = this.selObjects.size();
            p = null;
            if (sz > 0) {
                p = (JDObject)this.selObjects.get(0);
            }
            if (this.mode == 4 && this.objMenu == null) {
                this.addToMenu(null);
            }
            this.infoMenuItem.setVisible(sz >= 1);
            if (sz == 1) {
                String sId = this.selSummit != -1 ? " Summit:" + Integer.toString(this.selSummit) : "";
                this.infoMenuItem.setText(p.getName() + " [" + p.toString() + "]" + sId);
            } else {
                this.infoMenuItem.setText("Multiple selection");
            }
            if (this.mode == 4) {
                Component[] menuComps = this.objMenu.getComponents();
                for (int k = 0; k < menuComps.length; ++k) {
                    if (k < menuComps.length - 1) {
                        menuComps[k].setEnabled(k > 1 && sz > 0);
                        menuComps[k].setVisible(sz > 0);
                        continue;
                    }
                    menuComps[k].setEnabled(k > 1);
                    menuComps[k].setVisible(true);
                }
            } else {
                this.cutMenuItem.setEnabled(sz > 0);
                this.copyMenuItem.setEnabled(sz > 0);
                this.pasteMenuItem.setEnabled(this.clipboard.size() > 0);
                this.deleteMenuItem.setEnabled(sz > 0);
                this.groupMenuItem.setVisible(sz > 0);
                if (sz == 1) {
                    this.ungroupMenuItem.setVisible(p instanceof JDGroup);
                    this.editGroupMenuItem.setVisible(p instanceof JDGroup);
                } else {
                    this.ungroupMenuItem.setVisible(false);
                    this.editGroupMenuItem.setVisible(false);
                }
                this.raiseMenuItem.setVisible(sz == 1);
                this.lowerMenuItem.setVisible(sz == 1);
                this.frontMenuItem.setVisible(sz >= 1);
                this.backMenuItem.setVisible(sz >= 1);
                if (p != null) {
                    int pos = this.objects.indexOf(p);
                    this.raiseMenuItem.setEnabled(pos < this.objects.size() - 1);
                    this.lowerMenuItem.setEnabled(pos > 0);
                }
                boolean isPoly = p instanceof JDPolyline && sz == 1;
                this.editShapeMenuItem.setVisible(isPoly);
                this.connectShapeMenuItem.setVisible(isPoly);
                this.sep1.setVisible(this.infoMenuItem.isVisible());
                this.sep2.setVisible(this.editShapeMenuItem.isVisible());
                this.sep3.setVisible(this.groupMenuItem.isVisible() || this.ungroupMenuItem.isVisible());
                this.sep5.setVisible(this.raiseMenuItem.isVisible() || this.frontMenuItem.isVisible());
            }
            this.lastX = ex;
            this.lastY = ey;
            this.objMenu.show(this, e.getX(), e.getY());
        }
    }

    private void initCreate(int mode) {
        this.creationMode = mode;
        this.creationParam = null;
        this.sliderRef = null;
        this.connectPolyline = null;
        if (this.editedPolyline != null) {
            Rectangle r = this.editedPolyline.getRepaintRect();
            this.editedPolyline = null;
            this.repaint(r);
        }
        this.updateCreationStatus();
    }

    void setStatus(String s) {
        this.currentStatus = s == null ? " " : (s.length() == 0 ? " " : s);
        if (this.statusLabel != null) {
            this.statusLabel.setText(this.currentStatus);
        }
    }

    private void addStatus(String s) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(this.currentStatus + s);
        }
    }

    private Cursor getCursorForMotion(JDObject p, int summit) {
        switch (p.getSummitMotion(summit)) {
            case 3: {
                if (p instanceof JDRectangular) {
                    double x = p.getSummit(summit).getX();
                    double y = p.getSummit(summit).getY();
                    double xc = (double)p.getBoundRect().x + (double)p.getBoundRect().width / 2.0;
                    double yc = (double)p.getBoundRect().y + (double)p.getBoundRect().height / 2.0;
                    if (x < xc) {
                        if (y < yc) {
                            return nwCursor;
                        }
                        return swCursor;
                    }
                    if (y < yc) {
                        return neCursor;
                    }
                    return seCursor;
                }
                return bCursor;
            }
            case 0: {
                return dCursor;
            }
            case 1: {
                return hCursor;
            }
            case 2: {
                return vCursor;
            }
        }
        return dCursor;
    }

    private Rectangle buildSelectionRect() {
        Point p1 = new Point(this.selX1, this.selY1);
        Point p2 = new Point(this.selX2, this.selY2);
        return this.buildRectFromLine(p1, p2);
    }

    private Rectangle buildRectFromLine(Point p1, Point p2) {
        Rectangle r = new Rectangle();
        int m = this.zconvert(1, 0);
        if (m < 1) {
            m = 1;
        }
        if (p1.x < p2.x) {
            if (p1.y < p2.y) {
                r.setRect(p1.x - m, p1.y - m, p2.x - p1.x + 2 * m, p2.y - p1.y + 2 * m);
            } else {
                r.setRect(p1.x - m, p2.y - m, p2.x - p1.x + 2 * m, p1.y - p2.y + 2 * m);
            }
        } else if (p1.y < p2.y) {
            r.setRect(p2.x - m, p1.y - m, p1.x - p2.x + 2 * m, p2.y - p1.y + 2 * m);
        } else {
            r.setRect(p2.x - m, p2.y - m, p1.x - p2.x + 2 * m, p1.y - p2.y + 2 * m);
        }
        return r;
    }

    private boolean findSummit(int x, int y) {
        boolean found = false;
        this.curObject = -1;
        this.selSummit = -1;
        if (this.selObjects.size() != 0) {
            int i = 0;
            found = false;
            JDObject p = null;
            while (i < this.selObjects.size() && !found) {
                p = (JDObject)this.selObjects.get(i);
                this.selSummit = p.getSummit(x, y, this.zdconvert(6.0, 0.0));
                found = this.selSummit != -1;
                if (found) continue;
                ++i;
            }
            if (found) {
                this.curObject = i;
                this.setCursor(this.getCursorForMotion(p, this.selSummit));
            } else {
                this.setCursor(dCursor);
            }
        }
        return found;
    }

    private JDObject findObject(int x, int y) {
        boolean found = false;
        int i = this.objects.size() - 1;
        while (!found && i >= 0) {
            found = ((JDObject)this.objects.get(i)).isInsideObject(x, y);
            if (found) continue;
            --i;
        }
        if (found) {
            return (JDObject)this.objects.get(i);
        }
        return null;
    }

    private JDObject findMouseListenerObject(int x, int y) {
        boolean found = false;
        int i = this.objects.size() - 1;
        while (!found && i >= 0) {
            JDObject o = (JDObject)this.objects.get(i);
            if (o.hasMouseListener()) {
                found = ((JDObject)this.objects.get(i)).isInsideObject(x, y);
            }
            if (found) continue;
            --i;
        }
        if (found) {
            return (JDObject)this.objects.get(i);
        }
        return null;
    }

    private void selectObjects(int x, int y, Vector found) {
        for (int i = 0; i < this.objects.size(); ++i) {
            this.getObjectAt(i).findObjectsAt(x, y, found);
        }
    }

    private void createObject(JDObject p, int summit) {
        this.unselectAll(false);
        this.lastCreatedObject = p;
        this.objects.add(p);
        this.creationMode = 0;
        this.selObjects.add(p);
        this.isDraggingSummit = summit >= 0;
        this.curObject = 0;
        this.selSummit = summit;
        this.editedPolyline = null;
        this.repaint(p.getRepaintRect());
        this.fireSelectionChange();
        if (!this.isDraggingSummit) {
            this.setNeedToSave(true, "Object creation");
            this.fireCreationDone();
            this.lastCreatedObject = null;
        }
    }

    private void updateCreationStatus() {
        switch (this.creationMode) {
            case 1: {
                this.setStatus("Left click and drag to create a rectangle");
                break;
            }
            case 8: {
                this.setStatus("Left click and drag to create a rounded rectangle");
                break;
            }
            case 2: {
                this.setStatus("Left click and drag to create a line");
                break;
            }
            case 3: {
                this.setStatus("Left click and drag to create an ellipse");
                break;
            }
            case 4: {
                this.setStatus("Left click to create a new point and right click to create the last point");
                break;
            }
            case 5: {
                this.setStatus("Left click to create the label");
                break;
            }
            case 17: {
                this.setStatus("Left click to create the label");
                break;
            }
            case 16: {
                this.setStatus("Left click to create the titled rectangle");
                break;
            }
            case 6: {
                this.setStatus("Left click to create a new point and right click to create the last point");
                break;
            }
            case 9: {
                this.setStatus("Left click to insert an image");
                break;
            }
            case 11: {
                this.setStatus("Left click to create an axis");
                break;
            }
            case 12: {
                this.setStatus("Left click and drag to create a bar");
                break;
            }
            case 13: {
                this.setStatus("Left click and drag to create a slider");
                break;
            }
            case 14: {
                this.setStatus("Left click on a object to pick up new slider cursor");
                break;
            }
            case 15: {
                this.setStatus("Left click on the polyline to be connected.");
                break;
            }
            case 10: {
                this.setStatus("Left click to create a JDSwingObject : " + JDUtils.buildShortClassName(this.creationParam));
                break;
            }
            case 7: {
                this.setStatus("Left click to paste");
            }
        }
    }

    private void rebuildBackup(int pos) {
        this.clearObjects();
        this.editedPolyline = null;
        this.objects = ((UndoBuffer)this.undo.get(pos)).rebuild();
        for (int i = 0; i < this.objects.size(); ++i) {
            ((JDObject)this.objects.get(i)).setParent(this);
        }
        this.repaint();
        this.fireValueChanged();
        this.fireSelectionChange();
    }

    void fireSelectionChange() {
        JDUtils.updatePropertyDialog(this.selObjects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).selectionChanged();
        }
    }

    private void fireCreationDone() {
        this.setStatus("");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).creationDone();
        }
    }

    void fireClipboardChange() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).clipboardChanged();
        }
    }

    void fireValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).valueChanged();
        }
    }

    private void fireSizeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JDrawEditorListener)this.listeners.get(i)).sizeChanged();
        }
    }

    private void applyGlobalOption(JDFileLoader f) {
        this.setBackground(f.globalBackground);
        this.autoZoomAsked = f.autoZoomAsked;
    }

    private void createContextualMenu() {
        this.objMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem();
        this.infoMenuItem.setEnabled(false);
        this.cutMenuItem = new JMenuItem("Cut");
        this.cutMenuItem.addActionListener(this);
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.pasteMenuItem = new JMenuItem("Paste");
        this.pasteMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.editShapeMenuItem = new JMenuItem("Edit polyline");
        this.editShapeMenuItem.addActionListener(this);
        this.connectShapeMenuItem = new JMenuItem("Connect");
        this.connectShapeMenuItem.addActionListener(this);
        this.raiseMenuItem = new JMenuItem("Raise");
        this.raiseMenuItem.addActionListener(this);
        this.lowerMenuItem = new JMenuItem("Lower");
        this.lowerMenuItem.addActionListener(this);
        this.frontMenuItem = new JMenuItem("Bring to front");
        this.frontMenuItem.addActionListener(this);
        this.backMenuItem = new JMenuItem("Send to back");
        this.backMenuItem.addActionListener(this);
        this.groupMenuItem = new JMenuItem("Group");
        this.groupMenuItem.addActionListener(this);
        this.ungroupMenuItem = new JMenuItem("Ungroup");
        this.ungroupMenuItem.addActionListener(this);
        this.editGroupMenuItem = new JMenuItem("Edit group");
        this.editGroupMenuItem.addActionListener(this);
        this.zoomInMenuItem = new JMenuItem("Zoom in");
        this.zoomInMenuItem.addActionListener(this);
        this.zoomOutMenuItem = new JMenuItem("Zoom out");
        this.zoomOutMenuItem.addActionListener(this);
        this.createATKPExtension = new JMenuItem("Add ATKPanel ext");
        this.createATKPExtension.addActionListener(this);
        this.objMenu.add(this.infoMenuItem);
        this.sep1 = new JSeparator();
        this.objMenu.add(this.sep1);
        this.objMenu.add(this.cutMenuItem);
        this.objMenu.add(this.copyMenuItem);
        this.objMenu.add(this.pasteMenuItem);
        this.objMenu.add(this.deleteMenuItem);
        this.sep4 = new JSeparator();
        this.objMenu.add(this.sep4);
        this.objMenu.add(this.groupMenuItem);
        this.objMenu.add(this.ungroupMenuItem);
        this.objMenu.add(this.editGroupMenuItem);
        this.sep3 = new JSeparator();
        this.objMenu.add(this.sep3);
        this.objMenu.add(this.editShapeMenuItem);
        this.objMenu.add(this.connectShapeMenuItem);
        this.sep2 = new JSeparator();
        this.objMenu.add(this.sep2);
        this.objMenu.add(this.raiseMenuItem);
        this.objMenu.add(this.lowerMenuItem);
        this.objMenu.add(this.frontMenuItem);
        this.objMenu.add(this.backMenuItem);
        this.sep5 = new JSeparator();
        this.objMenu.add(this.sep5);
        this.objMenu.add(this.zoomInMenuItem);
        this.objMenu.add(this.zoomOutMenuItem);
        this.sep6 = new JSeparator();
        this.objMenu.add(this.sep6);
        this.objMenu.add(this.createATKPExtension);
        this.polyMenu = new JPopupMenu();
        this.infoPolyMenuItem = new JMenuItem();
        this.infoPolyMenuItem.setEnabled(false);
        this.delSummitMenuItem = new JMenuItem("Delete control point");
        this.delSummitMenuItem.addActionListener(this);
        this.brkShapeMenuItem = new JMenuItem("Add a control point here");
        this.brkShapeMenuItem.addActionListener(this);
        this.set0ShapeMenuItem = new JMenuItem("Set as starting point");
        this.set0ShapeMenuItem.addActionListener(this);
        this.reorderShapeMenuItem = new JMenuItem("Invert order");
        this.reorderShapeMenuItem.addActionListener(this);
        this.cancelShapeMenuItem = new JMenuItem("Return to normal edition mode");
        this.cancelShapeMenuItem.addActionListener(this);
        this.polyMenu.add(this.infoPolyMenuItem);
        this.polyMenu.add(new JSeparator());
        this.polyMenu.add(this.delSummitMenuItem);
        this.polyMenu.add(this.set0ShapeMenuItem);
        this.polyMenu.add(this.brkShapeMenuItem);
        this.polyMenu.add(this.reorderShapeMenuItem);
        this.polyMenu.add(this.cancelShapeMenuItem);
    }

    private boolean isSelectedSummit(int id) {
        boolean found = false;
        int i = 0;
        while (i < this.selSummits.length && !found) {
            found = this.selSummits[i] == id;
            if (found) continue;
            ++i;
        }
        return found;
    }

    private void selectSummit(int id) {
        if (!this.isSelectedSummit(id)) {
            int[] nSelSummits = new int[this.selSummits.length + 1];
            for (int i = 0; i < this.selSummits.length; ++i) {
                nSelSummits[i] = this.selSummits[i];
            }
            nSelSummits[i] = id;
            this.selSummits = nSelSummits;
        }
    }

    private Rectangle buildRepaintRect(Vector obs) {
        Rectangle oldRect = null;
        for (int i = 0; i < obs.size(); ++i) {
            JDObject p = (JDObject)obs.get(i);
            oldRect = oldRect == null ? p.getRepaintRect() : oldRect.union(p.getRepaintRect());
        }
        return oldRect;
    }

    private void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDrawEditor.this.repaint();
            }
        });
    }

    private boolean createObject(int eX, int eY) {
        int ey;
        int ex;
        if (this.alignToGrid) {
            ex = (eX + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
            ey = (eY + this.GRID_SIZE / 2) / this.GRID_SIZE * this.GRID_SIZE;
        } else {
            ex = eX;
            ey = eY;
        }
        switch (this.creationMode) {
            case 1: {
                this.createObject(new JDRectangle("Rectangle", ex, ey, 4, 4), 4);
                return true;
            }
            case 8: {
                this.createObject(new JDRoundRectangle("RoundRectangle", ex, ey, 4, 4), 4);
                return true;
            }
            case 2: {
                this.createObject(new JDLine("Line", ex, ey, ex, ey), 1);
                return true;
            }
            case 3: {
                this.createObject(new JDEllipse("Ellipse", ex, ey, 4, 4), 4);
                return true;
            }
            case 4: 
            case 6: {
                int s = this.tmpPoints.size();
                if (s == 0) {
                    this.unselectAll(false);
                    this.tmpPoints.clear();
                    this.tmpPoints.add(new Point(ex, ey));
                    this.tmpPoints.add(new Point(ex + 4, ey + 4));
                } else {
                    Rectangle old = this.buildRectFromLine((Point)this.tmpPoints.get(s - 2), (Point)this.tmpPoints.get(s - 1));
                    this.tmpPoints.add(new Point(ex, ey));
                    this.repaint(old.union(this.buildRectFromLine((Point)this.tmpPoints.get(s - 1), (Point)this.tmpPoints.get(s))));
                }
                this.fireSelectionChange();
                return true;
            }
            case 5: {
                String str = JOptionPane.showInputDialog(this, "Enter a text", "Create label", 1);
                if (str != null) {
                    this.createObject(new JDLabel("Label", str, ex, ey), -1);
                } else {
                    this.creationMode = 0;
                    this.fireCreationDone();
                }
                return true;
            }
            case 17: {
                String strr = JOptionPane.showInputDialog(this, "Enter a text", "Create label", 1);
                if (strr != null) {
                    this.createObject(new JDRotatableLabel("RotatableLabel", strr, ex, ey), -1);
                } else {
                    this.creationMode = 0;
                    this.fireCreationDone();
                }
                return true;
            }
            case 16: {
                String title = JOptionPane.showInputDialog(this, "Enter a title", "Create titled rect", 1);
                if (title != null) {
                    this.createObject(new JDTitledRect("TitledRect", title, ex, ey), -1);
                } else {
                    this.creationMode = 0;
                    this.fireCreationDone();
                }
                return true;
            }
            case 9: {
                JFileChooser chooser = new JFileChooser(".");
                String[] exts = new String[]{"gif", "png", "jpg"};
                chooser.addChoosableFileFilter(new JDFileFilter("Image file", exts));
                if (chooser.showOpenDialog(this) != 0) break;
                this.createObject(new JDImage("Image", chooser.getSelectedFile().getAbsolutePath(), ex, ey), -1);
                return true;
            }
            case 10: {
                if (this.creationParam != null) {
                    this.createObject(new JDSwingObject("SwingObject", this.creationParam, ex, ey), -1);
                    this.repaintLater();
                }
                return true;
            }
            case 11: {
                this.createObject(new JDAxis("Axis", ex, ey, 50, 100), -1);
                return true;
            }
            case 12: {
                this.createObject(new JDBar("Bar", ex, ey, 4, 4), 4);
                return true;
            }
            case 13: {
                this.createObject(new JDSlider("Slider", ex, ey, 4, 4), 4);
                return true;
            }
            case 14: {
                JDObject e = this.findObject(eX, eY);
                if (e == null) {
                    JOptionPane.showMessageDialog(this, "Cannot pick new cursor for slider:\nNo object found here.");
                } else if (e instanceof JDSlider) {
                    JOptionPane.showMessageDialog(this, "Cannot pick new cursor for slider:\n.Slider cannot be taken as cursor.");
                } else {
                    this.sliderRef.setCursor(e.copy(0, 0));
                    this.setNeedToSave(true, "Pick new cursor");
                }
                this.repaint();
                this.creationMode = 0;
                this.fireCreationDone();
                return true;
            }
            case 15: {
                JDObject e = this.findObject(eX, eY);
                if (e == null) {
                    JOptionPane.showMessageDialog(this, "No polyline found here.");
                } else if (!(e instanceof JDPolyline)) {
                    JOptionPane.showMessageDialog(this, "This object is not a polyline.");
                } else if (e.equals(this.connectPolyline)) {
                    JOptionPane.showMessageDialog(this, "Cannot connect to itself.");
                } else {
                    this.connectPolyline.connect((JDPolyline)e);
                    this.objects.remove(e);
                    this.setNeedToSave(true, "Connect polyline");
                }
                this.repaint();
                this.creationMode = 0;
                this.fireCreationDone();
                return true;
            }
            case 7: {
                this.creationMode = 0;
                this.pasteClipboard(ex, ey, true);
                this.fireCreationDone();
                return true;
            }
        }
        return false;
    }
}

