/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.JLXStyle;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

class JLXFileLoader {
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    String version;
    private String word;
    FileReader f;
    static final int[] ToJDTextAlign = new int[]{1, 0, 2};
    static String[] extNames = new String[]{"className", "classParam"};

    public JLXFileLoader(FileReader fr) {
        this.f = fr;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    String read_safe_word() throws IOException {
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    String read_safe_full_word() throws IOException {
        this.word = this.read_word(true);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    String read_word(boolean ignoreColon) throws IOException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (!ignoreColon && this.CurrentChar == ';') {
            ret_word.append(this.CurrentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.CurrentChar == '\"') {
            ret_word.append(this.CurrentChar);
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            ret_word.append(this.CurrentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (ignoreColon) {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
        } else {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n' && this.CurrentChar != ';') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    public int getCurrentLine() {
        return this.StartLine;
    }

    int read_int() throws IOException {
        int i;
        String s = this.read_safe_word();
        if (s.equals("!") || s.equals("$")) {
            return 0;
        }
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad integer format at line " + this.CrtLine + "\n" + e.getMessage());
        }
        return i;
    }

    double read_double() throws IOException {
        double d;
        String s = this.read_safe_word();
        if (s.equals("!") || s.equals("$")) {
            return 0.0;
        }
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad double format at line " + this.CrtLine + "\n" + e.getMessage());
        }
        return d;
    }

    Color read_color() throws IOException {
        String s = this.read_safe_word();
        if (s.equals("!") || s.equals("$")) {
            return null;
        }
        try {
            int i = (int)Long.parseLong(s, 16);
            int a = i >>> 24;
            int r = (i & 0xFF0000) >>> 16;
            int g = (i & 0xFF00) >>> 8;
            int b = i & 0xFF;
            return new Color(r, g, b, a);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad color format at line " + this.CrtLine + "\n" + e.getMessage());
        }
    }

    void jump_colon() throws IOException {
        String s = this.read_safe_word();
        if (!s.equals(";")) {
            throw new IOException("';' expected at line " + this.CrtLine + "\n");
        }
    }

    double[] parseDouleArray() throws IOException {
        String s = this.read_safe_full_word();
        if (s.equals("!") || s.equals("$")) {
            double[] ret = new double[2];
            ret[1] = 0.0;
            ret[0] = 0.0;
            return ret;
        }
        String[] a = s.split(";");
        double[] ret = new double[a.length];
        try {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Double.parseDouble(a[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Number expected at line " + this.getCurrentLine() + "\n" + e.getMessage());
        }
        return ret;
    }

    private String extractQuote(String s) {
        if (s.charAt(0) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    String read_string() throws IOException {
        String s = this.read_safe_word();
        return this.extractQuote(s);
    }

    JDObject parseLxRectangle(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Rectangle");
        r.parse(this, false);
        r.correct(x, y);
        int arcW = (int)this.read_double();
        this.read_double();
        int type = this.read_int();
        if (type == 0) {
            return new JDRectangle(r);
        }
        return new JDRoundRectangle(r, arcW);
    }

    JDObject parseLxCircle(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Ellipse");
        r.parse(this, false);
        r.correct(x, y);
        int a = (int)this.read_double();
        int b = (int)this.read_double();
        int atype = this.read_int();
        return new JDEllipse(r, 360 - (a + b), b, atype);
    }

    JDObject parseLxLine(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Line");
        r.parse(this, false);
        r.correct(x, y);
        JLXPath p = new JLXPath();
        p.parse(this, false, true);
        return new JDLine(r, p);
    }

    JDObject parseLxParallelogram(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Polyline");
        r.parse(this, false);
        r.correct(x, y);
        JLXPath p = new JLXPath();
        p.parse(this, true, false);
        this.read_int();
        this.read_int();
        return new JDPolyline(r, p);
    }

    JDObject parseLxPolyline(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Polyline");
        r.parse(this, false);
        r.correct(x, y);
        JLXPath p = new JLXPath();
        p.parse(this, true, true);
        return new JDPolyline(r, p);
    }

    JDObject parseLxText(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Text");
        r.parse(this, false);
        r.correct(x, y);
        this.read_int();
        this.read_double();
        String fname = this.read_string();
        int fstyle = this.read_int();
        int fsize = this.read_int();
        String txt = this.read_string();
        r.style.fillStyle = 0;
        r.style.lineWidth = 0;
        return new JDLabel(r, new Font(fname, fstyle, fsize), txt, 0, true);
    }

    JDObject parseLxTextArea(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Text");
        r.parse(this, false);
        r.correct(x, y);
        JLXPath p = new JLXPath();
        p.parse(this, true, false);
        this.read_int();
        this.read_double();
        String fname = this.read_string();
        int fstyle = this.read_int();
        int fsize = this.read_int();
        String txt = this.read_string();
        this.read_int();
        this.read_int();
        this.read_int();
        this.read_int();
        int align = this.read_int();
        Color txtColor = this.read_color();
        r.style.lineColor = txtColor == null ? Color.BLACK : txtColor;
        this.read_double();
        return new JDLabel(r, new Font(fname, fstyle, fsize), txt, ToJDTextAlign[align], false);
    }

    JDObject parseLxGeneralPath(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Polyline");
        r.parse(this, false);
        r.correct(x, y);
        JLXPath p = new JLXPath();
        p.parse(this, true, false);
        switch (p.pathType) {
            case 0: 
            case 1: {
                return new JDPolyline(r, p);
            }
            case 2: 
            case 3: {
                return new JDSpline(r, p);
            }
        }
        throw new IOException("Bad path format at line " + this.CrtLine);
    }

    JDObject parseLxImage(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Image");
        r.parse(this, false);
        r.correct(x, y);
        this.read_int();
        if (this.version.compareTo("0.3.0") >= 0) {
            this.read_int();
            this.read_int();
        }
        this.read_double();
        if (this.version.compareTo("1.0.1") >= 0) {
            this.read_int();
        }
        String iname = this.read_string();
        return new JDImage(r, iname);
    }

    JDObject parseLxGroup(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Group");
        r.parse(this, true);
        r.correct(x, y);
        Vector<JDObject> objects = new Vector<JDObject>();
        int nbObject = this.read_int();
        for (int i = 0; i < nbObject; ++i) {
            JDObject o = this.parseObject(r.boundRect.getX(), r.boundRect.getY());
            if (o == null) continue;
            objects.add(o);
        }
        return new JDGroup(r, objects);
    }

    JDObject parseLxPushButton(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Button");
        r.parse(this, true);
        r.correct(x, y);
        Vector<JDObject> objects = new Vector<JDObject>();
        int nbObject = this.read_int();
        for (int i = 0; i < nbObject; ++i) {
            JDObject o = this.parseObject(r.boundRect.getX(), r.boundRect.getY());
            if (o == null) continue;
            objects.add(o);
        }
        JDGroup ret = new JDGroup(r, objects);
        JDValueProgram vp = new JDValueProgram(3);
        vp.addNewEntry();
        vp.setDefaultMapping("false");
        vp.setMappingAt(0, "true");
        vp.setValueAt(0, "1");
        ret.setInvertShadowMapper(vp);
        ((JDObject)ret).setMinValue(0);
        ((JDObject)ret).setMaxValue(1);
        ((JDObject)ret).setInitValue(0);
        ret.setValueChangeMode(1);
        boolean interactive = false;
        if (this.version.compareTo("1.3.0") >= 0) {
            interactive = this.read_int() == 1;
        }
        ret.setInteractive(interactive);
        return ret;
    }

    private Vector findObjects(String name, Vector objs) {
        int nb = objs.size();
        Vector<JDObject> ret = new Vector<JDObject>();
        for (int i = 0; i < nb; ++i) {
            JDObject obj = (JDObject)objs.get(i);
            if (obj instanceof JDGroup) {
                if (obj.name.equals(name)) {
                    ret.add(obj);
                    continue;
                }
                Vector objs2 = ((JDGroup)obj).getChildren();
                Vector ret2 = this.findObjects(name, objs2);
                ret.addAll(ret2);
                continue;
            }
            boolean found = obj.name.equals(name);
            if (!found) continue;
            ret.add((JDObject)objs.get(i));
        }
        return ret;
    }

    JDObject parseLxMultiState(double x, double y) throws IOException {
        int i;
        JLXObject r = new JLXObject("MultiState");
        r.parse(this, true);
        r.correct(x, y);
        Vector<JDObject> objects = new Vector<JDObject>();
        int nbObject = this.read_int();
        for (i = 0; i < nbObject; ++i) {
            JDObject o = this.parseObject(r.boundRect.getX(), r.boundRect.getY());
            if (o == null) continue;
            objects.add(o);
        }
        boolean interactive = false;
        if (this.version.compareTo("1.3.0") >= 0) {
            interactive = this.read_int() == 1;
        }
        int min = this.read_int();
        int max = this.read_int();
        int v0 = this.read_int();
        for (i = min; i <= max; ++i) {
            String oname = Integer.toString(i);
            Vector subO = this.findObjects(oname, objects);
            if (subO.size() == 0) {
                System.out.println("JLXFileLoader.parseLxMultiState() : Warning, sub-object '" + oname + "' not found in " + r.name);
                continue;
            }
            JDValueProgram vp = new JDValueProgram(3);
            vp.addNewEntry();
            vp.setDefaultMapping("false");
            vp.setMappingAt(0, "true");
            vp.setValueAt(0, oname);
            for (int j = 0; j < subO.size(); ++j) {
                ((JDObject)subO.get(j)).setVisibilityMapper(vp.copy());
            }
        }
        JDGroup ret = new JDGroup(r, objects);
        ((JDObject)ret).setMinValue(min);
        ((JDObject)ret).setMaxValue(max);
        ((JDObject)ret).setInitValue(v0);
        ret.setInteractive(interactive);
        ret.setValueChangeMode(0);
        return ret;
    }

    JDObject parseLxToggle(double x, double y) throws IOException {
        JLXObject r = new JLXObject("Toggle");
        r.parse(this, true);
        r.correct(x, y);
        Vector<JDObject> objects = new Vector<JDObject>();
        int nbObject = this.read_int();
        for (int i = 0; i < nbObject; ++i) {
            JDObject o = this.parseObject(r.boundRect.getX(), r.boundRect.getY());
            if (o == null) continue;
            objects.add(o);
        }
        boolean interactive = false;
        if (this.version.compareTo("1.3.0") >= 0) {
            interactive = this.read_int() == 1;
        }
        int v0 = this.read_int();
        Vector subO = this.findObjects("OFF", objects);
        Vector sub1 = this.findObjects("ON", objects);
        if (subO.size() == 0) {
            throw new IOException("Toggle sub-object 'OFF' not found in " + r.name);
        }
        if (sub1.size() == 0) {
            throw new IOException("Toggle sub-object 'ON' not found in " + r.name);
        }
        JDValueProgram vp = new JDValueProgram(3);
        vp.addNewEntry();
        vp.setDefaultMapping("false");
        vp.setMappingAt(0, "true");
        vp.setValueAt(0, "1");
        for (int j = 0; j < subO.size(); ++j) {
            ((JDObject)subO.get(j)).setVisibilityMapper(vp);
        }
        JDValueProgram vp2 = new JDValueProgram(3);
        vp2.addNewEntry();
        vp2.setDefaultMapping("true");
        vp2.setMappingAt(0, "false");
        vp2.setValueAt(0, "1");
        for (int j = 0; j < sub1.size(); ++j) {
            ((JDObject)sub1.get(j)).setVisibilityMapper(vp2);
        }
        JDGroup ret = new JDGroup(r, objects);
        ((JDObject)ret).setMinValue(0);
        ((JDObject)ret).setMaxValue(1);
        ((JDObject)ret).setInitValue(v0);
        ret.setInteractive(interactive);
        ret.setValueChangeMode(0);
        return ret;
    }

    JDObject parseLxCustomShape(double x, double y) throws IOException {
        Vector objects = new Vector();
        JLXObject r = new JLXObject("Custom shape");
        r.parse(this, false);
        r.correct(x, y);
        if (this.version.compareTo("1.1.0") >= 0) {
            this.read_int();
            this.read_double();
        }
        int nbPath = this.read_int();
        JLXPath p = new JLXPath();
        block5: for (int i = 0; i < nbPath; ++i) {
            int pathType = this.read_int();
            if (pathType == 991) {
                this.read_int();
            }
            switch (pathType) {
                case 990: {
                    p.parseCustom(this, r, objects);
                    continue block5;
                }
                case 991: {
                    p.parseCustom(this, r, null);
                    continue block5;
                }
                case 992: {
                    System.out.println("JLXFileLoader.parseLxCustomShape() Not supported custom shape type :" + pathType);
                    p.parseCustom(this, r, null);
                    continue block5;
                }
                default: {
                    System.out.println("Invalid custom shape type :" + pathType);
                }
            }
        }
        if (objects.size() == 1) {
            return (JDObject)objects.get(0);
        }
        return new JDGroup(r, objects);
    }

    JDObject parseObject(double x, double y) throws IOException {
        String className = this.read_safe_word();
        if (className.equals("com.loox.jloox.LxRectangle")) {
            return this.parseLxRectangle(x, y);
        }
        if (className.equals("com.loox.jloox.LxCircle")) {
            return this.parseLxCircle(x, y);
        }
        if (className.equals("com.loox.jloox.LxLine")) {
            return this.parseLxLine(x, y);
        }
        if (className.equals("com.loox.jloox.LxPolyline")) {
            return this.parseLxPolyline(x, y);
        }
        if (className.equals("com.loox.jloox.LxParallelogram")) {
            return this.parseLxParallelogram(x, y);
        }
        if (className.equals("com.loox.jloox.LxText")) {
            return this.parseLxText(x, y);
        }
        if (className.equals("com.loox.jloox.LxTextArea")) {
            return this.parseLxTextArea(x, y);
        }
        if (className.equals("com.loox.jloox.LxGeneralPath")) {
            return this.parseLxGeneralPath(x, y);
        }
        if (className.equals("com.loox.jloox.LxImage")) {
            return this.parseLxImage(x, y);
        }
        if (className.equals("com.loox.jloox.LxGroup")) {
            return this.parseLxGroup(x, y);
        }
        if (className.equals("com.loox.jloox.LxPushButton")) {
            return this.parseLxPushButton(x, y);
        }
        if (className.equals("com.loox.jloox.LxMultiState")) {
            return this.parseLxMultiState(x, y);
        }
        if (className.equals("com.loox.jloox.LxCustomShape")) {
            return this.parseLxCustomShape(x, y);
        }
        if (className.equals("com.loox.jloox.LxToggle")) {
            return this.parseLxToggle(x, y);
        }
        if (className.startsWith("com")) {
            System.out.println("JLXFileLoader.parseObject() Unknown class found:" + className + " at line " + this.StartLine);
            char oChar = this.CurrentChar;
            this.read_char();
            while (oChar != '\n' || this.CurrentChar != '\n') {
                oChar = this.CurrentChar;
                this.read_char();
                if (this.CurrentChar != '\u0000') continue;
                throw new IOException("Unexpected end of file while trying to trigger to the next LxClass after : " + className);
            }
        }
        return null;
    }

    Vector parseFile() throws IOException {
        int i;
        Vector<JDObject> objects = new Vector<JDObject>();
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("JLoox")) {
            throw new IOException("Invalid header !");
        }
        this.version = this.read_safe_word();
        if (this.version.compareTo("1.3.1") >= 0) {
            this.read_safe_word();
        }
        new JLXStyle().parse(this);
        new JLXStyle().parse(this);
        this.read_string();
        this.read_int();
        this.read_int();
        this.read_int();
        this.read_int();
        this.read_safe_word();
        int nbLayer = this.read_int();
        for (i = 0; i < nbLayer; ++i) {
            this.read_string();
            this.read_int();
        }
        int nbObject = this.read_int();
        for (i = 0; i < nbObject; ++i) {
            JDObject o = this.parseObject(0.0, 0.0);
            if (o == null) continue;
            objects.add(o);
        }
        this.read_int();
        this.word = this.read_word(false);
        if (this.word != null && this.word.equalsIgnoreCase("\"UserData\"")) {
            for (i = 0; i < nbObject; ++i) {
                String ext = this.read_string();
                if (!ext.equalsIgnoreCase("ud")) continue;
                this.read_int();
                ((JDObject)objects.get(i)).setExtensionList(extNames);
                ((JDObject)objects.get(i)).setExtendedParam(0, this.read_string());
                ((JDObject)objects.get(i)).setExtendedParam(1, this.read_string());
            }
        }
        return objects;
    }

    public static void main(String[] args) {
        try {
            FileReader fr = new FileReader(args[0]);
            JLXFileLoader f = new JLXFileLoader(fr);
            f.parseFile();
            fr.close();
        }
        catch (IOException e) {
            System.out.println("Reading of " + args[0] + " failed " + e.getMessage());
        }
        System.exit(0);
    }
}

