/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JLXFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JLXStyle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

class JLXObject {
    String name;
    boolean visible;
    Rectangle2D boundRect;
    JLXStyle style;
    int shadowWidth;

    JLXObject(String name) {
        this.name = name;
        this.visible = true;
        this.shadowWidth = 0;
    }

    void correct(double x, double y) {
        this.boundRect.setRect(this.boundRect.getX() + x, this.boundRect.getY() + y, this.boundRect.getWidth(), this.boundRect.getHeight());
    }

    void parse(JLXFileLoader f, boolean isGroup) throws IOException {
        String flags;
        String s = f.read_string();
        if (!s.equals("!") && !s.equals("$")) {
            this.name = s;
        }
        this.visible = (flags = f.read_safe_word()).charAt(0) == '1';
        double x = f.read_double();
        f.jump_colon();
        double y = f.read_double();
        f.jump_colon();
        double w = f.read_double();
        f.jump_colon();
        double h = f.read_double();
        this.boundRect = new Rectangle2D.Double(x, y, w, h);
        f.read_double();
        f.read_double();
        f.read_safe_full_word();
        f.read_safe_word();
        if (f.version.compareTo("1.1.1") >= 0) {
            f.read_safe_word();
        }
        if (f.version.compareTo("2.0.0") >= 0) {
            f.read_int();
        }
        this.style = new JLXStyle();
        if (!isGroup) {
            this.style.parse(f);
            this.shadowWidth = (int)f.read_double();
        } else {
            this.style.fillStyle = 0;
            this.style.lineWidth = 0;
        }
    }
}

