/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JLXFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import java.io.IOException;
import java.util.Vector;

class JLXPath {
    static int[] ToJDLineArrow = new int[]{0, 5, 6, 7, 0, 1, 2, 3, 8, 0, 0, 0, 4, 0, 0, 0};
    Vector path = new Vector();
    int arrow = 0;
    boolean closed = false;
    int pathType = 1;

    JLXPath() {
    }

    void parse(JLXFileLoader f, boolean hasShadow, boolean hasArrow) throws IOException {
        int nbItem = f.read_int();
        for (int k = 0; k < nbItem; ++k) {
            int type = -1;
            double[] vals = null;
            if (f.version.compareTo("2.0.0") >= 0) {
                type = f.read_int();
            }
            if (type == 4) {
                System.out.println("JLXPath.parse() Unsuported type at line " + f.getCurrentLine());
                continue;
            }
            vals = f.parseDouleArray();
            this.path.add(vals);
            if (k != 1) continue;
            this.pathType = type;
        }
        boolean bl = this.closed = f.read_int() == 1;
        if (hasArrow) {
            this.arrow = ToJDLineArrow[f.read_int()];
        }
        if (hasShadow) {
            f.read_int();
        }
    }

    private void cleanPath() {
        double[] pt;
        double[] opt;
        if (this.path.size() > 1) {
            opt = (double[])this.path.firstElement();
            for (int i = 1; i < this.path.size(); ++i) {
                pt = (double[])this.path.get(i);
                if (pt[0] == opt[0] && pt[1] == opt[1]) {
                    this.path.remove(i);
                    --i;
                }
                opt = pt;
            }
        }
        if (this.path.size() > 1 && (pt = (double[])this.path.firstElement())[0] == (opt = (double[])this.path.lastElement())[0] && pt[1] == opt[1]) {
            this.path.remove(0);
        }
    }

    private void createPolyline(JLXObject parent, Vector objs, boolean closed) {
        if (this.path.size() > 1 && objs != null) {
            double w = parent.boundRect.getWidth();
            double h = parent.boundRect.getHeight();
            for (int i = 0; i < this.path.size(); ++i) {
                double[] pts = (double[])this.path.get(i);
                pts[0] = pts[0] * w;
                pts[1] = pts[1] * h;
            }
            this.closed = closed;
            this.cleanPath();
            objs.add(new JDPolyline(parent, this));
        }
        this.path.removeAllElements();
    }

    void parseCustom(JLXFileLoader f, JLXObject parent, Vector objs) throws IOException {
        int nbItem = f.read_int();
        block7: for (int i = 0; i < nbItem; ++i) {
            int action = f.read_int();
            switch (action) {
                case 0: {
                    this.createPolyline(parent, objs, false);
                    this.path.add(f.parseDouleArray());
                    continue block7;
                }
                case 1: {
                    this.path.add(f.parseDouleArray());
                    continue block7;
                }
                case 2: {
                    double[] ctrlPt = f.parseDouleArray();
                    double[] lastPt = (double[])this.path.lastElement();
                    JDUtils.computeSpline(lastPt[0], lastPt[1], ctrlPt[0], ctrlPt[1], ctrlPt[0], ctrlPt[1], ctrlPt[2], ctrlPt[3], 10, true, 0, this.path, null, null);
                    continue block7;
                }
                case 3: {
                    double[] ctrlPt = f.parseDouleArray();
                    double[] lastPt = (double[])this.path.lastElement();
                    JDUtils.computeSpline(lastPt[0], lastPt[1], ctrlPt[0], ctrlPt[1], ctrlPt[2], ctrlPt[3], ctrlPt[4], ctrlPt[5], 10, true, 0, this.path, null, null);
                    continue block7;
                }
                case 4: {
                    this.createPolyline(parent, objs, true);
                }
            }
        }
        this.createPolyline(parent, objs, false);
    }
}

