/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JLXFileLoader;
import java.awt.Color;
import java.io.IOException;

class JLXStyle {
    static int[] ToJDLineStyle = new int[]{0, 1, 2, 3, 4, 3, 4};
    static int[] ToJDFillStyle = new int[]{0, 1, 1, 8, 10, 9, 6, 3, 5, 2, 4, 7, 4, 7};
    Color lineColor = Color.BLACK;
    int lineStyle = 0;
    int lineWidth = 1;
    Color fillColor = Color.WHITE;
    int fillStyle = 0;
    float gradientX1 = 0.0f;
    float gradientX2 = 10.0f;
    float gradientY1 = 0.0f;
    float gradientY2 = 10.0f;
    Color gradientC1 = Color.white;
    Color gradientC2 = Color.black;
    boolean gradientCyclic = false;

    JLXStyle() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(JLXFileLoader f) throws IOException {
        Color c;
        String type = f.read_safe_word();
        if (type.equals("!")) {
            return;
        }
        if (!type.equals("A")) throw new IOException("Unsupported style type at line " + f.getCurrentLine());
        this.lineStyle = ToJDLineStyle[f.read_int()];
        this.lineWidth = (int)f.read_double();
        if (f.version.compareTo("2.0.0") >= 0) {
            f.read_int();
            f.read_int();
        }
        if ((c = f.read_color()) != null) {
            this.lineColor = c;
        }
        f.read_double();
        String fs = f.read_safe_word();
        if (!fs.equals("!")) {
            if (fs.equals("F")) {
                this.fillColor = f.read_color();
                this.fillStyle = 1;
                if (this.fillColor == null) {
                    this.fillColor = Color.black;
                }
                f.read_color();
            } else if (fs.equals("B")) {
                f.read_color();
                this.fillColor = f.read_color();
                if (this.fillColor == null) {
                    this.fillColor = Color.black;
                }
                this.fillStyle = 1;
            } else if (fs.equals("C")) {
                this.fillColor = f.read_color();
                if (this.fillColor == null) {
                    this.fillColor = Color.white;
                }
                this.fillStyle = 1;
            } else if (fs.equals("G")) {
                this.gradientX1 = (float)f.read_double();
                f.jump_colon();
                this.gradientY1 = (float)f.read_double();
                f.jump_colon();
                this.gradientX2 = (float)f.read_double();
                f.jump_colon();
                this.gradientY2 = (float)f.read_double();
                String flags = f.read_safe_word();
                this.gradientCyclic = flags.charAt(0) == '1';
                boolean transparent = flags.charAt(1) == '1';
                Color color = f.read_color();
                if (color != null) {
                    this.gradientC1 = color;
                }
                if ((color = f.read_color()) != null) {
                    this.gradientC2 = color;
                }
                if (transparent) {
                    this.gradientC1 = new Color(this.gradientC1.getRed(), this.gradientC1.getGreen(), this.gradientC1.getBlue(), 0);
                }
                int gradientType = 0;
                if (f.version.compareTo("2.0.2") >= 0) {
                    gradientType = f.read_int();
                }
                if (gradientType == 0) {
                    this.fillStyle = 11;
                } else if (gradientType != 1) {
                    // empty if block
                }
            } else if (fs.equals("T")) {
                f.read_string();
                f.read_color();
                f.read_color();
            } else {
                if (!fs.equals("S")) throw new IOException("Bad style format at line " + f.getCurrentLine());
                int fillstyle = f.read_int();
                Color color = f.read_color();
                Color color2 = f.read_color();
                this.fillColor = fillstyle == 1 ? color : (fillstyle == 2 ? color2 : Color.BLACK);
                if (this.fillColor == null) {
                    this.fillColor = Color.BLACK;
                }
                this.fillStyle = ToJDFillStyle[fillstyle];
            }
        }
        f.read_safe_full_word();
    }
}

