/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.Dynamics;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class LXFileLoader {
    private int CrtLine;
    private int StartLine;
    char CurrentChar;
    String version;
    private String word;
    FileReader f;

    public LXFileLoader(FileReader fr) {
        this.f = fr;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    String read_safe_word() throws IOException {
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    String read_safe_full_word() throws IOException {
        this.word = this.read_word(true);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    String read_line() throws IOException {
        StringBuffer ret_word = new StringBuffer();
        while (this.CurrentChar != '\n' && this.CurrentChar != '\u0000') {
            if (this.CurrentChar != '\u0000') {
                ret_word.append(this.CurrentChar);
            }
            this.read_char();
        }
        if (ret_word.length() == 0) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return ret_word.toString();
    }

    void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    String read_word(boolean ignoreColon) throws IOException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (!ignoreColon && this.CurrentChar == ';') {
            ret_word.append(this.CurrentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.CurrentChar == '\"') {
            ret_word.append(this.CurrentChar);
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            ret_word.append(this.CurrentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (ignoreColon) {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
        } else {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n' && this.CurrentChar != ';') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    public int getCurrentLine() {
        return this.StartLine;
    }

    int read_int() throws IOException {
        int i;
        String s = this.read_safe_word();
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad integer format at line " + this.CrtLine + "\n" + e.getMessage());
        }
        return i;
    }

    int read_int_16() throws IOException {
        int i;
        String s = this.read_safe_word();
        try {
            i = (int)Long.parseLong(s, 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad integer format at line " + this.CrtLine + "\n" + e.getMessage());
        }
        return i;
    }

    double read_double() throws IOException {
        double d;
        String s = this.read_safe_word();
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad double format at line " + this.CrtLine + "\n" + e.getMessage());
        }
        return d;
    }

    Color read_color() throws IOException {
        String s = this.read_safe_word();
        String s10 = s.substring(0, 2);
        String s12 = s.substring(2, 4);
        String s14 = s.substring(4, 6);
        if (s10.equals("-1")) {
            s10 = "FF";
        }
        if (s12.equals("-1")) {
            s12 = "FF";
        }
        if (s14.equals("-1")) {
            s14 = "FF";
        }
        try {
            return new Color(Integer.parseInt(s10, 16), Integer.parseInt(s12, 16), Integer.parseInt(s14, 16));
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad color format at line " + this.CrtLine + "\n" + e.getMessage());
        }
    }

    void jump_colon() throws IOException {
        String s = this.read_safe_word();
        if (!s.equals(";")) {
            throw new IOException("';' expected at line " + this.CrtLine + "\n");
        }
    }

    Font read_font() throws IOException {
        this.jump_space();
        String s = this.read_line();
        StringTokenizer stringtokenizer = new StringTokenizer(s, "-");
        if (stringtokenizer.countTokens() < 7) {
            return new Font(s, 0, 10);
        }
        stringtokenizer.nextToken();
        String s1 = stringtokenizer.nextToken();
        String s2 = stringtokenizer.nextToken();
        String s3 = stringtokenizer.nextToken();
        stringtokenizer.nextToken();
        stringtokenizer.nextToken();
        String s4 = stringtokenizer.nextToken();
        int size = 0;
        int style = 0;
        if (s2.equals("bold")) {
            style |= 1;
        }
        if (s3.equals("i")) {
            style |= 2;
        }
        try {
            size = Integer.parseInt(s4);
        }
        catch (NumberFormatException numberformatexception) {
            size = 12;
        }
        return new Font(s1, style, size);
    }

    void jump_dynamics() throws IOException {
        this.jump_space();
        if (this.CurrentChar == 'd') {
            this.word = this.read_safe_word();
            while (!this.word.equals("end")) {
                this.word = this.read_safe_word();
            }
            this.read_safe_word();
        }
    }

    Dynamics read_dynamics() throws IOException {
        this.jump_space();
        if (this.CurrentChar == 'd') {
            String extName;
            Dynamics dyna = new Dynamics();
            this.read_safe_word();
            while (true) {
                if ((extName = this.read_safe_word()).equals("_dynClassName")) {
                    dyna.dynClassName = this.read_safe_word();
                    continue;
                }
                if (extName.equals("_dynValueFlag")) {
                    dyna.dynValueFlag = this.read_int();
                    continue;
                }
                if (extName.equals("_dynSensitive")) {
                    dyna.dynSensitive = this.read_int();
                    continue;
                }
                if (extName.equals("_dynMinColor")) {
                    dyna.dynMinColor = this.read_int();
                    continue;
                }
                if (extName.equals("_dynMaxColor")) {
                    dyna.dynMaxColor = this.read_int();
                    continue;
                }
                if (extName.equals("_dynNumColors")) {
                    dyna.dynNumColors = this.read_int();
                    continue;
                }
                if (extName.equals("_dynColorIndicator")) {
                    dyna.dynColorIndicator = this.read_int();
                    continue;
                }
                if (extName.equals("_dynUseThreshold")) {
                    dyna.dynUseThreshold = this.read_int();
                    continue;
                }
                if (extName.equals("_dynTextFormat")) {
                    this.jump_space();
                    dyna.dynTextFormat = this.read_line();
                    continue;
                }
                if (extName.equals("_dynMinimum")) {
                    dyna.dynMinimum = this.read_double();
                    continue;
                }
                if (extName.equals("_dynMaximum")) {
                    dyna.dynMaximum = this.read_double();
                    continue;
                }
                if (extName.equals("_dynUserMinimum")) {
                    dyna.dynUserMinimum = this.read_double();
                    continue;
                }
                if (extName.equals("_dynUserMaximum")) {
                    dyna.dynUserMaximum = this.read_double();
                    continue;
                }
                if (extName.equals("_dynValue")) {
                    dyna.dynValue = this.read_double();
                    continue;
                }
                if (!extName.equals("_dynThreshold")) break;
                dyna.dynThreshold = this.read_double();
            }
            if (extName.equals("end")) {
                this.read_safe_word();
                return dyna;
            }
            throw new IOException("Invalid loox dynamics keyword :" + extName);
        }
        return null;
    }

    JDObject parseLxRectangle(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        double x = this.read_double();
        double y = this.read_double();
        double w = this.read_double();
        double h = this.read_double();
        lxObj.setBounds(x, y, w, h);
        if (this.CurrentChar != '\n') {
            lxObj.shadowWidth = this.read_int();
            lxObj.invertShadow = this.read_int() != 0;
        }
        return new JDRectangle(lxObj);
    }

    JDObject parseLxLine(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        int nb = this.read_int();
        if (nb != 2) {
            throw new IOException("Only 2 point are allowed for line object, line " + this.CrtLine + "\n");
        }
        double x1 = this.read_double();
        double y1 = this.read_double();
        double x2 = this.read_double();
        double y2 = this.read_double();
        lxObj.setBounds(x1, y1, x2, y2);
        return new JDLine(lxObj, x1 + lxObj.px, y1 + lxObj.py, x2 + lxObj.px, y2 + lxObj.py, lxObj.lineArrow);
    }

    JDObject parseLxPolyline(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        boolean isSpline = this.read_int() == 1;
        boolean closed = this.read_int() == 1;
        this.read_int();
        lxObj.shadowWidth = this.read_int();
        lxObj.invertShadow = this.read_int() != 0;
        this.read_int();
        this.read_int();
        this.read_int();
        int nb = this.read_int();
        if (isSpline) {
            this.read_double();
            this.read_double();
            double[] x = new double[nb - 1];
            double[] y = new double[nb - 1];
            for (int i = 0; i < nb - 1; ++i) {
                x[i] = this.read_double() + lxObj.px;
                y[i] = this.read_double() + lxObj.py;
            }
            return new JDSpline(lxObj, x, y, closed);
        }
        double[] x = new double[nb];
        double[] y = new double[nb];
        for (int i = 0; i < nb; ++i) {
            x[i] = this.read_double() + lxObj.px;
            y[i] = this.read_double() + lxObj.py;
        }
        return new JDPolyline(lxObj, x, y, closed);
    }

    JDObject parseLxEllipse(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        double x = this.read_double();
        double y = this.read_double();
        double w = this.read_double();
        double h = this.read_double();
        lxObj.setBounds(x, y, w, h);
        int a = this.read_int() / 64;
        int b = this.read_int() / 64;
        return new JDEllipse(lxObj, 360 - (a + b), b, lxObj.arcMode);
    }

    JDObject parseLxText(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        lxObj.px += this.read_double();
        lxObj.py += this.read_double();
        lxObj.fillStyle = 0;
        this.read_int();
        this.read_char();
        this.read_char();
        String s = this.read_line();
        s = s.replace('\u0001', '\n');
        return new JDLabel(lxObj, s);
    }

    JDObject parseLxPara(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        this.read_int();
        lxObj.shadowWidth = this.read_int();
        lxObj.invertShadow = this.read_int() != 0;
        this.read_int();
        this.read_int();
        int nb = 4;
        double[] x = new double[nb];
        double[] y = new double[nb];
        for (int i = 0; i < nb; ++i) {
            x[i] = this.read_double() + lxObj.px;
            y[i] = this.read_double() + lxObj.py;
        }
        return new JDPolyline(lxObj, x, y, true);
    }

    JDObject parseLxImage(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        this.read_int();
        double x = this.read_double();
        double y = this.read_double();
        double w = this.read_double();
        double h = this.read_double();
        String fileName = this.read_safe_word();
        lxObj.setBounds(x, y, w, h);
        return new JDImage(lxObj, fileName);
    }

    private Vector findObjects(String name, Vector objs) {
        int nb = objs.size();
        Vector<JDObject> ret = new Vector<JDObject>();
        for (int i = 0; i < nb; ++i) {
            JDObject obj = (JDObject)objs.get(i);
            if (obj instanceof JDGroup) {
                if (obj.name.equals(name)) {
                    ret.add(obj);
                    continue;
                }
                Vector objs2 = ((JDGroup)obj).getChildren();
                Vector ret2 = this.findObjects(name, objs2);
                ret.addAll(ret2);
                continue;
            }
            boolean found = obj.name.equals(name);
            if (!found) continue;
            ret.add((JDObject)objs.get(i));
        }
        return ret;
    }

    JDObject parseLxGroup(LXObject lxObj) throws IOException {
        JDObject obj;
        Dynamics dyn = this.read_dynamics();
        double x = this.read_double();
        double y = this.read_double();
        double w = this.read_double();
        double h = this.read_double();
        lxObj.setBounds(x, y, w, h);
        Vector<JDObject> objects = new Vector<JDObject>();
        while ((obj = this.parseObject(true)) != null) {
            objects.add(obj);
            obj.translate(lxObj.px, lxObj.py);
        }
        JDGroup ret = new JDGroup(lxObj, objects);
        if (dyn != null) {
            if (dyn.dynClassName.equals("multipleStatesClass")) {
                int min = (int)dyn.dynMinimum;
                int max = (int)dyn.dynMaximum;
                for (int i = min; i <= max; ++i) {
                    String oname = Integer.toString(i);
                    Vector subO = this.findObjects(oname, objects);
                    if (subO.size() == 0) {
                        System.out.println("LXFileLoader.parseLxGroup() : Warning, sub-object '" + oname + "' not found in " + lxObj.name);
                        continue;
                    }
                    JDValueProgram vp = new JDValueProgram(3);
                    vp.addNewEntry();
                    vp.setDefaultMapping("false");
                    vp.setMappingAt(0, "true");
                    vp.setValueAt(0, oname);
                    for (int j = 0; j < subO.size(); ++j) {
                        ((JDObject)subO.get(j)).setVisibilityMapper(vp.copy());
                    }
                }
                ((JDObject)ret).setMinValue(min);
                ((JDObject)ret).setMaxValue(max);
                ((JDObject)ret).setInitValue((int)dyn.dynValue);
                ret.setInteractive(dyn.dynSensitive == 1);
                ret.setValueChangeMode(0);
            } else {
                System.out.println("LXFileLoader.parseLxGroup() : Warning, " + dyn.dynClassName + " not suported.");
            }
        }
        return ret;
    }

    JDObject parseLxEndGroup(LXObject lxObj) throws IOException {
        this.jump_dynamics();
        this.read_double();
        this.read_double();
        this.read_double();
        this.read_double();
        return null;
    }

    JDObject parseObject(boolean inGroup) throws IOException {
        this.jump_space();
        if (this.CurrentChar == '\u0000') {
            return null;
        }
        LXObject lxObj = new LXObject();
        lxObj.parse(this, inGroup);
        switch (lxObj.type) {
            case 0: {
                return this.parseLxPolyline(lxObj);
            }
            case 1: {
                return this.parseLxText(lxObj);
            }
            case 2: {
                return this.parseLxEndGroup(lxObj);
            }
            case 3: {
                return this.parseLxGroup(lxObj);
            }
            case 4: {
                return this.parseLxRectangle(lxObj);
            }
            case 5: {
                return this.parseLxEllipse(lxObj);
            }
            case 6: {
                return this.parseLxLine(lxObj);
            }
            case 11: {
                return this.parseLxImage(lxObj);
            }
            case 13: {
                return this.parseLxPara(lxObj);
            }
        }
        throw new IOException("Object type " + lxObj.type + "not supported");
    }

    Vector parseFile() throws IOException {
        JDObject o;
        Vector<JDObject> objects = new Vector<JDObject>();
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("L3.3")) {
            throw new IOException("Invalid header , Loox V3.3 file or higher required!");
        }
        this.word = this.read_safe_word();
        boolean end = false;
        while (!end) {
            end = this.word.equals("gend");
            if (end) continue;
            this.word = this.read_safe_word();
        }
        while ((o = this.parseObject(false)) != null) {
            objects.add(o);
        }
        return objects;
    }

    public static void main(String[] args) {
        try {
            FileReader fr = new FileReader(args[0]);
            LXFileLoader f = new LXFileLoader(fr);
            f.parseFile();
            fr.close();
        }
        catch (IOException e) {
            System.out.println("Reading of " + args[0] + " failed " + e.getMessage());
            e.printStackTrace();
        }
        System.exit(0);
    }
}

