/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.JLXStyle;
import fr.esrf.tangoatk.widget.util.jdraw.LXFileLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

class LXObject {
    int type;
    String name = "";
    Font font = ATKConstant.labelFont;
    boolean visible = true;
    int userClass = 0;
    Color foreground = Color.BLACK;
    Color background = Color.WHITE;
    int lineWidth = 1;
    int lineStyle = 0;
    int lineArrow = 0;
    int fillStyle = 0;
    int shadowWidth = 0;
    boolean invertShadow = false;
    int arcMode = 0;
    double px = 0.0;
    double py = 0.0;
    Rectangle2D boundRect;
    static Color lastForeground;
    static Color lastBackground;
    static int lastLineWidth;
    static int lastLineStyle;
    static int lastLineArrow;
    static int lastFillStyle;
    static int lastArcMode;
    static Font lastFont;

    LXObject() {
    }

    void setBounds(double x, double y, double w, double h) {
        this.boundRect = new Rectangle2D.Double(x + this.px, y + this.py, w, h);
    }

    boolean toDo(int mask, int i) {
        return (mask & i) == i;
    }

    void parse(LXFileLoader f, boolean inGroup) throws IOException {
        if (!inGroup) {
            f.read_safe_word();
            f.read_int();
            f.read_safe_word();
            this.px = f.read_double();
            this.py = f.read_double();
            f.read_safe_word();
            int traj = f.read_int();
            if (traj != -1) {
                f.read_int();
                f.read_int();
                f.read_int();
                f.read_int();
                f.read_int();
                f.read_int();
            }
            f.read_safe_word();
            f.read_int();
            f.read_int();
            f.read_int();
        }
        f.read_int();
        this.type = f.read_int();
        f.read_int();
        this.userClass = f.read_int();
        f.jump_space();
        if (f.CurrentChar == 'N') {
            f.read_safe_word();
            f.jump_space();
            this.name = f.read_line();
        }
        f.read_int();
        this.visible = f.read_int() == 1;
        f.read_int();
        f.read_safe_word();
        f.jump_space();
        if (f.CurrentChar != '=') {
            int doMask = f.read_int_16();
            if (this.toDo(doMask, 1)) {
                f.read_safe_word();
            }
            if (this.toDo(doMask, 2)) {
                lastForeground = this.foreground = f.read_color();
            }
            if (this.toDo(doMask, 4)) {
                lastBackground = this.background = f.read_color();
            }
            if (this.toDo(doMask, 8)) {
                this.lineWidth = f.read_int() + 1;
                if (this.lineWidth > 6) {
                    this.lineWidth = 0;
                }
                lastLineWidth = this.lineWidth;
            }
            if (this.toDo(doMask, 16)) {
                lastLineStyle = this.lineStyle = JLXStyle.ToJDLineStyle[f.read_int()];
            }
            if (this.toDo(doMask, 32)) {
                lastLineArrow = this.lineArrow = JLXPath.ToJDLineArrow[f.read_int()];
            }
            if (this.toDo(doMask, 64)) {
                this.fillStyle = JLXStyle.ToJDFillStyle[f.read_int()];
                f.read_int();
                lastFillStyle = this.fillStyle;
            }
            if (this.toDo(doMask, 128)) {
                lastArcMode = this.arcMode = f.read_int();
            }
            if (this.toDo(doMask, 256)) {
                lastFont = this.font = f.read_font();
            }
        } else {
            f.read_safe_word();
            this.font = lastFont;
            this.arcMode = lastArcMode;
            this.fillStyle = lastFillStyle;
            this.lineArrow = lastLineArrow;
            this.lineStyle = lastLineStyle;
            this.lineWidth = lastLineWidth;
            this.foreground = lastForeground;
            this.background = lastBackground;
        }
        if (this.fillStyle > 1) {
            this.background = this.foreground;
        }
    }
}

