/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.jdraw.JDEntityNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDNode;

class MemberNode
extends JDNode {
    private String domain;
    private String family;
    private String member;

    MemberNode(String domain, String family, String member) {
        this.domain = domain;
        this.family = family;
        this.member = member;
    }

    @Override
    void populateNode() throws DevFailed {
        String devName = this.domain + "/" + this.family + "/" + this.member;
        try {
            Device ds = DeviceFactory.getInstance().getDevice(devName);
            AttributeInfo[] ai = ds.get_attribute_info();
            for (int i = 0; i < ai.length; ++i) {
                if (ai[i].data_format.value() == 0) {
                    switch (ai[i].data_type) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            this.add(new JDEntityNode(1, devName, "[number scalar]", ai[i].name));
                            break;
                        }
                        case 8: {
                            this.add(new JDEntityNode(1, devName, "[string scalar]", ai[i].name));
                            break;
                        }
                        case 1: {
                            this.add(new JDEntityNode(1, devName, "[boolean scalar]", ai[i].name));
                            break;
                        }
                        default: {
                            this.add(new JDEntityNode(1, devName, "[scalar]", ai[i].name));
                            break;
                        }
                    }
                    continue;
                }
                if (ai[i].data_format.value() == 1) {
                    switch (ai[i].data_type) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            this.add(new JDEntityNode(1, devName, "[number spectrum]", ai[i].name));
                            break;
                        }
                        case 8: {
                            this.add(new JDEntityNode(1, devName, "[string spectrum]", ai[i].name));
                            break;
                        }
                        case 1: {
                            this.add(new JDEntityNode(1, devName, "[boolean spectrum]", ai[i].name));
                            break;
                        }
                        default: {
                            this.add(new JDEntityNode(1, devName, "[spectrum]", ai[i].name));
                            break;
                        }
                    }
                    continue;
                }
                if (ai[i].data_format.value() == 2) {
                    switch (ai[i].data_type) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: {
                            this.add(new JDEntityNode(1, devName, "[number image]", ai[i].name));
                            break;
                        }
                        case 8: {
                            this.add(new JDEntityNode(1, devName, "[string image]", ai[i].name));
                            break;
                        }
                        case 1: {
                            this.add(new JDEntityNode(1, devName, "[boolean image]", ai[i].name));
                            break;
                        }
                        default: {
                            this.add(new JDEntityNode(1, devName, "[image]", ai[i].name));
                            break;
                        }
                    }
                    continue;
                }
                this.add(new JDEntityNode(1, devName, "[unknown]", ai[i].name));
            }
            ai = null;
            CommandInfo[] cmdList = ds.command_list_query();
            for (int i = 0; i < cmdList.length; ++i) {
                this.add(new JDEntityNode(2, devName, "[command]", cmdList[i].cmd_name));
            }
        }
        catch (ConnectionException e) {
            ErrorPane.showErrorMessage(null, devName, (ATKException)((Object)e));
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String toString() {
        return this.member;
    }
}

