/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw.examples;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class BarGraph
extends JFrame {
    JDrawEditor theGraph;
    JDObject graphArea;
    JDAxis graphAxis;
    JDObject[] allBars = new JDObject[8];
    String[] barList = new String[]{"Cell1", "Cell3", "Cell4", "Cell8", "Cell9", "Cell10", "Cell15", "Cell19"};

    public BarGraph() {
        this.theGraph = new JDrawEditor(3);
        try {
            this.theGraph.loadFile("bargraph.jdw");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error loading file", 0);
            System.exit(1);
        }
        this.graphArea = this.getObject("masterView");
        this.graphAxis = (JDAxis)this.getObject("Axis");
        for (int i = 0; i < this.barList.length; ++i) {
            this.allBars[i] = this.getObject(this.barList[i]);
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    for (int i = 0; i < BarGraph.this.barList.length; ++i) {
                        double h = Math.random() / 5.0 - 0.1;
                        BarGraph.this.updateBar(i, h);
                    }
                    BarGraph.this.graphArea.refresh();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        this.theGraph.setAutoZoom(true);
        this.setContentPane(this.theGraph);
        this.setTitle("BarGraph");
    }

    public JDObject getObject(String name) {
        Vector objs = this.theGraph.getObjectsByName(name, false);
        if (objs.size() == 0) {
            System.out.print("Error , no object named '" + name + "' found.");
            System.exit(0);
        } else if (objs.size() > 1) {
            System.out.print("Warning , more than one object having the name : " + name + " found ,getting first...");
        }
        return (JDObject)objs.get(0);
    }

    public void updateBar(int idx, double x) {
        Rectangle gRect = this.graphArea.getBoundRect();
        double y = gRect.y;
        double h = gRect.height;
        double max = this.graphAxis.getMax();
        double min = this.graphAxis.getMin();
        double nPos = (min - x) * h / (max - min) + (y + h);
        this.allBars[idx].moveSummitV(5, nPos);
    }

    public static void main(String[] args) {
        BarGraph bg = new BarGraph();
        ATKGraphicsUtils.centerFrameOnScreen(bg);
        bg.setVisible(true);
    }
}

