/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw.examples;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Interactive
extends JFrame
implements JDValueListener {
    JDrawEditor theGraph;
    JDObject btn1;
    JDObject btn2;
    JDObject checkbox;
    JDLabel textArea;
    String[] lines = new String[]{"", "", ""};

    public Interactive() {
        this.theGraph = new JDrawEditor(3);
        try {
            this.theGraph.loadFile("interactive.jdw");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error loading file", 0);
            System.exit(1);
        }
        this.btn1 = this.getObject("Button1");
        this.btn2 = this.getObject("Button2");
        this.checkbox = this.getObject("Checkbox");
        this.textArea = (JDLabel)this.getObject("textArea");
        this.addText("");
        this.btn1.addValueListener(this);
        this.btn2.addValueListener(this);
        this.checkbox.addValueListener(this);
        this.setContentPane(this.theGraph);
        this.setTitle("Interactive");
    }

    @Override
    public void valueChanged(JDObject src) {
        if (src == this.checkbox) {
            this.addText("Checkbox value changed: " + src.getValue());
            this.textArea.refresh();
        }
    }

    @Override
    public void valueExceedBounds(JDObject src) {
        if (src == this.btn1) {
            this.addText("Button1 pressed.");
        } else if (src == this.btn2) {
            this.addText("Button2 pressed.");
        }
    }

    public JDObject getObject(String name) {
        Vector objs = this.theGraph.getObjectsByName(name, false);
        if (objs.size() == 0) {
            System.out.print("Error , no object named '" + name + "' found.");
            System.exit(0);
        } else if (objs.size() > 1) {
            System.out.print("Warning , more than one object having the name : " + name + " found ,getting first...");
        }
        return (JDObject)objs.get(0);
    }

    public void addText(String s) {
        int i;
        for (i = 0; i < this.lines.length - 1; ++i) {
            this.lines[i] = this.lines[i + 1];
        }
        this.lines[i] = s;
        Object tmp = "";
        for (i = 0; i < this.lines.length; ++i) {
            tmp = (String)tmp + this.lines[i] + "\n";
        }
        this.textArea.setText((String)tmp);
        this.textArea.refresh();
    }

    public static void main(String[] args) {
        Interactive f = new Interactive();
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
    }
}

