/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DChart;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

class GradientPanel
extends JPanel
implements ActionListener {
    private JGL3DChart chart;
    private JGradientEditor gradViewer;
    private JButton gradButton;

    public GradientPanel(JGL3DChart chart) {
        this.chart = chart;
        this.setLayout(null);
        this.gradViewer = new JGradientEditor();
        this.gradViewer.setGradient(chart.getGradient());
        this.gradViewer.setEditable(false);
        this.gradViewer.setToolTipText("Display the image using this colormap");
        this.gradViewer.setBounds(10, 20, 240, 20);
        this.add(this.gradViewer);
        this.gradButton = new JButton();
        this.gradButton.setText("...");
        this.gradButton.setToolTipText("Edit colormap");
        this.gradButton.setMargin(new Insets(0, 0, 0, 0));
        this.gradButton.setBounds(250, 20, 20, 20);
        this.gradButton.addActionListener(this);
        this.add(this.gradButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.gradButton) {
            this.showGradientEditor();
        }
    }

    private void showGradientEditor() {
        Gradient g = JGradientEditor.showDialog(this, this.chart.getGradient());
        if (g != null) {
            this.gradViewer.setGradient(g);
            this.gradViewer.repaint();
            this.chart.setGradient(g);
        }
    }
}

