/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DAxis;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DView;
import fr.esrf.tangoatk.widget.util.jgl3dchart.SettingsFrame;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class JGL3DChart
extends JPanel
implements ActionListener {
    private JGL3DView j3dView;
    private Gradient gColor;
    JGradientViewer gradientViewer;
    private JButton resetRotBtn;
    private JButton rotationYXBtn;
    private JButton rotationYZBtn;
    private JButton rotationXZBtn;
    private JButton autoScaleCameraBtn;
    private JButton zoomBackBtn;
    private JButton settingsBtn;
    private SettingsFrame settingsFrame;

    public JGL3DChart() {
        this.setLayout(new BorderLayout());
        this.j3dView = new JGL3DView(this);
        this.add((Component)this.j3dView, "Center");
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        int[] gColormap = this.gColor.buildColorMap(65536);
        this.j3dView.setColorMap(gColormap);
        this.gradientViewer = new JGradientViewer();
        this.gradientViewer.setGradient(this.gColor);
        this.add((Component)this.gradientViewer, "East");
        JToolBar toolbarPanel = new JToolBar();
        toolbarPanel.setOrientation(0);
        this.resetRotBtn = Utils.createIconButton("jgl3dchart_resetrot", false, "Reset rotation", this);
        toolbarPanel.add(this.resetRotBtn);
        this.rotationYXBtn = Utils.createIconButton("jgl3dchart_rotYX", false, "Align to YX plane", this);
        toolbarPanel.add(this.rotationYXBtn);
        this.rotationYZBtn = Utils.createIconButton("jgl3dchart_rotYZ", false, "Align to YZ plane", this);
        toolbarPanel.add(this.rotationYZBtn);
        this.rotationXZBtn = Utils.createIconButton("jgl3dchart_rotXZ", false, "Align to XZ plane", this);
        toolbarPanel.add(this.rotationXZBtn);
        this.autoScaleCameraBtn = Utils.createIconButton("jgl3dchart_autosccam", false, "Auto scale camera", this);
        toolbarPanel.add(this.autoScaleCameraBtn);
        this.zoomBackBtn = Utils.createIconButton("jgl3dchart_zoomback", false, "Zoom back", this);
        toolbarPanel.add(this.zoomBackBtn);
        this.settingsBtn = Utils.createIconButton("jgl3dchart_settings", false, "Show settings", this);
        toolbarPanel.add(this.settingsBtn);
        this.add((Component)toolbarPanel, "North");
    }

    public void setData(double[][] data) {
        this.j3dView.setData(data);
    }

    public void resetRotation() {
        this.j3dView.resetRotation();
    }

    public void rotateYX() {
        this.j3dView.rotateYX();
    }

    public void rotateYZ() {
        this.j3dView.rotateYZ();
    }

    public void rotateXZ() {
        this.j3dView.rotateXZ();
    }

    public void rotate(double ox, double oy) {
        this.j3dView.rotate(ox, oy);
    }

    public void autoScaleCamera() {
        this.j3dView.autoScaleCameraRequest();
        this.j3dView.display();
    }

    public void setGradient(Gradient g) {
        this.gColor = g;
        int[] gColorMap = g.buildColorMap(65536);
        this.gradientViewer.setGradient(g);
        this.j3dView.setColorMap(gColorMap);
        this.j3dView.computeScale();
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    public JGL3DAxis getXAxis() {
        return this.j3dView.getXAxis();
    }

    public JGL3DAxis getYAxis() {
        return this.j3dView.getYAxis();
    }

    public JGL3DAxis getZAxis() {
        return this.j3dView.getZAxis();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.resetRotBtn) {
            this.resetRotation();
        } else if (src == this.rotationYXBtn) {
            this.rotateYX();
        } else if (src == this.rotationYZBtn) {
            this.rotateYZ();
        } else if (src == this.rotationXZBtn) {
            this.rotateXZ();
        } else if (src == this.autoScaleCameraBtn) {
            this.autoScaleCamera();
        } else if (src == this.zoomBackBtn) {
            this.j3dView.zoomBack();
        } else if (src == this.settingsBtn) {
            this.showSettings();
        }
    }

    public void showSettings() {
        if (this.settingsFrame == null) {
            this.settingsFrame = new SettingsFrame(this);
        }
        this.settingsFrame.setVisible(true);
    }

    public static void main(String[] args) {
        JGL3DChart joglChart = new JGL3DChart();
        double[][] data = new double[500][500];
        for (int x = -250; x < 250; ++x) {
            for (int y = -250; y < 250; ++y) {
                double e1 = (double)((x - 100) * (x - 100)) / 100.0 + (double)((y - 5) * (y - 5)) / 100.0;
                double e2 = (double)((x + 100) * (x + 100)) / 100.0 + (double)((y + 5) * (y + 5)) / 100.0;
                data[x + 250][y + 250] = 150.0 * Math.exp(-e1) - 150.0 * Math.exp(-e2);
            }
        }
        joglChart.setData(data);
        JFrame fr = new JFrame();
        fr.setTitle("JOGL Chart");
        fr.setContentPane(joglChart);
        fr.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(fr);
        fr.setVisible(true);
    }
}

