/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DAxis;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DChart;
import fr.esrf.tangoatk.widget.util.jgl3dchart.LabelInfo;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import fr.esrf.tangoatk.widget.util.jgl3dchart.VERTEX3D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

class JGL3DView
extends GLCanvas
implements GLEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    GLU glu;
    static final int ZOOM_ZY = 1;
    static final int ZOOM_ZX = 2;
    static final int ZOOM_YX = 3;
    static double[] logStep = new double[]{0.301, 0.477, 0.602, 0.699, 0.778, 0.845, 0.903, 0.954};
    private double angleOx = 0.5;
    private double angleOy = 0.785f;
    private double camDist;
    private boolean isDraggingRot;
    private boolean isDraggingZoom;
    private int mX;
    private int mY;
    private int mX2;
    private int mY2;
    private boolean autoScaleCameraRequest;
    private int[] gColormap;
    private JGL3DAxis xAxis;
    private JGL3DAxis yAxis;
    private JGL3DAxis zAxis;
    private double Scmin = 0.0;
    private double Scmax = 100.0;
    private boolean yDataAutoScale;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double zNear = -1.0E100;
    private double zFar = 1.0E100;
    private double[][] data;
    private boolean updateDataRequest;
    private int dataList;
    private JGL3DChart parent;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int zoomAllowedMode = 0;
    private boolean zoomRequest;
    private int zoomMode = 0;

    JGL3DView(JGL3DChart parent) {
        this.parent = parent;
        this.addGLEventListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setPreferredSize(new Dimension(640, 480));
        this.xAxis = new JGL3DAxis(this, 0);
        this.yAxis = new JGL3DAxis(this, 1);
        this.zAxis = new JGL3DAxis(this, 2);
        this.xAxis.setName("Xaxis");
        this.yAxis.setName("Yaxis");
        this.zAxis.setName("Zaxis");
        this.xAxis.setLabelColor(Color.RED);
        this.xAxis.setNameColor(Color.RED);
        this.yAxis.setLabelColor(new Color(0, 128, 0));
        this.yAxis.setNameColor(new Color(0, 128, 0));
        this.zAxis.setLabelColor(Color.BLUE);
        this.zAxis.setNameColor(Color.BLUE);
        this.updateAxisPosition();
        this.autoScaleCameraRequest();
        this.updateDataRequest = false;
        this.zoomRequest = false;
        this.dataList = 0;
        this.yDataAutoScale = true;
    }

    void setColorMap(int[] colormap) {
        this.gColormap = colormap;
    }

    void autoScaleCameraRequest() {
        this.autoScaleCameraRequest = true;
    }

    JGL3DAxis getXAxis() {
        return this.xAxis;
    }

    JGL3DAxis getYAxis() {
        return this.yAxis;
    }

    JGL3DAxis getZAxis() {
        return this.zAxis;
    }

    private void transformBoxSide(GL gl, double x, double y, double z) {
        double[] pos = new double[3];
        Utils.project3D(gl, x, y, z, pos);
        if (pos[0] < this.x0) {
            this.x0 = pos[0];
        }
        if (pos[0] > this.x1) {
            this.x1 = pos[0];
        }
        if (pos[1] < this.y0) {
            this.y0 = pos[1];
        }
        if (pos[1] > this.y1) {
            this.y1 = pos[1];
        }
    }

    private void computeBoundingBoxSide(GL gl) {
        this.x0 = 1.0E100;
        this.y0 = 1.0E100;
        this.x1 = -1.0E100;
        this.y1 = -1.0E100;
        double xMin = this.xAxis.getMin();
        double xMax = this.xAxis.getMax();
        double yMin = this.yAxis.getMin();
        double yMax = this.yAxis.getMax();
        double zMin = this.zAxis.getMin();
        double zMax = this.zAxis.getMax();
        this.transformBoxSide(gl, xMax, yMax, zMax);
        this.transformBoxSide(gl, xMin, yMax, zMax);
        this.transformBoxSide(gl, xMin, yMin, zMax);
        this.transformBoxSide(gl, xMax, yMin, zMax);
        this.transformBoxSide(gl, xMax, yMax, zMin);
        this.transformBoxSide(gl, xMin, yMax, zMin);
        this.transformBoxSide(gl, xMin, yMin, zMin);
        this.transformBoxSide(gl, xMax, yMin, zMin);
    }

    private void transformBoxDepth(GL gl, double x, double y, double z) {
        double[] pos = new double[3];
        Utils.project3D(gl, x, y, z, pos);
        if (pos[2] < this.zNear) {
            this.zNear = pos[2];
        }
        if (pos[2] > this.zFar) {
            this.zFar = pos[2];
        }
    }

    private void computeBoundingBoxDepth(GL gl) {
        this.zNear = 1.0E100;
        this.zFar = -1.0E100;
        double xMin = this.xAxis.getMin();
        double xMax = this.xAxis.getMax();
        double yMin = this.yAxis.getMin();
        double yMax = this.yAxis.getMax();
        double zMin = this.zAxis.getMin();
        double zMax = this.zAxis.getMax();
        this.transformBoxDepth(gl, xMax, yMax, zMax);
        this.transformBoxDepth(gl, xMin, yMax, zMax);
        this.transformBoxDepth(gl, xMin, yMin, zMax);
        this.transformBoxDepth(gl, xMax, yMin, zMax);
        this.transformBoxDepth(gl, xMax, yMax, zMin);
        this.transformBoxDepth(gl, xMin, yMax, zMin);
        this.transformBoxDepth(gl, xMin, yMin, zMin);
        this.transformBoxDepth(gl, xMax, yMin, zMin);
    }

    private void computeOrthographicProj(GL gl) {
        this.updateModelMatrix(gl, this.camDist);
        this.computeBoundingBoxDepth(gl);
        GL2 gl2 = (GL2)gl;
        Dimension d = this.getSize();
        gl2.glMatrixMode(5889);
        gl2.glLoadIdentity();
        gl2.glOrtho(d.width / 2, -d.width / 2, -d.height / 2, d.height / 2, this.zNear * 1.1, this.zFar * 1.1);
    }

    private void autoScaleCamera(GL gl) {
        this.updateModelMatrix(gl, 1.0);
        this.computeBoundingBoxSide(gl);
        Dimension d = this.getSize();
        double camDistx = (double)d.width * 0.8 / (this.x1 - this.x0);
        double camDisty = (double)d.height * 0.8 / (this.y1 - this.y0);
        this.camDist = camDistx > camDisty ? camDisty : camDistx;
        this.updateAxisPosition();
        this.autoScaleCameraRequest = false;
    }

    private void updateAxisPosition() {
        double xMin = this.xAxis.getMin();
        double xMax = this.xAxis.getMax();
        double yMin = this.yAxis.getMin();
        double yMax = this.yAxis.getMax();
        double zMin = this.zAxis.getMin();
        double zMax = this.zAxis.getMax();
        if (this.angleOy < 1.5707963267948966) {
            this.xAxis.setPosition(new VERTEX3D(xMin, yMin, zMin), new VERTEX3D(xMax, yMin, zMin));
        } else {
            this.xAxis.setPosition(new VERTEX3D(xMin, yMin, zMax), new VERTEX3D(xMax, yMin, zMax));
        }
        if (this.angleOx >= 0.5) {
            if (this.angleOy < 1.5707963267948966) {
                this.xAxis.setNormal(new VERTEX3D(0.0, 0.0, -10.0 / this.camDist));
            } else {
                this.xAxis.setNormal(new VERTEX3D(0.0, 0.0, 10.0 / this.camDist));
            }
        } else {
            this.xAxis.setNormal(new VERTEX3D(0.0, -10.0 / this.camDist, 0.0));
        }
        if (this.angleOy < 1.5707963267948966) {
            this.yAxis.setPosition(new VERTEX3D(xMax, yMin, zMin), new VERTEX3D(xMax, yMax, zMin));
        } else {
            this.yAxis.setPosition(new VERTEX3D(xMax, yMin, zMax), new VERTEX3D(xMax, yMax, zMax));
        }
        if (this.angleOy < 1.5707963267948966) {
            if (this.angleOy < 0.7853981633974483) {
                this.yAxis.setNormal(new VERTEX3D(10.0 / this.camDist, 0.0, 0.0));
            } else {
                this.yAxis.setNormal(new VERTEX3D(0.0, 0.0, -10.0 / this.camDist));
            }
        } else if (this.angleOy > 2.356194490192345) {
            this.yAxis.setNormal(new VERTEX3D(10.0 / this.camDist, 0.0, 0.0));
        } else {
            this.yAxis.setNormal(new VERTEX3D(0.0, 0.0, 10.0 / this.camDist));
        }
        this.zAxis.setPosition(new VERTEX3D(xMin, yMin, zMin), new VERTEX3D(xMin, yMin, zMax));
        if (this.angleOx >= 0.5) {
            this.zAxis.setNormal(new VERTEX3D(-10.0 / this.camDist, 0.0, 0.0));
        } else {
            this.zAxis.setNormal(new VERTEX3D(0.0, -10.0 / this.camDist, 0.0));
        }
    }

    void setData(double[][] data) {
        this.data = data;
        this.computeScale();
    }

    private boolean isValid(double f) {
        if (Double.isNaN(f)) {
            return false;
        }
        return !Double.isInfinite(f);
    }

    private void setDefaultRange() {
        if (this.yAxis.getScale() == 0) {
            this.Scmax = 100.0;
            this.Scmin = 0.0;
        } else {
            this.Scmax = 2.0;
            this.Scmin = -1.0;
        }
    }

    void computeScale() {
        if (this.data == null) {
            this.xAxis.setMin(this.xAxis.getMinimum());
            this.xAxis.setMax(this.xAxis.getMaximum());
            this.yAxis.setMin(this.yAxis.getMinimum());
            this.yAxis.setMax(this.yAxis.getMaximum());
            this.zAxis.setMin(this.zAxis.getMinimum());
            this.zAxis.setMax(this.zAxis.getMaximum());
            this.repaint();
            return;
        }
        if (this.data.length > 2 && this.data[0].length > 2) {
            double xGain = this.xAxis.getGainTransform();
            double xOff = this.xAxis.getOffsetTransform();
            double yGain = this.yAxis.getGainTransform();
            double yOff = this.yAxis.getOffsetTransform();
            double zGain = this.zAxis.getGainTransform();
            double zOff = this.zAxis.getOffsetTransform();
            boolean yRangeOK = false;
            this.Scmin = Double.MAX_VALUE;
            this.Scmax = -1.7976931348623157E308;
            if (!this.yDataAutoScale) {
                this.setDefaultRange();
            }
            if (this.yDataAutoScale) {
                for (int x = 0; x < this.data.length - 1; ++x) {
                    for (int z = 0; z < this.data[x].length - 1; ++z) {
                        double v = this.yAxis.getScale() == 0 ? this.data[x][z] + yOff : Math.log10(this.data[x][z]) + yOff;
                        if (!this.isValid(v)) continue;
                        if (v < this.Scmin) {
                            this.Scmin = v;
                        }
                        if (v > this.Scmax) {
                            this.Scmax = v;
                        }
                        yRangeOK = true;
                    }
                }
            }
            if (yRangeOK) {
                if (this.Scmax - this.Scmin < 1.0E-100) {
                    this.Scmax += 0.999;
                    this.Scmin -= 0.999;
                }
            } else {
                this.setDefaultRange();
            }
            switch (this.zoomMode) {
                case 1: {
                    if (this.xAxis.isAutoScale()) {
                        if (xGain < 0.0) {
                            this.xAxis.setMin(xGain * (double)this.data.length + xOff);
                            this.xAxis.setMax(xOff);
                            break;
                        }
                        this.xAxis.setMin(xOff);
                        this.xAxis.setMax(xGain * (double)this.data.length + xOff);
                        break;
                    }
                    this.xAxis.setMin(this.xAxis.getMinimum());
                    this.xAxis.setMax(this.xAxis.getMaximum());
                    break;
                }
                case 2: {
                    if (this.yAxis.isAutoScale()) {
                        this.yAxis.setMin(this.Scmin);
                        this.yAxis.setMax(this.Scmax);
                        break;
                    }
                    this.yAxis.setMin(this.yAxis.getMinimum());
                    this.yAxis.setMax(this.yAxis.getMaximum());
                    break;
                }
                case 3: {
                    if (this.zAxis.isAutoScale()) {
                        if (zGain < 0.0) {
                            this.zAxis.setMin(zGain * (double)this.data[0].length + zOff);
                            this.zAxis.setMax(zOff);
                            break;
                        }
                        this.zAxis.setMin(zOff);
                        this.zAxis.setMax(zGain * (double)this.data[0].length + zOff);
                        break;
                    }
                    this.zAxis.setMin(this.zAxis.getMinimum());
                    this.zAxis.setMax(this.zAxis.getMaximum());
                    break;
                }
                default: {
                    if (this.xAxis.isAutoScale()) {
                        if (xGain < 0.0) {
                            this.xAxis.setMin(xGain * (double)this.data.length + xOff);
                            this.xAxis.setMax(xOff);
                        } else {
                            this.xAxis.setMin(xOff);
                            this.xAxis.setMax(xGain * (double)this.data.length + xOff);
                        }
                    } else {
                        this.xAxis.setMin(this.xAxis.getMinimum());
                        this.xAxis.setMax(this.xAxis.getMaximum());
                    }
                    if (this.yAxis.isAutoScale()) {
                        this.yAxis.setMin(this.Scmin);
                        this.yAxis.setMax(this.Scmax);
                    } else {
                        if (this.yAxis.getScale() == 0) {
                            this.Scmin = this.yAxis.getMinimum();
                            this.Scmax = this.yAxis.getMaximum();
                        } else {
                            double yMin = Math.log10(this.yAxis.getMinimum());
                            double yMax = Math.log10(this.yAxis.getMaximum());
                            if (this.isValid(yMin) && this.isValid(yMax)) {
                                this.Scmin = yMin;
                                this.Scmax = yMax;
                            } else {
                                this.setDefaultRange();
                            }
                        }
                        this.yAxis.setMin(this.Scmin);
                        this.yAxis.setMax(this.Scmax);
                    }
                    if (this.zAxis.isAutoScale()) {
                        if (zGain < 0.0) {
                            this.zAxis.setMin(zGain * (double)this.data[0].length + zOff);
                            this.zAxis.setMax(zOff);
                            break;
                        }
                        this.zAxis.setMin(zOff);
                        this.zAxis.setMax(zGain * (double)this.data[0].length + zOff);
                        break;
                    }
                    this.zAxis.setMin(this.zAxis.getMinimum());
                    this.zAxis.setMax(this.zAxis.getMaximum());
                }
            }
            this.updateAxisPosition();
            if (this.yAxis.getScale() == 0) {
                this.parent.gradientViewer.getAxis().setMinimum(this.Scmin);
                this.parent.gradientViewer.getAxis().setMaximum(this.Scmax);
            } else {
                this.parent.gradientViewer.getAxis().setMinimum(Math.pow(10.0, this.Scmin));
                this.parent.gradientViewer.getAxis().setMaximum(Math.pow(10.0, this.Scmax));
            }
            this.parent.revalidate();
            this.parent.repaint();
        }
        this.updateDataRequest = true;
    }

    void zoomBack() {
        if (this.zoomMode != 0) {
            this.zoomMode = 0;
            this.computeScale();
            this.repaint();
        }
    }

    private void getColor(double data, double min, double max, float[] rgb) {
        double c = (data - min) / (max - min) * 65536.0;
        if (c < 0.0) {
            c = 0.0;
        }
        if (c > 65535.0) {
            c = 65535.0;
        }
        rgb[0] = (float)((this.gColormap[(int)c] & 0xFF0000) >> 16) / 256.0f;
        rgb[1] = (float)((this.gColormap[(int)c] & 0xFF00) >> 8) / 256.0f;
        rgb[2] = (float)(this.gColormap[(int)c] & 0xFF) / 256.0f;
    }

    private void buildDataList(GL gl) {
        if (this.data == null) {
            return;
        }
        GL2 gl2 = (GL2)gl;
        if (this.dataList != 0) {
            gl2.glDeleteLists(this.dataList, 1);
        }
        this.dataList = 0;
        if (this.data.length > 2 && this.data[0].length > 2) {
            double xGain = this.xAxis.getGainTransform();
            double xOff = this.xAxis.getOffsetTransform();
            double yGain = this.yAxis.getGainTransform();
            double yOff = this.yAxis.getOffsetTransform();
            double zGain = this.zAxis.getGainTransform();
            double zOff = this.zAxis.getOffsetTransform();
            this.dataList = gl2.glGenLists(1);
            gl2.glNewList(this.dataList, 4864);
            gl2.glBegin(4);
            float[] rgb = new float[3];
            int scale = this.yAxis.getScale();
            for (int x = 0; x < this.data.length - 1; ++x) {
                for (int z = 0; z < this.data[x].length - 1; ++z) {
                    float x00 = (float)(xGain * (double)x + xOff);
                    float z00 = (float)(zGain * (double)z + zOff);
                    float x01 = x00;
                    float z01 = (float)(zGain * ((double)z + 1.0) + zOff);
                    float x10 = (float)(xGain * ((double)x + 1.0) + xOff);
                    float z10 = z00;
                    float x11 = x10;
                    float z11 = z01;
                    if (!((double)x00 >= this.xAxis.getMin()) || !((double)x10 <= this.xAxis.getMax()) || !((double)z00 >= this.zAxis.getMin()) || !((double)z01 <= this.zAxis.getMax()) || !this.isValid(this.data[x][z]) || !this.isValid(this.data[x + 1][z]) || !this.isValid(this.data[x][z + 1]) || !this.isValid(this.data[x + 1][z + 1])) continue;
                    float y00 = scale == 1 ? (float)(yGain * Math.log10(this.data[x][z]) + yOff) : (float)(yGain * this.data[x][z] + yOff);
                    float y01 = scale == 1 ? (float)(yGain * Math.log10(this.data[x][z + 1]) + yOff) : (float)(yGain * this.data[x][z + 1] + yOff);
                    float y10 = scale == 1 ? (float)(yGain * Math.log10(this.data[x + 1][z]) + yOff) : (float)(yGain * this.data[x + 1][z] + yOff);
                    float y11 = scale == 1 ? (float)(yGain * Math.log10(this.data[x + 1][z + 1]) + yOff) : (float)(yGain * this.data[x + 1][z + 1] + yOff);
                    this.getColor(y00, this.Scmin * yGain, this.Scmax * yGain, rgb);
                    gl2.glColor3f(rgb[0], rgb[1], rgb[2]);
                    gl2.glVertex3f(x00, y00, z00);
                    this.getColor(y01, this.Scmin * yGain, this.Scmax * yGain, rgb);
                    gl2.glColor3f(rgb[0], rgb[1], rgb[2]);
                    gl2.glVertex3f(x01, y01, z01);
                    this.getColor(y10, this.Scmin * yGain, this.Scmax * yGain, rgb);
                    gl2.glColor3f(rgb[0], rgb[1], rgb[2]);
                    gl2.glVertex3f(x10, y10, z10);
                    this.getColor(y01, this.Scmin * yGain, this.Scmax * yGain, rgb);
                    gl2.glColor3f(rgb[0], rgb[1], rgb[2]);
                    gl2.glVertex3f(x01, y01, z01);
                    this.getColor(y11, this.Scmin * yGain, this.Scmax * yGain, rgb);
                    gl2.glColor3f(rgb[0], rgb[1], rgb[2]);
                    gl2.glVertex3f(x11, y11, z11);
                    this.getColor(y10, this.Scmin * yGain, this.Scmax * yGain, rgb);
                    gl2.glColor3f(rgb[0], rgb[1], rgb[2]);
                    gl2.glVertex3f(x10, y10, z10);
                }
            }
            gl2.glEnd();
            gl2.glEndList();
        }
    }

    private void manageZoom(GL gl) {
        double[] _coords = new double[3];
        double[] _coords2 = new double[3];
        switch (this.zoomAllowedMode) {
            case 1: {
                Utils.unproject(this.glu, gl, this.mX, this.mY, 0.0, _coords);
                Utils.unproject(this.glu, gl, this.mX2, this.mY2, 0.0, _coords2);
                if (_coords[1] > _coords2[1]) {
                    this.yAxis.setMax(_coords[1]);
                    this.yAxis.setMin(_coords2[1]);
                } else {
                    this.yAxis.setMax(_coords2[1]);
                    this.yAxis.setMin(_coords[1]);
                }
                if (_coords[2] > _coords2[2]) {
                    this.zAxis.setMax(_coords[2]);
                    this.zAxis.setMin(_coords2[2]);
                } else {
                    this.zAxis.setMax(_coords2[2]);
                    this.zAxis.setMin(_coords[2]);
                }
                this.updateAxisPosition();
                this.buildDataList(gl);
                this.repaint();
                this.zoomMode = this.zoomAllowedMode;
                break;
            }
            case 2: {
                Utils.unproject(this.glu, gl, this.mX, this.mY, 0.0, _coords);
                Utils.unproject(this.glu, gl, this.mX2, this.mY2, 0.0, _coords2);
                if (_coords[0] > _coords2[0]) {
                    this.xAxis.setMax(_coords[0]);
                    this.xAxis.setMin(_coords2[0]);
                } else {
                    this.xAxis.setMax(_coords2[0]);
                    this.xAxis.setMin(_coords[0]);
                }
                if (_coords[2] > _coords2[2]) {
                    this.zAxis.setMax(_coords[2]);
                    this.zAxis.setMin(_coords2[2]);
                } else {
                    this.zAxis.setMax(_coords2[2]);
                    this.zAxis.setMin(_coords[2]);
                }
                this.updateAxisPosition();
                this.buildDataList(gl);
                this.repaint();
                this.zoomMode = this.zoomAllowedMode;
                break;
            }
            case 3: {
                Utils.unproject(this.glu, gl, this.mX, this.mY, 0.0, _coords);
                Utils.unproject(this.glu, gl, this.mX2, this.mY2, 0.0, _coords2);
                if (_coords[0] > _coords2[0]) {
                    this.xAxis.setMax(_coords[0]);
                    this.xAxis.setMin(_coords2[0]);
                } else {
                    this.xAxis.setMax(_coords2[0]);
                    this.xAxis.setMin(_coords[0]);
                }
                if (_coords[1] > _coords2[1]) {
                    this.yAxis.setMax(_coords[1]);
                    this.yAxis.setMin(_coords2[1]);
                } else {
                    this.yAxis.setMax(_coords2[1]);
                    this.yAxis.setMin(_coords[1]);
                }
                this.updateAxisPosition();
                this.buildDataList(gl);
                this.repaint();
                this.zoomMode = this.zoomAllowedMode;
            }
        }
    }

    @Override
    public void init(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        this.glu = GLU.createGLU(gl);
        gl.glClearColor(0.9f, 0.9f, 0.9f, 0.0f);
        gl.glClearDepth(0.0);
        gl.glDepthFunc(518);
        gl.glEnable(2929);
        gl.glDisable(2884);
        gl.glDisable(2896);
        gl.glDisable(3553);
    }

    @Override
    public void dispose(GLAutoDrawable glautodrawable) {
    }

    @Override
    public void display(GLAutoDrawable glDrawable) {
        LabelInfo li;
        int i;
        LabelInfo li2;
        int i2;
        GL2 gl = (GL2)glDrawable.getGL();
        double xMin = this.xAxis.getMin();
        double xMax = this.xAxis.getMax();
        double yMin = this.yAxis.getMin();
        double yMax = this.yAxis.getMax();
        double zMin = this.zAxis.getMin();
        double zMax = this.zAxis.getMax();
        if (this.autoScaleCameraRequest) {
            this.autoScaleCamera(gl);
        }
        this.computeOrthographicProj(gl);
        this.updateModelMatrix(gl, this.camDist);
        gl.glClear(16384);
        gl.glClear(256);
        gl.glDisable(2929);
        gl.glDisable(12288);
        gl.glDisable(12289);
        gl.glBegin(7);
        gl.glColor3f(0.8f, 0.8f, 0.8f);
        gl.glVertex3f((float)xMax, (float)yMin, (float)zMin);
        gl.glVertex3f((float)xMax, (float)yMin, (float)zMax);
        gl.glVertex3f((float)xMax, (float)yMax, (float)zMax);
        gl.glVertex3f((float)xMax, (float)yMax, (float)zMin);
        gl.glColor3f(0.91f, 0.91f, 0.91f);
        gl.glVertex3f((float)xMin, (float)yMin, (float)zMin);
        gl.glVertex3f((float)xMin, (float)yMin, (float)zMax);
        gl.glVertex3f((float)xMax, (float)yMin, (float)zMax);
        gl.glVertex3f((float)xMax, (float)yMin, (float)zMin);
        gl.glColor3f(0.85f, 0.85f, 0.85f);
        if (this.angleOy < 1.5707963267948966) {
            gl.glVertex3f((float)xMin, (float)yMin, (float)zMax);
            gl.glVertex3f((float)xMin, (float)yMax, (float)zMax);
            gl.glVertex3f((float)xMax, (float)yMax, (float)zMax);
            gl.glVertex3f((float)xMax, (float)yMin, (float)zMax);
        } else {
            gl.glVertex3f((float)xMin, (float)yMin, (float)zMin);
            gl.glVertex3f((float)xMin, (float)yMax, (float)zMin);
            gl.glVertex3f((float)xMax, (float)yMax, (float)zMin);
            gl.glVertex3f((float)xMax, (float)yMin, (float)zMin);
        }
        gl.glEnd();
        this.xAxis.measureAxis(this.glu, gl);
        this.xAxis.paintAxis(gl);
        this.yAxis.measureAxis(this.glu, gl);
        this.yAxis.paintAxis(gl);
        this.zAxis.measureAxis(this.glu, gl);
        this.zAxis.paintAxis(gl);
        short pattern = 3855;
        gl.glLineStipple(1, pattern);
        gl.glEnable(2852);
        gl.glBegin(1);
        for (i2 = 0; i2 < this.yAxis.labelInfo.size(); ++i2) {
            li2 = this.yAxis.labelInfo.get(i2);
            gl.glColor3f(0.5f, 0.5f, 0.5f);
            gl.glVertex3f((float)xMax, (float)li2.p1.y, (float)zMin);
            gl.glVertex3f((float)xMax, (float)li2.p1.y, (float)zMax);
            if (this.yAxis.getScale() != 1 || i2 >= this.yAxis.labelInfo.size() - 1) continue;
            LabelInfo li22 = this.yAxis.labelInfo.get(i2 + 1);
            double step = li22.p1.y - li2.p1.y;
            for (int j = 0; j < logStep.length; ++j) {
                gl.glColor3f(0.7f, 0.7f, 0.7f);
                gl.glVertex3f((float)xMax, (float)(li2.p1.y + step * logStep[j]), (float)zMin);
                gl.glVertex3f((float)xMax, (float)(li2.p1.y + step * logStep[j]), (float)zMax);
            }
        }
        gl.glColor3f(0.5f, 0.5f, 0.5f);
        for (i2 = 0; i2 < this.zAxis.labelInfo.size(); ++i2) {
            li2 = this.zAxis.labelInfo.get(i2);
            gl.glVertex3f((float)xMax, (float)yMin, (float)li2.p1.z);
            gl.glVertex3f((float)xMax, (float)yMax, (float)li2.p1.z);
        }
        for (i2 = 0; i2 < this.xAxis.labelInfo.size(); ++i2) {
            li2 = this.xAxis.labelInfo.get(i2);
            gl.glVertex3f((float)li2.p1.x, (float)yMin, (float)zMin);
            gl.glVertex3f((float)li2.p1.x, (float)yMin, (float)zMax);
        }
        for (i2 = 0; i2 < this.zAxis.labelInfo.size(); ++i2) {
            li2 = this.zAxis.labelInfo.get(i2);
            gl.glVertex3f((float)xMin, (float)yMin, (float)li2.p1.z);
            gl.glVertex3f((float)xMax, (float)yMin, (float)li2.p1.z);
        }
        float zEnd = this.angleOy < 1.5707963267948966 ? (float)zMax : (float)zMin;
        for (i = 0; i < this.yAxis.labelInfo.size(); ++i) {
            li = this.yAxis.labelInfo.get(i);
            gl.glColor3f(0.5f, 0.5f, 0.5f);
            gl.glVertex3f((float)xMin, (float)li.p1.y, zEnd);
            gl.glVertex3f((float)xMax, (float)li.p1.y, zEnd);
            if (this.yAxis.getScale() != 1 || i >= this.yAxis.labelInfo.size() - 1) continue;
            LabelInfo li23 = this.yAxis.labelInfo.get(i + 1);
            double step = li23.p1.y - li.p1.y;
            for (int j = 0; j < logStep.length; ++j) {
                gl.glColor3f(0.7f, 0.7f, 0.7f);
                gl.glVertex3f((float)xMin, (float)(li.p1.y + step * logStep[j]), zEnd);
                gl.glVertex3f((float)xMax, (float)(li.p1.y + step * logStep[j]), zEnd);
            }
        }
        gl.glColor3f(0.5f, 0.5f, 0.5f);
        for (i = 0; i < this.xAxis.labelInfo.size(); ++i) {
            li = this.xAxis.labelInfo.get(i);
            gl.glVertex3f((float)li.p1.x, (float)yMin, zEnd);
            gl.glVertex3f((float)li.p1.x, (float)yMax, zEnd);
        }
        gl.glEnd();
        if (this.updateDataRequest) {
            this.buildDataList(gl);
            this.updateDataRequest = false;
        }
        if (this.dataList > 0) {
            gl.glEnable(12288);
            gl.glEnable(12289);
            double[] pMin = new double[]{0.0, 1.0, 0.0, -yMin};
            gl.glClipPlane(12288, pMin, 0);
            double[] pMax = new double[]{0.0, -1.0, 0.0, yMax};
            gl.glClipPlane(12289, pMax, 0);
            gl.glEnable(2929);
            gl.glCallList(this.dataList);
        }
        gl.glDisable(2929);
        gl.glDisable(12288);
        gl.glDisable(12289);
        Dimension d = this.getSize();
        LabelInfo.textRenderer.beginRendering(d.width, d.height);
        LabelInfo.textRenderer.setSmoothing(true);
        this.xAxis.paintAxisLabel(gl, d.width, d.height);
        this.yAxis.paintAxisLabel(gl, d.width, d.height);
        this.zAxis.paintAxisLabel(gl, d.width, d.height);
        LabelInfo.textRenderer.endRendering();
        if (this.zoomRequest) {
            this.manageZoom(gl);
            this.autoScaleCameraRequest = true;
            this.zoomRequest = false;
        }
    }

    @Override
    public void reshape(GLAutoDrawable glDrawable, int x, int y, int width, int height) {
        if (this.lastWidth != width || this.lastHeight != height) {
            GL gl = glDrawable.getGL();
            this.computeOrthographicProj(gl);
            this.updateDataRequest = true;
            this.lastWidth = width;
            this.lastHeight = height;
        }
    }

    public void displayChanged(GLAutoDrawable glDrawable, boolean modeChanged, boolean deviceChanged) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.camDist = e.getWheelRotation() < 0 ? (this.camDist *= 0.95) : (this.camDist *= 1.05);
        this.updateAxisPosition();
        this.display();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.isControlDown()) {
                this.isDraggingZoom = this.zoomAllowedMode != 0;
            } else {
                this.isDraggingRot = true;
            }
            this.mX = e.getX();
            this.mY = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDraggingRot = false;
        if (this.isDraggingZoom) {
            this.zoomRequest = true;
            this.isDraggingZoom = false;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isDraggingRot) {
            double dx = (double)(this.mX - e.getX()) * 0.02;
            double dy = (double)(this.mY - e.getY()) * 0.02;
            this.mX = e.getX();
            this.mY = e.getY();
            this.angleOx -= dy;
            this.angleOy += dx;
            if (this.angleOx < 0.0) {
                this.angleOx = 0.0;
            }
            if (this.angleOx > 1.5707963267948966) {
                this.angleOx = 1.5707963267948966;
            }
            if (this.angleOy < 0.0) {
                this.angleOy = 0.0;
            }
            if (this.angleOy > Math.PI) {
                this.angleOy = Math.PI;
            }
            this.updateAxisPosition();
            this.display();
            this.zoomAllowedMode = 0;
        }
        if (this.isDraggingZoom) {
            this.mX2 = e.getX();
            this.mY2 = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void resetRotation() {
        this.angleOx = 0.5;
        this.angleOy = 0.785f;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 0;
    }

    void rotateYX() {
        this.angleOx = 0.0;
        this.angleOy = Math.PI;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 3;
    }

    void rotateYZ() {
        this.angleOx = 0.0;
        this.angleOy = 1.5707963267948966;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 1;
    }

    void rotateXZ() {
        this.angleOx = 1.5707963267948966;
        this.angleOy = 1.5707963267948966;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 2;
    }

    void rotate(double ox, double oy) {
        this.angleOx = ox;
        this.angleOy = oy;
        if (this.angleOx < 0.0) {
            this.angleOx = 0.0;
        }
        if (this.angleOx > 1.5707963267948966) {
            this.angleOx = 1.5707963267948966;
        }
        if (this.angleOy < 0.0) {
            this.angleOy = 0.0;
        }
        if (this.angleOy > Math.PI) {
            this.angleOy = Math.PI;
        }
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 0;
    }

    private Rectangle buildZoomRect() {
        Rectangle r = new Rectangle();
        if (this.mX < this.mX2) {
            if (this.mY < this.mY2) {
                r.setRect(this.mX, this.mY, this.mX2 - this.mX, this.mY2 - this.mY);
            } else {
                r.setRect(this.mX, this.mY2, this.mX2 - this.mX, this.mY - this.mY2);
            }
        } else if (this.mY < this.mY2) {
            r.setRect(this.mX2, this.mY, this.mX - this.mX2, this.mY2 - this.mY);
        } else {
            r.setRect(this.mX2, this.mY2, this.mX - this.mX2, this.mY - this.mY2);
        }
        return r;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isDraggingZoom) {
            g.setColor(Color.WHITE);
            Rectangle zRect = this.buildZoomRect();
            g.drawRect(zRect.x, zRect.y, zRect.width, zRect.height);
        }
    }

    private void updateModelMatrix(GL gl, double scale) {
        this.angleOx = Utils.RoundAngle(this.angleOx);
        this.angleOy = Utils.RoundAngle(this.angleOy);
        VERTEX3D center = new VERTEX3D();
        center.x = (this.xAxis.getMax() + this.xAxis.getMin()) / 2.0;
        center.y = (this.yAxis.getMax() + this.yAxis.getMin()) / 2.0;
        center.z = (this.zAxis.getMax() + this.zAxis.getMin()) / 2.0;
        GL2 gl2 = (GL2)gl;
        gl2.glMatrixMode(5888);
        gl2.glLoadIdentity();
        gl2.glScaled(scale, scale, scale);
        gl2.glRotated(-Utils.ToDeg(this.angleOx), 1.0, 0.0, 0.0);
        gl2.glRotated(-Utils.ToDeg(this.angleOy), 0.0, 1.0, 0.0);
        gl2.glTranslated(-center.x, -center.y, -center.z);
    }
}

