/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import fr.esrf.tangoatk.widget.util.jgl3dchart.VERTEX3D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class Utils {
    private static Class theClass = null;
    private static Insets bMargin = new Insets(3, 3, 3, 3);
    static final Color fColor = new Color(99, 97, 156);
    static final Insets zInset = new Insets(0, 0, 0, 0);
    static final Font labelFont = new Font("Dialog", 0, 12);
    static final Font labelbFont = new Font("Dialog", 1, 12);

    private static void init() {
        if (theClass == null) {
            String className = "fr.esrf.tangoatk.widget.util.jgl3dchart.Utils";
            try {
                theClass = Class.forName(className);
            }
            catch (Exception e) {
                System.out.println("Utils.init() Class not found: " + className);
            }
        }
    }

    static VERTEX3D Cross(VERTEX3D v1, VERTEX3D v2) {
        VERTEX3D result = new VERTEX3D();
        result.x = v1.y * v2.z - v1.z * v2.y;
        result.y = v1.z * v2.x - v1.x * v2.z;
        result.z = v1.x * v2.y - v1.y * v2.x;
        return result;
    }

    static double RoundAngle(double a) {
        double r;
        for (r = a; r < -Math.PI; r += Math.PI * 2) {
        }
        while (r > Math.PI) {
            r -= Math.PI * 2;
        }
        return r;
    }

    static double ToDeg(double radians) {
        return radians / Math.PI * 180.0;
    }

    public static void project(GLU glu, GL gl, double x, double y, double z, double[] _2dcoord) {
        int[] viewport = new int[4];
        double[] mvmatrix = new double[16];
        double[] projmatrix = new double[16];
        double[] wcoord = new double[4];
        GL2 gl2 = (GL2)gl;
        gl2.glGetIntegerv(2978, viewport, 0);
        gl2.glGetDoublev(2982, mvmatrix, 0);
        gl2.glGetDoublev(2983, projmatrix, 0);
        glu.gluProject(x, y, z, mvmatrix, 0, projmatrix, 0, viewport, 0, wcoord, 0);
        _2dcoord[0] = wcoord[0];
        _2dcoord[1] = (double)viewport[3] - wcoord[1] - 1.0;
    }

    public static void unproject(GLU glu, GL gl, double x, double y, double z, double[] _3dcoord) {
        int[] viewport = new int[4];
        double[] mvmatrix = new double[16];
        double[] projmatrix = new double[16];
        double[] wcoord = new double[4];
        GL2 gl2 = (GL2)gl;
        gl2.glGetIntegerv(2978, viewport, 0);
        gl2.glGetDoublev(2982, mvmatrix, 0);
        gl2.glGetDoublev(2983, projmatrix, 0);
        double realy = viewport[3] - (int)y - 1;
        glu.gluUnProject(x, realy, z, mvmatrix, 0, projmatrix, 0, viewport, 0, wcoord, 0);
        _3dcoord[0] = wcoord[0];
        _3dcoord[1] = wcoord[1];
        _3dcoord[2] = wcoord[2];
    }

    public static void project3D(GL gl, double x, double y, double z, double[] _3dcoord) {
        GL2 gl2 = (GL2)gl;
        double[] mvmatrix = new double[16];
        gl2.glGetDoublev(2982, mvmatrix, 0);
        _3dcoord[0] = x * mvmatrix[0] + y * mvmatrix[4] + z * mvmatrix[8] + mvmatrix[12];
        _3dcoord[1] = x * mvmatrix[1] + y * mvmatrix[5] + z * mvmatrix[9] + mvmatrix[13];
        _3dcoord[2] = x * mvmatrix[2] + y * mvmatrix[6] + z * mvmatrix[10] + mvmatrix[14];
    }

    public static JButton createIconButton(String name, boolean hasDisa, String tipText, ActionListener l) {
        Utils.init();
        if (theClass != null) {
            JButton nB = new JButton(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jgl3dchart/gif/" + name + ".gif")));
            nB.setPressedIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jgl3dchart/gif/" + name + "_push.gif")));
            if (hasDisa) {
                nB.setDisabledIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jgl3dchart/gif/" + name + "_disa.gif")));
            }
            nB.setToolTipText(tipText);
            nB.setMargin(bMargin);
            nB.setBorder(null);
            nB.addActionListener(l);
            return nB;
        }
        return new JButton(name);
    }

    public static Border createTitleBorder(String name) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name, 1, 0, labelbFont, fColor);
    }
}

