/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.io.DragAndDropHandler;
import ij.macro.Interpreter;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;

public class OpenDialog {
    private String dir;
    private String name;
    private boolean recordPath;
    private static String defaultDirectory;
    private static Frame sharedFrame;
    private String title;
    private static String lastDir;
    private static String lastName;
    private static boolean defaultDirectorySet;

    public OpenDialog(String title) {
        this(title, null);
    }

    public OpenDialog(String title, String path) {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && (path == null || path.equals(""))) {
            if ((path = Macro.getValue(macroOptions, title, path)) == null || path.equals("")) {
                path = Macro.getValue(macroOptions, "path", path);
            }
            if ((path == null || path.equals("")) && title != null && title.equals("Open As String")) {
                path = Macro.getValue(macroOptions, "OpenAsString", path);
            }
            path = OpenDialog.lookupPathVariable(path);
        }
        if (path == null || path.equals("")) {
            if (Prefs.useJFileChooser) {
                this.jOpen(title, OpenDialog.getDefaultDirectory(), null);
            } else {
                this.open(title, OpenDialog.getDefaultDirectory(), null);
            }
            if (this.name != null) {
                OpenDialog.setDefaultDirectory(this.dir);
            }
            this.title = title;
            this.recordPath = true;
        } else {
            this.decodePath(path);
            this.recordPath = IJ.macroRunning();
        }
        IJ.register(OpenDialog.class);
    }

    public OpenDialog(String title, String defaultDir, String defaultName) {
        String path = null;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            path = Macro.getValue(macroOptions, title, path);
        }
        if (path != null) {
            this.decodePath(path);
        } else {
            if (Prefs.useJFileChooser) {
                this.jOpen(title, defaultDir, defaultName);
            } else {
                this.open(title, defaultDir, defaultName);
            }
            this.title = title;
            this.recordPath = true;
        }
    }

    public static String lookupPathVariable(String path) {
        if (path != null && path.indexOf(".") == -1 && !new File(path).exists()) {
            Interpreter interp;
            String path2;
            if (path.startsWith("&")) {
                path = path.substring(1);
            }
            String string = path2 = (interp = Interpreter.getInstance()) != null ? interp.getStringVariable(path) : null;
            if (path2 != null) {
                path = path2;
            }
        }
        return path;
    }

    void jOpen(String title, String path, String fileName) {
        LookAndFeel saveLookAndFeel = Java2.getLookAndFeel();
        Java2.setSystemLookAndFeel();
        if (EventQueue.isDispatchThread()) {
            this.jOpenDispatchThread(title, path, fileName);
        } else {
            this.jOpenInvokeAndWait(title, path, fileName);
        }
        Java2.setLookAndFeel(saveLookAndFeel);
    }

    void jOpenDispatchThread(String title, String path, String fileName) {
        int returnVal;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        fc.setDragEnabled(true);
        fc.setTransferHandler(new DragAndDropHandler(fc));
        File fdir = null;
        if (path != null) {
            fdir = new File(path);
        }
        if (fdir != null) {
            fc.setCurrentDirectory(fdir);
        }
        if (fileName != null) {
            fc.setSelectedFile(new File(fileName));
        }
        if ((returnVal = fc.showOpenDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File file = fc.getSelectedFile();
        if (file == null) {
            Macro.abort();
            return;
        }
        this.name = file.getName();
        this.dir = fc.getCurrentDirectory().getPath() + File.separator;
    }

    void jOpenInvokeAndWait(final String title, final String path, final String fileName) {
        final boolean isMacro = Thread.currentThread().getName().endsWith("Macro$");
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int returnVal;
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(title);
                    fc.setDragEnabled(true);
                    fc.setTransferHandler(new DragAndDropHandler(fc));
                    File fdir = null;
                    if (path != null) {
                        fdir = new File(path);
                    }
                    if (fdir != null) {
                        fc.setCurrentDirectory(fdir);
                    }
                    if (fileName != null) {
                        fc.setSelectedFile(new File(fileName));
                    }
                    if ((returnVal = fc.showOpenDialog(IJ.getInstance())) != 0 && isMacro) {
                        Interpreter.abort();
                        return;
                    }
                    File file = fc.getSelectedFile();
                    if (file == null && isMacro) {
                        Interpreter.abort();
                        return;
                    }
                    OpenDialog.this.name = file.getName();
                    OpenDialog.this.dir = fc.getCurrentDirectory().getPath() + File.separator;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void open(String title, String path, String fileName) {
        Frame parent = IJ.getInstance();
        if (parent == null) {
            if (sharedFrame == null) {
                sharedFrame = new Frame();
            }
            parent = sharedFrame;
        }
        if (IJ.isMacOSX() && IJ.isJava18()) {
            ImageJ ij = IJ.getInstance();
            parent = ij != null && ij.isActive() ? ij : null;
        }
        FileDialog fd = new FileDialog(parent, title);
        if (path != null) {
            if (IJ.isWindows() && path.contains("/")) {
                path = path.replaceAll("/", "\\\\");
            }
            fd.setDirectory(path);
        }
        if (fileName != null) {
            fd.setFile(fileName);
        }
        fd.show();
        this.name = fd.getFile();
        if (this.name == null) {
            if (IJ.isMacOSX()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            Macro.abort();
        } else {
            this.dir = fd.getDirectory();
        }
    }

    void decodePath(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            this.dir = path.substring(0, i + 1);
            this.name = path.substring(i + 1);
        } else {
            this.dir = "";
            this.name = path;
        }
    }

    public String getDirectory() {
        lastDir = this.dir;
        return this.dir;
    }

    public String getFileName() {
        if (this.name != null) {
            if (Recorder.record && this.recordPath && this.dir != null) {
                Recorder.recordPath(this.title, this.dir + this.name);
            }
            lastName = this.name;
        }
        return this.name;
    }

    public String getPath() {
        if (this.getFileName() == null) {
            return null;
        }
        return this.getDirectory() + this.getFileName();
    }

    public static String getDefaultDirectory() {
        if (Prefs.commandLineMacro() && !defaultDirectorySet) {
            return IJ.getDir("cwd");
        }
        if (defaultDirectory == null) {
            defaultDirectory = Prefs.getDefaultDirectory();
        }
        return defaultDirectory;
    }

    public static void setDefaultDirectory(String dir) {
        defaultDirectory = dir = IJ.addSeparator(dir);
        defaultDirectorySet = true;
    }

    public static String getLastDirectory() {
        return lastDir;
    }

    public static void setLastDirectory(String dir) {
        lastDir = dir;
    }

    public static String getLastName() {
        return lastName;
    }

    public static void setLastName(String name) {
        lastName = name;
    }
}

