/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ClassChecker
implements PlugIn {
    private String[] paths = null;
    private String[] names = null;

    @Override
    public void run(String arg) {
        this.deleteDuplicates();
    }

    void deleteDuplicates() {
        int i;
        this.getPathsAndNames();
        if (this.paths == null || this.paths.length < 2) {
            return;
        }
        String[] sortedNames = new String[this.names.length];
        for (i = 0; i < this.names.length; ++i) {
            sortedNames[i] = this.names[i];
        }
        StringSorter.sort(sortedNames);
        for (i = 0; i < sortedNames.length - 1; ++i) {
            if (!sortedNames[i].equals(sortedNames[i + 1])) continue;
            this.delete(sortedNames[i]);
        }
    }

    void delete(String name) {
        String path1 = null;
        String path2 = null;
        for (int i = 0; i < this.names.length; ++i) {
            long date2;
            if (path1 == null && this.names[i].equals(name)) {
                path1 = this.paths[i] + this.names[i];
            } else if (path2 == null && this.names[i].equals(name)) {
                path2 = this.paths[i] + this.names[i];
            }
            if (path1 == null || path2 == null) continue;
            File file1 = new File(path1);
            File file2 = new File(path2);
            if (file1 == null || file2 == null) {
                return;
            }
            long date1 = file1.lastModified();
            if (date1 < (date2 = file2.lastModified())) {
                this.log(path1);
                break;
            }
            this.log(path2);
            break;
        }
    }

    void log(String path) {
        IJ.log("Duplicate plugin: " + path);
    }

    void getPathsAndNames() {
        String path = Menus.getPlugInsPath();
        if (path == null) {
            return;
        }
        File f = new File(path);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        ArrayList<String> v1 = new ArrayList<String>();
        ArrayList<String> v2 = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (name.endsWith(".class") || name.endsWith(".jar")) {
                if (name.equals("package-info.class")) continue;
                v1.add(path);
                v2.add(name);
                continue;
            }
            this.getSubdirectoryFiles(path, name, v1, v2);
        }
        this.paths = v1.toArray(new String[0]);
        this.names = v2.toArray(new String[0]);
    }

    void getSubdirectoryFiles(String path, String dir, List<String> v1, List<String> v2) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + Prefs.separator;
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".class") && !name.endsWith(".jar") || name.equals("package-info.class")) continue;
            v1.add(path + dir);
            v2.add(name);
        }
    }
}

