/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.plugin.ControlPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreePanel
implements ActionListener,
WindowListener,
TreeExpansionListener,
TreeWillExpandListener {
    ControlPanel pcp;
    boolean isMainPanel;
    String title;
    boolean isDragging = false;
    Point defaultLocation;
    private JTree pTree;
    private JMenuBar pMenuBar;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode draggingNode = null;
    private DefaultTreeModel pTreeModel;
    private ActionListener listener;
    private JFrame pFrame;
    private JCheckBoxMenuItem pMenu_saveOnClose;
    private JCheckBoxMenuItem pMenu_noClutter;
    private TreePath rootPath;
    private static final int[] _uparrow1_data = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 1, 1, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 14, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 14, 4, 5, 6, 1, 7, 0, 0, 0, 0, 0, 0, 0, 0, 1, 8, 4, 9, 14, 2, 6, 1, 0, 0, 0, 0, 0, 0, 0, 2, 8, 4, 9, 14, 14, 14, 2, 6, 1, 0, 0, 0, 0, 0, 8, 8, 4, 9, 14, 14, 14, 14, 14, 2, 6, 2, 0, 0, 0, 8, 10, 14, 8, 10, 11, 11, 12, 12, 12, 12, 12, 6, 2, 0, 14, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] _uparrow1_ctable = new int[]{33, -16777216, -13619152, -5592406, -1, -12829636, -14342875, -4802890, -10987432, -3947581, -14540254, -13948117, -13750738, -6250336, -8355712};
    private static IndexColorModel iconCM = new IndexColorModel(8, _uparrow1_ctable.length, _uparrow1_ctable, 0, true, 255, 0);
    private static final ImageIcon upIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, (ColorModel)iconCM, _uparrow1_data, 0, 16)));

    public TreePanel(DefaultMutableTreeNode root, ControlPanel pcp, boolean isMainPanel) {
        new TreePanel(root, pcp, isMainPanel, null);
    }

    public TreePanel(DefaultMutableTreeNode root, ControlPanel pcp, boolean isMainPanel, Point location) {
        this.root = root;
        this.pcp = pcp;
        this.isMainPanel = isMainPanel;
        this.defaultLocation = location;
        this.rootPath = new TreePath(root.getPath());
        this.title = (String)root.getUserObject();
        this.buildTreePanel();
        pcp.registerPanel(this);
    }

    public void buildTreePanel() {
        this.pFrame = new JFrame(this.title);
        this.pFrame.setDefaultCloseOperation(2);
        this.pTreeModel = new DefaultTreeModel(this.root);
        this.pTree = new JTree(this.pTreeModel);
        this.pTree.setEditable(false);
        this.pTree.putClientProperty("JTree.lineStyle", "Angled");
        this.pTree.getSelectionModel().setSelectionMode(1);
        this.pTree.setRootVisible(false);
        this.pTree.setShowsRootHandles(true);
        JScrollPane ptView = new JScrollPane(this.pTree);
        this.addMenu();
        this.pFrame.getContentPane().add((Component)ptView, "Center");
        this.addListeners();
        this.pFrame.pack();
        if (this.defaultLocation != null) {
            if (IJ.debugMode) {
                IJ.log("CP.buildTreePanel: " + this.defaultLocation);
            }
            this.pFrame.setLocation(this.defaultLocation.x, this.defaultLocation.y);
        } else {
            this.pcp.restoreGeometry(this);
        }
        if (this.pFrame.getLocation().x == 0) {
            GUI.center(this.pFrame);
        }
        this.setVisible();
        ImageJ ij = IJ.getInstance();
        ij.addWindowListener(this);
        this.pFrame.addKeyListener(ij);
        this.pTree.addKeyListener(ij);
    }

    void addMenu() {
        this.pMenuBar = new JMenuBar();
        Insets ins = new Insets(0, 0, 0, 10);
        this.pMenuBar.setMargin(ins);
        if (this.isMainPanel) {
            JMenuItem helpMI = new JMenuItem("Help");
            helpMI.addActionListener(this);
            helpMI.setActionCommand("Help");
            this.pMenuBar.add(helpMI);
        } else {
            JMenuItem spMI = new JMenuItem("Show Parent", upIcon);
            spMI.addActionListener(this);
            spMI.setActionCommand("Show Parent");
            this.pMenuBar.add(spMI);
        }
        this.pFrame.setJMenuBar(this.pMenuBar);
    }

    void addListeners() {
        this.addActionListener(this);
        this.pFrame.addWindowListener(this);
        this.pFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Rectangle r = e.getComponent().getBounds();
                if (IJ.debugMode) {
                    IJ.log("CP.componentMoved: " + r);
                }
                if (r.x > 0) {
                    TreePanel.this.defaultLocation = new Point(r.x, r.y);
                    TreePanel.this.recordGeometry();
                }
            }
        });
        this.pTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePanel.this.isDragging = false;
                if (e.getClickCount() != 2) {
                    return;
                }
                int selRow = TreePanel.this.pTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    TreePanel.this.toAction();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TreePanel.this.isDragging) {
                    Point pnt = new Point(e.getX(), e.getY());
                    SwingUtilities.convertPointToScreen(pnt, TreePanel.this.pTree);
                    TreePanel.this.tearOff(null, pnt);
                }
                TreePanel.this.isDragging = false;
            }
        });
        this.pTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int selRow = TreePanel.this.pTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (((DefaultMutableTreeNode)TreePanel.this.pTree.getLastSelectedPathComponent()).isLeaf()) {
                        return;
                    }
                    TreePanel.this.pFrame.setCursor(new Cursor(13));
                    TreePanel.this.isDragging = true;
                }
            }
        });
        this.pTree.addTreeExpansionListener(this);
        this.pTree.addTreeWillExpandListener(this);
    }

    public String getTitle() {
        return this.title;
    }

    public TreePath getRootPath() {
        return this.rootPath;
    }

    public boolean isTheMainPanel() {
        return this.isMainPanel;
    }

    public JFrame getFrame() {
        return this.pFrame;
    }

    public JTree getTree() {
        return this.pTree;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.root;
    }

    public Point getDefaultLocation() {
        return this.defaultLocation;
    }

    boolean isVisible() {
        return this.pFrame.isVisible();
    }

    void setBounds(int x, int y, int w, int h) {
        this.pFrame.setBounds(new Rectangle(x, y, w, h));
        this.defaultLocation = new Point(x, y);
    }

    void setAutoSaveProps(boolean autoSave) {
        if (this.isTheMainPanel()) {
            this.pMenu_saveOnClose.setSelected(autoSave);
        }
    }

    boolean getAutoSaveProps() {
        return this.pMenu_saveOnClose.isSelected();
    }

    void restoreExpandedNodes() {
        if (this.pTree == null || this.root == null) {
            return;
        }
        this.pTree.removeTreeExpansionListener(this);
        TreeNode[] rootPath = this.root.getPath();
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf() || node == this.root) continue;
            Object[] nodePath = node.getPath();
            TreePath nTreePath = new TreePath(nodePath);
            String npS = nTreePath.toString();
            Object[] localPath = new DefaultMutableTreeNode[nodePath.length - rootPath.length + 1];
            for (int i = 0; i < localPath.length; ++i) {
                localPath[i] = (DefaultMutableTreeNode)nodePath[i + rootPath.length - 1];
            }
            TreePath newPath = new TreePath(localPath);
            if (this.pcp.hasExpandedStateProperty(npS) && !this.pcp.hasPanelShowingProperty(npS)) {
                if (newPath == null) continue;
                try {
                    this.pTree.expandPath(newPath);
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (!this.pcp.hasExpandedStateProperty(npS) && !this.pTree.isExpanded(newPath) || !this.pcp.hasPanelShowingProperty(npS)) continue;
            this.pTree.collapsePath(newPath);
            this.pcp.unsetExpandedStateProperty(npS);
        }
        this.pTree.addTreeExpansionListener(this);
    }

    public void processEvent(ActionEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener al) {
        this.listener = AWTEventMulticaster.add(this.listener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.listener = AWTEventMulticaster.remove(this.listener, al);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == null) {
            return;
        }
        if (cmd.equals("Help")) {
            this.showHelp();
            return;
        }
        if (cmd.equals("Show Parent")) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.root.getParent();
            if (parent != null) {
                TreePanel panel = this.pcp.getPanelForNode(parent);
                if (panel == null) {
                    panel = this.pcp.newPanel(parent);
                }
                if (panel != null) {
                    panel.setVisible();
                }
            }
            return;
        }
        if (!cmd.equals("Reload Plugins From Panel")) {
            if (cmd.equals("Reload Plugins")) {
                this.pcp.closeAll(false);
            } else {
                IJ.doCommand(cmd);
            }
            return;
        }
        this.pcp.closeAll(false);
        IJ.doCommand("Reload Plugins");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (IJ.debugMode) {
            IJ.log("CP.windowClosing: " + this.isMainPanel);
        }
        if (this.isMainPanel) {
            this.pcp.saveProperties();
        }
        this.pcp.unsetPanelShowingProperty(this.getRootPath().toString());
    }

    @Override
    public void windowActivated(WindowEvent e) {
        WindowManager.setWindow(this.getFrame());
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent ev) {
        String evPathString = ev.getPath().toString();
        evPathString = evPathString.substring(evPathString.indexOf("[") + 1, evPathString.lastIndexOf("]"));
        evPathString = evPathString.substring(this.getTitle().length() + 2, evPathString.length());
        String rootPath = this.getRootPath().toString();
        rootPath = rootPath.substring(rootPath.indexOf("[") + 1, rootPath.lastIndexOf("]"));
        String path = "[" + rootPath + ", " + evPathString + "]";
        this.pcp.unsetExpandedStateProperty(path);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent ev) {
        Hashtable panels;
        TreePanel p;
        TreePath evPath = ev.getPath();
        String evPathString = ev.getPath().toString();
        evPathString = this.pcp.pStr2Key(evPathString);
        evPathString = evPathString.substring(this.getTitle().length() + 1, evPathString.length());
        String rootPath = this.getRootPath().toString();
        String path = (rootPath = this.pcp.pStr2Key(rootPath)) + "." + evPathString;
        if (this.pcp.hasPanelShowingProperty(path) && (p = (TreePanel)(panels = this.pcp.getPanels()).get(path)) != null) {
            p.close();
        }
        this.pcp.setExpandedStateProperty(path);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent ev) {
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent ev) {
    }

    void recordGeometry() {
        this.pcp.recordGeometry(this);
    }

    void refreshTree() {
        this.pTreeModel.reload();
    }

    void tearOff() {
        this.tearOff(null);
    }

    void tearOff(DefaultMutableTreeNode node) {
        this.tearOff(node, null);
    }

    void tearOff(DefaultMutableTreeNode node, Point pnt) {
        this.isDragging = false;
        this.pFrame.setCursor(Cursor.getDefaultCursor());
        if (node == null) {
            node = (DefaultMutableTreeNode)this.pTree.getLastSelectedPathComponent();
        }
        if (node.isLeaf()) {
            return;
        }
        Object[] nPath = node.getPath();
        TreeNode[] rPath = this.root.getPath();
        Object[] tPath = new DefaultMutableTreeNode[nPath.length - rPath.length + 1];
        for (int i = 0; i < tPath.length; ++i) {
            tPath[i] = (DefaultMutableTreeNode)nPath[i + rPath.length - 1];
        }
        TreePath path = new TreePath(nPath);
        TreePath localPath = new TreePath(tPath);
        String pathString = localPath.toString();
        TreePanel p = this.pcp.getPanelForNode(node);
        if (p == null) {
            p = pnt != null ? this.pcp.newPanel(node, pnt) : this.pcp.newPanel(node);
            this.pTree.collapsePath(localPath);
        } else {
            if (pnt != null) {
                p.setLocation(pnt);
            }
            p.setVisible();
            this.pTree.collapsePath(localPath);
        }
    }

    void toAction() {
        String aCmd;
        DefaultMutableTreeNode nde = (DefaultMutableTreeNode)this.pTree.getLastSelectedPathComponent();
        if (nde.getChildCount() > 0) {
            return;
        }
        String cmd = aCmd = nde.toString();
        if (this.pcp.treeCommands.containsKey(aCmd)) {
            cmd = (String)this.pcp.treeCommands.get(aCmd);
        }
        this.processEvent(new ActionEvent(this, 1001, cmd));
    }

    void setVisible() {
        if (this.pFrame != null && !this.pFrame.isVisible()) {
            TreePanel pnl;
            this.restoreExpandedNodes();
            if (this.defaultLocation != null) {
                this.pFrame.setLocation(this.defaultLocation);
            }
            this.pFrame.setVisible(true);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.root.getParent();
            if (parent != null && (pnl = this.pcp.getPanelForNode(parent)) != null && pnl.isVisible()) {
                TreeNode[] rPath = this.root.getPath();
                TreeNode[] pPath = pnl.getRootNode().getPath();
                Object[] tPath = new DefaultMutableTreeNode[rPath.length - pPath.length + 1];
                for (int i = 0; i < tPath.length; ++i) {
                    tPath[i] = (DefaultMutableTreeNode)rPath[i + pPath.length - 1];
                }
                TreePath localPath = new TreePath(tPath);
                pnl.getTree().collapsePath(localPath);
            }
        }
        if (this.pcp != null) {
            this.pcp.setPanelShowingProperty(this.getRootPath().toString());
        }
    }

    void setLocation(Point p) {
        if (p != null) {
            this.defaultLocation = p;
        }
    }

    void close() {
        this.pFrame.dispatchEvent(new WindowEvent(this.pFrame, 201));
        this.pcp.unsetPanelShowingProperty(this.getRootPath().toString());
    }

    private void showHelp() {
        this.pcp.showHelp();
    }
}

