/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep;

import org.lsmp.djep.groupJep.groups.FreeGroup;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.lsmp.djep.xjep.DoNothingVisitor;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public class PolynomialVisitor
extends DoNothingVisitor {
    private OperatorSet opSet;
    private FreeGroup fg;

    public PolynomialVisitor(JEP j) {
        this.opSet = j.getOperatorSet();
    }

    public Polynomial calcPolynomial(Node node, FreeGroup fg) throws ParseException {
        this.fg = fg;
        return (Polynomial)node.jjtAccept(this, null);
    }

    @Override
    public Object visit(ASTFunNode node, Object data) throws ParseException {
        int nchild = node.jjtGetNumChildren();
        Polynomial[] children = new Polynomial[nchild];
        for (int i = 0; i < nchild; ++i) {
            children[i] = (Polynomial)node.jjtGetChild(i).jjtAccept(this, data);
        }
        Operator op = node.getOperator();
        if (op == null) {
            throw new ParseException("Function " + node.getName() + " cannot be converted to a polynomial");
        }
        if (op == this.opSet.getAdd()) {
            return this.fg.add(children[0], children[1]);
        }
        if (op == this.opSet.getSubtract()) {
            return this.fg.sub(children[0], children[1]);
        }
        if (op == this.opSet.getMultiply()) {
            return this.fg.mul(children[0], children[1]);
        }
        throw new ParseException("Operator " + op.getName() + " not supported");
    }

    @Override
    public Object visit(ASTVarNode node, Object data) throws ParseException {
        if (this.fg.getSymbol().equals(node.getName())) {
            return this.fg.getTPoly();
        }
        Variable var = node.getVar();
        if (!var.hasValidValue()) {
            throw new ParseException("Variable " + var.getName() + " does not have a valid value");
        }
        return this.fg.valueOf(new Number[]{(Number)var.getValue()});
    }

    @Override
    public Object visit(ASTConstant node, Object data) throws ParseException {
        return this.fg.valueOf(new Number[]{(Number)node.getValue()});
    }
}

