/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Multiply;

public class ElementMultiply
extends Multiply
implements NaryOperatorI {
    @Override
    public Dimensions calcDim(Dimensions[] dims) throws ParseException {
        int len = dims.length;
        if (len == 0) {
            throw new ParseException("ElementMultiply called with 0 arguments");
        }
        if (len == 1) {
            return dims[0];
        }
        Dimensions firstDim = dims[0];
        for (int i = 1; i < len; ++i) {
            if (firstDim.equals(dims[i])) continue;
            throw new ParseException("ElementMultiply: dimensions of each argument should be the same");
        }
        return firstDim;
    }

    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI[] inputs) throws ParseException {
        int numArgs = inputs.length;
        int len = res.getNumEles();
        for (int i = 0; i < len; ++i) {
            Object ele = inputs[0].getEle(i);
            for (int j = 1; j < numArgs; ++j) {
                ele = super.mul(ele, inputs[j].getEle(i));
            }
            res.setEle(i, ele);
        }
        return res;
    }

    @Override
    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 instanceof MatrixValueI && param2 instanceof MatrixValueI) {
            return this.mul((MatrixValueI)param1, (MatrixValueI)param2);
        }
        if (param1 instanceof MatrixValueI) {
            MatrixValueI l = (MatrixValueI)param1;
            MatrixValueI res = Tensor.getInstance(l.getDim());
            for (int i = 0; i < res.getNumEles(); ++i) {
                res.setEle(i, super.mul(l.getEle(i), param2));
            }
            return res;
        }
        if (param2 instanceof MatrixValueI) {
            MatrixValueI r = (MatrixValueI)param2;
            MatrixValueI res = Tensor.getInstance(r.getDim());
            for (int i = 0; i < res.getNumEles(); ++i) {
                res.setEle(i, super.mul(param1, r.getEle(i)));
            }
            return res;
        }
        return super.mul(param1, param2);
    }

    public Object mul(MatrixValueI param1, MatrixValueI param2) throws ParseException {
        Dimensions dims = this.calcDim(new Dimensions[]{param1.getDim(), param2.getDim()});
        MatrixValueI res = Tensor.getInstance(dims);
        return this.calcValue(res, new MatrixValueI[]{param1, param2});
    }
}

