/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import java.util.Vector;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.List;

public class VList
extends List
implements NaryOperatorI {
    public VList() {
        this.numberOfParameters = -1;
    }

    @Override
    public Dimensions calcDim(Dimensions[] dims) throws ParseException {
        return Dimensions.valueOf(dims.length, dims[0]);
    }

    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI[] inputs) throws ParseException {
        int eleSize = inputs[0].getNumEles();
        for (int i = 0; i < inputs.length; ++i) {
            for (int j = 0; j < eleSize; ++j) {
                res.setEle(i * eleSize + j, inputs[i].getEle(j));
            }
        }
        return res;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        if (this.curNumberOfParameters < 1) {
            throw new ParseException("Empty list");
        }
        Object param1 = inStack.pop();
        if (param1 instanceof Vector) {
            Vector vec1 = (Vector)param1;
            int rows = this.curNumberOfParameters;
            int cols = vec1.size();
            Matrix res = (Matrix)Matrix.getInstance(rows, cols);
            for (int j = 0; j < cols; ++j) {
                res.setEle(rows - 1, j, vec1.elementAt(j));
            }
            for (int i = rows - 2; i >= 0; --i) {
                Vector vec = (Vector)inStack.pop();
                for (int j = 0; j < cols; ++j) {
                    res.setEle(i, j, vec.elementAt(j));
                }
            }
            inStack.push(res);
            return;
        }
        if (param1 instanceof MatrixValueI) {
            MatrixValueI mat1 = (MatrixValueI)param1;
            int rows = this.curNumberOfParameters;
            int neles = mat1.getNumEles();
            MatrixValueI res = Tensor.getInstance(Dimensions.valueOf(rows, mat1.getDim()));
            for (int j = 0; j < neles; ++j) {
                res.setEle((rows - 1) * neles + j, mat1.getEle(j));
            }
            for (int i = rows - 2; i >= 0; --i) {
                MatrixValueI mat = (MatrixValueI)inStack.pop();
                for (int j = 0; j < neles; ++j) {
                    res.setEle(i * neles + j, mat.getEle(j));
                }
            }
            inStack.push(res);
            return;
        }
        MVector res = new MVector(this.curNumberOfParameters);
        res.setEle(this.curNumberOfParameters - 1, param1);
        for (int i = this.curNumberOfParameters - 2; i >= 0; --i) {
            Object param = inStack.pop();
            res.setEle(i, param);
        }
        inStack.push(res);
    }
}

