package fr.esrf.tango.pogo;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class Extensions {
  @Inject
  @Extension
  private IQualifiedNameProvider qfnProvider;
  
  public String loc(final EObject obj) {
    String _xifexpression = null;
    EObject _eContainer = obj.eContainer();
    boolean _tripleNotEquals = (_eContainer != null);
    if (_tripleNotEquals) {
      String _info = this.info(obj);
      String _plus = (_info + "owned by ");
      String _info_1 = this.info(obj.eContainer());
      _xifexpression = (_plus + _info_1);
    } else {
      _xifexpression = this.info(obj);
    }
    return _xifexpression;
  }
  
  public String info(final EObject obj) {
    final QualifiedName name = this.qfnProvider.getFullyQualifiedName(obj);
    String _xifexpression = null;
    if ((name != null)) {
      _xifexpression = name.toString();
    } else {
      _xifexpression = "<unnamed>";
    }
    final String dynamicName = _xifexpression;
    String _name = obj.eClass().getName();
    String _plus = ((dynamicName + " [") + _name);
    return (_plus + "]");
  }
}
