/*
 * Decompiled with CFR 0.152.
 */
package xpather;

import xpather.IllegalXpathExpressionException;
import xpather.XpathAttribute;
import xpather.XpathDecorator;
import xpather.XpathElement;
import xpather.XpathExpression;
import xpather.XpathFragment;
import xpather.XpathPredicate;

class EqualToXpathDecorator
implements XpathDecorator<XpathPredicate> {
    private final String value;

    public EqualToXpathDecorator(String value) {
        this.value = value;
    }

    @Override
    public XpathPredicate decorate(XpathFragment xpathFragment) {
        this.assertIsInstanceOfElementOrAttribute(xpathFragment);
        String xpath = this.stripLeadingSlash(xpathFragment);
        return XpathExpression.predicate(xpath + "='" + this.value + "'");
    }

    private void assertIsInstanceOfElementOrAttribute(XpathFragment xpathFragment) {
        if (xpathFragment instanceof XpathElement || xpathFragment instanceof XpathAttribute) {
            return;
        }
        throw new IllegalXpathExpressionException("is() can only be applied to and Element or Attribute, not to : " + xpathFragment.toXpath());
    }

    private String stripLeadingSlash(XpathFragment xpathFragment) {
        return xpathFragment.toXpath().replace("/", "");
    }
}

