/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.xml2yaml;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML2YAML {
    private static final Logger logger = LoggerFactory.getLogger(XML2YAML.class);

    public void convert(InputStream inputStream, OutputStream outputStream) {
        try {
            Stack<Node> stack = new Stack<Node>();
            stack.push(new Node());
            boolean firstPrint = true;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            StartElement startElement = null;
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(inputStream);
            while (reader.hasNext()) {
                String content;
                Node currentNode;
                XMLEvent nextEvent = reader.nextEvent();
                if (nextEvent.isStartElement()) {
                    Node parentNode = (Node)stack.peek();
                    currentNode = new Node();
                    startElement = nextEvent.asStartElement();
                    currentNode.name = startElement.getName().getLocalPart();
                    currentNode.isXml2Yaml = "xml2yaml".equals(currentNode.name);
                    currentNode.isItem = "_".equals(currentNode.name);
                    currentNode.indent = stack.size() - 2;
                    currentNode.firstPrint = firstPrint;
                    if (!currentNode.isXml2Yaml) {
                        this.startElement(startElement, currentNode, parentNode, writer);
                        firstPrint = currentNode.firstPrint;
                    }
                    stack.push(currentNode);
                }
                if (nextEvent.isCharacters() && startElement != null && !(content = nextEvent.asCharacters().getData()).isBlank()) {
                    currentNode = (Node)stack.peek();
                    this.content(content, startElement, nextEvent, currentNode, writer);
                }
                if (!nextEvent.isEndElement()) continue;
                Node currentNode2 = (Node)stack.pop();
                Node parentNode = (Node)stack.peek();
                parentNode.previousNode = currentNode2;
            }
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startElement(StartElement startElement, Node currentNode, Node parentNode, Writer writer) throws Exception {
        String key = this.attr(startElement, "key", currentNode.name);
        String id = this.attr(startElement, "id", null);
        String ref = this.attr(startElement, "ref", null);
        if (!parentNode.isItem || parentNode.previousNode != null) {
            if (!currentNode.firstPrint) {
                writer.append("\n");
            }
            currentNode.firstPrint = false;
            writer.append(this.indent(currentNode.indent));
        }
        if (currentNode.isItem) {
            writer.append("- ");
        } else {
            writer.append(key);
            writer.append(": ");
            if (id != null) {
                writer.append("&" + id);
            }
            if (ref != null) {
                writer.append("*" + ref);
            }
        }
    }

    private void content(String content, StartElement startElement, XMLEvent contentEvent, Node currentNode, Writer writer) throws Exception {
        boolean newlinesArePresent = content.contains("\n");
        if (newlinesArePresent) {
            boolean replaceNewlines;
            boolean reindent = this.bool(startElement, "reindent", true);
            if (reindent) {
                content = content.replaceAll("^\\s*\n", "").replaceAll("\n\\s*$", "");
                content = this.replaceXMLIdentWithYAMLIndent(content, currentNode.indent + 1);
            }
            if (replaceNewlines = this.bool(startElement, "replaceNewlines", false)) {
                writer.append(">");
            } else {
                writer.append("|");
            }
            String stripIndent = this.attr(startElement, "stripIndent", null);
            if (stripIndent != null) {
                writer.append(stripIndent);
            }
            writer.append("\n");
        }
        writer.append(content);
    }

    private String replaceXMLIdentWithYAMLIndent(String content, int indent) {
        List lines = content.lines().collect(Collectors.toList());
        int numberOfWhitespaceMin = Integer.MAX_VALUE;
        for (String line2 : lines) {
            int numberOfWhitespace = 0;
            while (Character.isWhitespace(line2.charAt(0))) {
                line2 = line2.substring(1);
                ++numberOfWhitespace;
            }
            if (numberOfWhitespace >= numberOfWhitespaceMin) continue;
            numberOfWhitespaceMin = numberOfWhitespace;
        }
        int numberOfWhitespaceMinFinal = numberOfWhitespaceMin;
        String indentStr = this.indent(indent);
        content = lines.stream().map(line -> indentStr + line.substring(numberOfWhitespaceMinFinal)).collect(Collectors.joining("\n"));
        return content;
    }

    private String attr(StartElement startElement, String name, String defaultValue) {
        Attribute attribute = startElement.getAttributeByName(new QName(name));
        String value = attribute == null ? defaultValue : attribute.getValue();
        return value;
    }

    private boolean bool(StartElement startElement, String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.attr(startElement, name, "" + defaultValue));
    }

    private String indent(int n) {
        return "  ".repeat(n);
    }

    private class Node {
        String name;
        boolean isItem = false;
        boolean isXml2Yaml = false;
        Node previousNode = null;
        int indent;
        boolean firstPrint = true;

        private Node() {
        }
    }
}

