/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.xml2yaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML2YAML {
    private static final Logger logger = LoggerFactory.getLogger(XML2YAML.class);

    public void convert(InputStream inputStream, OutputStream outputStream) {
        try {
            Stack<Node> stack = new Stack<Node>();
            stack.push(new Node());
            boolean firstPrint = true;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            StartElement startElement = null;
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(inputStream);
            while (reader.hasNext()) {
                String content;
                Node currentNode;
                XMLEvent nextEvent = reader.nextEvent();
                if (nextEvent.isStartElement()) {
                    Node parentNode = (Node)stack.peek();
                    currentNode = new Node();
                    currentNode.parentNode = parentNode;
                    startElement = nextEvent.asStartElement();
                    currentNode.name = startElement.getName().getLocalPart();
                    currentNode.isXml2Yaml = "xml2yaml".equals(currentNode.name);
                    String key = this.attr(startElement, "key", currentNode.name);
                    if (key != null) {
                        currentNode.name = key;
                    }
                    currentNode.isItem = "_".equals(currentNode.name);
                    currentNode.indent = stack.size() - 2;
                    currentNode.firstPrint = firstPrint;
                    if (!(parentNode == null || parentNode.name == null || parentNode.isXml2Yaml || parentNode.isItem || parentNode.colonPrinted)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Child node '" + currentNode.name + "' found, appending ':' to parent node '" + this.listParents(currentNode) + "'");
                        }
                        this.append(currentNode, writer, ": ");
                        parentNode.colonPrinted = true;
                    }
                    if (!currentNode.isXml2Yaml) {
                        this.startElement(startElement, currentNode, parentNode, writer);
                        firstPrint = currentNode.firstPrint;
                    }
                    stack.push(currentNode);
                }
                if (nextEvent.isCharacters() && startElement != null && !(content = nextEvent.asCharacters().getData()).isBlank()) {
                    currentNode = (Node)stack.peek();
                    this.content(content, startElement, nextEvent, currentNode, writer);
                }
                if (!nextEvent.isEndElement()) continue;
                Node currentNode2 = (Node)stack.pop();
                Node parentNode = (Node)stack.peek();
                parentNode.previousNode = currentNode2;
            }
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startElement(StartElement startElement, Node currentNode, Node parentNode, Writer writer) throws Exception {
        String id = this.attr(startElement, "id", null);
        String ref = this.attr(startElement, "ref", null);
        if (!parentNode.isItem || parentNode.previousNode != null) {
            if (!currentNode.firstPrint) {
                this.append(currentNode, writer, "\n");
            }
            currentNode.firstPrint = false;
            this.append(currentNode, writer, this.indent(currentNode.indent));
        }
        if (currentNode.isItem) {
            this.append(currentNode, writer, "- ");
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("Starting a new node '" + currentNode.name + "'" + (String)(parentNode == null || parentNode.isXml2Yaml ? "" : " child of '" + this.listParents(currentNode) + "'"));
            }
            this.append(currentNode, writer, currentNode.name);
            if (id != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Node '" + currentNode.name + "' has an id '" + id + "'");
                }
                this.append(currentNode, writer, ": &" + id);
                currentNode.colonPrinted = true;
            }
            if (ref != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Node '" + currentNode.name + "' has an reference '" + ref + "'");
                }
                this.append(currentNode, writer, ": *" + ref);
                currentNode.colonPrinted = true;
            }
        }
    }

    private void content(String content, StartElement startElement, XMLEvent contentEvent, Node currentNode, Writer writer) throws Exception {
        boolean newlinesArePresent;
        String id = this.attr(startElement, "id", null);
        String ref = this.attr(startElement, "ref", null);
        if (!currentNode.isItem && !currentNode.colonPrinted) {
            if (logger.isTraceEnabled()) {
                logger.trace("Content found, appending ':' to node '" + this.listParents(currentNode) + "'");
            }
            this.append(currentNode, writer, ": ");
            currentNode.colonPrinted = true;
        }
        if (newlinesArePresent = content.contains("\n")) {
            boolean replaceNewlines;
            boolean reindent = this.bool(startElement, "reindent", true);
            if (reindent) {
                content = content.replaceAll("^\\s*\n", "").replaceAll("\n\\s*$", "");
                content = this.replaceXMLIdentWithYAMLIndent(content, currentNode.indent + 1);
            }
            if (replaceNewlines = this.bool(startElement, "replaceNewlines", false)) {
                this.append(currentNode, writer, ">");
            } else {
                this.append(currentNode, writer, "|");
            }
            String stripIndent = this.attr(startElement, "stripIndent", null);
            if (stripIndent != null) {
                this.append(currentNode, writer, stripIndent);
            }
            this.append(currentNode, writer, "\n");
        }
        this.append(currentNode, writer, content);
    }

    private String replaceXMLIdentWithYAMLIndent(String content, int indent) {
        List lines = content.lines().collect(Collectors.toList());
        int numberOfWhitespaceMin = Integer.MAX_VALUE;
        for (String line2 : lines) {
            int numberOfWhitespace = 0;
            while (Character.isWhitespace(line2.charAt(0))) {
                line2 = line2.substring(1);
                ++numberOfWhitespace;
            }
            if (numberOfWhitespace >= numberOfWhitespaceMin) continue;
            numberOfWhitespaceMin = numberOfWhitespace;
        }
        int numberOfWhitespaceMinFinal = numberOfWhitespaceMin;
        String indentStr = this.indent(indent);
        content = lines.stream().map(line -> indentStr + line.substring(numberOfWhitespaceMinFinal)).collect(Collectors.joining("\n"));
        return content;
    }

    private String attr(StartElement startElement, String name, String defaultValue) {
        Attribute attribute = startElement.getAttributeByName(new QName(name));
        String value = attribute == null ? defaultValue : attribute.getValue();
        return value;
    }

    private boolean bool(StartElement startElement, String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.attr(startElement, name, "" + defaultValue));
    }

    private String indent(int n) {
        return "  ".repeat(n);
    }

    private String listParents(Node currentNode) {
        Object s = "";
        while (currentNode.parentNode != null && currentNode.parentNode.name != null && !currentNode.parentNode.isXml2Yaml) {
            s = currentNode.parentNode.name + (((String)s).isEmpty() ? "" : ".") + (String)s;
            currentNode = currentNode.parentNode;
        }
        return s;
    }

    private void append(Node currentNode, Writer writer, String s) throws IOException {
        if (logger.isTraceEnabled() && !s.isBlank()) {
            logger.trace("> " + this.indent(currentNode.indent) + s.replaceAll("\n", "<newline>"));
        }
        writer.append(s);
    }

    private class Node {
        String name;
        boolean isItem = false;
        boolean isXml2Yaml = false;
        Node previousNode = null;
        Node parentNode = null;
        int indent;
        boolean firstPrint = true;
        boolean colonPrinted = false;

        private Node() {
        }
    }
}

