/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.antu;

import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.icon.antu.AntuIcon;
import org.teamapps.icon.antu.AntuIconStyle;
import org.teamapps.icons.Icon;
import org.teamapps.server.jetty.embedded.TeamAppsJettyEmbeddedServer;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView2;
import org.teamapps.ux.component.infiniteitemview.ListInfiniteItemViewModel;
import org.teamapps.ux.component.notification.Notification;
import org.teamapps.ux.component.notification.NotificationPosition;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class AntuIconBrowser {
    private SessionContext sessionContext;
    private AntuIconStyle iconStyle;
    private final ListInfiniteItemViewModel<AntuIcon> iconViewModel = new ListInfiniteItemViewModel(AntuIcon.getIcons());

    public AntuIconBrowser(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Component getUI() {
        Panel panel = new Panel();
        Component iconFinder = this.createIconFinder();
        panel.setContent(iconFinder);
        panel.setTitle("Icon Viewer");
        panel.setIcon((Icon)AntuIcon.APP_GCSTAR_48);
        return panel;
    }

    protected Component createIconFinder() {
        Panel iconViewComponent = this.createIconViewer();
        VerticalLayout verticalLayout = new VerticalLayout();
        ResponsiveForm responsiveForm = new ResponsiveForm(100, 200, 0);
        verticalLayout.addComponent((Component)responsiveForm);
        ResponsiveFormLayout layout = responsiveForm.addResponsiveFormLayout(400);
        layout.addSection((Icon)AntuIcon.ACTION_VIEW_FILTER_24, "Filter Icons");
        TextField searchField = new TextField();
        layout.addLabelAndField((Icon)AntuIcon.ACTION_SEARCH_24, "Icon Name", (AbstractField)searchField);
        searchField.setEmptyText("Search...");
        searchField.onTextInput.addListener(s -> this.iconViewModel.setRecords(AntuIcon.getIcons().stream().filter(icon -> s == null || icon.getIconId().contains(s.toUpperCase())).collect(Collectors.toList())));
        verticalLayout.addComponent((Component)searchField);
        ComboBox styleSelector = ComboBox.createForList(AntuIconStyle.getStyles());
        styleSelector.setTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        styleSelector.setPropertyExtractor((style, propertyName) -> {
            switch (propertyName) {
                case "icon": {
                    return AntuIcon.ACTION_DRAW_BRUSH_24;
                }
                case "caption": {
                    return style.getStyleId();
                }
            }
            return null;
        });
        styleSelector.setRecordToStringFunction(AntuIconStyle::getStyleId);
        styleSelector.setValue((Object)AntuIconStyle.LIGHT);
        styleSelector.setShowClearButton(false);
        styleSelector.onValueChanged.addListener(style -> {
            this.iconStyle = style;
            this.iconViewModel.onAllDataChanged.fire();
            if (style.equals(AntuIconStyle.DARK)) {
                iconViewComponent.setBodyBackgroundColor((Color)Color.BLACK.withAlpha(0.96f));
            } else {
                iconViewComponent.setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.96f));
            }
        });
        layout.addLabelAndField((Icon)AntuIcon.ACTION_DRAW_BRUSH_24, "Icon Style", (AbstractField)styleSelector);
        verticalLayout.addComponentFillRemaining((Component)iconViewComponent);
        return verticalLayout;
    }

    public Panel createIconViewer() {
        InfiniteItemView2 iconView = new InfiniteItemView2();
        iconView.setItemTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE);
        iconView.setItemHeight(50.0f);
        iconView.setItemWidth(300.0f);
        iconView.setItemPropertyExtractor((antuIcon, propertyName) -> {
            switch (propertyName) {
                case "icon": {
                    return antuIcon.withStyle(this.iconStyle);
                }
                case "caption": {
                    return antuIcon.getIconId();
                }
            }
            return null;
        });
        AntuIconStyle iconStyle = AntuIconStyle.LIGHT;
        iconView.setModel(this.iconViewModel);
        Panel panel = new Panel(null, "Icons");
        panel.setContent((Component)iconView);
        panel.setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.96f));
        iconView.onItemClicked.addListener(iconItemClickedEventData -> {
            TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_EXTRA_VERY_LARGE_ICON_TWO_LINES);
            AntuIcon icon = (AntuIcon)iconItemClickedEventData.getRecord();
            templateField.setValue((Object)new BaseTemplateRecord((Icon)icon, "AntuIcon." + icon.getIconId(), icon.getIconPath() + ".svg"));
            Notification iconNotification = new Notification();
            iconNotification.setContent((Component)templateField);
            iconNotification.setShowProgressBar(false);
            iconNotification.setDisplayTimeInMillis(5000);
            this.sessionContext.showNotification(iconNotification, NotificationPosition.TOP_RIGHT);
        });
        return panel;
    }

    public static void main(String[] args) throws Exception {
        WebController controller = sessionContext -> {
            RootPanel rootPanel = new RootPanel();
            sessionContext.addRootPanel(null, rootPanel);
            Component antuIconBrowser = new AntuIconBrowser(sessionContext).getUI();
            rootPanel.setContent(antuIconBrowser);
        };
        new TeamAppsJettyEmbeddedServer(controller, 8082).start();
    }
}

