/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.antu;

import java.io.IOException;
import java.io.InputStream;
import org.teamapps.icon.antu.AntuIcon;
import org.teamapps.icon.antu.AntuIconStyle;
import org.teamapps.icons.IconLoaderContext;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.spi.IconLoader;

public class AntuIconLoader
implements IconLoader<AntuIcon> {
    public IconResource loadIcon(AntuIcon icon, int size, IconLoaderContext context) {
        return new IconResource(this.getSVG(icon.getIconPath(), icon.getStyle()), IconType.SVG);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getSVG(String iconPath, AntuIconStyle style) {
        String folder = style.getFolder();
        String resourcePath = "/org/teamapps/icon/antu/" + folder + "/" + iconPath + ".svg";
        try (InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

